---
title: JAVA – O caminho do aprendizado
authors: Fellipe Filgueiras
type: post
date: 2015-04-16
excerpt: Entenda o que é necessário para aprender e se tornar um desenvolvedor Java.
url: /java-o-caminho-aprendizado/
categories:
  - back-end
tags:
  - java
  - server

---
Para entender o que é o Java, é preciso compreender três elementos que quando estão juntos, se torna possível o desenvolvimento de um sistema, são eles: Uma linguagem de programação, um ambiente de desenvolvimento e uma interface de programas aplicativos (Applications Programming Interface – API).

Uma linguagem é composta por um conjunto de palavras e símbolos utilizados pelos programadores para escrever cada parte de um programa. Além disso, ela também define regras de sintaxe que precisam ser observadas. No Java, a linguagem é utilizada para produzir diversos elementos de um programa, tais como: classes, interfaces, atributos, métodos, variáveis, constantes, estruturas de decisão e estruturas de repetição.

O ambiente de desenvolvimento é o conjunto de ferramentas necessárias para o desenvolvimento de softwares. O kit padrão do Java contém um conjunto de considerável de ferramentas, tais como: um compilador (javac), um interpretador de aplicativos (java), um visualizador de applets (appletviewer) e um gerador de documentação (javadoc). Também existem várias IDEs (Integrated Development Environment – Ambiente de Desenvolvimento Integrado) disponíveis que facilitam o processo de desenvolvimento de software, como a  IDE eclipse, que é uma das IDEs mais utilizadas pelos desenvolvedores.

Porém os softwares desenvolvidos em Java não resultam somente da junção de um ambiente de desenvolvimento e de uma linguagem de programação. A isso se soma um extenso conjunto de componentes, que formam sua API. O Java contém dois tipos fundamentais de componentes em sua API: as classes e as interfaces , uma pessoa que queira estudar Java, deverá passar a maior parte do seu tempo estudando a sua API do que aprender a lidar com a linguagem e com um ambiente de desenvolvimento.

_O termo interface não deve ser confundido com “Interface gráfica”. Do mesmo modo que uma classe, uma interface pode abrigar atributos e métodos. Para evitar mal entendidos, as referências à “Interface Gráfica” são feitas através da sigla GUI (Graphic User Interface – Interface Gráfica de Usuário)._

Como a API Java contém diversas classes e interfaces para o desenvolvimento de software, o desenvolvedor poderá se concentrar apenas na construção dos componentes que atenderão às necessidades do sistema que está sendo desenvolvido.

Sendo assim, pode-se dizer que existem três partes distintas para se aprender acerca do Java: A linguagem de programação, a segunda diz respeito ao funcionamento das ferramentas que compõem o seu ambiente de desenvolvimento, e a terceira é o extenso conjunto de classes e interfaces que compõem a sua API.

[<img class="aligncenter wp-image-48148 size-full" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/04/imagem1.jpg" alt="" width="623" height="456" />][1]

Pode-se perceber claramente que “linguagem Java” é uma expressão que não representa todo o caminho a ser trilhado. Para se tornar um desenvolvedor Java, é preciso estudar tanto a linguagem quanto sua API e um ambiente de desenvolvimento. Assim, o mais adequado é assumir o conceito de Java como um conjunto de tecnologias que podem ser aplicadas ao desenvolvimento de software e não apenas como uma linguagem.

Ao tratar do Java tão somente como uma linguagem de programação, ignora-se o segredo de seu sucesso: a produtividade possibilitada por sua extensa API e um ambiente de execução que permite que seus programas sejam executados nos principais sistemas operacionais.

 [1]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/04/imagem1.jpg