---
title: JAVA – Como plataforma
authors: Fellipe Filgueiras
type: post
date: 2015-04-30
excerpt: Entenda como o Java pode ser executado em qualquer plataforma.
url: /java-como-plataforma/
categories:
  - back-end
tags:
  - java

---
Uma plataforma é uma estrutura que possibilita a execução de softwares aplicativos. Basicamente, o que você precisa para rodar um aplicativo são um computador e um sistema operacional instalado nele. Mas os sistemas operacionais são concebidos para determinadas arquiteturas de computadores e são incompatíveis com todas as demais. Por isso, os próprios sistemas operacionais são utilizados para identificar as plataformas.

Do mesmo modo que os sistemas operacionais são compatíveis apenas com determinado tipo de computador, os programas compilados com as tecnologias tradicionais somente são compatíveis com um único sistema operacional, e isso tira o sono de um desenvolvedor quando ele escreve um programa e compila em C++ para executar no Windows, e o mesmo não será possível executar em outra plataforma.

O Java supera essa dificuldade, o programa escrito em Java pode ser executado em qualquer sistema operacional e, por conseguinte, em qualquer arquitetura de computador. E é exatamente isso que se refere a expressão adotada pela Sun Microsystems: “Escreva uma vez. Execute em qualquer lugar.”

Para entender como é possível, basta realizar uma análise comparativa entre os processos de desenvolvimento, compilação e execução de programas com as tecnologias tradicionais e com o Java.

[<img class=" size-full wp-image-48241 aligncenter" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/04/imagem2.jpg" alt="imagem" width="567" height="394" />][1]

Note que o processo de compilação do Java gera uma representação intermediária do código (bytecodes), que pode ser interpretada por qualquer sistema operacional que tenha uma JVM (Java Virtual Machine – Máquina Virtual Java), e é essa JVM que garante que o que foi escrito em Java seja executado em qualquer sistema operacional.

Dessa forma e de outras particularidades, a plataforma Java se distingue claramente das tecnologias de desenvolvimento de software tradicionais.

 [1]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/04/imagem2.jpg