---
title: Introduzindo “Rich Cards”, um novo formato de resultados para Buscas
authors: Rodrigo Fávaro
type: post
date: 2016-07-04
url: /introduzindo-rich-cards-um-novo-formato-de-resultados-para-buscas/
titulo_personalizado:
  - 'Conheça o novo formato para resultados de busca <strong>Rich Cards</strong>'
categories:
  - Destaques
  - HTML
  - Mobile
  - Semântica
  - SEO
tags:
  - rich cards
  - rich snippets

---
Como uma boa empresa de tecnologia, o Google parece fazer da necessidade de evoluir suas ferramentas uma &#8220;obsessão&#8221;.  Quando o assunto é mobilidade então, essa questão é um pouco superior.

Todo mundo sabe que a maneira de interagir em um resultado de busca depende muito de como as informações estão organizadas no topo. Temos uma tendência em clicar nos primeiros resultados, algo que o o próprio Google nos educou. Com os <a href="https://www.rodrigofavaro.com/2015/06/dados-estruturados-melhorando-a-exibicao-do-seu-site-no-google/" target="_blank">Dados Estruturados (Rich Snippets)</a>, temos uma nova forma de obter resultados relevantes, através de imagens, votação entre outros meios que certamente influenciarão nosso clique. Agora, o Google vai além e lança o que podemos chamar de uma evolução dos &#8220;Rich Snippets&#8221;, os &#8220;Rich Cards&#8221; (Cartões Ricos traduzindo ao pé da letra).

&#8220;Rich Cards&#8221; nada mais são do que um novo formato do resultado de uma busca, baseado no sucesso dos Dados Estruturados. Assim como os Dados Estruturados, os &#8220;Rich Cards&#8221; usam a estruturação do <a href="https://schema.org/" target="_blank">schema.org</a> para exibir conteúdo em um formato ainda mais envolvente e visual, com o foco em oferecer uma melhor experiência ao usuário de dispositivos móveis.

 <img class="size-full wp-image-54126" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2016/05/rich-result-evolution.png" alt="Evolução do Rech Result" width="1600" height="900" />Evolução da pesquisa de consultas: com “rich cards”, os resultados são apresentados em carrosséis que são fáceis de navegar por rolagem esquerda e direita. Carrosséis podem conter todos os cartões do mesmo site ou de vários sites.

Para quem tem seu próprio site ou quem trabalha gerenciando sites de pessoas/empresas, esta com certeza é uma nova oportunidade para de destacar nos resultados da pesquisa e atrair mais e melhores usuários para sua página. Por exemplo, se você tem um site de **receitas**, você pode agora construir uma visualização mais rica de seu conteúdo  com uma imagem de destaque para cada prato. Este novo formato visual ajuda os usuários a encontrarem o que eles querem de imediato, sem ter que ficar lendo a descrição para ver se aquela é realmente a receita que estava procurando, e assim garantindo que sua página de receita sobre bolo de cenoura realmente atraia pessoas interessadas em bolo de cenoura.

O Google está inicialmente mostrando os &#8220;Rich Cards&#8221; para duas categorias: **receitas** e **filmes**. Eles irão aparecer neste primeiro momento em resultados de busca móvel em _Inglês_ para o google.com. É claro que esse não é um limitante para começar a estudar o assunto e implementar no seu site, afinal de contas, esse tipo de evolução é lançada para testes no google.com mas muito em breve deverá chegar ao Google Brasil, levando em consideração que o Brasil é um dos maiores mercados para o Google.

**Por onde começar?**
  
Claro que o Google não ia te deixar &#8220;abandonado&#8221;. Foi construído um conjunto abrangente de ferramentas e uma completa atualização da documentação do desenvolvedor para tornar proprietários e desenvolvedores de sites capazes de realizar as alterações inicias.

**Explore os tipos de &#8220;Rich Cards&#8221; e identifique onde ajustar seu conteúdo**
  
Você pode navegar em uma nova galeria com imagens (screenshots) e amostras de código de cada tipo de marcação. Clique <a href="https://developers.google.com/search/docs/guides/search-gallery" target="_blank">aqui</a>.

**Testar e ajustar sua marcação**
  
Segundo o Google, é altamente recomendável usar JSON-LD na sua implementação.

  * Descubra quais <a href="https://developers.google.com/search/docs/guides/mark-up-content" target="_blank">campos são essenciais</a>  para marcar para que um &#8220;Rich Card&#8221; apareça. Aproveite também pois o Google listou campos adicionais que podem melhorar seus &#8220;Rich Cards&#8221;.
  * Veja uma pré-visualização na <a href="https://search.google.com/structured-data/testing-tool/u/0/" target="_blank">renovada Ferramenta de Teste de Dados Estruturados</a> de como os &#8220;Rich Cards&#8221; podem aparecer nas buscas (atualmente disponível para receitas e filmes).
  * Use a Ferramenta de Teste para ver erros e ajustar sua marcação em tempo real.

<img class="size-full wp-image-54127 aligncenter" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2016/05/structured-data-testing-tool.png" alt="ferramenta de teste de dados estruturados" width="1265" height="782" />

**Mantenha o controle na cobertura e depuração de erros**
  
Veja como muitos dos seus &#8220;Rich Cards&#8221; são indexados no novo <a href="https://www.google.com/webmasters/tools/rich-cards" target="_blank">relatório de Pesquisa sobre &#8220;Rich Cards&#8221;</a>.

<img class="size-full wp-image-54125 aligncenter" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2016/05/rich-card-errors.png" alt="Erros de Rich Cards" width="926" height="524" />

  * Mantenha-se atento para os erros (também listados no relatório de &#8220;Rich Cards&#8221;). Cada exemplo de erro é &#8220;linkado&#8221; diretamente para a ferramenta de Teste de Dados Estruturados para que você possa testá-lo.
  * Lembre-se de <a href="https://support.google.com/sites/answer/100283" target="_blank">enviar um sitemap (mapa do site)</a> para ajudar o Google a descobrir todo o seu conteúdo.

**Encontre oportunidades de crescimento**
  
No relatório de &#8220;Rich Cards&#8221;, você verá que eles podem ser melhorados/reforçados pela marcação de campos adicionais.

<img class="size-full wp-image-54124 aligncenter" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2016/05/enhanceable-rich-cards.png" alt="enhanceable rich cards" width="912" height="575" />

&nbsp;

**Monitor de desempenho**
  
Um novo filtro &#8220;Rich Results&#8221; no Analytics (atualmente em beta fechado) irá ajudá-lo a controlar como seus &#8220;Rich Cards&#8221; e &#8220;Rich Snippets&#8221; estão trabalhando nas buscas. Você será capaz de ver os cliques e impressões para ambos.

**Perguntas e Respostas**
  
**P**: Posso manter meus &#8220;Rich Snippets&#8221; existentes?
  
**R**: Sim, você pode! Você será sempre informado pelo Google como o rico ecossistema de resultado evolui.

**P**: E sobre o relatório de Dados Estruturados no _Search Console_?
  
**R**: O relatório de Dados Estruturados continuará a mostrar apenas as <a href="https://support.google.com/webmasters/answer/2650907" target="_blank">entidades de nível superior</a> para os &#8220;Rich Snippts&#8221; existentes (produto, receita, review, eventos, apps, vídeos, notícias) e para quaisquer novas categorias (por exemplo, filmes). O Google pretende migrar todos os erros do relatório de Dados Estruturados no relatório &#8220;Rich Card&#8221;.

**P**: E se eu usar de forma errada a marcação?
  
**R**: As orientações técnicas e de qualidade serão aplicadas para &#8220;rich cards&#8221; assim como são para &#8220;rich snippets&#8221;. O Google irá aplicá-las como antes.

**Conclusões**
  
Este é um serviço que demanda tempo e com certeza poucas pessoas estão interessadas e com disposição para realiza-lo. Claro que não preciso nem dizer que quem o fizer, terá seu site em destaque de forma &#8220;gratuita&#8221; e poderá fazer disso novos clientes, novas vendas e muito mais acessos ao seu website.

Para saber mais sobre &#8220;rich cards&#8221;, veja como foi a <a href="https://events.google.com/io2016/schedule?sid=8f9c1403-0cef-e511-a517-00155d5066d7#day2/8f9c1403-0cef-e511-a517-00155d5066d7" target="_blank">sessão do Google I/O 2016</a> que tratou sobre pesquisa neste ecossistema móvel. Não esqueça também de ver a <a href="https://developers.google.com/search/docs/guides/search-features" target="_blank">Documentação do Desenvolvedor.</a>  Se tiver mais perguntas, poderá encontrar mais respostas na sessão dedicada de dados estruturados no <a href="https://productforums.google.com/forum/#!categories/webmasters/structured-data" target="_blank">fórum do Google</a>, no <a href="https://twitter.com/googlewmc" target="_blank">Twitter</a> ou no <a href="https://plus.google.com/+GoogleWebmasters/" target="_blank">Google+</a>.

Qualquer dúvida ou informações adicionais, podem me enviar um e-mail (rodrigomfavaro@gmail.com). Será um prazer discutir esses assuntos com vocês. Até a próxima.

&nbsp;

<p style="font-size: 11px">
  Fonte: <a href="https://webmasters.googleblog.com/2016/05/introducing-rich-cards.html?utm_source=feedburner&utm_medium=email&utm_campaign=Feed:+blogspot/amDG+(Official+Google+Webmaster+Central+Blog)" target="_blank">Google Webmaster Central Blog</a>
</p>