+++
authors = "Diego Eis"
categories = ["notícias"]
date = "2018-07-27T00:35:49+00:00"
excerpt = "Pesquisa TIC Domicílios 2017, do Cetic.br, também aponta que a metade dos indivíduos conectados acessa a Internet exclusivamente pelo celular."
image = "https://i.imgur.com/5qJ5vJ1.jpg"
publishdate = "2018-07-27T00:35:00+00:00"
tags = ["mercado"]
title = "Internet por banda larga volta a crescer no Brasil"
type = "post"

+++
O acesso à Internet nos domicílios voltou a crescer no Brasil, totalizando 42,1 milhões de lares conectados em 2017 (61% das residências). Nas áreas urbanas, essa proporção é de 65%, o que corresponde a 38,8 milhões de domicílios conectados. Os dados são da pesquisa [TIC Domicílios 2017](https://www.imcgrupo.com/link.php?code=bDpodHRwJTNBJTJGJTJGY2V0aWMuYnIlMkZwZXNxdWlzYSUyRmRvbWljaWxpb3MlMkZpbmRpY2Fkb3JlczozMjU2NjQ1MDE0OmRpZWdvQHRhYmxlbGVzcy5jb20uYnI6MTMxOWFkNWVhODE0Yjk1MWI3YjE3YTU4NTMxZGJkMzZlOA==), divulgada nesta terça-feira (24) pelo Comitê Gestor da Internet no Brasil (CGI.br), por meio do Centro Regional de Estudos para o Desenvolvimento da Sociedade da Informação (Cetic.br) do Núcleo de Informação e Coordenação do Ponto BR (NIC.br).  
  
O estudo aponta ainda que as desigualdades por classe socioeconômica e por áreas urbanas e rurais persistem: o acesso à Internet está presente em 30% dos domicílios de classe D/E (proporção era de 23% em 2016) e 34% das residências da área rural (em 2016, era 26%). Já nas classes A e B, as proporções atingem, respectivamente, 99% e 93%. Além disso, 19% dos domicílios conectados não possuem computador, o que representa 13,4 milhões de residências. Essa proporção era de apenas 4% em 2014.  
  
Segundo o estudo, o preço da conexão permanece como principal motivo mencionado para a ausência de Internet nos domicílios: 27% dos entrevistados afirmam que o serviço é caro. "O dado revela ser cada vez mais essencial o investimento em infraestrutura e em políticas públicas que possibilitem que todos os brasileiros possam ter acesso à Internet em suas casas, sem distinção de classe social ou região geográfica", pontua Alexandre Barbosa, gerente do Cetic.br.  
  
No que diz respeito ao principal tipo de conexão, a TIC Domicílios 2017 registrou estabilidade em relação ao ano anterior, seja por residência conectada por [banda larga fixa](https://combomultinetnow.com/net-virtua/) (64%) ou móvel 3G ou 4G (25%). O acesso móvel, no entanto, continua sendo mais utilizado do que o fixo por domicílios de classes D/E (48%).

## Usuários de Internet

A proporção de usuários de Internet no Brasil cresceu seis pontos percentuais, passando de 61% (2016) para 67% (2017). Em números absolutos, [120,7](https://maps.google.com/?q=120,7&entry=gmail&source=g) milhões de brasileiros acessam a rede, sendo que nas áreas urbanas essa proporção é de 71%. Ainda de acordo com a pesquisa, 87% deles usam a Internet todos os dias ou quase todos os dias. Já em relação ao dispositivo para acesso individual, mais uma vez a pesquisa aponta a preferência pelo celular, utilizado por quase a totalidade dos usuários (96%). Observou-se ainda um crescimento da televisão, utilizada por 22% dos usuários para conectar-se à Internet. Essa proporção em 2014 era de 7%.  
  
As atividades mais mencionadas durante o uso da Internet continuam sendo o envio de mensagens (90%) e o uso de redes sociais (77%), porém o acesso a conteúdos audiovisuais tem apresentado crescimento nos últimos anos. A proporção dos usuários de Internet que assistiu a vídeos na Internet ou ouviu músicas _on-line_foi de 71% em 2017, o que representa 85 milhões de pessoas. A pesquisa também investigou entre a população usuária de Internet com 16 anos ou mais. Em relação aos serviços de governo eletrônico utilizados. Os serviços mais citados foram direitos do trabalhador e previdência (28%) e educação pública (28%).

## **Dispositivo utilizado para acessar Internet**

A pesquisa TIC Domicílios 2017 aponta que metade da população conectada acessa a Internet exclusivamente pelo telefone celular, o que representa 58,7 milhões de brasileiros. Pela primeira vez na série histórica, o estudo mostra que a proporção de usuários que acessam a rede apenas pelo celular (49%) superou a daqueles que combinam celular e computador (47%).  
  
O perfil de uso exclusivo pelo celular é mais comum entre os usuários de classe D/E (80%) e de áreas rurais (72%). Isto reflete uma realidade em que os cidadãos de baixa renda não possuem múltiplos dispositivos de acesso à Internet como acontece no caso das classes A e B. Esse perfil também é superior entre as mulheres (53%) em relação aos homens (45%).  
  
"No Brasil, 33 milhões de usuários com renda mensal de até dois salários mínimos utilizam a Internet exclusivamente pelo celular, enquanto o uso simultâneo incluindo o computador foi realizado por 88% dos usuários da classe A. O fator socioeconômico é preponderante. Aqueles que têm a possibilidade de escolher combinam o uso de mais de um dispositivo para acessar a rede, algo crucial para o desenvolvimento de habilidades digitais, especialmente no cenário de nova economia digital", pontua Barbosa.  
  
Em sua 13ª edição, a TIC Domicílios realizou entrevistas em mais de 23 mil domicílios em todo o território nacional, entre novembro de 2017 e maio de 2018 com o objetivo de medir o uso das tecnologias da informação e da comunicação nos domicílios, o acesso individual a computadores e à Internet, atividades desenvolvidas na rede, entre outros indicadores.  
  
Para acessar a TIC Domicílios 2017 na íntegra, assim como rever a série histórica, visite [https://cetic.br/](https://cetic.br/ "https://cetic.br/"). Compare a evolução dos indicadores a partir da visualização de dados disponível em: [https://data.cetic.br/cetic/explore?idPesquisa=TIC_DOM](https://data.cetic.br/cetic/explore?idPesquisa=TIC_DOM "https://data.cetic.br/cetic/explore?idPesquisa=TIC_DOM").