---
title: 'HTML 5 e SEO: mitos e verdades'
authors: Rodrigo Simoni
type: post
date: 2013-08-30
url: /html-5-e-seo-mitos-e-verdades/
dsq_thread_id: 1660828959
categories:
  - HTML5
  - SEO

---
Sabemos que o Google está cada vez mais buscando relevância em conteúdo de alta qualidade e campo semântico que tenha significado. A cada atualização do algorítimo, percebemos que conteúdo de qualidade também precisa estar semântico, ou seja, que faça sentido tanto para os usuários como para o Googlebot, o robô do Google.

Um dos assuntos mais discutidos em SEO, é se o código de um site tem o poder de influenciar o ranqueamento no Google. Se seu site estiver escrito em HTML 5, ele pode ganhar vantagem? Afinal, até que ponto o HTML 5 pode impactar o SEO? Se um site estiver escrito em tabelas (forma antiga e obsoleta de estruturar um site), ele pode perder pontos com o Google? Vamos discutir isso:

## Evolução do HTML

O HTML tem bastante história e desde 1992 passou por várias versões e a linguagem evoluiu muito de lá pra cá. Aqui vai um resumo das principais mudanças:

  * Em 1992, a W3C, de Tim Berners-Lee, lança o HTML com apenas algumas marcações de texto e link.
  * Em 1993 apareceram marcações de tabelas, formulários e alguns estilos para definir a aparência.
  * Em 1994 é lançado o HTML v2.0 com algumas de suas características padronizadas.
  * Em 1996 foi lançado o CSS1 para formatar todos os estilos visuais da página separado do documento HTML.
  * Em 1999 é lançado o HTML v4.01.
  * Em 2000 o HTML evolui para (X)HTML, unindo documentos XML com HTML.
  * Em 2008 começa a documentação do HTML 5, ao qual está evoluindo e é a versão atual.

O HTML5 foi criado exatamente para dar significado semântico às páginas web, além de padronizar e facilitar o entendimento das sessões de um site pelos navegadores.

## Estrutura básica do HTML 5

A quinta versão do HTML possui uma estrutura mais objetiva e de fácil entendimento pelos navegadores. Cada “parte” ou “sessão” de um site deve ter um significado de acordo com suas tags. Vamos conhecer a estrutura básica do HTML 5:

<img alt="Estrutura HTML5" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/08/html5-estrutura-420x310.png" width="420" height="310" />

### Estruturação

**<header> – **Serve para marcar o cabeçalho do documento. Dentro da header devem conter por exemplo elementos como o logo do site e o menu principal.

**<nav> – **Essa tag serve para identificar o menu principal do site, ou seja, o menu de navegação. Ele pode estar dentro da tag header, pois geralmente se encontra no topo da página.

**<section> – **A section serve para separar as sessões de uma página e para identificar abordagens diferentes de uma página.

**<hgroup> – **Serve para agrupar títulos e subtítulos de uma página.

**<article> – **Serve para identificar as chamadas que estão dentro de uma section. As chamadas principais da home por exemplo, podem ser alocados cada uma delas dentro da tag article.

**<main> – **Essa é uma tag recente criada pela W3C. Ela pode ser usada para identificar o conteúdo principal da página. Por exemplo, o conteúdo de um artigo pode estar dentro da tag main.

**<figure> – **Serve para inserirmos as imagens da página. Com essa tag, os motores de renderização podem entender melhor a imagem e do que ela trata.

**<aside> – **Essa tag é usada para a identificação de um conteúdo secundário que não seja parte da sessão principal do site. Ela é bastante usada como uma sidebar, alocadas em uma coluna esquerda ou direita de uma página.

**<footer> – **Usada para identificar o rodapé do site.

### **Multimídia**

**<audio> – **É uma maneira simples e eficiente de inserirmos um arquivo de áudio na página.

**<video> – **É usada para inserirmos arquivos de vídeo na página. Existem muitas atributos que complementam essa tag, como inserir legenda por exemplo.

Essas tags mostram apenas a estrutura básica do HTML5 e existem muitas outras que daria para escrever um artigo só falando delas. Muitas dessas tags podem ser completadas com outros atributos que irão ajudar ainda mais na identificação dos elementos do site por motores dos browsers.

## **HTML 5 é bom para SEO?**

O HTML 5 já é bastante usado pelos desenvolvedores e está cada vez mais tomando forma. Se for usar CSS3, tome cuidado em não estrapolar, pois muitos de seus seletores ainda não são identificados pelo Internet Explorer de versões mais antigas.

Por outro lado, o HTML5 pode fazer uma verdadeira limpeza no código do seu site, deixando ele mais rápido de carregar e ganhando assim performance. Sabemos que a velocidade de carregamento de uma página é um fator considerável para o Google, por tanto, uma vez que seu site tem o código limpo e bem escrito, podemos considerar que isso possa ser um fator indireto de ranqueamento.

## Meu site precisa estar em HTML 5?

Como já disse, o HTML 5 já é muito usado e será cada vez mais usado. Apesar de alguns navegadores ainda não interpretarem tão bem algumas tags de forma semântica, elas são renderizadas.

É recomendável deixar seu site em HTML 5 pelo ganho de performance e pela tendência do mercado, pois o HTML 5 evoluirá cada vez mais. Não há problema algum estruturar o código do seu site em HTML 5 e mesmo que algumas tags não sejam interpretadas semanticamente, elas não atrapalham de jeito nenhum.

## Futuro do HTML5

Os navegadores estão se preparando cada vez mais para conseguir entender melhor cada parte do seu site e de forma semântica identificar cada elemento da página.

Mais do que o HTML 5 evoluir ou surgirem outras versões, o Google mostra que está dando muita importância à semântica, tanto no sentido de estrutura do site quanto ao seu campo semântico, por isso, é importante já fazer uso do HTML 5 e seguir a tendência semântica da web.