---
title: Hierarquia no design
authors: Fabio Marelli
type: post
date: 2016-06-30
url: /hierarquia-no-design/
categories:
  - Design
  - UX
tags:
  - Hierarquia
  - hierarquia no design
  - interface
  - organizar informação

---
Hierarquia, segundo o dicionário Michaelis, é a categoria atribuída às pessoas ou às coisas, classificadas de acordo com a ordem de importância, crescente ou decrescente. Dessa forma, organizar hierarquicamente é o mesmo que definir graus de importância à alguém ou à alguma coisa.

A hierarquia no design tem o mesmo objetivo da definição acima citada. Hierarquizar no design é controlar a transmissão e o impacto da mensagem. O designer sabe disso e faz uso da escala, cor, tonalidade, peso, inclinação, espacejamento, intervalos e inúmeras outras técnicas para atingir o objetivo de organizar a informação. Um exemplo clássico da importância da hierarquização no design é o sumário de um livro. Ali o leitor deverá encontrar as informações hierarquizadas e organizadas para que o conteúdo não fique confuso e que a navegação flua de tal forma que o leitor posso ter uma noção geral, porém real, do conteúdo do livro.

A hierarquia guia o usuário na interface do dispositivo. Um site bem projetado é, entre outras coisas, ter as suas seções e estruturas dispostas em uma hierarquia coerente, que facilite a navegação do usuário no encontro das informações que deseja. Por exemplo, o título de uma seção recebe uma tipografia no tamanho de 48 pixels e um corpo pesado (bold), e o slogan que está posicionado logo abaixo recebe uma tipografia no tamanho de 24 pixels e um corpo normal. Bem, nesse caso o designer comunicou ao usuário que o título é mais importante que o slogan, e que deve ser lido primeiro e o slogan em seguida.

De acordo com as designers Ellen Lupton e Jennifer Cole Phillips, autoras do livro &#8220;Novos Fundamentos do Design&#8221;, &#8220;expressar hierarquias é um processo ativo, investigativo e capaz de gerar resultados visuais dinâmicos.&#8221;. Hierarquizar não precisa ser a mesma coisa sempre. O designer pode ser inventivo, criativo na solução de problemas de hierarquia, toda a vez que o projeto permitir, para sempre romper a barreira do &#8220;mais do mesmo&#8221;. Essa inovação renova o interesse do usuário no conteúdo.

Abaixo alguns exemplos onde a hierarquia é aplicada:

<img class="size-full wp-image-54066" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2016/05/Parcel.png" alt="Parcel" width="1351" height="642" />

&nbsp;

No site de entregas [Parcel][1], a home foi pensada e construída de forma que as atenções iniciais se voltem para a marca da empresa escrita no tamanho de 54 pixels. Após esse impacto inicial o usuário é conduzido a ler o slogan da empresa, que está escrito no tamanho de 19 pixels. Essa diferença entre os tamanhos indica claramente quem é mais importante, e quem deve ser lido primeiro. Isso é hierarquizar as informações.

&nbsp;

<img class="size-full wp-image-54067" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2016/05/webField.png" alt="webField" width="1348" height="642" />

&nbsp;

Nesse caso o impacto não é tão gritante quanto o anterior. No site Web Field Manual os títulos estão no tamanho de 16 pixels, com um corpo pesado (bold), em caixa-alta (caps lock) e na cor vermelha. Já a descrição que vem logo abaixo de cada título está no tamanho de 13 pixels, porém com um corpo normal (regular). Bem, o contraste causado nesse caso também comunica ao usuário que ele deve ler o título primeiro, para após ler a descrição.

Esses exemplos deixam claro que existem muitas possibilidades de trabalhar a hierarquia em um projeto gráfico ou para web. O importante é que o designer tenha os conhecimentos necessários de hierarquia, um bom senso crítico e muita criatividade, pois o sucesso é garantido.

**4 PASSOS DA HIERARQUIA**

  * **Guiar o usuário &#8211;** A hierarquia guia a navegação do usuário na plataforma, seja ela on-line ou off-line. A hierarquia mostra o que o usuário deve ler primeiro.
  * **Destacar o mais importante &#8211;** Em um site de notícias, por exemplo, os títulos das notícias recebem um destaque maior. Dessa forma, se houver interesse pelo título, o usuário vai clicar e ler a notícia.
  * **O usuário escaneia o conteúdo &#8211;** Isso está relacionado aos conceitos UI e UX, pois o usuário faz um escaneamento geral da interface, diferentemente de uma máquina que escaneia item por item de forma individual. Esse escaneamento feito pelo usuário faz com que ele tenha uma noção real do que se trata o conteúdo, e dessa forma vai buscar os itens com maior destaque na interface para saber se vai continuar lendo ou não.
  * **Tudo influencia a hierarquia &#8211;** Inclinação, cor, peso, tonalidade, espaçamento, contraste entre a tipografia, alinhamento, entre outros.

 [1]: https://www.fromparcel.com/