---
title: Guia de Estilos
authors: Dani Guerrato
paid: true
type: post
date: 2013-01-09
excerpt: Entenda mais sobre guias de estilos, padrões para equipes, organização de CSS e mais.
url: /guia-de-estilos/
dsq_thread_id: 994310264
categories:
  - CSS
  - Design
  - HTML
  - UX
tags:
  - 2013
  - design
  - wireframes
---

Um dos elementos mais importantes do processo de criação de identidade visual é a elaboração de um documento com informações concretas sobre cores, tipografia, forma, exemplos de uso, tamanho mínimo e área de reserva do logotipo, etc. Este documento, conhecido como Guia de Identidade Visual ou simplesmente Manual da Marca, não se restringe apenas ao aspecto gráfico e pode muitas vezes incluir explicações sobre a visão, história e filosofia da empresa, uma perspectiva mais aprofundada dos símbolos e signos utilizados para compor o design ou até instruções gerais sobre a linguagem a ser utilizada na comunicação escrita, por exemplo. Seja um documento em PDF de apenas uma página com diretrizes simples do tipo “faça e não faça” ou um livro complexo com dezenas de exemplos de aplicação, o Guia de Identidade Visual é o que garante a consistência e uniformidade da percepção de uma marca. É o que vai fazer ela ser imediatamente reconhecida como uma entidade.

Mas estes guias não se restringem ao universo do design. E eles podem ser mais ou menos formais. Uma revista ou jornal possui um manual de estilo com padronizações de elementos como tamanho da lauda, ortografia, e estilo geral da redação. 

Na moda e no design de interiores é muito comum o uso de mood boards, literalmente quadros de humor. Podem ser organizados nos mais diferentes meios, de pastas fichário com recortes e colagens, a quadro de cortiça com alfinites ou boards virtuais no Pinterest. Não importa muito o formato, a idéia aqui é reunir inspirações de cores, texturas, padrões, etc de maneira mais ou menos complexa para ajudar a compor o clima geral do design. Um mood board pode parecer confuso e bagunçado, mas é um guia de estilo a sua maneira.

Websites também podem possuir guias de estilo, mas, infelizmente, poucos profissionais incorporam esta boa prática no workflow. 

## O problema de outros métodos

Muitos podem argumentar que os guias de estilo ou styles guides podem ser substituídos por outros elementos como wireframes e mockups. Mas cada um destes métodos possuem pequenas falhas com potencial para tornarem-se grandes problemas. Vamos a eles&#8230;

Wireframes são úteis para a prototipagem. É no wireframe que podemos visualizar a estrutura mais básica de um site. Básica até demais. É bem difícil explicar para um usuário comum que aquele monte de caixas, linhas e rabiscos é na verdade um esqueleto complexo de um website. Em geral profissionais da internet conseguem abstrair que no lugar daquele quadrado gigante no topo de uma folha haverá um banner rotativo animado por Javascript com imagens grandes, legendas e textos. Para o seu cliente ainda será apenas um rascunho. E dificilmente ele dará a aprovação (e o investimento) para um rascunho, por mais bem arquitetado que ele esteja.

> Wireframes são úteis para a prototipagem. É no wireframe que podemos visualizar a estrutura mais básica de um site.

Já os mockups são bem úteis para o cliente visualizar o produto final. Mas, além de tomarem uma quantidade muito grande de tempo (certas vezes mais do que o desenvolvimento final), muitas vezes são retratos no mínimo otimistas e no máximo absurdamente utópicos de um website. Dificilmente aquela conjunção perfeita de pixels do PSD vai se repetir “ao vivo” na versão final em HTML. E isto não é culpa dos designers e / ou deselvolvedores. Em uma situação ideal teríamos textos, imagens, vídeos, etc com antecedência para então projetarmos um layout perfeitamente desenhado para receber aquele conteúdo especifico. Não sei se sou uma designer especialmente azarada, mas jobs assim não caíram muitas vezes do céu para a minha mesa. E quando o conteúdo é dinâmico a coisa complica ainda mais, pois a partir do momento que ele será administrado por terceiros, meu amigo, você perdeu o controle do layout. O texto final editado pelo redator não ocupará o mesmo espaço do seu Lorem Ipsum. As imagens não terão a resolução tão boa. Muitas vezes é difícil até convencer um cliente de uma empresa pequena a contratar um fotografo ou comprar imagens de um banco (Que freelancer nunca ouviu “Como assim não posso simplesmente copiar do Google?”). O fato é que, a maior parte dos clientes não sabe prever de maneira objetiva e pontuada o tipo de conteúdo de um site antes de ele ser projetado. E isto é compreensivel. Vou explicar.

## Por que seu cliente não sabe dizer o que quer

Web design é uma profissão nova. O primeiro navegador gráfico surgiu em meados de 1993. Ou seja, são por volta de 20 anos de história&#8230; E no começo ninguém de fato sabia bem como desenvolver para a web. Foi necessário alguns anos e muitas pesquisas teóricas e práticas, testes com usuários, chutes certeiros e alguns nem tanto (alô Flash!) e muita muita discussão para que se fundamentasse um conhecimento básico padronizado sobre o assunto. E ainda assim ele está permanentemente em construção. Agora. Em entidades como a W3C, em livros e eBooks, em rodinhas de café e artigos como este. Mas antes que se chegasse perto de um consenso do que era “melhor” para a internet a solução foi tentar emprestar teorias e fundamentos do parente mais próximo. O mais perto que tínhamos era o Design Gráfico. Mas não é uma transição ideal&#8230;Um poster, um cartão de visita ou um panfleto são objetos estáticos. Já um website é como uma entidade viva em constante evolução. Com o tempo novas necessidades vão surgindo e é impossível prever no mockup inicial todas as situações de uso, por mais que nos esforcemos para cobrir todas as bases. O seu cliente não sabe o que quer por que, até de fato ele “ter” um site, ele (compreensivelmente) não sabe bem o que dá para fazer com um. E talvez você também não soubesse antes de começar a trabalhar com isto. Eu certamente não sabia. Mesmo em sites já estabelecidos mudanças acontecem. Sempre tem uma nova rede social que é a bola da vez ou o público-alvo cresceu, mudou de ideia, evoluiu. No inicio blogs eram uma versão virtual dos diários adolescentes do passado e agora são utilizados como ferramenta de divulgação e propagação de conhecimento. E a web vai continuar sendo esta metamorfose constante. Como definir, explicar, entender, catalogar algo que muda de forma a cada instante? Como fazer isto para alguém que nasceu antes? Aqueles que a 20 anos atrás tinham dificuldades em programar o vídeocassete certamente vão estranhar a user interface de um tablet. Por mais amigável que ela seja existe um certo medo do novo. 

E o que dizer quando somando a este equação entram diferentes mídias, resoluções de tela e velocidades de banda? A triste realidade é que, por estas e outras razões, o mockup nunca corresponde ao produto final. E a raiz deste problema esta no processo de criação

## Websites não são páginas

Um designer abre o Photoshop, cria um novo arquivo e a primeira decisão a se tomar é a largura do canvas. O problema é que na internet não existem canvas. Telas, páginas e dobras são conceitos do mundo real, metáforas que utilizamos para tentar descrever a web (que também não é uma teia) de maneira mais concreta. A internet é inerentemente fluída. Existe apenas um espaço vazio a ser preenchido, limitado apenas pelo viewport do browser. Nós adicionamos as larguras de maneira artificial por que estamos acostumados com elas. Nós gostamos de posters, cartões e panfletos. Mas para contornarmos este problema, que aflige tanto designers como desenvolvedores, é necessário parar de pensar em websites como páginas e começar a trata-los como sistemas. Uma página é uma face de uma folha. Um sistema é um conjunto de elementos interconectados que formam um todo organizado. Na internet não existem folhas.

> É necessário portanto pararmos de projetar ambientes estáticos e começarmos a pensar em termos de guias de estilo. 

## O que é um guia de estilo

Lembra do Guia de Identidade Visual do inicio do texto? Um guia de estilo funciona da mesma forma. Só que ao invés de se restringir ao campo semântico do design gráfico, o guia de estilo pode (e deve) conter também elementos da interface, padronização de código, vocabulário, lógica de programação etc. O ideal é que o guia de estilo funcione como um meta-site. 

## O que colocar em um guia de estilo

O que não pode faltar de jeito nenhum no seu guia de estilo são os elementos gráficos e suas respectivas interações. Pense em todos os elementos de HTML que provavelmente serão utilizados no layout e projete-os. Isto deve incluir, pelo menos, o estilo básico dos parágrafos, títulos de h1 a h6, links, listas numeradas e não numeradas, tabelas, blocos de citação, botões (e seus respectivos estados padrão, ativo, inativo, hover), formulários e seus respectivos campos (input, textarea, select, radio buttons), caixas de busca, iconografia, blocos de comentário, breadcumbs, mensagens de erro, cores, tipografia, grids&#8230; Enfim, pense em termos de blocos de lego. Com eles você consegue construir qualquer estrutura. Com os elementos da interface prontos você consegue construir qualquer página. Vale a pena até incluir snippets de código a ser reutilizado. Como, por exemplo, um módulo de carrossel ou slider. Outra informação importante são as dimensões padrões de altura e largura das imagens.

Mas não é necessário se limitar a isto. Por que não definir padrões para a equipe de desenvolvimento? Existem tantas maneiras de organizar um CSS, por exemplo, que não é incomum pessoas de um mesmo grupo não entenderem o código uns dos outros. O estilo será inline ou identado? Qual vai ser o padrão de nomenclatura de elementos do layout? A ordem das declarações? Organização das pastas? São itens muitas vezes subjetivos, mas que nos fazem perder tempo a cada novo projeto por que cada um escreve de um jeito. Não importa a decisão que seja melhor para você ou sua equipe, o importante é ter um vocabulário compartilhado para todos falarem a mesma língua. 

## Se você não se convenceu até agora&#8230;

As vantagens dos Guias de Estilo são inúmeras. É mais fácil de testar e de realizar mudanças, é mais simples de apresentar para um cliente e mais sustentável a longo prazo. Afinal, você pode passar o projeto para frente tranquilo, sabendo que uma outra pessoa conseguirá entender a estrutura básica do site como um sistema. Os ganhos de tempo, dinheiro e tranquilidade são imensuráveis.

## Veja na prática

Se você quer um exemplo prático confira o Styleguide da [Mozilla][1]. É um guia de estilo muito bonito, completo e muito bacana como inspiração. Outro exemplo bom em termos de organização e conteúdo são os estilos básicos do framework [Bootstrap][2]. Quer mais? [Este site][3] contem uma galeria com diversos exemplos de guia de estilo. Vale a pena favoritar. Para quem procura um guia que inclua padrões de organização de código o WordPress [Coding Standarts][4] é um bom exemplo de guia de estilo de PHP. 

## Leitura recomendada:

  * [Responsive Summit][5]
  * [Front-end Style Guides][6]
  * [Future Friendly Style Guides][7]
  * [CCS Coding Standarts][8]
  * [Style Tyles and How they Work][9]
  * [Styleguides são o novo Photoshop][10]

 [1]: https://www.mozilla.org/en-US/styleguide
 [2]: https://twitter.github.com/bootstrap/base-css.html
 [3]: https://gimmebar.com/collection/4ecd439c2f0aaad734000022/front-end-styleguides
 [4]: https://codex.wordpress.org/WordPress_Coding_Standards
 [5]: https://maban.co.uk/65
 [6]: https://24ways.org/2011/front-end-style-guides/
 [7]: https://speakerdeck.com/lukebrooker/future-friendly-style-guides
 [8]: https://coffeepowered.co.uk/2010/01/css-coding-standards/
 [9]: https://www.alistapart.com/articles/style-tiles-and-how-they-work/
 [10]: https://arquiteturadeinformacao.com/2012/12/17/styleguides-sao-o-novo-photoshop/