---
title: GitHub vs GitLab
authors: Lucas Gonçalves Cunha
type: post
image: https://cdn-images-1.medium.com/max/1600/1*OLsrVuctE2DO924KoSkNLA.png
date: 2018-06-05
excerpt: Comparativo entre as duas plataformas.
categories:
- Artigos
- Ferramentas
tags:
- Opinião
- GIT
---

# GitLab vs GitHub: um comparitivo entre as plataformas

![Imagem logo Gitlab vs GitHub](https://cdn-images-1.medium.com/max/1600/1*OLsrVuctE2DO924KoSkNLA.png)

## Controle de Versão

O controle de versão se tornou uma prática indispensável nos últimos anos, devido ao crescimento das equipes e a complexidade de desenvolvimento de softwares. Raramente temos um cenário de desenvolvimento que não seja colaborativo. Gerenciar conflitos de código, melhorar a comunicação e facilitar acompanhamento do que se está sendo feito é uma tarefa complexa e trabalhosa. Sendo assim, surgiram ferramentas de apoio ao desenvolvimento de software para dar suporte a estas atividades. Hoje uma das ferramentas mais usada para essa tarefa é o GIT.

O próprio site do [GIT](https://git-scm.com/) o define como sendo um sistema de controle de versão, distribuído, open-source e desenvolvido para dar suporte de pequenos até grandes projetos com velocidade e eficiência. No site do sistema são mostrados projetos e companhias que o usam. Podemos citar como exemplo, gigantes do setor de TI como: Google, Facebook, Microsoft, Twitter entre outras. Para quem não está familiarizado com a ferramenta, no site do sistema GIT tem uma sessão para [iniciantes que queiram aprender comandos](https://try.github.io/levels/1/challenges/1), além de tutoriais de instalação.

## Git

O GIT serve como controle de versão e atividades afins, mas para isso deve-se ter repositórios para serem gerenciados. Aqui entra as duas plataformas que serão comparadas no artigo: GitLab e GitHub. As duas plataformas são para hospedagem de repositórios baseados no sistema de controle de versão GIT, que simplificam o trabalho de desenvolvimento. Elas fornecem locais centralizados, baseados em nuvem, onde as equipes podem armazenar, compartilhar, publicar, testar e colaborar em projetos de desenvolvimento.

## GitHub

O [GitHub](https://github.com/) é uma plataforma de hospedagem de repositórios com 27 milhões de usuários, 80 milhões de repositórios e 1,8 milhão de organizações, dados em maio de 2018. O projeto foi lançado em 2008 pelos desenvolvedores da Logical Awesome e adquirida pela Microsfot recentemente. O GitHub foi escrito em Ruby on Rails. Durante a evolução da ferramenta foi visto que funcionalidades que permitissem a interação entre usuários foram implementadas, deixando com a cara de rede social. Alguns dizem que o GitHub é a rede social dos desenvolvedores. Lista de discussões, wikis e ferramentas para gerenciar contribuições foram adicionadas a plataforma. Talvez o maior exemplo do poder da plataforma é seu uso pela comunidade de desenvolvimento do Linux. Apesar disso, uma grande ironia é a plataforma ser suporte para vários projetos open-source, mas ela mesma não é.

## GitLab

Já o [GitLab](https://gitlab.com/) surgiu meados de 2011, fundado por Dmitriy Zaporozhets e Valery Sizov. Os dois criaram a plataforma devido a uma necessidade própria. O projeto é open source, o que atraiu a ajuda de colaboradores. O projeto conta com mais de 1980 colaboradores ao redor do mundo (Maio 2018), inclusive brasileiros. São mais de 100 mil organizações e milhões de usuários fazendo uso da plataforma, segundo o site da própria plataforma. Podemos citar como organizações que usam o GitLab: NASA, SandDisk, redhat, Sony, EA entre outras. Em setembro de 2015 o GitLab recebeu um financiamento de aproximadamente U$ 4 Milhões da empresa Khosla Ventures.

## Características em comum

Existe um universo gigante de funcionalidade entre as plataformas. Foge do escopo do artigo a comparação entre todas as funcionalidades. Mas podemos citar os recursos básicos bem similares e estão disponíveis nas duas plataformas:

* **Pull request**

* **Revisão de código**

* **Edição inline**

* **Acompanhamento de problemas (Issue Tracking)**

* **Autenticação de dois fatores**

* **Gerenciamento avançado de permissão**

* **API rica em recursos**

* **Fork / Clone de repositórios**

* **Integrações de terceiros**

A duas plataformas apresentam recursos similares, mas existem algumas diferenças interessantes na hora de optar por uma delas.

## Importar e exportar

Quando comparamos plataformas para este fim, a capacidade de importar projetos existentes é uma característica a ser observada. Nesse caso, o GiHub importa de sistemas de controle de versão como Git, SVN, Mercurial e TFS. Já o GitLab faz importação de outros serviços do GitHub, Bitbucket, Google Code, Fogbugz. Vale destacar que a documentação para procedimentos de importação fornecidas no do GitLab é bem completa, facilitando a vida do usuário.

Além disso, quando se trata de exportar dados, o GitLab parece fazer um trabalho bastante sólido, oferecendo a capacidade de exportar seus projetos, incluindo os seguintes dados:

* **Wiki e repositórios de projetos**

* **Uploads de projetos**

* **Configuração incluindo webhooks e serviços**

* **Issues com comentários, solicitações de merge com diffs e comentários, rótulos, milestones, snippets e outras entidades do projeto**

Por outro lado, o GitHub parece ser mais restritivo quando se trata de exportar recursos de repositórios existentes.

## Preços e planos

O plano gratuito do GitHub permite que você hospede um número ilimitado de repositórios públicos com a capacidade de clonar, bifurcar (fork) e contribuir para eles. Se você deseja hospedar projetos privados gratuitamente, com certeza essa não é a solução.

O plano hospedado pela nuvem do GitLab permite que um número ilimitado de usuários colaborem em um número ilimitado de projetos públicos e privados. Eles têm 10GB de limite de espaço por repositório.

O plano gratuito de codificação permite que 10 membros colaborem em um número ilimitado de repositórios públicos e privados, mas impõem um limite de armazenamento geral de 1 GB, que parece uma grande restrição.

Se você está procurando uma solução gratuita baseada em nuvem para projetos privados, a oferta do GitLab é provavelmente a mais atraente.

As duas plataformas têm serviços pagos também. A hospedagem pode ser particular em servidor próprio ou nos servidores das plataformas. No caso do GitLab, os preço vão da versão gratuita até o valor de 99 dolares por mês por usuário, com uma gama serviços divididos em quatro planos. Já o GitHub são três planos que vão de 7 dolares a 21 dolares por mês. Para maiores detalhes, basta consultar as páginas das duas plataformas onde os serviços estão detalhados.

## Integrações

As duas plataformas oferecem serviço de integração com app de terceiro. Uma boa ideia é pesquisar nos sites das plataformas informações sobre app compatíveis para integração. A integração permite a melhoria do processo e aumento de produtividade da equipe participante no projeto em geral.

Um ponto extremamente favorável ao GitLab é o conjunto de ferramentas próprias para acompanhamento e suporte para o desenvolvimento usando metodologia DevOps. A nova metodologia que vem sendo usada para o desenvolvimento de software tem todo suporte na plataforma do GitLab. A integração com sua própria ferramenta de [CI/CD](https://about.gitlab.com/features/gitlab-ci-cd/) facilita a visualização dos builds e pipelines. Com as ferramentas de de CI/CD e o [GitLab Runner](https://docs.gitlab.com/runner/) é possível automatizar diversas tarefas no processo de deploy, agilizando o processo de entrega e entregando com mais segurança. Isso é útil para geração de builds e analisar falhas de compilação. Para ter algo semelhante para projetos hospedados no GitHub, ferramentas como CircleCI teriam que ser usadas.

## Issues

O recurso de issues do GitLab é muito parecido com o do GitHub, mas a visualização do board e sua disposição facilita a movimentação de cartões entre as colunas. Isso pode ser feito no GitHub usando ferramentas externas, mas ter uma interface do usuário para controlá-las é uma grande vitória.

# Conclusão

As duas plataformas dão um suporte excelente para quem quer aglo além de um controle de versão. Tecnicamente são bem semelhantes, mas com uma proposta pouco diferente: O GitHub preza pela alta disponibilidade e desempenho de recursos básicos, usando a integração com ferramentas de terceiros para atividades alternativas, enquanto o GitLab incorpora todos recursos em uma única plataforma bem integrada e com ótimo apelo visual. Apesar da aquisição do GitHub pela Microsoft gerar dúvidas sobre o futuro da plataforma, dependerá da sua necessidade adoção de uma ou outra. Se quer uma solução open-source, GitLab é a melhor opção. Se o seu projeto é de código aberto, o GitHub definitivamente é a escolha.

## Para ler mais

* [GitHub vs. Bitbucket vs. GitLab vs. Coding](https://medium.com/flow-ci/github-vs-bitbucket-vs-gitlab-vs-coding-7cf2b43888a1)
* [GitLab e GitHub: How are they different?](https://www.upwork.com/hiring/development/gitlab-vs-github-how-are-they-different/)
* [What Is GitHub and Why Should Your Digital Team Use It?](https://www.upwork.com/hiring/development/what-is-github-and-why-should-your-digital-team-use-it/)

---

**Apoio:** [Curso de Eletricista](https://portaldaengenharia.com/cursos/curso-de-eletricista/)
