---
type: post
title: Gerenciando o produto por resultados (Outcomes) e não por entregas (Outputs)
excerpt: >-
  Entenda como por que é melhor gerenciar produtos digitais por meio de
  resultados, não entregas.
authors: Diego Eis
date: '2019-10-23'
publishDate: '2019-10-23'
image: 'https://i.imgur.com/aLKQUnO.jpg'
categories:
  - product management
tags:
  - dados
---
É muito comum encontrar Product Managers que raciocinam da seguinte maneira: o usuário tem um problema, então, faço uma funcionalidade/melhoria/mudança e resolvo o problema.

![Forma errada de pensar antes da solução, antes de funcionalidade, depois o problema.](https://diegoeis.com/images/uploads/img1.png)

Mas não é só por que finalizamos e shipamos uma funcionalidade, que o problema será resolvido ou muito mais importante: que essa entrega causou o impacto desejado no comportamento do usuário e/ou trouxe impacto positivo financeiro ou de posicionamento para a empresa.

## Direcionando seu produto por entregas e funcionalidades (outputs)

Quem nunca teve que preparar uma apresentação para a empresa - principalmente para os stakeholders - com um roadmap de entregas de funcionalidades? É comum as pessoas precisarem/desejarem ver quando e o que será entregue a fim de entender onde e quando teremos os resultados para o usuário ou para a empresa.

![roadmap baseado em funcionalidades](https://diegoeis.com/images/uploads/roadmap.png)

Quando funcionalidades estão no centro do nosso backlog e das nossas discussões, **estamos gerenciando nosso produto por Outputs** (que eu chamo aqui de _entregas_, por falta de tradução melhor).

> Managers don’t care how they achieve their business goals; they just want to achieve them. — [Jeff Gothelf e Josh Seiden](https://hbr.org/2017/02/you-need-to-manage-digital-projects-for-outcomes-not-outputs)

Ser apaixonado pela solução é um erro comum entre novos e velhos Product Managers. Mais correto (e difícil) é ser apaixonado pelo problema. **Isso quer dizer que é melhor investir mais tempo no Upstream do processo, conhecendo mais o problema, entendendo seus meandros e motivos, para depois avançar para uma solução**. Aquela velha história de pensar duas vezes pra cortar uma.

**A quantidade de software (traduzido em funcionalidades, bugs, débitos técnicos, alinhamento de design…) entregue, não importa**. O que importa é se essas entregas estão impactando o comportamento do usuário, que por sua vez impactam os indicadores de produto, que por sua vez devem impactar indicadores de negócio. 

Mesmo que as funcionalidade sejam pautadas em necessidades reais do usuário, que foram descobertas em entrevistas de mercado e validadas por dados, você como Product Manager **deveria gerenciar seus produtos tendo em vista Resultados (Outcomes)**.

## Direcionando seu produto por resultados (outcomes)

Gerenciar um produto por resultados é direcionar a empresa e o time para alcançar um determinado objetivo, mudando um determinado indicador de produto que por sua vez muda o negócio. 

Os outcomes são definidos por indicadores mensuráveis pelo time, que é importante para o usuário ao mesmo tempo que para o negócio.

> É melhor investir mais tempo no Upstream do processo, para conhecer mais o problema, entendendo seus meandros e motivos, para depois avançar para uma solução.

Isso é muito mais fácil dizer do que fazer. Se o seu time faz isso sozinho, tem grandes chances de fracassar ou ter entraves bem grandes. O correto é que a empresa tenha um alinhamento claro e transparente sobre os objetivos que precisam ser alcançados. Dessa forma o time pode decidir como impactar o usuário para alcançar os objetivos globais.

![Melhor analisar indicadores de produto e depois em funcionalidades.](https://diegoeis.com/images/uploads/img-indicadores-funcionliadade.png)

O trabalho do Product Manager nesse ponto é instigar a liderança a definir e criar alinhamento sobre os objetivos que precisam ser atingidos. O time então expõe quais as oportunidades que podem ser exploradas que tem mais chances  de dar um bom resultado.

[![correto pensar em indicadores de produto, depois problema, depois funcionalidade, que gera mudança de comportamento do usuário, que muda indicadores de produto, que muda o negócio](https://diegoeis.com/images/uploads/correto.png)](https://diegoeis.com/images/uploads/correto.png)

A ideia é que você trabalhe para modificar resultados, e não meça sua performance por entregas de funcionalidades. Quando uma empresa trabalha com qualquer framework que coloque objetivos e resultados em primeiro lugar - como por exemplo OKRs - definir, medir e monitorar o que será feito fica bem mais fácil e inteligente.

![Roadmap tendo em vista primeiro indicadores e depois as  entregas que modificarão esses indicadores.](https://diegoeis.com/images/uploads/roadmap-correto.png)

Você deve definir seus Outputs apenas depois de definir os Outcomes. Isso parece ser simples e óbvio, mas geralmente não é isso que acontece. 

![pense em resultados, depois oportunidades, e por ultimo as ideias que modificarão os resultados.](https://diegoeis.com/images/uploads/ideia-resultado-oportunidade.png)

Contudo, a definição dos resultados que devemos atingir só vem depois de identificarmos os problemas e necessidades dos usuários. Muito por isso é tão importante conhecer bem a proposta de valor da empresa e qual o posicionamento que o produto deverá ter no mercado.

![Mas antes de pensar em resultados, pense em qual problema você quer resolver.](https://diegoeis.com/images/uploads/ideia-resultado-oportunidade2.png)

## O problema da confiança

Um dos principais problemas de liderarmos nossos produtos por meio de outcomes é a falta de confiança que gestores e stakeholders tem em seus times. Geralmente é uma desconfiança velada sobre a capacidade e competência de deixar o time definir como os outcomes serão alcançados.

![Ciclo da confiança explicado no próximo parágrafo.](https://diegoeis.com/images/uploads/ciclo.png)

Essa desconfiança cria um ambiente onde stakeholders e a liderança faça microgerenciamento dos outputs (entregas). Que por sua vez faz o time se afastar cada vez mais do principal objetivo que é entregar outcomes (resultados). Que faz os gestores e liderança terem ainda menos confiança. 

Esse é um problema importante que só pode ser resolvido com uma mudança de cultura, comportamento da liderança e também dos times, todos agindo em conjunto e não de modo individual.

Mas existem outros problemas que fazem com que a cobrança por entregas seja maior que por resultados, uma delas é a senioridade e nível de maturidade dos integrantes do times. 

Trabalhar com os eixos de Autonomia e Alinhamento não é algo fácil e deve ser exercitado por todos os níveis da empresa. Uma cultura de confiança deve ser criada, mas confiança não vem sozinha, precisa existir uma dose gigante de responsabilidade. Isso quer dizer que ninguém erra sozinho.

Como líderes, devemos perguntar mais, e os times deveriam mostrar melhor seus resultados, não fixando os olhares nas entregas, mas nos objetivos alcançados. Enquanto a liderança define, de forma transparente e objetiva, **o que** deve ser alcançado, o time tem o direito de decidir o **como** você chegarão lá.

## Referências:

* [You Need to Manage Digital Projects for Outcomes, Not Outputs](https://hbr.org/2017/02/you-need-to-manage-digital-projects-for-outcomes-not-outputs)
* [Everyone Thinks They’re Managing by Outcomes. Here’s How to Actually Do it.](https://www.producttalk.org/2019/10/managing-outcomes/)
* [Managing digital product teams to outcomes instead of output](https://planet-lean.com/digital-product-team-outcome-lean-agile/)
* [Problem vs solution mindset](https://medium.com/@jocatorres/problem-vs-solution-mindset-8c9add6076c2)
