---
title: Gerenciando equipes de alta performance em meio ao crescimento
authors: Vagner Dutra
type: post
image: https://i.imgur.com/9KYogqv.png
date: 2020-09-10
excerpt: Mantendo a alta performance tendo a contratação como uma opção e não como regra.
categories:
  - Agile e Gestão
  - Opinião
tags:
  - Mercado
  - Gestão
  - Contratação
---
Quando se fala sobre crescimento de uma organização, a conversa geralmente leva à contratação. Embora seja claro que contratar é uma abordagem muito importante para organizações em crescimento, é comum utilizarmos essa opção com muita frequência.

Para descobrir o momento certo para contratar é necessário que além de conhecer a estratégia da sua empresa, você também conheça muito bem seus times e em que momento estão.

Will Larson, autor do livro  [An Elegant Puzzle: Systems of Engineering](https://www.amazon.com/Elegant-Puzzle-Systems-Engineering-Management/dp/1732265186), analisa o momento de uma equipe utilizando quatro estados.

# Os quatro estados de um time

**Ficando para trás,**  **pisando na água**,  **pagando dívidas** e  **inovando**.

![Image for post](https://i.imgur.com/qQWAtZ2.png)

1.  **FALLING BEHIND —** Uma equipe está  **ficando para trás**  se, a cada semana, seu backlog fica maior que a semana anterior. As pessoas estão trabalhando muito, mas não estão progredindo, consequentemente seus usuários estão insatisfeitos.
2.  **TREADING WATER**  — Uma equipe está  **pisando na água**  se ela for capaz de realizar seu trabalho criando novas funcionalidades, mas não de começar a pagar dívidas técnicas. As pessoas estão trabalhando muito, mas não sentem satisfação ou orgulho do que estão construindo, consequentemente, seus usuários podem estar insatisfeitos.
3.  **REPAYING DEBT**  — Uma equipe está  **pagando dívidas**  quando é capaz de começar a pagar suas dívidas técnicas e se beneficiar de melhorias de performance e de qualidade, mas não tem tempo para inovar. Seus usuários podem continuar insatisfeitos.
4.  **INNOVATION**  — Uma equipe está  **inovando**  quando sua dívida técnica é baixa e sustentável e tem facilidade para criar novas funcionalidades. O time está trabalhando de forma saudável e o trabalho está satisfazendo as novas necessidades dos usuários.

Partindo da premissa de que a empresa está crescendo rápido e o escopo dos projetos e times tende sempre a aumentar, as equipes podem passar por esses estados várias vezes, criando assim um ciclo.

# O que fazer em cada estado

![Image for post](https://i.imgur.com/EoRYo2G.png)

1.  Ao  **ficar para trás**, a solução é  **contratar mais pessoas**  até que a equipe comece a pisar na água. Lembrando que você pode substituir a contratação com o redimensionamento dos times, baseado nas prioridades da empresa.
2.  Ao  **pisar na água**, a solução é  **repensar os processos**. Taticamente, o foco aqui é ajudar as pessoas a fazerem a transição de uma visão pessoal de produtividade para uma  **visão de equipe**. É muito comum reduzir o WIP (trabalho em progresso) do time para controlar as demandas e assim, conseguir planejar como pagar suas dívidas.
3.  Ao  **pagar uma dívida**, a correção é **adicionar tempo**. Tudo já está funcionando, você só precisa encontrar espaço para o pagamento de dívidas e também justificá-las agregando valor para o usuário. Em uma equipe que estava  **ficando para trás**  e alcançou este estado, todos estão ansiosos para entregar novas funcionalidades, e como líder, você deve controlar a impaciência do time e colocar todo foco possível nas dívidas mais críticas.
4.  A  **inovação**  é um pouco diferente, por que você atingiu o equilíbrio entre dívidas técnicas e construção de novas funcionalidades, mas ainda há uma correção para ser feita! Nesse caso, é necessário  **manter uma folga no cronograma**  da sua equipe para que ela possa criar  **qualidade**, trabalhar com  **excelência técnica**  e operar continuamente em  **inovação**.

A  **inovação**  é o estado ideal, pois indica que o tamanho do time está adequado as demandas. Além disso, indica também que os integrantes do time e os usuários estão satisfeitos.

É indicado  **contratar**  nos  **três primeiros estados**, sendo mais necessário no primeiro, porém podendo variar de acordo com a velocidade do crescimento da organização.

# Implementando correções nos times

![Image for post](https://i.imgur.com/e8vMjsT.png)

Independente da correção que você irá utilizar —  **contratação**,  **reorganização, processos ou tempo**  — você precisará implementar aos poucos. Cada time pode estar em um estado diferente, então comece a aplicar as mudanças em  **um time**. Itere nele até conseguir encontrar a melhor forma para aumentar a eficácia. Você terá recursos limitados, então não tente mover todas as equipes ao mesmo tempo, entenda suas particularidades e comece a aplicar onde considerar mais relevante para a estratégia da empresa.

----------

Agora, conhecendo o momento do seu time, todas as contratações devem ser feitas para a manutenção de times enxutos e de alta performance. Então, se você quer  **projetar headcount**  em meio ao crescimento, considere em seu cálculo de capacidade, o diagnóstico atual e a projeção dos times junto da sua estratégia.

Espero que tire proveito dessa leitura e que consiga diagnosticar seus times e planejar melhor suas contratações. Esse texto foi inspirado no livro  [An Elegant Puzzle: Systems of Engineering Management](https://www.amazon.com/Elegant-Puzzle-Systems-Engineering-Management/dp/1732265186), caso queira se aprofundar no tema, recomendo a leitura.
