---
title: Front-end, UX e Back-end
authors: Diego Eis
type: post
date: 2013-01-16
excerpt: Na verdade não é cada um na sua. Ou você levanta para ver o que acontece no mundo ao seu redor ou você atrofia suas skills.
url: /front-end-ux-e-back-end/
tweetbackscheck:
  - 1355164558
shorturls:
  - 'a:3:{s:9:"permalink";s:48:"https://tableless.com.br/front-end-ux-e-back-end/";s:7:"tinyurl";s:26:"https://tinyurl.com/d7lgtx7";s:4:"isgd";s:19:"https://is.gd/sVWLBy";}'
twittercomments:
  - 'a:0:{}'
dsq_thread_id: 954944209
categories:
  - Código
  - Design
  - UX
tags:
  - 2013
  - back-end
  - designers
  - front-end
  - programadores

---
> “One of the reasons for poor design execution is that UX teams need to own more than just design. We need to own front-end development.”

Frase sensacional [em um artigo do site UXMatters][1], um dos melhores sites sobre experiência do usuário e arquitetura de informação que tenho nas minhas leituras regulares.

Os designers para web precisam muito aprender a linguagem com que seus layouts serão codificados. Na minha opinião é estranho um designer para web não entender HTML e CSS, pelo menos o básico, o suficiente. Mesmo que ele não vá digitar código todos os dias. Conhecer essas linguagens é tão necessário quanto Photoshop ou Illustrator.

Os melhores desenvolvedores front-end, que prezam pelo layout bonito e bem afinado pensam e falam usando linguagens de design e UX. Claro que HTML, CSS e Javascript são linguagens técnicas, mas elas estão muito mais perto do lado de Design e experiência do usuário do que programação pesada de back. O Javascript, talvez, é o que se aproxima da área mais hardcore do back-end, mas isso só quando falamos em consumir APIs, usar JS no lado do servidor e etc. Javascript é o tempo inteiro usado também para tratar experiências e comportamentos para o usuário.

> O front-end faz a integração do projeto, fazendo as amarrações necessárias para que o sistema seja funcional e usável.

A maioria dos programadores back-end não conhecem front-end por não enxergarem isso como uma forma de melhorar suas skills. Normalmente alguns programadores não gostam de front por acharem muito próximo de UX. Coisa designer, sabe? Enquanto isso o pessoal da área de UX não se aproxima de front-end por acharem que é coisa de programador. É simples, mas é uma verdade. Ambos acabam atrofiando as possibilidades de melhorarem muito seus conhecimentos dentro das suas áreas.

Os desenvolvedores front-end trabalham no meio desses dois profissionais completamente diferentes e muitos se arriscam em um dos dois lados. Há os front-ends designers, que sabem o que é bonito e feio, entendem de grid, alinhamento, cores e etc. Podem não arriscar a criar um layout, mas entendem do assunto. Há também o front-end programador, que talvez até conheça uma linguagem back-end e manja o básico de algumas outras. Não faz um sistema complexo todos os dias, mas é um contribuir fervoroso nos projetos em que trabalha. Ambos são especialistas em front-end, com focos totalmente diferentes. Outro ponto que os destacam é que eles não ignoram as skills de cada área, mesmo não fazendo parte do seu core. E nem podem deixar que isso aconteça, eles perderiam muitos pontos de experiência.

> Quando os times de UX entendem a importância do front-end, eles entregam não apenas representações visuais dos projetos, mas também experiências que realmente valham a pena.

Os front-ends trabalham muito melhor suas skills quando eles entendem em qual dos lados eles tem mais facilidade. Se você é front-end e acha design interessante, busque mais conhecimento nessa área. Se puder, sente-se ao lado dos designers na sua equipe. Se você acha que programação server-side é sua praia, sente-se ao lado dos programadores. Entenda como eles fazem a integração da linguagem server-side no código client-side gerado por você. Estude maneiras de como o client pode consumir informação do back.
  
Apenas assim front-ends irão produzir códigos mais robustos e escaláveis, pensando na experiência do usuário e em formas de consumir e reutilizar informações mais eficientemente.

Quando os times de UX entendem a importância do front-end, eles entregam não apenas representações visuais dos projetos, mas podem entregar experiências que realmente valham a pena. Isso é ultrapassar aquela barreira do “é possível ou não é possível de fazer”. Isso diminui custos. Todo o resultado é mais correto. Um UX que entrega um protótipo funcional em HTML e CSS vale seu peso em ouro. É importante por que esse tipo de atitude concretiza ideias enquanto o projeto ainda é imaturo.

Entender sobre os processos é importante para qualquer um dentro da equipe. Entender as limitações e saber quais os impactos que cada decisão, por mínima que seja, desencadeia no projeto é algo que só se conhece quando você procura saber mais do que acontece ao seu redor. E eu não estou dizendo para você ser um profissional canivete, longe disso. Mas trabalhar em equipe envolve muito mais do que conversas nos dailys da vida.

 [1]: https://www.uxmatters.com/mt/archives/2012/04/great-user-experiences-require-great-front-end-development.php