---
title: Como dar início ao FRONT-END em 2018?
authors: Leonardo Cesca Flach
image: https://i.imgur.com/JvE8HAp.jpg
type: post
date: 2018-11-09
excerpt: Descubra um pouco mais sobre a área de front-end em 2018.
categories:
  - Front-end
  - HTML
  - CSS
---

## Conheça alguns passos para iniciar no front-end no ano de 2018.

Talvez um dos tópicos mais pesquisados pelos iniciantes na área. Mas não se desespere em aprender rápido, as coisas levam tempo para se consolidarem e devem ser respeitadas.

Você já deve ter se perguntado: Qual a maneira mais fácil e rápida de aprender front-end? A verdade é que não há atalhos e muito menos fórmulas mágicas para ser um desenvolvedor front-end, basta ter persistência e dedicação.

Todos nós algum dia de nossas vidas nos perguntamos: *“Será que realmente estou no caminho certo aprendendo isso? É realmente necessário?”*  

## Começando

Independente se você vai querer ser um [front end engineer ou front end design](https://tableless.com.br/os-dois-tipos-de-front-end-design-e-o-engineer-parte-1-uma-breve-historia/), a primeira coisa que você deve aprender e levar para vida são os fundamentos de HTML5 e CSS3, sem essa dupla fantástica e crucial dominada logo à frente encontrará problemas..

Após ter dominado a dupla, é importante conhecer e praticar o famoso mobile-first. [Mobile-First](https://tableless.com.br/mobile-first-a-arte-de-pensar-com-foco/), para quem não conhece, é um conceito onde é desenvolvido primeiramente para telas menores (celulares e tablets), ou seja, você escreve HTML e CSS de forma que eles respeitem telas menores e depois vá se ajustando para telas maiores (desktop).

Beleza, já domino HTML5, CSS3 e sei aplicar Mobile-First. E agora? Agora é importante estudar o Get BEM ou apenas BEM. [BEM](http://getbem.com/introduction/) é uma metodologia que tem o intuito de ajudar o desenvolvedor a escrever classes de maneira mais rápida, auto-explicativa e auxiliar na manutenção de códigos. Portanto, isso irá lhe diferenciar dos demais.

Aliado ao BEM, é necessário você aprender SASS. [SASS](http://blog.caelum.com.br/css-menos-sofrido-com-sass/) é um pré-processador CSS que auxilia (MUITO) a escrever css. Nele é possível declarar variáveis para poupar escrita e ctrl+c ctrl+v de códigos.

Ok, SASS já meu novo amigo mas como compilo ele? Bom, você deve aprender algum [Task Builder](https://blog.codecasts.com.br/ecossistema-javascript-parte-03-task-runners-5acedba9f072) . Sugiro [Gulp](https://tableless.com.br/gulp-o-novo-automatizador/), pois é simples e fácil.

Depois de aprender tudo isso, você pode partir para um [framework Javascript](https://becode.com.br/frameworks-e-bibliotecas-javascript-que-voce-deveria-conhecer/). Sim, como eu falei no início desse post, demora e a sua força de vontade pode aumentar ou diminuir esse tempo.

Importante frisar que ANTES de tentar se aventurar em frameworks JavaScript é bom você estudar, com calma, o JS puro mais conhecido como [Vanilla](https://github.com/entrylvl/traducoes-de-artigos/blob/master/javascript/vale-a-pena-aprender-vanillajs--com-certeza.md). A partir dele, você vai começar a entender diversas funções que vão te auxiliar quando for usar um framework.

Então, resumindo a curva de aprendizado:

**1º- HTML5 / CSS3**

**2º- Mobile-First**

**3º- BEM**

**4º- SASS**

**5º- GULP**

**6º- JAVASCRIPT**

**7º- Frameworks JS**  


**Mas Léo, é muita coisa!!!**

Sim de fato, é muita para ser estudada e, as vezes, bate um desanimo por conta disso. Mas aqui vão algumas dicas:

- Comece pelo básico e não tenha vergonha disso. Não é porque as pessoas estão usando frameworks que você também deve. Se você se basear nos outros você irá se desanimar. Portanto, pense no quanto evoluiu até aqui e siga firme!

- Estude uma coisa de cada vez e evite se distrair com conteúdos que não agreguem tanto valor ao que você quer aprender.

- Faça projetos. Por mais "toscos" que possam parecer no inicio. Fazer projetos é como trabalhar sem trabalhar e é um ótimo exercicío para melhorar suas habilidades.

- Se você não consegue se concentrar por muito tempo em frente ao computador, existem técnicas como por exemplo [Pomodoro](https://www.napratica.org.br/pomodoro/) entre outras e que são comprovadas eficazes.

Há também os adeptos de planos de estudos. Particularmente, gosto bastante pois ajuda a ter um norte. Para isso, pode-se usar o [Trello](https://trello.com/) e adicionar cards para cada conteúdo a ser estudado, movendo-os quando estiver terminado. 

Como dica de planos de estudos, sugiro:

1º - Leia a documentação do que deseja aprender.

2º - Tente montar algo a partir da documentação lida

3º - Faça alguma video-aula sobre o assunto

4º - Tente a partir da video-aula assistida, elaborar um projeto semelhante ao feito mas customizado por você

5º - NÃO DESISTA!!  

**Lembre-se de uma coisa: O caminho pode ser longo e desgastante mas no fim você terá um futuro brilhante!**  

Bons estudos !
