---
title: "Framer X: React, meet design"
authors: Diego Eis
type: post
date: 2018-06-19
image: https://i.imgur.com/UrgN6zz.jpg
excerpt: "Um produto que promete juntar design e código mobile."
categories:
  - Notícias
tags:
  - ferramentas
  - Robôs e Código
---

Desde o artigo que eu escrevi há mais de um ano atrás sobre [o fim da profissão front-end como conhecemos hoje](https://tableless.com.br/carreira-de-front-end-vai-morrer/), tenho acompanhado de perto as iniciativas do mercado de tentar minimizar o trabalho braçal de produção de código, automatizando as partes mais repetitivas do processo, liberando cada vez mais espaço para que designers e desenvolvedores possam usar seu tempo com coisas mais importantes. Deixar o trabalho pesado, repetitivo, enfadonho para a máquina é a tacada mais inteligente a se fazer, e na verdade já fazemos isso o tempo inteiro com os task runners da vida.

Agora, a implementação de layouts pode ficar ainda mais fácil com o Framer X. A ideia ainda se restringe ao design x código mobile (que pra mim, como é um ambiente mais controlado, pode ser uma das primeiras áreas a receber automatizações mais densas). O Framer X é um produto totalmente novo da Framer, que já é conhecida por seus plugins de prototipagem para o Sketch. O Framer X permite usar componentes para construir sistemas de design baseados em React e ES6.

A ideia ainda não é fazer coisas malucas e apps inteiros em React native e tal, mas facilitar, nesse primeiro passo, a criação de gráficos, layouts responsivos, fluxos de tela etc.

<iframe width="560" height="315" src="https://www.youtube.com/embed/bDGDsxn67d4" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen></iframe>

Essa abordagem também está sendo usada pela [Supernova](https://techcrunch.com/2018/03/13/supernova-studio/), que é uma outra iniciativa que transforma design em código mobile nativo, simplesmente acabando com o abismo que existe entre design e desenvolvimento mobile.

<iframe width="560" height="315" src="https://www.youtube.com/embed/lAdpMx1dOGE" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen></iframe>

O site da Framer ainda não traz tantos detalhes do funcionamento ou de como eles fizeram essa tecnologia, mas com certeza eles darão mais detalhes quando lançarem realmente o produto, que hoje está em beta, com lista de espera.

## Leia mais sobre o assunto

Se você quiser ler mais sobre as iniciativas de automatização de código que tenho acompanhado, veja a lista de links abaixo:

**Últimos meses**

  * [An AI can now write its own code](https://www.fastcompany.com/40564859/an-ai-can-now-write-its-own-code)
  * [Supernova promises to automatically convert Sketch mobile app designs into native UI code](https://techcrunch.com/2018/03/13/supernova-studio/)
  * [Airbnb built an AI that turns design sketches into product source code](https://thenextweb.com/artificial-intelligence/2017/10/25/airbnb-ai-sketches-design-code/)
  * [How you can train AI to convert design mockups into HTML and CSS](https://thenextweb.com/syndication/2018/02/11/can-train-ai-convert-design-mockups-html-css/)
  * [The CEO of GitHub, which caters to coders, thinks automation will bring an end to traditional software programming](https://www.businessinsider.com/github-ceo-wanstrath-says-automation-will-replace-software-coding-2017-10)

**Dados reais no design**

  * [3 Easy Steps for Working with Realistic Data in Sketch Using JSON][9]
  * [Designing with Data][10]
  * [Prototype with real data in Framer, from JSON to multi-device and internet of things][11]
  * [Adobe XD: Designing with Real Data][12]

**Sobre não usar texto fake em layouts**

  * [Lorem Ipsum is Killing Your Designs][13]
  * [Why designers should never use fake text][14]
  * [Stop using Lorem Ipsum!][15]
  * [&#8220;Getting Real&#8221; design tip: Just say no to Lorem Ipsum][16]

**WebAssembly**

  * [FAQ do site WebAssembly][17]
  * [WebAssembly – a web compilada][5]
  * [Google, Microsoft, Mozilla And Others Team Up To Launch WebAssembly, A New Binary Format For The Web][18]
  * [WebAssembly e o futuro da Web][19]
  * [From asm.js to webassembly][20]
  * [The Web is getting its bytecode: WebAssembly][21]

**Sobre o cenário das ferramentas de front-end**

  * [front-end.directory][22]
  * [Using front-end build tools][23]
  * [A Collection Of Best Front End Frameworks][24]
  * [GitHub: Front-end JavaScript frameworks][25]
  * [Front-End Tooling Trends for 2017][26]
  * [Updated List: The 67 Very Best Front End Web Developer Tools][27]
  * [The most popular JavaScript front-end tools][28]
  * [Top 10 Templating Engines for JavaScript To Improve and Simplify Your Workflow 2017][29]
  * [Automating Front-end Workflow][30]
  * [Javascript State of the Union 2015, parte 3][31]
  * [Slides &#8211; Javascript State of the Union 2015][32]
  * [The State of Front-End Tooling 2016 &#8211; Results][33]
  * [Front-end Roles and Responsibilities][34]

 [1]: https://github.com/sskyy/blade
 [2]: https://rink.hockeyapp.net/apps/0172d48cceec171249a8d850fb16276b
 [3]: https://protoship.io/tools/teleport.html
 [4]: https://protoship.io/tools/uipad.html
 [5]: https://tableless.com.br/o-webassembly-vem-ai/
 [6]: https://www.wired.com/2016/10/ubers-self-driving-truck-makes-first-delivery-50000-beers/
 [7]: https://movimentoux.com/work/felipememoria/
 [8]: https://www.fmemoria.com.br/
 [9]: https://www.shopify.com/partners/blog/91010886-3-easy-steps-for-working-with-realistic-data-in-sketch-using-json
 [10]: https://medium.com/@markjenkins/designing-with-data-7f6bcd907f0a#.95haya5yq
 [11]: https://blog.framer.com/prototype-with-real-data-in-framer-from-json-to-multi-device-and-internet-of-things-6eb1ae8b8325#.fo9b8i4gz
 [12]: https://medium.com/@anirudhs/project-comet-designing-with-real-data-959beccb5c1a#.v6khfndrh
 [13]: https://www.smashingmagazine.com/2010/01/lorem-ipsum-killing-designs/
 [14]: https://thenextweb.com/dd/2015/04/09/why-designers-should-never-use-fake-text/#.tnw_zjSSHkxh
 [15]: https://www.creativebloq.com/design/stop-using-lorem-ipsum-7116907
 [16]: https://signalvnoise.com/archives/001083.php
 [17]: https://webassembly.org/docs/faq/
 [18]: https://techcrunch.com/2015/06/17/google-microsoft-mozilla-and-others-team-up-to-launch-webassembly-a-new-binary-format-for-the-web/
 [19]: https://jaydson.com/webassembly-e-o-futuro-da-web/
 [20]: https://brendaneich.com/2015/06/from-asm-js-to-webassembly
 [21]: https://arstechnica.com/information-technology/2015/06/the-web-is-getting-its-bytecode-webassembly/
 [22]: https://frontend.directory/
 [23]: https://radify.io/blog/using-build-tools/
 [24]: https://usablica.github.io/front-end-frameworks/compare.html
 [25]: https://github.com/showcases/front-end-javascript-frameworks?s=stars
 [26]: https://www.sitepoint.com/front-end-tooling-trends-2017/
 [27]: https://blog.debugme.eu/front-end-web-developer-tools/
 [28]: https://techbeacon.com/most-popular-javascript-front-end-tools
 [29]: https://colorlib.com/wp/top-templating-engines-for-javascript/
 [30]: https://speakerdeck.com/addyosmani/automating-front-end-workflow
 [31]: https://medium.com/@caiovaccaro/javascript-state-of-the-union-2015-parte-3-281aa04bece1#.bulta9j6j
 [32]: https://www.slideshare.net/Hugeinc/javascript-state-of-the-union-2015
 [33]: https://ashleynolan.co.uk/blog/frontend-tooling-survey-2016-results
 [34]: https://hackernoon.com/front-end-roles-and-responsibilities-6ee8654f1649#.gsg5zdjtr
