---
title: 'Flat design: a nova tendência dos gradientes'
authors: Isaque Melo
type: post
date: 2015-06-12
excerpt: Como utilizar gradientes em meio ao flat design nas suas composições web.
url: /flat-design-nova-tendencia-dos-gradientes/
categories:
  - Design
  - O Básico
tags:
  - flat design
  - gradientes

---
O _flat design_ está dominando cada pixel: isso é uma coisa que nós já sabemos. Mas você já ouviu falar dos gradientes no _flat design_?

Soa meio estranho, não é? Pois é, mas existe, e hoje vou mostrar a você que o gradiente voltou. Não daquele jeito horrível e assustador, que causa medo aos olhos, mas sim de uma forma bonita e confortável, e o melhor de tudo, _flat_ <3.

Nos últimos dias tenho observado alguns trabalhos de agências de design que mostram que o gradiente pode ser usado no _flat design_. Uma delas criou o site da Virgin America. Assim que você entrar no <a title="Site Virgin America" href="https://www.virginamerica.com/" target="_blank">site</a>, observe que existe um gradiente no topo. O site é todo _flat_, mas este detalhe o torna mais bonito e confortável. E não para por aí; a mesma agência fez trabalhos para outras marcas, e demonstrou que quando trata-se de _flat design_ sabe fazer direito. (<a title="Agência Work.CO" href="https://work.co/virgin-america/" target="_blank">https://work.co/virgin-america/</a>)

[<img class="alignnone wp-image-48978" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/05/Capturar2.png" alt="Site Virgin America" width="757" height="310" />][1]

Já no Brasil não é diferente. Temos alguns sites que mostram que essa tendência está chegando com tudo. Um exemplo bem útil é o <a title="Mega Curioso" href="https://www.megacurioso.com.br/" target="_blank">Megacurioso</a> criado pelo <a title="Grupo No Zebra" href="https://www.gruponzn.com/" target="_blank">Grupo NZN</a>. Ao acessar o site, com uma interface completamente _flat,_ você observa no topo um gradiente muito bonito e chamativo. Mas este menu tira o conceito &#8220;_flat_&#8221; do site? Não, só o deixa mais _flat_ ainda.

<img class="alignnone wp-image-48977" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/05/21.png" alt="Mega Curioso" width="750" height="309" />

Temos diversos outros exemplos de sites que aderiram a esta tendência. Mas e aí, como usar? O uso do gradiente tem que ser bastante cuidadoso, pois qualquer erro pode estragar seu trabalho. Eu listei algumas dicas para que você use o gradiente corretamente:

  1. É recomendado o uso cores flats nos seus gradientes: você pode usar o site flatuicolors.com, e caso não tenha as cores que você queira, existem diversas &#8220;paletas&#8221; flat na internet que podem lhe ajudar bastante.

[<img class="alignnone wp-image-48981" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/05/q.png" alt="Flat UI Colors" width="746" height="371" />][2]

<ol start="2">
  <li>
    Evite o uso de cores &#8220;puras&#8221; (100% da cor), como já citado, é legal utilizar as cores flats.
  </li>
</ol>

<ol start="3">
  <li>
    Use apenas gradientes lineares horizontais. Evite o uso gradientes de outros tipos (Os gradientes lineares podem ser usados em alguns casos)
  </li>
</ol>

<ol start="4">
  <li>
    Não abuse, o uso do gradiente é limitado. Caso use o gradiente em muitos elementos irá tirar o &#8220;brilho&#8221; do uso do gradiente.
  </li>
</ol>

<ol start="5">
  <li>
    Use apenas gradientes lineares horizontais. Evite o uso gradientes de outros tipos (Os gradientes lineares podem ser usados em alguns casos).
  </li>
</ol>

<ol start="6">
  <li>
    Use sua criatividade.
  </li>
</ol>

&#8220;Existe alguma ferramenta que possa facilitar minha vida, que tenha gradientes nos padrões adequados para usar com o _flat design_?&#8221; Sim, existe: eu recomendo o <a href="https://www.uiGradients.com" target="_blank">uiGradients.com</a>, mas, como tempo é dinheiro, você pode acelerar o processo usando um kit de gradientes que eu fiz para Photoshop +CS3,  assim você evita copiar e colar tantas vezes até escolher o gradiente correto. Você pode baixá-lo <a title="Link Download" href="https://drive.google.com/file/d/0B_umgIb0YnwYME5Wb00xc1dMd1E/view?usp=sharing" target="_blank">clicando aqui</a>. Caso não saiba como instalar um novo gradiente <a title="Video Youtube" href="https://www.youtube.com/watch?v=P1cgi0NvJ5U" target="_blank">clique aqui</a>.

<img class="alignnone wp-image-48988" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/05/ui-gradients.png" alt="ui gradients" width="754" height="384" />

Fiz uma pequena e rápida demonstração de _flat_ com gradientes em html + css + svg que você pode baixar <a title="Demo" href="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/05/Demo.rar" target="_blank">aqui</a>. Abaixo confira alguns outros exemplos:

[<img class="  aligncenter wp-image-48992" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/05/dee.png" alt="exemplo de gradiente + flat design" width="342" height="342" />][3]

[<img class="  aligncenter wp-image-48990" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/05/arte.png" alt="exemplo de gradiente + flat design" width="342" height="342" />][3]

Bom pessoal, é isso. Espero que vocês tenham gostado. E lembrem-se sempre: tudo em exagero fica ruim, hehe.

 [1]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/05/Capturar2.png
 [2]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/05/q.png
 [3]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/05/dee.png