---
title: Ferramentas úteis para se trabalhar com SEO
authors: Douglas Faria
type: post
date: 2013-10-23
url: /ferramentas-uteis-para-se-trabalhar-com-seo/
dsq_thread_id: 1890740877
categories:
  - SEO

---

Muitas vezes ficamos perdidos em como mensurar resultados e analisa-los, afim de traçar estratégias mais eficazes. Isso acontece principalmente quando estamos começando a trabalhar com SEO. Sabemos o quanto é importante trabalhar os fatores OnPage, ter um servidor estável e um site rápido, além de bons links e menções, entre outros fatores que, somados, fica difícil de se controlar.

Por isso, trouxe aqui algumas [ferramentas de SEO](https://www.webpeak.com.br/), umas pagas e outras free, mas que vão ajuda-lo a administrar a sua campanha. Vamos a elas.

## SEO Tools for Excel

Vou começar com um plugin fantástico que não é tão explorado. Trata-se do **SEO Tools for Excel**. Um plugin muito bom para excel onde podemos avaliar fatores On-page, acompanhar Backlinks, Referências de Redes sociais, Linkar no GA, entre muitas outras coisas, diretamente no excel.

<https://nielsbosma.se/projects/seotools/>

## GTW – Google Webmasters Tools ou Ferramentas para Webmasters

Essa ferramenta é muito boa. É a melhor custo benefício (na minha opinião!) pois é gratuita e você consegue usá-la em vários níveis de análise.

[<img class="alignnone size-medium wp-image-39271" alt="google webmaster tools" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/10/gtw-576x310.png" width="576" height="310" srcset="uploads/2013/10/gtw-576x310.png 576w, uploads/2013/10/gtw-312x168.png 312w, uploads/2013/10/gtw.png 1093w" sizes="(max-width: 576px) 100vw, 576px" />][1]

O GTW nos permite analisar backlinks, erros de HTML, configurações do Robots.TXT, envio de Sitemaps e em um contexto mais avançado, você consegue linka-lo no Google Analytics e descobrir dados do famoso “Not Provider”, por exemplo.

Além disso, você gerencia a propriedade dos seus sites para utilização de serviços automatizados da Google em um dado domínio (site), como o Google Apps.

Recentemente o Google incluiu ao GTW uma funcionalidade que auxilia na criação de Dados Estruturados. Lá você pode validar e testar as configurações de forma rápida e fácil.

Se você não usa, passe a usar:

<https://www.google.com/webmasters/tools/home?hl=pt-BR>

## Google Analytics – GA

O Google Analytics é outra ferramenta praticamente obrigatória para você trabalha com SEO. Muita gente ainda tem a falsa impressão de que o GA é contador de visitas, que capta a quantidade de visitantes por dia e depois te exibe isso em um gráfico.

[<img class="alignnone size-full wp-image-39272" alt="google-analytics-dougalsfaria10" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/10/google-analytics_products_sm_01.jpg" width="474" height="164" srcset="uploads/2013/10/google-analytics_products_sm_01.jpg 474w, uploads/2013/10/google-analytics_products_sm_01-329x113.jpg 329w" sizes="(max-width: 474px) 100vw, 474px" />][2]

Engana-se quem pensa dessa forma. O GA te permite fazer análises profundas não só em cima de quantidade, mas de qualidade também. Você pode, por exemplo, identificar a necessidade de se criar um layout responsivo para o seu site. Isso porque pelo GA você consegue saber o Navegador e o Sistema Operacional do visitante com muita facilidade.

Além disso, você consegue identificar problemas de arquitetura analisando o comportamento do usuário, criar funis e medir as taxas de conversão de um site ou página.

Só para se ter uma ideia, para o e-commerce é possível colocar valores em nas conversões e assim mensurar valores. Por exemplo, você poderia saber quanto você faturou com um determinado item, apenas configurando uma meta com valores estipulados.

Lembrando que o [SEO hoje tem um foco muito grande no usuário][3], entender como o mesmo se comporta no seu site é essencial para criarmos estratégias mais criativas.

<https://www.google.com/analytics/>

## PageSpeed

Um dos principais fatores adotados pelo Google para rankeamento, a velocidade de carregamento do site pode ser medida através do PageSpeed. Hoje, com o crescimento das buscas locais e mobile, o Google vem dando grande importância para quem tem sites rápidos tanto para desktops, quanto para dispositivos móveis. Se você pensar que um usuário toma a decisão se fica ou não em um site em cerca de 5 segundos, é bom ter um site rápido!

O legal é que você pode instalar um plugin no Chrome e o site te dá todas as informações para que você possa corrigir os problemas.

<https://developers.google.com/speed/pagespeed/>

[<img class="alignnone size-medium wp-image-39273" alt="Pagespeed Google" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/10/Capturar-573x310.png" width="573" height="310" srcset="uploads/2013/10/Capturar-573x310.png 573w, uploads/2013/10/Capturar-310x168.png 310w, uploads/2013/10/Capturar.png 1234w" sizes="(max-width: 573px) 100vw, 573px" />][4]

## Planejador de Palavras Chave

“O Planejador de palavras-chave é como um workshop para a criação de novas campanhas da Rede de Pesquisa ou para a expansão das existentes.”

Estas palavras estão no suporte do Google para usuários do Planejador e você pode conferir aqui:

<https://support.google.com/adwords/answer/2999770?hl=pt-BR>

[<img class="alignnone size-medium wp-image-39274" alt="planejador de palavras chave" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/10/planejador-567x310.png" width="567" height="310" srcset="uploads/2013/10/planejador-567x310.png 567w, uploads/2013/10/planejador-307x168.png 307w, uploads/2013/10/planejador.png 786w" sizes="(max-width: 567px) 100vw, 567px" />][5]

O Planejador é uma solução recente do Google e que precisa ser mais bem , mas já é possível dizer que veio para otimizar a busca por palavras chave e/ou grupos de anúncios de forma mais eficaz. Antes, era preciso uma analise combinada de dados vindo do Estimador de Tráfego e do Google Keyword Tool. O que o Google fez foi unir essa funcionalidade a uma única ferramenta. As mudanças visuais são sutis, mas a performance está melhor e você consegue planejar e encontrar novas oportunidades relevantes.

## MOZ

### Open Site Explorer

O opensiteexplorer.com é uma ferramenta da Moz que permite analisar links de um domínio. O legal é que você consegue comparar links de até 5 domínios.  O serviço é pago e é parte dos pacotes de serviços oferecidos pela MOZ, com custo inicial de $99,00. Mas a boa notícia é que você consegue utilizar o serviço gratuitamente com algumas limitações.

[<img class="alignnone size-medium wp-image-39275" alt="opensiteexplorer" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/10/opensiteexplorer-572x310.png" width="572" height="310" srcset="uploads/2013/10/opensiteexplorer-572x310.png 572w, uploads/2013/10/opensiteexplorer-310x168.png 310w, uploads/2013/10/opensiteexplorer.png 1133w" sizes="(max-width: 572px) 100vw, 572px" />][6]

#### Prós:

Possui dados de texto âncora, Informações de “Top Pages” e Análises Ilimitadas.

#### Contras:

Assinatura mensal, Índice com atualização aprox. 3 em 3 semanas, Não possui dados históricos

### MOZ Tolbar

Um bom plugin para você analisar rapidamente um domínio. Disponível para Firefox e Chrome. Vale a pena instalar, é **FREE**:

<https://moz.com/tools/seo-toolbar>

## MajesticSEO

Um bom concorrente da MOZ, onde sua principal diferença na ferramenta de análise de links é o histórico e a atualização diária do índice. É mais econômica, mas ainda sim é um bom serviço. Custa +- $48,00.

[<img class="alignnone size-medium wp-image-39276" alt="majestic SEO" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/10/Capturar2-466x310.png" width="466" height="310" srcset="uploads/2013/10/Capturar2-466x310.png 466w, uploads/2013/10/Capturar2-252x168.png 252w, uploads/2013/10/Capturar2.png 1114w" sizes="(max-width: 466px) 100vw, 466px" />][7]

Em algumas situações é possível utilizá-las de forma complementar para fazer a análise e extrair informações mais relevantes.

#### Prós:

Atualização diária do índice, Dados históricos de backlinks, Possui dados de texto âncora e IP, O maior índice entre as ferramentas pagas

#### Contras:

Assinatura por créditos, Análise mais profunda, requer créditos.

## Conclusão

Bom pessoal, espero que seja útil para vocês, claro que existem muitas ferramentas legais e que poderiam estar aqui, mas estas são ferramentas muito boa que, na minha humilde opinião, vale a pena conhecer e usar.

Qualquer ideia bacana é bem vinda e pode ser citada nos comentários! Abraços e até aproxima!

 [1]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/10/gtw.png
 [2]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/10/google-analytics_products_sm_01.jpg
 [3]: https://tableless.com.br/o-seo-moderno-e-o-foco-no-usuario
 [4]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/10/Capturar.png
 [5]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/10/planejador.png
 [6]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/10/opensiteexplorer.png
 [7]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/10/Capturar2.png
