---
title: Ferramentas e sites para tornar mais ágil o seu desenvolvimento
authors: Thaiana Poplade
type: post
date: 2013-09-19
excerpt: No dia-a-dia, a correria em cumprir prazos nos faz buscar e fazer uso de ferramentas que possam auxiliar na velocidade de desenvolvimento. Seja no front ou no design, em tempos de mudanças e transições, nada mais justo que uma lista de algumas ferramentas especiais para que você mantenha seu processo profissional e ágil.
url: /ferramentas-e-sites-prontos-para-tornar-seu-processo-de-desenvolvimento-mais-agil/
dsq_thread_id: 1777581043
categories:
  - Artigos
  - Código
  - CSS
  - CSS3
  - Design
  - HTML
  - HTML5
  - Técnicas e Práticas
tags:
  - ferramentas

---
## Planejamento

Na grande maioria dos projetos web, tudo se inicia pela Arquitetura de Informação (UX) e mesmo que talvez esta não seja a sua área, eventualmente organizar e entender um website por inteiro, também possa ser uma necessidade.

Sem considerar todos os argumentos aplicados às melhores metodologias, criar um sitemap* pode ser algo bastante útil então, a dica é, uma das ferramentas online que trabalha bem com esse tipo de documento é o <a title="Ferramenta para mapas mentais - Coggle.it" href="https://coggle.it/" target="_blank">Coggle.it</a> que ainda está em sua versão beta, mas já pode ser usado e aplicado.

_*Sitemap: organograma contendo todas as páginas que o site/portal irá conter. Este documento especifica as várias telas. Geralmente é produzido no início do projeto e refinada durante todas as etapas conforme as demandas posteriores. Referência: https://webinsider.com.br_

Outra ferramenta para o planejamento de projetos, especial para _brainstorms_ e referências (para os designers de plantão) é o <a title="Ferramenta online para Brainstorms" href="https://mural.ly/" target="_blank">Mural.ly</a>, que além de funcional tem uma interface de fácil uso que te permite, literalmente, arrastar um website para o seu mural de ideias.

## Design

Nos dias de inspiração, o design de uma interface simplesmente flui sem paradas e pausas em branco, mas em alguns dias as coisas ficam um pouco mais difíceis e até mesmo escolher as melhores cores, torna-se uma coisa bastante complexa. Pensando nisso a <a title="Ferramenta de paleta de cores online" href="https://colorschemedesigner.com" target="_blank">ColorScheme</a> e a <a title="Ferramenta de paleta de cores online" href="https://colorschemer.com" target="_blank">ColorSchemer.com</a> são ótimas ferramentas de paletas de cores para seu website. Você insere o código hexadecimal da cor principal e a ferramenta te mostra as demais combinações. Vale a pena.

Além de pensar em interface, com as técnicas de Design Responsivo, é inevitável em algum momento pensar em grids (mesmo que você seja um daqueles contra o uso deles 😉 ). Para isso, existe o <a title="Ferramenta de calculo de grid para web" href="https://gridcalculator.dk" target="_blank">Grid Calculator</a> e o <a title="Ferramenta de cálculo de medidas para grid para web" href="https://gridpak.com" target="_blank">Grid Pak</a> onde você insere a medida de largura padrão de seu website e ele cria as medidas das colunas divididas igualmente. Você ainda pode fazer o download do grid em PSD e PNG.

## Front-end

Essa talvez seja a etapa de um projeto melhor auxiliada neste quesito ferramentas. Graças ao perfil colaborativos dos Front-Ends do mundo, as possibilidades são quase infinitas (estamos chegando lá :D) e esta fase de transição HTML 4 -> HTML 5 e CSS 2 -> CSS3, proporciona ainda mais que novas ferramentas surjam.

Iniciando pelos auxiliadores de CSS3 :D. Sim! Eles são ótimos e poupam nossa memória em lembrar exatamente como as novas propriedades precisam ser declaradas para gerarem efeitos na interface.
  
A primeira dica fica para o <a title="Ferramenta de criação de códigos css3" href="https://createcss3.com/" target="_blank">Create CSS3</a>, que é bastante completo e contém a maior parte das novas características mais usadas. A forma de usá-lo é bem simples: clica no item de seu interesse, configura com os dados necessários para você e _voialá,_ um trecho de propriedades css pronto para ser implementado.

Ainda falando em css, que tal deixar o css feio, bonito? Isso mesmo! O <a title="Ferramenta de reorganização de Css" href="https://html.fwpolice.com/css/" target="_blank">Css Beautifier</a> reorganiza a distribuição de linhas e tabs do seu arquivo css. Basicamente, ele deixa mais agradável a leitura.

Mas, se apenas deixar bonito não resolve e você também quer um css otimizado, no <a title="Ferramenta de otimização de CSS" href="https://www.cssdrive.com/index.php/main/csscompressor" target="_blank">CSS Compressor</a>, você copia, cola e sai um css minimizado e pronto para ser implementado. Aliás, você ainda pode determinar o nível das “facadas” que você dará nas linhas do seu arquivo. 😉

Na mesma linha, porém um pouco mais completo, tem o <a title="Ferramenta de otimização CSS" href="https://cssminifier.com/" target="_blank">CSS Minifier</a> que também minimiza, tem API de integração e o bônus de outras 3 ferramentas, Javascript Minifier, PNG Crush (para redução de arquivos png) e o JPG Optimiser (para otimização de arquivos JPEG).

Aproveitando o bônus da ferramenta anterior, outra ferramenta que pode auxiliar na questão de performance de imagens, é o <a title="Ferramenta de redução de peso de arquivos de imagem" href="https://imageoptim.com/" target="_blank">Image Optim</a>, um software de fácil instalação para Mac, que reduz o peso de arquivos de imagens. Caso você não utilize um Mac, sem problema, ele possui uma versão <a title="Versão Linux e Windows" href="https://trimage.org/" target="_blank">Windows e outra Linux</a>. Vale a pena.

Que tal testar seus códigos antes de implementá-los em seu projeto?
  
Isso lhe garante a segurança de saber se vai dar tudo certo na execução daquele javascript ou na inserção daquela propriedade no css.
  
Para isso, lhes apresento o <a title="Teste seus códigos online, antes de implementá-los" href="https://codepen.io/pen" target="_blank">CodePen</a>, um editor de código _live_ que funciona de forma bem direta e de fácil manuseio. Tem muita gente testando por lá ;).

Para os front-ends ligados nas novidades, a ferramenta indicada é o <a title="Ferramenta de atualização de padrões HTML5" href="https://html5please.com/" target="_blank">HTML5Please</a> que vai informando quais novas tags e propriedades de HTML5 e CSS3 já podem ser implementadas neste período de transição.

E para fechar, front-end para site responsivo.
  
Quando um projeto também será responsivo (prática cada vez mais comum e mais profissional) esta estratégia precisa ser planejada antes de sua execução para que ao invés de gerar problemas você consiga gerar códigos bem feitos e o efeito esperado. Para isso, uma das preocupações que aparecerão será com as imagens do seu projeto e como elas responderão aos diferentes dispositivos. Neste aspecto, o <a title="Ferramenta para imagens responsivas" href="https://adaptive-images.com/" target="_blank">Adaptive Images</a> te auxilia detectando a resolução do usuário e apresentando a imagem com a melhor resolução possível ao dispositivo.

Completando a linha responsivo, outra preocupação é questão dos textos e sua adaptação à diferentes tamanhos de telas e neste caso, entra em cena o <a title="Ferramenta para Textos responsivos" href="https://fittextjs.com/" target="_blank">FitText</a>, um script que fará seu font-size realmente flexível.

## Validação

Tudo pronto, tudo certinho, site publicado em ambiente de homologação ou até mesmo em ambiente final, que tal validar seu sites para ver se ele está de acordo com os padrões?

Para web standars tem o já conhecido (e as vezes temido) <a title="Validados web standars" href="https://validator.w3.org/" target="_blank">W3C Validator</a> e outra opção não tão conhecida, mas funcional, o <a title="Validador de HTML" href="https://github.com/philipwalton/html-inspector" target="_blank">HTML Inspector</a>.

Para os padrões de acessibilidade, você pode utilizar o <a title="Validador de acessibilidade" href="https://achecker.ca/checker/index.php" target="_blank">A Checker</a> que em alguns segundos diz quais padrões não estão sendo seguidos para que seu site seja acessível por navegadores textuais e de audio e ainda indica as melhores práticas para reverter os problemas.

Outra ferramenta importante para quem pensa em validações é a <a title="Validador de indexação" href="https://www.google.com/webmasters/tools/" target="_blank">Webmaster Tools da Google</a>, que permite verificar como o robô do buscador está se comportando em seu site, além de dizer quais páginas estão sendo indexadas. Além disso, te possibilita informar mudanças de URL ou até mesmo retorno de sites que foram invadidos. A ferramenta é robusta e de extrema valia. Confere lá!

E você, conhece outras ferramentas? Completa lá nos comentários. 😉

Até a próxima.

&nbsp;