---
title: As ferramentas do desenvolvedor React em 2019
authors: Tailo Mateus Gonsalves
type: post
image: https://cdn-images-1.medium.com/max/1600/1*vHHBwcUFUaHWXntSnqKdCA.png
date: 2019-01-22
excerpt: Ferramentas úteis para otimizar o fluxo de trabalho do React em 2019
tags:
  - React em 2019
categories:
  - Front-end
  - ReactJS
  - JavaScript
---

Aparentemente, este ano será mais um ano de crescimento para o React e seu ecossistema, que vem crescendo rapidamente.

Esse pode ser um bom momento para ver alguns dos melhores recursos, ferramentas e bibliotecas a serem introduzidos no seu fluxo de trabalho do React, para aproveitar ao máximo. Todos estes são de código aberto, então sinta-se à vontade para ir em frente.

Esperamos que essas ótimas ferramentas possam ajudar a acelerar seu fluxo de trabalho e abrir as portas para novos recursos em 2019. Sinta-se à vontade para adicionar suas próprias sugestões e experiências.

### Bibliotecas de componentes

![](https://cdn-images-1.medium.com/max/800/1*wZMjYVLM5VZPoBhD6518Vw.jpeg)

Muitas bibliotecas disponibilizam componentes no React, projetos da comunidade à bibliotecas criadas por empresas. Abaixo você pode ver algumas das bibliotecas mais famosas.

**Algumas das melhores** : [React Material-UI](https://github.com/mui-org/material-ui), [Grommet 2.0](https://github.com/grommet/grommet), [React Bootstrap](https://github.com/react-bootstrap/react-bootstrap), [Reactstrap](https://github.com/reactstrap/reactstrap), [Prime React](https://github.com/primefaces/primereact), [Elemental-UI](https://github.com/elementalui/elemental), [Semantic-UI](https://github.com/Semantic-Org/Semantic-UI-React).

* [23 Best React UI Component Frameworks](https://hackernoon.com/23-best-react-ui-component-libraries-and-frameworks-250a81b2ac42)

### Componentes de estilo

Em 2018, houve muita discussão sobre o estilo de componentes usando CSS em JS e [styled-components](https://github.com/styled-components/styled-components) para Sass, Less, CSS modules, CSS Inline e até mesmo projetos como Stylable.

Qual utilizar é uma questão de preferência pessoal e as necessidades da arquitetura da sua aplicação, então a escolha é sua. Você pode encontrar a discussão completa aqui abaixo, com uma revisão mais profunda de prós e contras para cada escolha que você faz. Dê uma olhada.

* Veja também: [9 CSS em bibliotecas JS para 2019](https://blog.bitsrc.io/9-css-in-js-libraries-you-should-know-in-2018-25afb4025b9b)

### Gerenciamento de estado

Um tópico doloroso que foi um grande debate (ou rixa) em 2018. Agora a Store está aberta para negócios (desculpe por isso) e diferentes ferramentas estão ficando mais comuns. 

Entre as ferramentas populares, você pode encontrar [Unstated](https://github.com/jamiebuilds/unstated), e [Mobx,](https://github.com/mobxjs/mobx)** **que incorpora o paradigma de componentes encapsulados do React. Também a nova [API de Contexto,](https://blog.bitsrc.io/react-context-api-a-replacement-for-redux-6e20790492b3) que é uma alternativa promissora para o [Redux](https://redux.js.org/).

* [State of React State Management for 2019](https://blog.bitsrc.io/state-of-react-state-management-in-2019-779647206bbc)

### Testes

A pesquisa [“State of JS” de 2018](https://blog.bitsrc.io/top-javascript-testing-frameworks-in-demand-for-2019-90c76e7777e9) lista as estruturas de testes mais solicitadas em 2019, com estruturas de testes populares como [Jest](https://jestjs.io/), [Mocha](https://mochajs.org/), [Karma](https://karma-runner.github.io/2.0/index.html) e outras, para tornar o TDD mais simples no nível de componente.

Aqui estão alguns guias úteis e profundos para testar componentes do React com a Jest & Enzyme, que é provavelmente a melhor combinação para apostar no desenvolvimento da maioria das aplicações React deste ano. Dê uma olhada.

* [Testing React Components with Jest and Enzyme- In Depth](https://blog.bitsrc.io/how-to-test-react-components-with-jest-and-enzyme-in-depth-145fcd06b90)

* [How to Test React Components using Jest and Enzyme](https://blog.bitsrc.io/how-to-test-react-components-using-jest-and-enzyme-fab851a43875)

### Boilerplates

![](https://cdn-images-1.medium.com/max/800/1*rqyYOhFVVrMDJ-4p5rk3LA.gif)

Com o lançamento do [create-react-app 2.0](https://blog.bitsrc.io/introducing-create-react-app-version-2-0-6667aee5db17), parece que esse boilerplate de React continua sendo o projeto mais popular e
recomendado que existe. No entanto, também vale a pena dar uma olhada em projetos como o [React-Boilerplate](https://github.com/react-boilerplate/react-boilerplate) e o [React Slingshot,](https://github.com/coryhouse/react-slingshot) que oferecem uma alternativa para diferentes casos de uso.

### React Hooks e API de Contexto

Embora muitos novos recursos tenham sido introduzidos no React em 2018, talvez dois são os mais significativos em termos de discussão da comunidade. A primeira é a API de Contexto do React que, após um longo período de espera, é oficializada e entra em jogo como um potencial substituto do Redux. O segundo é o React Hooks**,** que permite usar o estado e outros recursos do React sem escrever uma classe, o que contribui para o gerenciamento de estados e muito mais.

**API de contexto**

* [React Context API — A Replacement for Redux?](https://blog.bitsrc.io/react-context-api-a-replacement-for-redux-6e20790492b3)

* [Why you should consider the new Context API in React? — A deep dive](https://blog.bitsrc.io/why-you-should-consider-the-new-context-api-in-react-a-deep-dive-d588b66c57b5)

**Hooks**

* [Understanding Hooks in React](https://blog.bitsrc.io/understanding-hooks-in-react-a-deep-dive-d5d5dc88ecd9)

* [Understanding React Hooks — useState](https://blog.bitsrc.io/understanding-react-hooks-usestate-6627120614ab)

### Depuração

![](https://cdn-images-1.medium.com/max/800/1*kBdE2EsYc0zftvj4iUb7sQ.gif)

Bem, não há muita novidade aqui, pois o React dev-tools e o Redux dev-tools ainda fazem o trabalho rápido e simples. A [extensão](https://chrome.google.com/webstore/detail/react-developer-tools/fmkadmapgofadopljbjfkapdkoienihi?hl=en) React dev-tools permite que você inspecione as hierarquias dos componentes, e até mesmo veja como as alterações nos componentes afetam outros componentes.

A [extensão](https://github.com/zalmoxisus/redux-devtools-extension) dev-tools do Redux permite inspecionar cada estado e ações. Você pode ter várias lojas ou instâncias diferentes para cada estado local do componente.

### Geradores de site estático

React trouxe uma nova era para a composição de websites estáticos baseados em componentes, com novas estruturas como [Gatsby](https://www.gatsbyjs.org/) e [React static](https://github.com/nozzle/react-static). Essas bibliotecas aproveitam os componentes e a capacidade de fornecer uma experiência rápida, flexível e poderosa para a criação de sites estáticos. Aqui está uma revisão completa de 9 bibliotecas para olhar em 2019.

* [9 React Static Site Generators for 2019](https://blog.bitsrc.io/9-react-static-site-generators-for-2019-f54a66e519d2)

### Conclusão

O ecossistema React está se movendo rapidamente, assim como o ecossistema geral em torno de componentes. À medida que as mudanças fluem, novas oportunidades e ferramentas surgem para nos fornecer novos recursos que podem não apenas acelerar a maneira como construímos software, mas também mudar o software que construímos. Podemos melhorar a capacidade de reutilização, cobertura de teste, reduzir erros, tamanho de pacote e assim por diante.

### ⭐️ Créditos

* [The React Developer Tools You Should Know in 2019](https://hackernoon.com/the-react-developer-tools-you-should-know-in-2019-e681dc4f4332), escrito originalmente por [Jonathan Saring](https://hackernoon.com/@JonathanSaring)

