---
title: Faz uma animação legal aí!
authors: Vanessa Nunes
type: post
date: 2016-05-12
url: /faz-uma-animacao-legal-ai/
categories:
  - Design
  - Opinião
  - UX
tags:
  - animação
  - desenvolvimento web
  - mercado
  - ux

---
Sempre que um projeto começa, eu me questiono se a agência entende a importância da animação para o design de interface e como o trabalho do motion designer pode contribuir para o sucesso da experiência interativa, reforçando tudo o que foi pensado desde o nascimento do projeto, lá na arquitetura de informação.

Muitas vezes, ouvi que o motion designer coloca a mão no projeto para refinar e fazer firulas no site. Isso dava a sensação de que meu trabalho era secundário. Ou então, que se não houvesse prazo suficiente para animar o site, me era dito: escolhe um elemento que você acha importante e faz uma animação legal aí.

**Legal! Mas o que é uma “animação legal”?**

Infelizmente, a animação é considerada decorativa pela maior parte dos profissionais de desenvolvimento web. E entender animação como algo apenas “legal” torna muito mais difícil de levar essa etapa do processo a sério, quando na verdade é parte essencial do processo de comunicação e entendimento em um projeto interativo.

Nós usamos o HTML para contar histórias e comunicar grandes quantidades de informação. E a animação nos ajuda a fazer as duas coisas de forma melhor. Imaginemos que a animação é um guia turístico, que permite às pessoas acompanhar a história do seu site sem se perderem. Ela ajuda o olhar a se orientar dentro da interface, encontrar o seu caminho ou estabelecer relações visuais.

Nossos cérebros e olhos são programados a prestar atenção aos objetos em movimento &#8211; é um reflexo. Mágicos usam o movimento para realizar truques com as mãos. Desta forma, a animação pode ajudar o olho a ver de onde um novo objeto vem ou para onde o objeto foi (e provavelmente saber onde encontrá-lo novamente). Motion não é firula, é necessário e pode melhorar a experiência do usuário e tornar o design mais consistente e real.

Portanto, a animação de interface preenche eventuais lacunas de compreensão de diversas maneiras:

  * É crucial para sugerir interação, bem como criar um estímulo visual para o usuário perceber novas informações numa mudança de status na interface; 
  * Fornece feedback visual e sinaliza pistas do que vem em seguida; 
  * Apresenta transições espacialmente lógicas entre telas. Além disso, elementos animados de acordo com as leis da física ajudam as pessoas a memorizar a interface mais facilmente, pois lhes parece familiar e previsível; 
  * Estilos de animações transmitem mais personalidade ao conteúdo do que qualquer interação estática poderia transmitir; 
  * Animações bem feitas conquistam os usuários, tornam a experiência mais agradável e divertida e os ajuda a se relacionar de forma melhor com o produto. 

Hoje, com a propagação das pequenas telas dos devices, que nos leva a implementar grandes interfaces em pequenos espaços, seria confuso e frustrante para o usuário entender as relações espaciais entre layers, abas deslizantes e zooms sem o trabalho do motion designer para ligar os pontos. Assim como na tipografia, que pode apenas servir funcionalmente para a leitura ou pode agregar expressão ao conteúdo, a animação também pode ir além e se moldar para trabalhar em harmonia com o design. A atenção a esse nível de detalhes é o que separa os grandes projetos dos medianos, tanto na tipografia como em animação.

Apesar da chatice de centenas de terminologias de profissões surgirem a cada mês no Linkedin (sim, já vi coisas como “astronauta de ideias” por lá), nossa área vem se denominando Motion UI. E há indícios de que venha, num futuro próximo, a se chamar UX Choreographer. É algo novo no mundo digital, mas que vem provando sua importância e não só merece uma fatia maior das horas do projeto, como também precisa deixar de ser “apenas” um braço da direção de arte ou da programação dentro das agências para, enfim, se tornar uma área de maior importância e independência.

Independente, aqui, se refere a tornar-se mais profissional e não somente ser a pessoa que fica sentada sozinha no fundão da agência só recebendo o famoso: “faz alguma coisa legal aí!”.

As agências e produtoras devem prever o espaço para mais um locutor, mais esse contador de histórias. A animação precisa ter sua voz e movimento devidamente reconhecidos.

**Para saber mais**

Recomendo ler o artigo <a href="https://medium.com/@adaptivepath/jedi-principles-of-ui-animation-2b88423b1dac#.gzxg45w5u" target="_blank">Jedi Principles of UI Animation</a>, uma verdadeira aula sobre animação de interface.

Vale também assistir o vídeo <a href="https://vimeo.com/93206523" target="_blank">Illusion of Life</a>, sobre os 12 prncípios básicos da animação, de Frank Thomas e Ollie Johnston, animadores dos estúdios Disney.