---
title: FAQ sobre Tableless
authors: Diego Eis
type: post
date: 2005-08-08
excerpt: Entenda o que são Web Standards, o que é Tableless, quais as vantagens, relação com acessibilidade e tudo mais.
url: /faq/
dsq_thread_id: 503033277
categories:
  - Artigos
  - O Básico
  - Técnicas e Práticas
  - Tecnologia e Tendências
tags:
  - Browsers
  - faq
  - firefox
  - linux
  - tableless
  - tags
---
### O que são os Web Standards?

Imagine se cada eletrodoméstico usasse um tipo de tomada. E ao comprar um novo eletrodoméstico, você tivesse que adaptar uma tomada nova em sua casa. Imaginou o caos que seria? Felizmente existe um PADRÃO de tomadas para todos os aparelhos domésticos. Se comprarmos um aparelho de som, e então levarmos para outra cidade, estado ou país, a tomada será a mesma e seu aparelho funcionará. Percebemos então o verdadeiro valor dos padrões. Na Web não é diferente, também é necessário haver padrões. Por isso que projetos como [WaSP][1] (Web Standards Project) surgiram no auge da desordem no desenvolvimento do sites. Eles foram um dos que impulsionaram a popularização dos Web Standards, fazendo a [W3C][2] (World Wide Web Consortium) ser conhecida por todos como uma autoridade e então ajudando-a a cumprir com seu papel.

O [W3C][3] criou linguagens básicas de publicação de conteúdo para Web. Essas linguagens são chamadas de Web Standards (Padrões Web). HTML, XHTML, CSS, SVG, XML, XSLT, entre vários outros.

Esses padrões hoje são estudados e felizmente os desenvolvedores estão aplicando em seus sites. Os desenvolvedores devem perceberem as incríveis vantagens que o desenvolvimento com os Padrões oferece, não só para a execução do trabalho, mas para a estruturação da web em si. Para a estruturação da Web do futuro, onde ninguém terá que garimpar em buscadores para conseguir a informação que se precisa, mas a informação estará aonde você estiver, andará com você aonde quer que for, e você terá acesso a ela sem barreiras, na hora que quiser, onde quiser, e usando o dispositivo que for.

### O que é tableless e como funciona essa metodologia?

Primeiramente é necessário que entendamos um pouco do conceito dos Web Standards.
  
A idéia original da Web, era que existisse um ambiente onde pessoas conseguissem trocar informações livremente, e que essas informações poderiam ser acessadas de diversos dispositivos. O [W3C][2] (World Wide Web Consortium) criou as linguagens básicas de publicação de conteúdo para Web, como por exemplo: HTML, CSS, SVG, XML, entre vários outros. Essas linguagens são chamadas de Web Standards (Padrões Web).

Por este tempo, deu- se início a Guerra dos Browsers. Onde o Internet Explorer e o Netscape travavam uma briga para conseguir mais adeptos. Durante essa guerra, as linguagens do [W3C][2] eram ainda rascunhos. Então, os browsers não tinham um guia completo para se basearem e lançarem seus browsers com suporte a esses Padrões. Resultou que os fabricantes de browsers criaram seus próprios padrões. E foi aí que problema começou a crescer para o lado dos desenvolvedores e usuários. De um lado estava o desenvolvedor estudando as diferenças de cada browser, para assim poder escolher qual ele iria priorizar e qual ele iria ignorar. Do outro usuário, com o mesmo dilema. Se ele escolhesse “tal” browser, os sites que ele visitara poderiam não funcionar.

Os usuários que tinham algum tipo de deficiência, como por exemplo auditiva ou visual, ficaram praticamente isolados do mundo digital, já que os desenvolvedores web tiveram que se adaptar a um certo tipo de browser, obedecendo suas peculiaridades.

Durante essa época, desenvolver um site era um trabalho árduo levando os desenvolvedores escolherem apenas um browser e desenvolver apenas para esse browser. Era quase que insuportável tenta desenvolver um site que se adequasse às duas plataformas de browsers. Os trabalho de atualizar ou fazer manutenções eram enormes e despendiam de muito tempo e paciência.

Foi por esse período que surgiram projetos como o [WaSP][1] (Web Standards Project), que é um movimento para difundir os Web Standards. Esse grupo teve um papel muito importante na divulgação dos Padrões. Eles conversaram com os fabricantes dos principais browsers, convencendo- os de fazerem browsers mais compatíveis com os Padrões. E isso deu certo&#8230; Tanto que temos o Opera, Mozilla, e vários outros por aí. Hoje, o desenvolvedor tem mais liberdade de desenvolvimento do que a 5 anos atrás. Hoje, a visão dos fabricantes de browser mudou completamente, e se continuar assim, teremos uma web melhor em muito pouco tempo.

Sabendo disso, podemos agora entender o que é Tableless.
  
Comecemos pelo nome. O nome Tableless é um nome mais “publicitário” para se referir a sites que seguem os Padrões. Os sites Tableless não são construídos usando as famigeradas tables. Elas usam XHTML para apresentar a informação e as Folhas de Estilo (CSS) para formatar essa informação. Pelo motivo de as tables não serem usadas para a estruturação, essa metodologia se chama Tableless.

Antes que você pense que as tables foram totalmente apagadas do mapa, eu explico: No movimento Web Standards, cada tag tem a sua função. Se você quer fazer um parágrafo, usa- se a tag <p>< /p>. Se quer fazer um título de primeiro nível, usa- se a tag <h1>< /h1>. Se você quer exibir dados tabulados, como por exemplo um calendário, ou ainda uma lista de produtos seguidos de nome, preço e tamanho, você usará as tables para exibir esses dados.

### Qual é a grande diferença entre montar um site nos padrões tradicionais para os que são feitos em
  
tableless?

Essa pergunta é muito difícil de ser respondida porque as diferenças entre um método e outro são gritantes. Essas diferenças afetam todas as pessoas envolvidas no projeto: começando na equipe de desenvolvimento. Aquela briga tradicional entre designer e programador acaba. Eles começam a trabalhar juntos no mesmo projeto, sem um atrapalhar o trabalho do outro. O designer trabalhará sem tocar no código de programação, ficará apenas no código CSS, onde o programador não terá como estragar o layout do Designer. E dessa forma, com os dois trabalhando ao mesmo tempo, no mesmo projeto, o tempo de produção será diminuída.
  
Inclui os donos do negócio, já que há diversas economias no desenvolvimento do projeto e também em manutenções posteriores, bem como consumo de banda que é tão preciosa hoje em dia. E finalizando no usuário, que agora pode acessar o site usando a plataforma e o browser que preferir. Poderá acessar de seu Mac ou do seu Linux, usando Opera ou Konqueror. Ele terá controle.

### No que diz respeito ao uso da metodologia tableless, quais são as principais vantagens com
  
relação a atualizações de design?

Assunto interessantíssimo. Suponhamos a seguinte situação:
  
Final daquele grande projeto. Cliente grande, site gigantesco. Várias aprovações de layout durante o caminho. Tudo acertado e pronto para ir pro ar. Faltando apenas alguns detalhes, o chefe chama o designer em um canto e diz: &#8211; O cliente acabou de ligar; ele estava analisando o site e pediu que todos os títulos mudassem de cor. Ele não gostou do azul, gostaria de verde mesmo.
  
O designer, com um olhar de desgosto, volta para sua cadeira e fica pensando em apenas uma coisa: &#8211; Por onde vou começar?
  
Ele fez o site em um editor visual, os títulos do site estão sendo formatados nos próprios documentos, direto no código. A única saída seria abrir documento por documento e substituir título por título.

Creio que se isso não aconteceu com você, algo parecido deve ter acontecido. Se o site acima tivesse sido feito seguindo os padrões, usando CSS para sua formatação, e o código fosse um XHTML bem Semântico, o trabalho disso seria quase nulo. O designer (ou o responsável pelo código CSS) mudaria apenas uma linha.

E se, o caso não fosse para mudar apenas um título, mas mudar o layout do site, como faria? Se o site foi feito do jeito convencional, provavelmente seria da seguinte forma: O designer faria um novo layout em algum programa de imagem, implementaria este layout passando para HTML, e o programador teria que programar novamente em cima deste novo layout. Mas, se o site foi feito seguindo os Web Standards, bastava o designer escrever outro arquivo CSS, e depois de pronto, substituir os arquivos.

Despenderia de tempo apenas de uma pessoa. A programação não seria afetada, e o todo o site funcionaria perfeitamente, já que foi apenas o arquivo de formatação que foi substituído. Passe um pouco de tempo visitando o site: [CSS Zen Garden][4].
  
Esse layout mostra como isso funciona. O criador deste site disponibilizou o arquivo HTML para download. Os interessados baixam esse arquivo, e fazem um CSS em cima dele e depois mandam enviam de volta. Os interessados tem apenas o direito de criar um CSS e se quiser usar imagens para compor o layout, eles não podem mudar o código HTML que o criador do site disponibilizou.

Há uma infinidade de layouts, bonitos, funcionais e compatíveis&#8230; Mudando apenas UM arquivo. Facilidade de manutenção ou renovação de layout, economia de tempo, trabalho e paciência.

### Com relação à acessibilidade, quais as vantagens que um site feito em tableless proporciona para
  
usuários com necessidades especiais?

Os usuários com necessidades especiais ganham mais facilidade de navegar no site.
  
Imagine um deficiente visual. Ele usa um browser que ao visitar um site, le todo o conteúdo mostrado na tela.

Os sites convencionais são feitos, em sua maioria com editores visuais. E em todos são usados os famosos spacer.gif. Para quem não sabe o que é isso, eu explico: São gifs transparentes de 1px que servem para dar espaçamento entre celular ou outro objeto da página. Esses spacer.gif normalmente são colocados apenas a tag relacionada a imagem, sem nenhum texto alternativo. Isso faz com que alguns sintetizadores leiam o nome da imagem. Então, suponha que você tem uma célula separada 20px e que essa distância foi feita com os spacer.gif.

O visitante terá que ouvir ou apertar uma tecla 20 vezes para passar essas imagens que são extremamente inúteis para ele. Isso transforma a navegação deles muito, muito cansativa. São coisas bem pequenas que fazem a navegação dessas pessoas valerem a pena.
  
Existem hoje muitos sistemas que analisam sites para checar se estão de acordo com as guias de acessibilidade. Esses são alguns:

  * [Bobby][5]
  * [### O que são os Web Standards?

Imagine se cada eletrodoméstico usasse um tipo de tomada. E ao comprar um novo eletrodoméstico, você tivesse que adaptar uma tomada nova em sua casa. Imaginou o caos que seria? Felizmente existe um PADRÃO de tomadas para todos os aparelhos domésticos. Se comprarmos um aparelho de som, e então levarmos para outra cidade, estado ou país, a tomada será a mesma e seu aparelho funcionará. Percebemos então o verdadeiro valor dos padrões. Na Web não é diferente, também é necessário haver padrões. Por isso que projetos como [WaSP][1] (Web Standards Project) surgiram no auge da desordem no desenvolvimento do sites. Eles foram um dos que impulsionaram a popularização dos Web Standards, fazendo a [W3C][2] (World Wide Web Consortium) ser conhecida por todos como uma autoridade e então ajudando-a a cumprir com seu papel.

O [W3C][3] criou linguagens básicas de publicação de conteúdo para Web. Essas linguagens são chamadas de Web Standards (Padrões Web). HTML, XHTML, CSS, SVG, XML, XSLT, entre vários outros.

Esses padrões hoje são estudados e felizmente os desenvolvedores estão aplicando em seus sites. Os desenvolvedores devem perceberem as incríveis vantagens que o desenvolvimento com os Padrões oferece, não só para a execução do trabalho, mas para a estruturação da web em si. Para a estruturação da Web do futuro, onde ninguém terá que garimpar em buscadores para conseguir a informação que se precisa, mas a informação estará aonde você estiver, andará com você aonde quer que for, e você terá acesso a ela sem barreiras, na hora que quiser, onde quiser, e usando o dispositivo que for.

### O que é tableless e como funciona essa metodologia?

Primeiramente é necessário que entendamos um pouco do conceito dos Web Standards.
  
A idéia original da Web, era que existisse um ambiente onde pessoas conseguissem trocar informações livremente, e que essas informações poderiam ser acessadas de diversos dispositivos. O [W3C][2] (World Wide Web Consortium) criou as linguagens básicas de publicação de conteúdo para Web, como por exemplo: HTML, CSS, SVG, XML, entre vários outros. Essas linguagens são chamadas de Web Standards (Padrões Web).

Por este tempo, deu- se início a Guerra dos Browsers. Onde o Internet Explorer e o Netscape travavam uma briga para conseguir mais adeptos. Durante essa guerra, as linguagens do [W3C][2] eram ainda rascunhos. Então, os browsers não tinham um guia completo para se basearem e lançarem seus browsers com suporte a esses Padrões. Resultou que os fabricantes de browsers criaram seus próprios padrões. E foi aí que problema começou a crescer para o lado dos desenvolvedores e usuários. De um lado estava o desenvolvedor estudando as diferenças de cada browser, para assim poder escolher qual ele iria priorizar e qual ele iria ignorar. Do outro usuário, com o mesmo dilema. Se ele escolhesse “tal” browser, os sites que ele visitara poderiam não funcionar.

Os usuários que tinham algum tipo de deficiência, como por exemplo auditiva ou visual, ficaram praticamente isolados do mundo digital, já que os desenvolvedores web tiveram que se adaptar a um certo tipo de browser, obedecendo suas peculiaridades.

Durante essa época, desenvolver um site era um trabalho árduo levando os desenvolvedores escolherem apenas um browser e desenvolver apenas para esse browser. Era quase que insuportável tenta desenvolver um site que se adequasse às duas plataformas de browsers. Os trabalho de atualizar ou fazer manutenções eram enormes e despendiam de muito tempo e paciência.

Foi por esse período que surgiram projetos como o [WaSP][1] (Web Standards Project), que é um movimento para difundir os Web Standards. Esse grupo teve um papel muito importante na divulgação dos Padrões. Eles conversaram com os fabricantes dos principais browsers, convencendo- os de fazerem browsers mais compatíveis com os Padrões. E isso deu certo&#8230; Tanto que temos o Opera, Mozilla, e vários outros por aí. Hoje, o desenvolvedor tem mais liberdade de desenvolvimento do que a 5 anos atrás. Hoje, a visão dos fabricantes de browser mudou completamente, e se continuar assim, teremos uma web melhor em muito pouco tempo.

Sabendo disso, podemos agora entender o que é Tableless.
  
Comecemos pelo nome. O nome Tableless é um nome mais “publicitário” para se referir a sites que seguem os Padrões. Os sites Tableless não são construídos usando as famigeradas tables. Elas usam XHTML para apresentar a informação e as Folhas de Estilo (CSS) para formatar essa informação. Pelo motivo de as tables não serem usadas para a estruturação, essa metodologia se chama Tableless.

Antes que você pense que as tables foram totalmente apagadas do mapa, eu explico: No movimento Web Standards, cada tag tem a sua função. Se você quer fazer um parágrafo, usa- se a tag <p>< /p>. Se quer fazer um título de primeiro nível, usa- se a tag <h1>< /h1>. Se você quer exibir dados tabulados, como por exemplo um calendário, ou ainda uma lista de produtos seguidos de nome, preço e tamanho, você usará as tables para exibir esses dados.

### Qual é a grande diferença entre montar um site nos padrões tradicionais para os que são feitos em
  
tableless?

Essa pergunta é muito difícil de ser respondida porque as diferenças entre um método e outro são gritantes. Essas diferenças afetam todas as pessoas envolvidas no projeto: começando na equipe de desenvolvimento. Aquela briga tradicional entre designer e programador acaba. Eles começam a trabalhar juntos no mesmo projeto, sem um atrapalhar o trabalho do outro. O designer trabalhará sem tocar no código de programação, ficará apenas no código CSS, onde o programador não terá como estragar o layout do Designer. E dessa forma, com os dois trabalhando ao mesmo tempo, no mesmo projeto, o tempo de produção será diminuída.
  
Inclui os donos do negócio, já que há diversas economias no desenvolvimento do projeto e também em manutenções posteriores, bem como consumo de banda que é tão preciosa hoje em dia. E finalizando no usuário, que agora pode acessar o site usando a plataforma e o browser que preferir. Poderá acessar de seu Mac ou do seu Linux, usando Opera ou Konqueror. Ele terá controle.

### No que diz respeito ao uso da metodologia tableless, quais são as principais vantagens com
  
relação a atualizações de design?

Assunto interessantíssimo. Suponhamos a seguinte situação:
  
Final daquele grande projeto. Cliente grande, site gigantesco. Várias aprovações de layout durante o caminho. Tudo acertado e pronto para ir pro ar. Faltando apenas alguns detalhes, o chefe chama o designer em um canto e diz: &#8211; O cliente acabou de ligar; ele estava analisando o site e pediu que todos os títulos mudassem de cor. Ele não gostou do azul, gostaria de verde mesmo.
  
O designer, com um olhar de desgosto, volta para sua cadeira e fica pensando em apenas uma coisa: &#8211; Por onde vou começar?
  
Ele fez o site em um editor visual, os títulos do site estão sendo formatados nos próprios documentos, direto no código. A única saída seria abrir documento por documento e substituir título por título.

Creio que se isso não aconteceu com você, algo parecido deve ter acontecido. Se o site acima tivesse sido feito seguindo os padrões, usando CSS para sua formatação, e o código fosse um XHTML bem Semântico, o trabalho disso seria quase nulo. O designer (ou o responsável pelo código CSS) mudaria apenas uma linha.

E se, o caso não fosse para mudar apenas um título, mas mudar o layout do site, como faria? Se o site foi feito do jeito convencional, provavelmente seria da seguinte forma: O designer faria um novo layout em algum programa de imagem, implementaria este layout passando para HTML, e o programador teria que programar novamente em cima deste novo layout. Mas, se o site foi feito seguindo os Web Standards, bastava o designer escrever outro arquivo CSS, e depois de pronto, substituir os arquivos.

Despenderia de tempo apenas de uma pessoa. A programação não seria afetada, e o todo o site funcionaria perfeitamente, já que foi apenas o arquivo de formatação que foi substituído. Passe um pouco de tempo visitando o site: [CSS Zen Garden][4].
  
Esse layout mostra como isso funciona. O criador deste site disponibilizou o arquivo HTML para download. Os interessados baixam esse arquivo, e fazem um CSS em cima dele e depois mandam enviam de volta. Os interessados tem apenas o direito de criar um CSS e se quiser usar imagens para compor o layout, eles não podem mudar o código HTML que o criador do site disponibilizou.

Há uma infinidade de layouts, bonitos, funcionais e compatíveis&#8230; Mudando apenas UM arquivo. Facilidade de manutenção ou renovação de layout, economia de tempo, trabalho e paciência.

### Com relação à acessibilidade, quais as vantagens que um site feito em tableless proporciona para
  
usuários com necessidades especiais?

Os usuários com necessidades especiais ganham mais facilidade de navegar no site.
  
Imagine um deficiente visual. Ele usa um browser que ao visitar um site, le todo o conteúdo mostrado na tela.

Os sites convencionais são feitos, em sua maioria com editores visuais. E em todos são usados os famosos spacer.gif. Para quem não sabe o que é isso, eu explico: São gifs transparentes de 1px que servem para dar espaçamento entre celular ou outro objeto da página. Esses spacer.gif normalmente são colocados apenas a tag relacionada a imagem, sem nenhum texto alternativo. Isso faz com que alguns sintetizadores leiam o nome da imagem. Então, suponha que você tem uma célula separada 20px e que essa distância foi feita com os spacer.gif.

O visitante terá que ouvir ou apertar uma tecla 20 vezes para passar essas imagens que são extremamente inúteis para ele. Isso transforma a navegação deles muito, muito cansativa. São coisas bem pequenas que fazem a navegação dessas pessoas valerem a pena.
  
Existem hoje muitos sistemas que analisam sites para checar se estão de acordo com as guias de acessibilidade. Esses são alguns:

  * [Bobby][5]
  *][6] 
  * [Da Silva][7]

Lembrando que o site não precisa ser Tableless para se aplicar as [Guias de Acessibilidade][8]. Mas se o site seguir os padrões, com certeza a experiência de se navegar vai ser muito melhor.

### Atualmente, existe no mercado alguma resistência em se optar por trabalhar com a metodologia
  
tableless? Por quê?

Existia muito, hoje a resistência é menor.
  
Os desenvolvedores ainda tem medo do novo. Muitos pensam:
  
&#8211; Preciso aprender tudo outra vez?! Tenho que largar o editor visual? Tenho que fazer o código na unha em vez de usar o editor visual que é tão mais fácil, rápido e prático?
  
Ou, muitas vezes o desenvolvedor já se convenceu, quer mudar, mas esta decisão não depende dele somente, e sim do Chefe. Parece brincadeira, mas já vi muitos casos do chefe falar:
  
&#8211; Você quer dizer que os sites que você vai fazer com essa nova metodologia não vai funcionar no Netscape 4?
  
Outros dizem que não vale a pena dedicar mais tempo aprendendo tudo de novo só para fazer sites funcionarem em outros browsers que não sejam Internet Explorer:
  
&#8211; Internet Explorer domina 90% do mercado, vou querer fazer para os outros 10%, porque?!

Hoje, felizmente esses comentários estão desaparecendo, e finalmente estão percebendo todas as vantagens que um site que segue os padrões pode trazer. No começo, uma desculpa bastante usada era que: Fazer sites usando os Padrões não servem para criar Portais, como Terra, UOL, AOL, e etc&#8230; Isso já é passado, mesmo porque naquele tempo nenhum era Tableless. A equipe do Terra foi treinada pela empresa em que trabalho (visie.com.br), e o site deles é Tableless. O ganho que tiveram com economia de banda foi espetacular e a facilidade de manutenção também foi enorme.

Outro caso interessante é o site da [ESPN][9].
  
Aquele site é enorme. Depois que migraram o site para os padrões estima- se que a economia de banda seria de 730 terabytes no ano. A Wired conseguiu uma redução de tamanho das páginas de 54%. Diante de números tão expressivos, é difícil contestar de que não vale a pena. E se não valesse, porque sites como: Lee Jeans, Fast Company, Macromedia, Blogger, Chevrolet, Terra, Quark, e outros migraram para os Web Standards?

Como a folha de estilo (CSS) favorece o webdesigner no processo criativo de um site desde a criação até a montagem? Controle.
  
CSS favorece um grande controle para o designer. Tanto para a criação quanto para a modificação do layout. Usando CSS, o designer não precisa criar inúmeros gifs transparentes para controlar medidas e distâncias. Com CSS ele tem total controle na manipulação de margens, bordas, distâncias, posição, tamanho, e etc. Formatação de texto também uma das vantagens que é muito flexível. O designer pode aumentar o tamanho das linhas dos parágrafos, capitalizar, fazer caixa alta/baixa, e etc&#8230; CSS é como se fosse uma ferramenta para o designer. Assim como Photoshop, Illustrator, ou outro programa visual.

### Quais são os maiores problemas enfrentados por quem opta por trabalhar com a metodologia
  
tableless? (digo a respeito à compatibilidade com determinados navegadores).

Atualmente poucos browsers causam problemas ao desenvolvedor. A maioria dos browsers atuais tem um bom suporte aos padrões, o que permite que os desenvolvedores façam sites sem muitos problemas.
  
Acho que o que dará mais problemas futuramente, serão os browsers de dispositivos móveis. Mas temos o consolo de que essa fatia do mercado, está começando a caminhar mais rapidamente&#8230; isso promete.

### Como sites feitos em tableless são visualizados nos dispositivos móveis?

São visualizados com a melhor qualidade possível para esse dispositivo.
  
Claro, se você espera ver um site em um dispositivo móvel do mesmo jeito que vê num PC, é melhor rever seus conceitos. E se você pensa que só porque fez um site seguindo os Web Standards, ele vai ser visto com a melhor qualidade em “mobiles” (dispositivos móveis), também tire o cavalinho da chuva. Lembre- se que existem sites Tableless mal feitos, isso é claro.

Temos que ter em mente que usuários desses dispositivos tem algumas dificuldades, como por exemplo barra de rolagem. Dá um desanimo quando você abre um site num handheld, e então aquela imponente barra de rolagem horizontal aparece. Quando você é obrigado a rolar a barra toda vez que precisa navegar no menu.

No CSS existe uma facilidade enorme, chama-se Media Types. As Medias Types te permitem fazer um CSS exclusivamente para um tipo e Media. Como por exemplo Impressão ou até HandHelds (Essas são as mais comuns, existem outras medias, como por exemplo para leitores de telas para deficientes visuais ou outra que é exclusivamente para impressoras que imprimem em braile. Essas medias ainda não estão totalmente implementadas, por isso não são muito comuns.) As Medias Types funcionam da seguinte forma: se você quer que seu site tenha letras grandes na hora da impressão&#8230; Vocês simplesmente fará um arquivo CSS para impressão, que será usado automaticamente quando o visitante tentar imprimir uma página no seu site.

Com a Media Type para HandHelds não é diferente. Você cria um CSS exclusivamente para os dispositivos móveis. Seu site usará a mesma estrutura XHTML para qualquer media, o que muda é apenas o arquivo CSS. Essa é a facilidade que o CSS dá em relação a isso. Mas o desenvolvedor deve ter bom senso, e estudar um bocado esse mundo que é tão interessante e está se aproximando da popularidade tão rápido.

### Quais são as vantagens proporcionadas pelo fato de o conteúdo da página estar separado da
  
formatação (CSS)?

Vantagens enormes, para desenvolvedores e para usuário.
  
As vantagens ligadas à parte dos desenvolvedores estão na facilidade de manutenção e na briga entre designers e programadores. Na facilidade de manutenção, o desenvolvedor terá uma flexibilidade tremenda na hora de corrigir algum erro ou se simplesmente quiser mudar todo o layout do site. Se o designer quiser mudar o layout do site, ele simplesmente terá o trabalho de escrever outro código CSS formatando o site com o novo visual, e depois apenas substituir os arquivos. Sem trabalho de ter que refazer o código XHTML e sem precisar mexer no código do programador.

A briga entre o designer e o programador termina por que eles não atrapalham mais o trabalho um do outro. Nem o designer estraga o código do programador e nem o programador estraga o layout do designer.

Há muitas maneiras de os designers e programadores trabalharem harmoniosamente. Como por exemplo: no início do desenvolvimento, o designer e o programador podem sentar juntos e então criar a estrutura do documento, ou seja, o código XHTML do site. Aqui eles farão um código semântico, legível. Feita essa parte, os dois trabalharão em cima deste XHTML separadamente, cada um com sua responsabilidade. O programador com seus códigos client &#8211; side, banco de dados e etc&#8230; Já o designer ou o responsável por isso, formatará o visual do site, usando CSS. Com o XHTML estruturado semanticamente, o designer não terá grandes problemas ao aplicar estilos às tags.

Outra vantagem que interessa a sites grandes (como portais) é a diminuição do consumo de banda. Há uma queda enorme no número de linhas de código, já que tags desnecessárias foram totalmente excluídas e a separação de informação (XHTML) e formatação (CSS) é praticada. O fator “tamanho” é bastante importante, pois se o tamanho do site diminui, o consumo de banda diminui; logo, os gastos excessivos por causa do estouro de banda são imediatamente reduzidos.

Já o lado do usuário ganha uma grande vantagem: flexibilidade e controle. O usuário ganha a liberdade de escolher qual dispositivo, qual plataforma e por fim, qual browser ele irá utilizar para visualizar seus sites. Um usuário por exemplo pode utilizar Mac e navegar com Safari, Firefox ou até mesmo Internet Explorer. Ou utilizar Linux e navegar com Konqueror, Galeon ou Opera. Se preferir, o visitante pode estar usando algum dispositivo móvel como um PocketPC com Windows Mobile e visitar o site utilizando o Internet Explorer.

Como você já percebeu, há uma variação interminável de plataformas e dispositivos. Isso só tende a aumentar. Esse é o caminho que a web deve percorrer. Liberdade para troca de informações, independente do dispositivo utilizado para isso. É isso que o usuário espera.

 [1]: https://www.webstandards.org/about/mission/pt/
 [2]: https://www.w3.org/
 [3]: https://www.w3.org/ "World Wide Web Consortium"
 [4]: https://www.csszengarden.com/
 [5]: https://www.mardiros.net/bobby-accessibility-tool.html
 [6]: https://www.st-andrews.ac.uk/its/web/accessibility/cynthia_validator.shtml
 [7]: https://www1.acessobrasil.org.br/dasilva/dasilva.html
 [8]: https://www.w3.org/WAI/
 [9]: https://espn.com