---
title: 6 dicas para evitar problemas de incompatibilidade entre browsers.
authors: Thaiana Poplade
type: post
date: 2010-09-28
excerpt: Mesmo com o lançamento de versões beta dos principais browsers, prontos para receber o HTML5, profissionais ainda enfrentam dificuldades em realizar o trabalho de webstandards nos dias de hoje.
url: /evite-incompatibilidade-browsers/
aktt_notify_twitter:
  - yes
tweetbackscheck:
  - 1356453002
shorturls:
  - 'a:3:{s:9:"permalink";s:56:"https://tableless.com.br/evite-incompatibilidade-browsers";s:7:"tinyurl";s:26:"https://tinyurl.com/3bca7fj";s:4:"isgd";s:19:"https://is.gd/cqRnYS";}'
twittercomments:
  - 'a:111:{i:12532730868801536;s:6:"136288";i:13195698786803713;s:6:"136368";i:13198428708278273;s:6:"136373";i:13198177104560128;s:6:"136374";i:42236296344633344;s:7:"retweet";i:43729063575166976;s:6:"137160";i:111086047353503745;s:7:"retweet";i:111077506890731520;s:7:"retweet";i:111074654403305472;s:7:"retweet";i:111074153930567680;s:7:"retweet";i:111067416116727809;s:7:"retweet";i:111063770872283136;s:7:"retweet";i:111061894160334850;s:7:"retweet";i:111055561482715136;s:7:"retweet";i:111054059515027457;s:7:"retweet";i:111053091754868737;s:7:"retweet";i:111050142936875008;s:7:"retweet";i:111049160056246272;s:7:"retweet";i:111048895001399296;s:7:"retweet";i:111047981905608704;s:7:"retweet";i:111042261462171648;s:7:"retweet";i:111031727845158913;s:7:"retweet";i:111017235606290432;s:7:"retweet";i:110989330486538240;s:7:"retweet";i:110983369839489024;s:7:"retweet";i:110927449734397952;s:7:"retweet";i:110927017624616960;s:7:"retweet";i:110923479527862274;s:7:"retweet";i:110918433415237632;s:7:"retweet";i:110912424785358848;s:7:"retweet";i:110911501438697472;s:7:"retweet";i:110909985977933824;s:7:"retweet";i:110908486682025984;s:7:"retweet";i:110907893838135299;s:7:"retweet";i:110907737466077184;s:7:"retweet";i:110907543534047232;s:7:"retweet";i:110905518574415872;s:7:"retweet";i:110904859577950208;s:7:"retweet";i:110904601087188992;s:7:"retweet";i:110904524981547010;s:7:"retweet";i:110904396493225984;s:7:"retweet";i:110904261340168192;s:7:"retweet";i:109245080858132480;s:7:"retweet";i:179641868940869633;s:7:"retweet";i:179589490980036608;s:7:"retweet";i:179574673011519488;s:7:"retweet";i:179562539028459520;s:7:"retweet";i:179561559687835648;s:7:"retweet";i:186826644793737216;s:7:"retweet";i:186822436375887878;s:7:"retweet";i:186809003886653440;s:7:"retweet";i:186808885661806592;s:7:"retweet";i:186808255023030272;s:7:"retweet";i:186808155215364096;s:7:"retweet";i:186807568302211072;s:7:"retweet";i:186807434231300096;s:7:"retweet";i:186807117871726592;s:7:"retweet";i:186807115707465729;s:7:"retweet";i:186807110036766720;s:7:"retweet";i:186807064285290498;s:7:"retweet";i:186806734457806849;s:7:"retweet";i:199585846486241281;s:7:"retweet";i:199731455105048576;s:7:"retweet";i:199674604707528704;s:7:"retweet";i:199641123168321536;s:7:"retweet";i:199599510903721984;s:7:"retweet";i:199586199948632066;s:7:"retweet";i:199586071242215424;s:7:"retweet";i:199585672946917376;s:7:"retweet";i:206059650964135937;s:7:"retweet";i:206051205565263873;s:7:"retweet";i:206043120201252865;s:7:"retweet";i:206021963410440192;s:7:"retweet";i:206019951079849984;s:7:"retweet";i:206014509775732736;s:7:"retweet";i:206013566812303360;s:7:"retweet";i:206013298762727424;s:7:"retweet";i:211095720802009090;s:7:"retweet";i:211090937240223745;s:7:"retweet";i:211090235025657856;s:7:"retweet";i:211087581771870208;s:7:"retweet";i:211087527690518529;s:7:"retweet";i:211087105269571584;s:7:"retweet";i:211087082490314752;s:7:"retweet";i:211086927028424704;s:7:"retweet";i:215496955839791104;s:7:"retweet";i:215191656092270594;s:7:"retweet";i:215170991167508481;s:7:"retweet";i:215115565520531456;s:7:"retweet";i:215084348586729472;s:7:"retweet";i:215081205400473600;s:7:"retweet";i:215078638582890496;s:7:"retweet";i:215076856888705025;s:7:"retweet";i:215075992874659840;s:7:"retweet";i:224867216074612736;s:7:"retweet";i:224865518656565252;s:7:"retweet";i:224860234206822400;s:7:"retweet";i:233652907050946560;s:7:"retweet";i:231400889947127808;s:7:"retweet";i:231386909400772608;s:7:"retweet";i:231385343562244096;s:7:"retweet";i:231380442870329345;s:7:"retweet";i:252037518487347201;s:7:"retweet";i:251713024455503874;s:7:"retweet";i:251675671259123712;s:7:"retweet";i:251674422358966272;s:7:"retweet";i:251674158998618112;s:7:"retweet";i:259345943357431808;s:7:"retweet";i:259288679263113216;s:7:"retweet";i:259284961692098560;s:7:"retweet";i:278576777994047489;s:7:"retweet";}'
tweetcount:
  - 564
dsq_thread_id: 503039615
categories:
  - Browsers
  - Código
  - CSS
  - HTML
  - Técnicas e Práticas
tags:
  - 2010
  - Browsers
  - CSS
  - desenvolvimento web
  - navegadores
  - padroes web
  - tecnicascss

---
Nas últimas semanas muito falou-se das novas versões de _browsers_ que serão colocadas à disposição dos usuários nos próximos meses. Alguns esperam para ver se a gigante Microsoft recuperará o mercado e outros acompanham as novidades de Mozilla e Google com suas versões beta do Firefox 4 e do Chrome 6. É inevitável perceber a preocupação de todos em adaptar-se às necessidades dos usuários, padrões de desenvolvimento web e compatibilidade com o novo protagonista da web &#8211; o HTML5 &#8211; porém em meio à esses lançamentos, fica a pergunta: enquanto isso, como agir com os atuais _browsers_? Como criar estruturas de _front-end_ para que os parâmetros do CSS 2 sejam igualmente aplicados à todos?

Essas perguntas já travaram várias batalhas entre desenvolvedores e navegadores, tendo como principal vilão o Internet Explorer em suas versões 6, 7 e 8 que além de não ser compatível com os demais browsers também não é compatível entre suas próprias versões, dificultando a criação de padrões e a exclusão de _hacks_. De qualquer forma, nosso trabalho é visualizar igualmente as interfaces em todos os navegadores &#8211; o chamado _crossbrowser_ &#8211; e para isso, apresento algumas possibilidades e propriedades que podem ser inseridas aos seus arquivos css para evitar esses problemas sem utilizar _hacks_, “gambiarras” ou arquivos diferentes para cada _browser._

### Dica nº 1: Organização x manutenção.

Em seu artigo, a [Talita Pagani][1] apresenta [estratégias para melhorar a organização dos arquivos CSS][2] e aproveito o gancho para aconselhar: é indiscutível que, em se tratando de manutenção ou a criação de arquivos CSS, a organização seja fundamental para encontrarmos os problemas quando as incompatibilidades surgirem. Então, uma estrutura de classes, ID&#8217;s e identação de elementos, parâmetros e valores é ponto crucial para manutenção e desenvolvimento de estruturas _html&css_.

### Dica nº 2: Elementos com propriedades pré-definidas.

Muitos desenvolvedores não sabem, mas alguns elementos do HTML tem propriedades pré-definidas que, quando começamos a trabalhar com a diagramação podem por exemplo, nos trazer dificuldades de encontrar aquele “espaço a mais” que incomoda tanto. Então, inicialmente, vamos eliminar todas estas formatações criando uma declaração que elimina os principais parâmetros pré-definidos que “bagunçam” a interface de _browser_ para _browser:_ _margin’s_ e _padding’s._ Para tanto, utilizaremos o selector universal (*) no ínicio da folha de estilo eliminando os espaçamentos internos ou externos dos elementos:

[cc lang=&#8221;css&#8221;]*{
  
padding: 0;
  
margin:0;
  
}[/cc]

Caso em sua estrutura tenha várias folhas de estilo, separadas por página (home.css), aconselho que seja criado um arquivo específico para a declaração desta propriedade e valores zerados, com o nome de &#8220;geral.css&#8221; ou &#8220;reset.css&#8221;. Assim, posteriormente ele poderá ser linkado à página ou inserido, via parâmetro **@import**,  às outras folhas de estilo incorporando às demais declarações.

Se necessário utilizar _margin’s_ ou _padding’s_ para alguns elementos, meu conselho é que você crie classes específicas para cada um deles, pois isso vai lhe garantir um controle maior de qual elemento tem uma propriedade que pode causar alguma diferença em larguras ou alturas nos blocos do HTML.

Há um artigo aqui no Tableless que explica esse conceito chamado [CSS Reset][3].

### Dica nº 3: largura e altura x propriedade _padding_.

Alguns desenvolvedores também não sabem, mas quando inserimos a propriedade _width_ ou _height_ à um elemento e adicionamos a propriedade _padding_ à esse mesmo elemento, os valores estabelecidos serão somados. Por exemplo, se tenho um elemento com _width: 640px_ e estabeleço o parâmetro _padding-left: 20px_, meu elemento terá ao todo _660px_ de largura. Portanto, quando utilizar a propriedade _padding_, tanto os valores de largura quanto os de altura, devem ser reduzidos proporcionalmente para que seu bloco continue com o mesmo tamanho e com um espaçamento interno necessário.
  
No nosso exemplo, o correto então seria: _width: 620px_ e _padding-left: 20px_. Ficando o elemento todo com uma largura total de _640px_.

[cc lang=&#8221;css&#8221;].blocoNoticias{
  
width: 620px;
  
padding-left: 20px;
  
}[/cc]

### Dica nº 4: colunas x propriedade float.

Toda vez que utilizamos a propriedade _float_ para formatação de colunas em nossa página, temos que nos lembrar de regras básicas:

  * &#8211; Se as colunas estão inseridas dentro de algum outro elemento, você terá que obrigatoriamente usar, neste elemento “externo”, a propriedade _display:table_ e a propriedade _height:auto_. Caso contrário, no Firefox, seu background pode não aparecer ou tão pouco obedecer a altura da colunas.
  * &#8211; Se após as colunas, existir um outro elemento com propriedade horizontal, formando uma linha, ele obrigatoriamente deve receber a propriedade _clear:both_, para que ele não incorpore a propriedade _float_ inserida nas colunas e fique logo abaixo delas.

### Dica nº 5: Propriedade border para visualizar os problemas.

Para quem já está com toda a página pronta e não consegue encontrar e resolver alguns problemas como uma coluna embaixo da outra ou um texto ultrapassando o limite de seu bloco, insira a propriedade _border:solid 1px red_ ao elemento e visualize na tela a altura e largura deste bloco. Com isso você vai conseguir perceber qual elemento está extrapolando o limite ou qual espaçamento está “empurrando” os demais blocos.
  
Visualizar o problema na tela, facilita a resolução.

### Dica nº 6: verifique sua página, desde o início, em todos os _browsers._

É muito mais fácil começar uma estrutura _html&css_ já verificando a inserção de cada elemento em todos os _browsers_ ao mesmo tempo, do que desenvolver tudo visualizando apenas em um dos navegadores e após finalizar o projeto, visualizar nos demais. Com toda certeza, se este cuidado não for tomado, você vai se deparar com uma interface com cara de “jogos de _puzzle_ embaralhados” em algum momento e vai ser ainda mais difícil resolver os problemas.

Essas são apenas algumas das tantas possibilidades que temos para evitar o uso de hacks ou “jeitinhos” na construção de nossos arquivos html&css no trabalho de _crossbroswers_. De qualquer forma, me mantenho na torcida de que com a nova geração, tenhamos muito mais chances de desenvolver um código html melhor estruturado e um css com propriedades visuais que hoje ainda não podemos utilizar, do que ficar estudando os erros dos navegadores para encontrarmos os acertos dos desenvolvedores &#8211; quase como tiros no escuro.

 [1]: https://tableless.com.br/6-estrategias-para-melhorar-a-organizacao-do-seu-css-2#author-image
 [2]: https://tableless.com.br/6-estrategias-para-melhorar-a-organizacao-do-seu-css-2
 [3]: https://tableless.com.br/css-reset "Como fazer um reset nas propriedades do CSS"