---
title: Eu não sou uma máquina
authors: Reinaldo Ferraz
type: post
date: 2012-08-30
excerpt: Além da grande barreira de acessibilidade, já que os CAPTCHAs tradicionais não costumam ser acessíveis, novas modalidades de CAPTCHA mais difíceis vem sendo criados para evitar que robôs consigam acessar seus formulários.
url: /eu-nao-sou-uma-maquina/
tweetbackscheck:
  - 1356438616
shorturls:
  - 'a:3:{s:9:"permalink";s:31:"https://tableless.com.br/?p=6718";s:7:"tinyurl";s:26:"https://tinyurl.com/96wxpvz";s:4:"isgd";s:19:"https://is.gd/BIRiRd";}'
twittercomments:
  - 'a:0:{}'
dsq_thread_id: 824445143
categories:
  - Acessibilidade
  - Artigos
  - Mercado
  - Tecnologia e Tendências
  - UX
tags:
  - acessibilidade
  - desenvolvimento
  - usabilidade
  - web

---
<img class="alignleft size-medium wp-image-6719" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2012/08/captcha-300x193.jpg" alt="Imagem ilustrando um captcha impossível de ser solucionado" width="300" height="193" srcset="uploads/2012/08/captcha-300x193.jpg 300w, uploads/2012/08/captcha.jpg 366w" sizes="(max-width: 300px) 100vw, 300px" />Por trás de uma máquina, alguém faz perguntas sem sentido, com a intenção de descobrir se você é uma pessoa ou robô. Não estou falando do interrogatório do caçador de andróides, entre Rick Deckard e Rachael durante uma sequência do filme [Blade Runner][1], de 1982. Estou falando de uma pessoa que está fazendo uma compra em uma loja online em 2012. Estou falando do CAPTCHA.

O CAPTCHA, acrônimo de “_Completely Automated Public Turing test to tell Computers and Humans Apart_” é um teste cognitivo criado para evitar que robôs preencham campos de formulários, especialmente para o envio de spams. Segundo a [definição da Wikipedia][2], “Como os computadores são incapazes de resolver o CAPTCHA, todo usuário que incorpora uma solução correta é presumidamente humano”, significa que quem passar no teste do formulário é um humano, certo? Errado.

Em 2011, [uma equipe da Universidade de Standford desenvolveu técnicas para quebrar os mais conhecidos CAPTCHAs disponíveis na web][3], e o resultado foi assustador: 66% dos “Captchas” usados pelo Authorize.net foram quebrados pela técnica e quase todos os desafios do site da CNN foram solucionados. Resumindo, estamos permitindo que robôs acessem o conteúdo que devia estar disponível somente para as pessoas.

[Esse artigo da Lêda Spelta e do Horácio Soares da Digital Acesso explica com detalhes as diversas barreiras que os CAPTCHAs criam em nome da segurança][4]. São várias técnicas ineficazes criadas para proteger o sistema de invasores e robôs que estão barrando o acesso de seus usuários. Nesse mesmo artigo os autores abordam com mais profundidade detalhes sobre outras pesquisas e estudos e comentam sobre a decisão da BBC de abolir o CAPTCHA de suas páginas.

Além da grande barreira de acessibilidade, já que os CAPTCHAs tradicionais não costumam ser acessíveis, novas modalidades de CAPTCHA mais difíceis vem sendo criados para evitar que robôs consigam acessar seus formulários, mas alguns exemplos mostram que isso está se tornando mais difícil para o usuário tambem.

É o caso [desse exemplo][5], desenvolvido em um formato de “jogo” para facilitar a conclusão das tarefas. Ele é inacessível para um usuário que não consegue utilizar um mouse, como uma pessoa com deficiência visual ou tetraplegia. Para minimizar essa questão, os desenvolvedores criaram um ícone de acessibilidade, que pede para o usuário escutar um som incompreensível e digitar alguma palavra em uma caixa de texto.

Enquanto algumas empresas buscam técnicas cada vez mais complexas para evitar que robôs acessem o conteúdo da sua página, algumas optam por fazer o mais simples e acessível. É o caso do formulário de contato do [Instituto Faber Ludens][6], que utiliza uma pergunta simples em modo texto para verificar se não somos robôs preenchendo um campo de formulário. Um usuário que utiliza um software leitor de tela, por exemplo, consegue facilmente preencher esse campo. A mesma criatividade para desenvolver CAPTCHAs inacessíveis pode trazer ótimas soluções para garantir a segurança dos sistemas sem barrar o acesso das pessoas.

A web é feita de pessoas e para pessoas. O acesso a informação de qualquer lugar é uma vitória que hoje nós temos que comemorar. Estamos construindo uma web para as pessoas que deve ser segura, mas que não deve criar barreiras de acesso para os seres humanos. Quem sabe, muito antes desse futuro não tão distante previsto por Ridley Scott, eu não tenha mais que provar para uma máquina que eu sou um ser humano.

 [1]: https://www.imdb.com/title/tt0083658/
 [2]: https://pt.wikipedia.org/wiki/CAPTCHA
 [3]: https://elie.im/publication/text-based-Captcha-strengths-and-weaknesses#.UDzNQ8FlSk8
 [4]: https://acessodigital.net/art_captcha-heroi-ou-vilao.html
 [5]: https://areyouahuman.com/demo/
 [6]: https://www.faberludens.com.br/pt-br/contact