---
title: WordPress para front-end, iniciando um projeto.
authors: Thaiana Poplade
type: post
date: 2013-04-01
excerpt: Estranho dizer que vamos falar de Wordpress classificando à um grupo específico, mas se o seu negócio é “html’s“, “css’s“ e algumas arriscadas em “jquery’s“ e “javascript’s“, você vai entender do que estou falando.
url: /wordpress-para-front-end-iniciando-um-projeto/
categories:
  - Artigos
  - Wordpress
tags:
  - 2013
  - Wordpress

---
Após um sumiço (justificável) aqui do Tableless, garanto: continuo, por aí, na ativa “codando“, testando e opinando da perspectiva front-end/UX a respeito da evolução do desenvolvimento web.
  
No último ano tive a chance de trabalhar incansavelmente com o opensource CMS Worpdress e se você não sabe do que estou falando, te aconselho a parar por aqui e clicar nos links abaixo:

<a href="https://tableless.com.br/front-end-concluido-como-comecar-wordpress-parte-i" target="_blank">https://tableless.com.br/front-end-concluido-como-comecar-wordpress-parte-i/#.UVh-Aqt36So</a>

<a href="https://br.wordpress.org/" target="_blank">https://br.wordpress.org/</a>

<a href="https://www.youtube.com/watch?v=1skFgAcgZik" target="_blank">https://www.youtube.com/watch?v=1skFgAcgZik</a>

Esta experiência, me fez adquirir alguns processos para iniciar novos projetos com o uso da plataforma e agora vou dividir com vocês. Ressalto que, são escolhas bastante pessoais, uma vez que com o WP podemos fazer a mesma coisa de inúmeras formas, portanto se você conhece mais algum outro método que possa ser adicionado à esta listagem, sinta-se a vontade para completar através dos comentários.

**Passo 1**

**Baixar uma versão atualizada do WordPress:** esta etapa é bastante importante principalmente para quem faz grande uso de pluggins. Eu confesso que circulo entre a versão mais atual e duas versões anteriores pois, já tive o desagrado de descobrir de última hora que o pluggin escolhido para usar em um dos projetos que eu estava desenvolvendo, só aceitava versões anteriores da plataforma. Portanto, tome cuidado com esta etapa.

**
  
Passo 2**

**Escolha um tema em “branco“ (Sandbox):** depois de instalado o WP não faça nada antes de instalar um novo tema mais “limpo“ visualmente, senão você (que conhece de HTML) vai sofrer horrores tentando descobrir onde estão os “problemas“ de css do tema que acompanha o WP. No nosso caso, o escolhido é o tema <a title="Sandbox" href="https://wordpress.org/extend/themes/sandbox" target="_blank">Sandbox </a>(indicação de um amigo/desenvolvedor que trabalhou comigo) que tem um visual totalmente clean e sem grandes formatações, ainda assim, antes mesmo de aplica-lo ao admin do WP, limpo os arquivos de estilo do tema, deixando apenas os presets básicos (aproveito e incluo presets para <a title="Tableless - Html5 e os novos atributos." href="https://tableless.com.br/html-5-novos-elementos-e-atributos/#.UViPXqt36So" target="_blank">tags HTML5 </a>também, assim você já pode aplicar as novas estruturas html em seus códigos.). Feito isso, “visualizar página“.

&nbsp;

**
  
Passo 3**

**Crie (desenhe, se necessário) uma dinâmica de uso do WordPress:** na prática, visulizar o layout, os dados de sitemap e partir para um rabisco da lógica de ações do usuário para atualizar o conteúdo deste site com o WordPress. Isso te permite entender melhor onde você terá que personalizar o uso do CMS no painel de administração, além de já adiantar um passo onde você conseguirá desenvolver o html diretamente no tema do WP visualizando a aplicação do CMS a cada conteúdo.

**
  
Passo 4**

**Escolher os (melhores) pluggins:** na etapa anterior, você já terá uma boa ideia de quais funcionalidades o usuário do WP vai precisar para atualizar o site, portanto antes mesmo da criação dos htmls das páginas, é ideial fazer a escolha dos pluggins. Essa escolha é bastante complicada uma vez que a chance de um pluggin não funcionar ou até mesmo não atender a necessidade, é grande, portanto vale levar em conta alguns pontos: atualização do pluggin, popularidade, complexibilidade e suporte.
  
Abaixo, indico uma lista de alguns pluggins que trazem ferramentas bem comuns às necessidades da maioria dos websites:

<p style="padding-left: 30px">
  <b>Galeria de imagem: NexGen Gallery<br /> </b><a href="https://wordpress.org/extend/plugins/nextgen-gallery/">https://wordpress.org/extend/plugins/nextgen-gallery/</a><br /> Um dos melhores na criação de galeria de imagens completas. O gerenciamento das imagens é muito simples de ser feito e é possível inserir tags e outras propriedades para auxílio à indexação das imagens.
</p>

<p style="padding-left: 30px">
  <b>Campos do WordPress customizados: Advanced Custom Fields</b><br /> <a href="https://wordpress.org/extend/plugins/advanced-custom-fields/">https://wordpress.org/extend/plugins/advanced-custom-fields/</a><br /> Personalizar os campos do WP é algo que mais cedo ou mais tarde, você precisará fazer. Este é um dos melhores pluggins para isso e caso você precise comprar para adquirir ainda mais funcionalidades, ele super vale a pena.
</p>

<p style="padding-left: 30px">
  <b>Formulários: Contact Form 7</b><br /> <a href="https://wordpress.org/extend/plugins/contact-form-7/">https://wordpress.org/extend/plugins/contact-form-7/</a><br /> É salvação para formulários. Principalmente quando temos aqueles formulários de envio de arquivos, como o <i>Trabalhe Conosco. </i>Este pluggin resolve para você de forma muito rápida e simples. Basta um pouquinho de leitura na página do pluggin e você já sai fazendo seu primeiro formulário ;).
</p>

<p style="padding-left: 30px">
  <b>Música online: Flash MP3 Player</b><br /> <a href="https://wordpress.org/extend/plugins/flash-mp3-player/">https://wordpress.org/extend/plugins/flash-mp3-player/</a><br /> Este pluggin é aquele tipo de  alternativa para se ter uma playlist de músicas no site. Não é tão comum termos isso nos websites de hoje, mas eventualmente surge a necessidade de disponibilizar uma listagem de músicas com autoplay, ou não, e botões de “stop“, “play/pause“&#8230; para o usuário. Este é o cara que resolve isso para você.
</p>

<p style="padding-left: 30px">
  <b>Banners e áreas de destaque: WordPress Content Slide</b><br /> <a href="https://wordpress.org/extend/plugins/content-slide/">https://wordpress.org/extend/plugins/content-slide/</a><br /> Sabe quando você precisa trazer as imagens de alguns posts/páginas para uma estrutura de banner slider? Então, este é o pluggin que te ajuda nisso. Banners criados de acordo com as imagens destacadas de um post ou de uma categoria. Vale a pena dar um olhada.
</p>

<p style="padding-left: 30px">
  <b>Tradução: Qtranslate</b><br /> <a href="https://wordpress.org/extend/plugins/qtranslate/">https://wordpress.org/extend/plugins/qtranslate/</a><br /> E por fim, não menos importante, o Qtranslate. Um pluggin para criar uma estrutura de website com várias traduções. Ele cria possibilidades de inserir conteúdos em diferentes línguas, além de te auxiliar na inserção destas em seu front-end, com bandeirinhas e URL`s.<br /> Vale a pena.
</p>

Após toda essa estruturação, mão a obra, que daqui para frente é aquilo que você já conhece – HTML + CSS e lindas páginas publicadas pela web.

Boa sorte e até a próxima.

😉

&nbsp;