---
title: Então você quer ser designer web? (Parte 1 – Cores)
authors: cristianoweb
type: post
date: 2015-06-04
excerpt: Nesta primeira parte, conheça algumas ferramentas para trabalhar com paletas de cores e tornar-se um designer web.
url: /entao-voce-quer-ser-designer-web-parte-1-cores/
categories:
  - Design
  - O Básico
tags:
  - designer web
  - web designer
---
Um dia em você acha que já sabe &#8220;mexer&#8221; bastante no Photoshop (ou Fireworks) e decide que se lançar no mercado como designer web. Fez alguns pequenos trabalhos, e não vê a hora de criar um site bacana e colocar seus serviços à venda na prateleira de um domínio com seu nome.

Por mais que você seja talentoso, e mereça um lugar ao Sol, o que mais faz falta nesse momento é bagagem. Ter um bom repositório de referências é a melhor forma de começar a trabalhar em qualquer projeto web antes mesmo de clicar &#8220;Ctrl + N&#8221; no Photoshop.

Pensando nisso, resolvi falar de inúmeras áreas de apoio especificamente voltadas para a criação de _layouts_, interfaces e projetos web. Falarei sobre ícones, bancos de imagens, fontes, texturas e tantos outros assuntos que não vão caber num post só. Por isso criei uma <a title="Nota - Links de referências para série de artigos Designer Web no Tableless | Esse link abre numa nova janela" href="https://www.evernote.com/shard/s29/sh/4eba57a4-d176-4d8e-8616-eea8893abf29/a0cc26baf67bcfa97a24fb8f1ad35bf2" target="_blank">nota no meu Evernote</a> que está recheada de links para que eu possa sempre visitá-la antes de começar a escrever por aqui. Sintam-se à vontade de sugerir qualquer coisa, inclusive as áreas. A ideia é que essa lista seja infinita.

## Então para começar eu resolvi falar de cores

Responsável por boa parte da emoção transmitida ao usuário, uma boa paleta de cores pode ser o sucesso do seu site. Dependendo da combinação escolhida, a paleta pode transmitir felicidade, calma, acolhimento, excitação, estímulo, enfim, há sempre uma ou mais cores indicadas para o sentimento que você deseja transmitir para a sua interface. É a chamada Psicologia das Cores. Um excelente infográfico que explica muito bem esse conceito é o do site Viver de Blog no artigo <a title="Artigo 'A Psicologia das cores no marketing' por Henrique Carvalho | Esse link abre numa nova janela" href="https://viverdeblog.com/psicologia-das-cores/" target="_blank">A Psicologia das cores no marketing.</a> Vale a leitura.

Vamos às ferramentas:

### Color Palette Generator

<img class="aligncenter wp-image-49263 size-full" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/05/thumb-entao-voce-quer-ser-designer-web-parte-1-cores-color-palette-generator.png" alt="DeGraeve.com - Paleta de Cores para Designers Web " width="800" height="480" />

Uma excelente ferramenta online que tem uma função bastante útil quando o conceito central do seu projeto é uma fotografia. Imagine que você precisa criar a paleta de cores baseada nessa imagem. Normalmente você abriria a imagem no Photoshop e usaria o conta-gotas, selecionando algumas partes onde a cor fosse mais relevante, e criaria uma nova paleta com as cores desejadas. Isso seria mega trabalhoso, além do fato de confiar seu olho para decidir quais cores seriam as mais relevantes na imagem.

Com **<a href="https://www.degraeve.com/color-palette/" target="_blank">Color Palette Generator</a>** basta subir a imagem que ele faz esse trabalho para você, escolhendo 6 cores, e exibindo o código hexadecimal nos formatos &#8220;_dull_&#8221; (cores mais opacas) e &#8220;_vibrant_&#8221; (cores mais vibrantes). Veja um exemplo do resultado de cores com a <a href="https://www.degraeve.com/color-palette/index.php?q=https://www.henry4school.fr/UK/monarchy/images/queen-rainbow.jpg,827371D47B83FCFCFCDCD6D3B8B7C3,8B6B69FF4E5EFDFDFCE1D5CFB2B1CA" target="_blank">imagem Rainbow Queen</a>.

### Material Palette

<img class="aligncenter wp-image-49265 size-full" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/05/thumb-entao-voce-quer-ser-designer-web-parte-1-cores-material-palette.png" alt="material palette - Paleta de Cores para Designers Web " width="800" height="480" />

Seguindo a onda &#8220;_Flat Design_&#8220;, a **<a href="https://www.materialpalette.com/" target="_blank">Material Palete</a>** é uma ferramenta que certamente vem a calhar. Basta escolher duas cores, e ela simula interfaces &#8216;_mobile flat_&#8216;, além de sugerir combinações. Você pode alterar a combinação baseado em uma das cores e recomeçar o ciclo, que, uma vez definido, fica disponível para download nos formatos CSS, SASS, LESS, SVG, XML e PNG.

### Adobe Color CC

<img class="aligncenter wp-image-49267 size-full" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/05/thumb-entao-voce-quer-ser-designer-web-parte-1-cores-color-adobe.png" alt="Adobe Color CC - Paleta de Cores para Designers Web " width="800" height="480" />

Para quem tem um perfil na Adobe a dica é usar o **<a href="https://color.adobe.com/pt/" target="_blank">Adobe Color CC</a>**, ideal para fazer estudos de combinação de cores e salvar na nuvem. Você pode começar a paleta baseada em uma cor específica ou em uma imagem, fazendo inclusive ajustes online. A ferramenta indica a paleta de 5 cores que pode ser refinada conforme o gosto do freguês.

Além disso, há uma galeria de paletas com os temas públicos de outros usuários, onde é possível copiá-las para sua galeria e editá-las posteriormente, permitindo ainda o download, salvá-las como favoritas ou fazer comentários. Utilize também a busca, pois os resultados levam em consideração o nome que os usuários deram para as suas paletas, assim como o nome das cores e _tags_. Enfim, uma mar de possibilidades.

### Paletton

<a href="https://paletton.com/" target="_blank"><img class="aligncenter wp-image-49268 size-full" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/05/thumb-entao-voce-quer-ser-designer-web-parte-1-cores-paletton.png" alt="Paletton - Paleta de Cores" width="800" height="480" /></a>

**[Paletton][1]** é uma ferramenta online no formato _Color Schemer_, onde selecionamos uma cor inicial, podendo ajustar infinitas combinações, sempre com as opções de variação monocromática, cor adjacente, tríade (três cores), tétrada (quatro cores), e sempre de forma editável. Uma vez decidida a paleta, basta fazer download nos formatos HTML, CSS, LESS, XML, entre outros.

### COLOURlovers

<img class="aligncenter wp-image-49269 size-full" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/05/thumb-entao-voce-quer-ser-designer-web-parte-1-cores-colour-lovers.png" alt="COLOURlovers - Paleta de Cores para Designers Web " width="800" height="480" />

Uma mistura de rede social e ferramenta, **<a href="https://www.colourlovers.com/" target="_blank">COLOURlovers</a>** é antes de mais nada um ótimo laboratório na hora de criar paletas de cores. A ferramenta também auxilia na criação de cores únicas, _patterns_, entre outros.

Comece a criar a paleta baseada numa cor única, que pode ser ajustada a qualquer momento, já que a ferramenta sugere composições de cores automaticamente. Você pode também fazer o upload de uma imagem e terá como resultado uma das mais completas sugestões de cores via ferramentas online.

### Coolors

<img class="aligncenter wp-image-49270 size-full" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/05/thumb-entao-voce-quer-ser-designer-web-parte-1-cores-coolors.png" alt="Coolors - Paleta de Cores para Designers Web " width="800" height="480" />

Conheci esta a ferramenta recentemente e me apaixonei. **<a href="https://coolors.co/app" target="_blank">Coolors</a>** é simples e fácil de usar. É ideal para usuários mais exigentes que precisam ajustar não só a cor, mas também outros tipos de saída (tem até CMYK para impressos) e canais de cor. Você define uma cor e vai ajustando conforme a sua necessidade. Caso esteja de acordo com uma cor, basta fechar o cadeado e ajustar as outras até completar a paleta.

O processo é manual, mas oferece um enorme controle para quem não deseja que um algorítimo decida sua composição. Para quem busca inspiração antes de meter a mão na massa, o site também oferece uma vasta galeria de paletas, com a possibilidade de exportação nos formatos PDF, PNG, SCSS e SVG. E se você for usuário dos serviços na nuvem da Adobe, há ainda a possibilidade de inserir diretamente no Illustrator e  Photoshop um Add-on por U$ 5,00. Uma pechincha.

<img class="aligncenter size-full wp-image-49279" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/05/thumb-entao-voce-quer-ser-designer-web-parte-1-cores-livro-jardim-secreto.png" alt="E aí, ficou com uma vontade incontrolável de sair colorindo tudo?" width="800" height="471" />

**E aí, ficou com uma vontade incontrolável de sair colorindo tudo?**

Não esqueça de comentar quais ferramentas você usa e sugerir áreas para serem abordadas nos próximos posts.

Até o próximo artigo!

 [1]: https://paletton.com/