---
title: Efeito Parallax, o novo Flash?
authors: thiago-pacheco
type: post
date: 2013-09-12
excerpt: O efeito parallax tem sido a "modinha" do momento, mas alguns profissionais dizem que o efeito parallax prejudica no SEO do seu site, já outros dizem que isso não acontece e é exatamente isso que vamos explorar aqui com o objetivo de fornecer uma visão geral sobre o assunto.
url: /efeito-parallax-flash/
dsq_thread_id: 1733749210
categories:
  - Código
  - SEO
tags:
  - buscadores
  - google
  - parallax
  - SEO

---
## O que é Parallax?

O efeito paralaxe basicamente é uma abordagem de design do site que tem sido usado por vários anos e agora leva o seu nome a partir do conceito de [movimento paralaxe][1] é muito interessante quando bem utilizado e pode ser bastante explorado se você for criativo. Você pode ver um [artigo sobre como fazer um efeito parallax em apenas 3 passos aqui][2].

Um dos principais **benefícios do uso de projeto paralaxe** é que ele permite que o site conte uma história para o visitante apenas por rolagem, não necessariamente uma história do tipo joão e maria com final feliz, mas uma linha de raciocínio lógico para informar o usuário ou até mesmo induzi-lo a alguma ação final seja ela curtir, compartilhar ou comprar algo.

[<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/09/funciona-search-google.jpg" alt="Como funciona search Google" width="598" height="292" class="alignnone size-full wp-image-38870" style="padding:10px 0" srcset="uploads/2013/09/funciona-search-google.jpg 598w, uploads/2013/09/funciona-search-google-329x160.jpg 329w, uploads/2013/09/funciona-search-google-588x287.jpg 588w" sizes="(max-width: 598px) 100vw, 598px" />][3]
  
Uma boa demonstração desta técnica narrativa é encontrada em &#8220;[como funciona a busca][3]&#8220;, onde o Google explica em termos muito básicos como o motor de busca funciona.

Um outro ponto positivo é que as páginas ficam esteticamente mais interessantes, mais agradável para determinados tipos de público e provavelmente faz com que os usuários curtam ou compartilhem mais a página. Reforçando: eu disse **provavelmente**, isso depende muito do seu público.
  
Uma vez curtida ou compartilhada, gera engajamento social e isso ajuda no posicionamento do seu site, uma vez que [SEO e Social Media][4] estão cada vez mais próximos.

## Como o efeito parallax afeta o SEO?

Semelhante ao Flash e AJAX, o paralaxe apresenta um grande desafio para SEO o principal problema é o fato do conteúdo estar concentrado em uma única página tornando difícil otimizar o site para uma variedade de palavras chaves.

A grande sacada de um projeto SEO é justamente trabalhar o máximo de palavras chaves possível dentro do site, informações disponibilizadas do próprio Google mostra que a cada 5 buscas 1 é um termo novo jamais buscado.

### Analytics

Muitos sites utilizam como um indicador de performance o tempo do usuário dentro da página para uma página paralaxe não é uma métrica aconselhável, pois o usuário nunca trocaria de página então esse tempo certamente seria alto.
  
Um outro ponto a ser discutido é a análise do comportamento do usuário dentro da sua página, cruzando informações de um [heatmap][5] com o Analytics você pode ter dados valiosos do comportamento do usuário, quando você está em uma página parallax você acaba tendo um trabalho extra em fazer as configurações corretamento no Analytics.

### Mobile

Já parou para pensar que o comportamento do usuário está mudando, hoje estamos assistindo novela, jogo, filme e estamos com o celular ou tablet do lado conectado olhando o que está acontecendo nas mídias sociais.

#### Agora te pergunto paralaxe funciona em dispositivos móveis?

Nem precisa me responder, já fiz o teste utilizando a própria página do Google &#8220;[como funciona a busca][3]&#8220;, a equipe de desenvolvimento teve que criar uma segunda versão do site especificamente para dispositivos móveis.
  
O projeto que era uma página paralaxe ficou estática no mobile e foi separado em 3 páginas.
  
[<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/09/mobile-funciona-search-google.jpg" alt="mobile funciona search google" width="597" height="286" class="alignnone size-full wp-image-38877" srcset="uploads/2013/09/mobile-funciona-search-google.jpg 597w, uploads/2013/09/mobile-funciona-search-google-329x157.jpg 329w, uploads/2013/09/mobile-funciona-search-google-588x281.jpg 588w" sizes="(max-width: 597px) 100vw, 597px" />][6]

## Então a melhor opção é não utilizar Parallax?

Se no projeto que está participando o objetivo é obter visibilidade dos buscadores, então o ideal é evitar a página com efeito paralaxe, mas existem soluções criativas quando o assunto é SEO e Parallax veja um exemplo interessante: Uma abordagem seria combinar uma navegação &#8220;normal&#8221; (com links e páginas) e as principais páginas de entrada ter o efeito parallax, com essa abordagem você ajuda a garantir que cada página tenha a sua palavra chave explorada ao máximo.

#### Conclusão

O efeito paralaxe não é tão ruim, sim, é melhor que um site todo em Flash ou em Ajax, mas não é ideal se o objetivo do seu site é ter visibilidade através dos principais buscadores, mas como falado nesse post você pode ter bons resultados com a otimização do seu site já que SEO e Social estão cada vez mais pertos.

 [1]: https://pt.wikipedia.org/wiki/Paralaxe
 [2]: https://tableless.com.br/parallax-simples-com-jquery-e-css/ "Parallax simples com JQuery e CSS"
 [3]: https://www.google.com/intl/in/insidesearch/howsearchworks/thestory/
 [4]: https://www.doting.com.br/marketing-digital-seo-sorocaba
 [5]: https://en.wikipedia.org/wiki/Heat_map
 [6]: https://www.google.com/intl/en/insidesearch/howsearchworks/thestory/part-2.html