---
title: Duas dicas de como lidar com o Not Provided
authors: Douglas Faria
type: post
date: 2014-02-26
url: /duas-dicas-de-como-lidar-com-o-provided-comece-desbanca-lo/
dsq_thread_id: 2324385432
categories:
  - Artigos
  - SEO
tags:
  - analytics
  - google
  - not provided
  - SEO

---
Aprenda a lidar com esse cara chato na hora de analisar relatórios no Analytics.

Todo mundo que trabalha com SEO, ou pelo menos boa parte da galera, possui o Google Analytics instalado em seus projetos para fazer análise dos dados de acesso e comportamento do usuário. Dessa forma, podemos compreender como o usuário se comporta em nosso site e traçar estratégias melhores.

Provavelmente, você deve ter visto no relatório de palavras chave o famoso (e chato) _not provided._ Pois é pessoal, e é sobre ele que nós vamos falar hoje: **o que é o not provided** **e o que podemos fazer para lidar com ele.**

## O que é o not provided?

Tudo começou em 2011, quando o [Google anunciou][1] uma mudança nos resultados em páginas seguras (HTTPS), deixando de exibir a palavra-chave de origem de todos os usuários logados.

Logo após a polêmica das espionagens, aliado à uma imensa vontade do Google de entregar visitas por meio de Links Patrocinados, ainda em 2013 o Google converteu todas as páginas de resultados e de seus serviços para HTTPs.

Ou seja, agora tudo é retornado em cima de um ambiente seguro, o que faz o seu camarada _not provided_ aumentar a cada dia.

## Beleza, mas&#8230; Como lidar com o not provided?

Existem algumas coisas que você pode fazer para a vida ficar mais feliz! Eu costumo dizer que SEO exige muita criatividade. Não há tanta receita de bolo para tudo e o Google muda muito rápido para combater práticas de Black Hat. O que você deve fazer é unir o conhecimento às boas práticas conhecidas e criar algo legal!

Aqui passo a vocês duas formas simples de lidar com esse cara que eu uso na minha empresa de criação de sites e SEO, mas não se esqueçam, sejam criativos! Então vamos aprender como lidar com o not provided:

## Link o Google Webmaster Tools

O primeiro passo é linkar sua conta do GA (Google Analytics) com a conta no Google Webmasters Tools.

Com isso, você transformará dados vindos do Webmaster Tools em informação preciosa para sua campanha. Isso porque O Analytics irá pegar e tratar as informações e gerar as estatísticas referentes à elas.

Faça o seguinte:

### PASSO 1

No menu à esquerda, expanda Aquisição (Traffic Source), depois expanda otimização de mecanismos de pesquisa (Search engine optimization) e clique em Consultas (Queries).

[<img class="alignnone size-full wp-image-40936" alt="Como lidar com o not provided" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/02/linkar-gtw-no-ga.png" width="711" height="362" srcset="uploads/2014/02/linkar-gtw-no-ga.png 711w, uploads/2014/02/linkar-gtw-no-ga-329x168.png 329w, uploads/2014/02/linkar-gtw-no-ga-588x299.png 588w, uploads/2014/02/linkar-gtw-no-ga-608x310.png 608w" sizes="(max-width: 711px) 100vw, 711px" />][2]

### PASSO 2

Configure como achar melhor e clique em EDITAR, no final da página:

[<img class="alignnone size-full wp-image-40937" alt="configurando o google analytics" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/02/2.png" width="829" height="1200" srcset="uploads/2014/02/2.png 829w, uploads/2014/02/2-116x168.png 116w, uploads/2014/02/2-214x310.png 214w" sizes="(max-width: 829px) 100vw, 829px" />][3]

### PASSO 3

Após clicar em editar, uma nova janela do GTW será aberta e você deverá selecionar o site em questão:

[<img class="alignnone size-full wp-image-40938" alt="PASSO 3 Após clicar em editar, uma nova janela do GTW será aberta e você deverá selecionar o site em questão 2" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/02/3.png" width="1529" height="583" srcset="uploads/2014/02/3.png 1529w, uploads/2014/02/3-329x125.png 329w, uploads/2014/02/3-588x224.png 588w, uploads/2014/02/3-660x251.png 660w" sizes="(max-width: 1529px) 100vw, 1529px" />][4]

### PASSO 4

Clique em Salvar e, na próxima tela, Salvar novamente:

[<img class="alignnone size-full wp-image-40939" alt="not provide analytics" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/02/5.png" width="829" height="1200" srcset="uploads/2014/02/5.png 829w, uploads/2014/02/5-116x168.png 116w, uploads/2014/02/5-214x310.png 214w" sizes="(max-width: 829px) 100vw, 829px" />][5]

Feito isso, ao voltar no mesmo relatório, em Aquisição (Traffic Source > otimização de mecanismos de pesquisa (Search engine optimization) > Consultas, você verá uma lista de Keywords vindas diretamente do GTW.

Ficará mais ou menos assim:

[<img class="alignnone size-full wp-image-40940" alt="Not provided" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/02/6.png" width="319" height="452" srcset="uploads/2014/02/6.png 319w, uploads/2014/02/6-118x168.png 118w, uploads/2014/02/6-218x310.png 218w" sizes="(max-width: 319px) 100vw, 319px" />][6]

Prontinho! Agora você já tem dados essenciais e importantes para suas estratégias de SEO. Mas você achou que era só isso? Não!

Ainda conseguimos criar um outro relatório bacana que mostra as páginas de entrada (Landing Pages) que o usuário utiliza para acessar nosso site.

Vamos lá:

Em Aquisição > Palavras-chave > Organico, troque a dimensão primária para **Página de Destino** (se o seu estiver em Inglês, procure por Landing Pages).

[<img class="alignnone size-full wp-image-40941" alt="Landing pages para SEO" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/02/7.png" width="572" height="305" srcset="uploads/2014/02/7.png 572w, uploads/2014/02/7-315x168.png 315w" sizes="(max-width: 572px) 100vw, 572px" />][7]

Com esse novo relatório em mãos você pode pensar de algumas maneiras. Uma delas é que você tem controle da otimização OnPage das suas páginas e assim fica bacana criar uma relação assim:

Páginas acessadas x Keywords otimizadas nessas páginas x Keywords de entrada no site (do primeiro relatório).

Temos mais opções para **trabalhar com o not provided**, como a criação de filtros e relatórios avançados, mas isso ficará para o próximo post!

Material complementar:

<https://moz.com/blog/100-percent-keyword-not-provided-whiteboard-tuesday>

<https://moz.com/blog/what-is-seo-now>

Espero que ajude vocês, até logo!

 [1]: https://googleblog.blogspot.com.br/2011/10/making-search-more-secure.html
 [2]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/02/linkar-gtw-no-ga.png
 [3]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/02/2.png
 [4]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/02/3.png
 [5]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/02/5.png
 [6]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/02/6.png
 [7]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/02/7.png