---
title: 'Dev, você precisa saber inglês'
authors: Diego Eis
type: post
date: 2018-06-18
excerpt: 'Não caia na ladainha de que você não precisa disso'
image: https://i.imgur.com/KMGoRNo.jpg
sponsor: organizze
categories:
  - Carreira
tags:
  - Comportamento
  - Tecnologia e Tendências
---

O texto vai ser um pouco grande.
Tem ocorrido um papo tóxico nas redes sociais há alguns dias sobre a não produção de conteúdo em inglês. Onde o discurso é que se você vai produzir conteúdo, produza conteúdo em português, para que seu conteúdo possa ser inclusivo e então ser mais acessível por aqueles que não sabem inglês. 

---

## Sobre produzir conteúdo em inglês

Eu sempre produzi conteúdo em português, desde o começo da minha carreira. Fiz isso exatamente por um motivo: eu queria que pessoas perto de mim, que exerciam ou estavam começando a exercer a mesma profissão que eu, tivessem conteúdo em português para ler e estudar. O único objetivo era amadurecer a comunidade e consequentemente nosso mercado. Quando você produz conteúdo nacional sobre um determinado assunto, você acaba fortalecendo o mercado local, colocando nossos profissionais em lugar de destaque lá fora, não apenas como consumidores de conteúdo, mas também como criadores de conteúdo, formadores de opinião e etc... 

Quando você passa a fazer conteúdo em inglês, você se foca mais ainda nesse objetivo, exatamente por que um artigo escrito em inglês tem maior alcance no mundo. Você destaca um profissional brasileiro, no mercado mundial, favorecendo mais ainda o objetivo de amadurecer e mudar a forma com que profissionais de outros países enxergam o mercado brasileiro.

Acho que a preocupação de criar conteúdo primariamente em português para depois produzir em outro idioma é totalmente legítima, mas eu tenho um outro ponto de vista: em vez de motivar a galera escrever só conteúdo em português, por que não ajudar as pessoas a aprenderem inglês, de forma que eles aumentem suas skills e se tornem profissionais melhores? Eu acho que seria uma atitude mais inclusiva.

Não encontrar conteúdo em português no começo da minha carreira foi essencial para que eu melhorasse minhas skills. Eu sei que o aprendizado é diferente em cada um, acredite, eu sei muito bem disso. Para quem não é inteligente, meu esforço me fez ser quem sou hoje. 

E eu sei também que a exigência de saber inglês nas empresas é totalmente dispensável. Eu conto nos dedos de uma mão quantas vezes tive que falar em inglês no trabalho no meu tempo de desenvolvedor. Não acho que esse cenário mudou atualmente, de forma que os desenvolvedores precisam falar em inglês todos os dias no trabalho. Pelo contrário, eu vejo é desenvolvedores querendo fazer daily e outras cerimonias em inglês, só para melhorarem suas skills. Então, sou totalmente contra exigir que os desenvolvedores falem inglês se não for realmente necessário.

---

## A maioria do conteúdo está em inglês

O mundo está escrito em inglês. Você vai encontrar muito conteúdo em português e outros idiomas, mas a maioria do conteúdo que você, desenvolvedor, vai precisar consumir todos os dias para tirar dúvidas ou aprender algo novo, está em inglês.

Quando comecei o Tableless, conteúdo em pt-br era MUITO escasso. Você não conseguia aprender HTML/CSS/JS estudando apenas em fontes de conteúdo escritas em português. Existia um grupo de discussão de verdade (ArqHP), nenhum fórum de verdade, poucos blogs (eu conhecia de verdade basicamente o Tableless e o do Maujor). Minha saída? Trazer conteúdo em português sobre o assunto. 

Entenda que naquela época não existia conteúdo em português, e o assunto aqui no Brasil era uma piada, logo, foi uma boa ideia começar a produzir conteúdo em pt-br para popularizar o assunto no Brasil. Antes disso, eu me aprofundava em blogs e sites gringos, além da documentação do W3C.

Detalhe: antes do Tableless eu só sabia ler em inglês, muito por causa da escola e tal. E mesmo assim, era muito difícil ler documentações pesadas como as do W3C. Eu tinha que parar a cada minuto para pesquisar sobre uma palavra nova. Valeu a pena.

A restrição de conteúdo em português me fez aprender inglês. Seria egoísmo meu não falar pra você aprender inglês, dado que isso abre portas que você nem imagina.

## Escrever e ler inglês abre portas para você entrar em contato com devs de outros países

Eu me lembro a primeira vez que fiz um comentário no site do Jeffrey Zeldman, a primeira vez que mandei e-mail para o Håkon Wium Lie. Alguns e-mails não foram respondidos, outros foram, e isso foi incrível. 

Uma coisa que pode te atrapalhar é a preocupação em ter um inglês perfeito ao comunicar com pessoas que falam nativamente o idioma... Isso é uma bobeira das grandes. Pode perguntar para qualquer brasileiro que está morando fora e eles te darão mais ou menos essa resposta: a maioria dos gringos não se importam se você está falando certo ou errado.

Então, por favor, não termine seus emails em inglês ou seus chats com a frase: "Sorry for my english..."  

Quando você consegue escrever e ler, nem que seja o mínimo, o suficiente para se comunicar com a outra pessoa, você consegue abrir portas para falar com desenvolvedores do Netflix, Twitter, Facebook, Google, Microsoft e [coloque aqui sua empresa gringa predileta].


## Se você souber ler, escrever e falar, você tem a possibilidade de trabalhar fora do país

Há! Me fala: esse é o objetivo (ou sonho) de 9 em cada 10 desenvolvedores, não? Trabalhar fora do país, em uma empresa gringa, num país diferente... é pra poucos... 
NÃÃÃÃOOOO é pra poucos. É pra qualquer um que se esforçou para aprender inglês, que se quer se conectar com pessoas de fora do país, que aprimorou suas skills além do código e foi sem medo.

Eu tenho medo. Bastante. Medo de falar errado, medo de dizer coisas erradas, medo de se sentir avaliado, medo de mostrar que meu vocabulário em inglês é limitado... Esse medo vai existir sempre, mas só até você fazer o inglês ser parte do seu dia a dia.

Esse ano fiz duas entrevistas com dois CEOs gringos de empresas grandes. Eu quase morri de medo. Mas cheguei lá, e falei. E veja bem: perguntei para eles sobre meu inglês e eles disseram que ele era ótimo, melhor do que 90% das pessoas que eles conversam.
Um deles foi até engraçado, porque ele falava português. Uma hora de entrevista falando em inglês, pra no final, ele pedir a sobremesa em português. 

Obviamente você precisa ter uma boa comunicação para poder passar nas entrevista e ainda mais para conseguir lidar com seus colegas no dia a dia. Você não vai conseguir chegar nesse nível se não aprender inglês e só consumir conteúdo em português... e ficar acomodado... 

## Você começa a se sentir mais empoderado e portanto, mais confiante no seu trabalho

Consumir conteúdo em inglês, muitas vezes direto da fonte, te dá poder de argumentação, além de aprender que os problemas do seu dia a dia acontecem também com a galera de fora. Você consegue verificar como eles aprenderam e resolveram o mesmo problema que seu time está tentando resolver. Isso te dá mais confiança, pois é muito mais interessante você ter a opinião de várias fontes, do que apenas de uma.

## Produzir conteúdo em inglês expõe você à comunidade gringa

Eu comecei a escrever conteúdo em inglês ano passado. Foi a melhor coisa que eu já fiz. Meu conteúdo começou a impactar MUITO mais gente de outros países. Não só países que falam inglês... Mas pessoas de todos os cantos do mundo.

Eu recebi e mails, comentários, likes e tudo mais de pessoas que eu nunca pensei que leriam um conteúdo meu.

Veja meu [perfil no The Practical Dev](https://dev.to/diegoeis). Fiz a mesma coisa falando sobre Produtos Digitais, publicando artigos no [Product Coalition](https://productcoalition.com/3-things-that-a-product-manager-dont-have-to-do-64a9981298b1). Fiz mais artigos que estão espalhados por aí.

Assim como o Tableless, existem centenas de outros sites que aceitam autores convidados. Isso faz bem pra sua carreira, faz bem pra sua mente, faz bem para suas skills, e ainda por cima você consegue se preparar para uma futura carreira em uma empresa gringa.

## Você pode decidir até onde vai

Você precisa falar inglês? Depende.
Você precisa escrever em inglês? Depende.
Você precisa ler em inglês? Com toda certeza.

A empresa em que você trabalha é uma multinacional? O dono da empresa é um gringo que não fala português? Você trabalha em uma empresa que embora não seja multinacional, ela se propõe a falar inglês por algum motivo? Você precisa lidar com times de fora do país?  
  
Se todas as suas respostas foram *não*, então você não precisa falar em inglês. É uma balela sem tamanho dizer que as pessoas precisam falar inglês para executar o seu trabalho. Depende muito. 

Você quer se comunicar com pessoas de fora do Brasil para conversar sobre qualquer assunto? Você gosta de ler conteúdo gringo e quer comentar sobre? Você quer expressar sua opinião em sites gringos? Você quer produzir conteúdo em inglês?

Se todas as suas respostas foram *não*, então você não precisa escrever em inglês. Sinta-se à vontade em apenas consumir conteúdo. Quando você precisa escrever em inglês, existem uma série de ferramentas que vão te ajudar nisso: desde o Google Translate até o Grammarly.

Agora, ler é imprescindível. As documentações da linguagem que você programa estão em inglês. Os vídeos dos criadores e mantenedores da tecnologia que você usa todos os dias estão em inglês. Muitas vezes a solução que você precisa está no GitHub e foi desenvolvida por um Hindu, em inglês. Ler inglês é algo que não tem como você não saber. 

## É importante ter conteúdo acessível

Eu sei muito bem que é importante ter conteúdo em português. Isso amadurece nossa comunidade, além de ajudar as pessoas que estão iniciando agora na área. Então, é importante que quem produz conteúdo, produza-o em português. Mas também é importante que essa pessoa produza seu conteúdo em inglês também. Bom conteúdo deve ser compartilhado em todos os idiomas.

Pense em países que têm pouco conteúdo na sua língua nativa, onde a única saída é ter conteúdo em inglês. Essa pessoa pode aprender com um brasileiro que se dispôs a compartilhar seu conhecimento em inglês.

É engraçado pensar: mesmo que você esteja sendo uma boa pessoa tentando amplificar a necessidade de termos bons conteúdos em português para que o assunto da nossa área seja mais acessível e tal, você está sendo uma má pessoa por estar querendo que o conteúdo não tenha alcance para o mundo, onde poderia ajudar MUITO mais pessoas. 

Eu preferiria discutir como podemos fazer a comunidade de desenvolvimento brasileira aprender inglês do que promover a criação de conteúdo em português. Contudo, eu continuo produzindo conteúdo em português pois é sim importante ter conteúdo no seu idioma nativo. 


