---
title: 'Design responsivo: foco no ser humano'
authors: Reinaldo Ferraz
type: post
date: 2013-03-21
excerpt: Gostaria de fazer uma rápida analogia sobre o desenvolvimento do design responsivo de hoje com os softwares de vinte anos atrás.
url: /design-responsivo-foco-no-ser-humano/
dsq_thread_id: 1155144295
categories:
  - Design
  - Mobile
  - UX
tags:
  - 2013
  - CSS
  - responsive web design
  - rwd

---
Quando o computador tornou-se realmente pessoal, o desenvolvimento de softwares cresceu exponencialmente. Uma enorme demanda de aplicativos surgia para aquele produto enorme, com [monitor CRT][1] e velocidade de processamento muito menor do que o telefone celular que está no seu bolso. 

Esses aplicativos traziam novidades e surgiam para resolver problemas que ainda não tínhamos. Com o tempo, passamos a nos familiarizar com a interface desse dispositivo mas hoje, olhando para trás, é possível entender como naquela época desenvolvíamos um software pensando na máquina, e não na pessoa que faria o uso dela.

Com base nessa pequena introdução nostálgica, gostaria de fazer uma rápida analogia sobre o desenvolvimento do design responsivo de hoje com os softwares de vinte anos atrás.

Uma das grandes balelas era que podíamos fazer várias coisas ao mesmo tempo. Essa [reportagem do Fantástico de 1991][2] mostra bem como a indústria queria nos vender a produtividade a qualquer preço, mesmo sabendo que não fazemos duas coisas ao mesmo tempo (ou você já conseguiu escrever um texto e atualizar uma planilha sem dar um ALT/Command Tab?) ou então, quando fazemos (como assistir a dois vídeos na mesma tela) não aproveitamos totalmente seu potencial. 

Já na web de hoje em dia temos que nos preocupar ao carregar uma página com conteúdo desnecessário no dispositivo móvel. Não adianta querer que nosso usuário faça diversas coisas ao mesmo tempo pois vai tirar a atenção do que é realmente necessário. Se a pessoa navega por um dispositivo móvel procurando uma pizzaria, ela quer saber o endereço, ou telefone, cardápio ou preços. Uma animação em Flash não vai ter utilidade nesse momento (na verdade, nunca teve). Burocratizar o acesso no momento que o usuário mais precisa é algo que pode custar o retorno desse usuário à sua página.

> Na web de hoje em dia temos que nos preocupar ao carregar uma página com conteúdo desnecessário no dispositivo móvel

Você já deve ter lido artigos sobre as iconografias em softwares. O clássico nessa categoria é o ícone de salvar dos softwares mais antigos que era representado por um disquete. [Este artigo mostra que o disquete não é o único dos problemas que temos com iconografia.][3]

Agora olhe para o dispositivo no qual está lendo esse texto. Existe uma entrada de disquete nele? Possivelmente não e é a mesma situação quando publicamos um &#8220;clique aqui&#8221; nas nossas páginas. O termo clique veio do uso do mouse, que desapareceu dos dispositivos móveis (inclusive a seta/cursor que ficava na tela). Mesmo selecionando links e acionando dispositivos com o dedo, continuamos chamando essa ação de &#8220;clicar&#8221;. O problema é quando pensamos no &#8220;clicar&#8221;, &#8220;passar o mouse&#8221;, &#8220;selecionar&#8221; para criar aplicações que não nos permitem esse recurso. Hoje nosso contato com alguns dispositivo são as pontas dos dedos, mas sabemos que [isso é apenas uma questão de tempo][4].

E por falar em links, antigamente todos eles deveriam aparecer na primeira página do nosso site. De preferência sem barra de rolagem, claro. Hoje estamos cada vez mais eliminando conteúdo desnecessário das páginas principais e permitindo que o usuário consiga buscar e até mesclar informações que sejam relevantes, muito melhor do que deixá-lo procurando conteúdo na página principal. Veja por exemplo como era a [página principal do &#8220;Cadê?&#8221; em 2000][5] comparada com a interface do Google de hoje.

Todos os exemplos que citei foram para reforçar a teoria de desenvolvimento com foco no ser humano. Não sabemos quais os dispositivos que permitirão o acesso ao nosso site/aplicação no futuro. Qual foi a sua reação quando encontrou no seu analitics o primeiro usuário de tablet ou de videogame navegando na sua página? E como será a nossa reação quando encontrarmos um relógio ou uma máquina de lavar dentro das estatísticas?

> O foco do design responsivo deve ir muito além do dispositivo. Precisamos desenvolver pensando no ser humano.

Essas comparações podem parecer um pouco absurdas, mas mostram o quanto o software sempre esteve mais relacionado com a máquina do que com o usuário. Enquanto tratarmos o usuário como um operador de um sistema burocrático, teremos que escrever enormes documentações sobre como operar esse sistema, que deve ser mais intuitivo e menos complicado como eram há 20 anos atrás. E isso é o nosso dever. Transformar a experiência do usuário em nossas páginas o foco principal do desenvolvimento web.

 [1]: https://pt.wikipedia.org/wiki/Monitor_de_v%C3%ADdeo#CRT
 [2]: https://www.youtube.com/watch?feature=player_embedded&v=WIfKfzGBvYc
 [3]: https://www.hanselman.com/blog/TheFloppyDiskMeansSaveAnd14OtherOldPeopleIconsThatDontMakeSenseAnymore.aspx
 [4]: https://www.youtube.com/watch?v=6BTCoT8ajbI
 [5]: https://web.archive.org/web/20000620030315/https://www.cade.com.br/