---
title: Desenvolvimento ágil utilizando Scrum
authors: Dani Guerrato
paid: true
type: post
date: 2013-06-06
excerpt: Conheça a metodologia Scrum e aprenda a colocar as estratégias na prática para gerenciar qualquer tipo de projeto.
url: /desenvolvimento-agil-utilizando-scrum/
dsq_thread_id: 1358454513
categories:
  - Artigos
tags:
  - desenvolvimento agil
  - gerenciamento de projeto
  - scrum

---
No artigo de hoje vamos conhecer os eventos, papéis e artefatos do Scrum e como adapta-los para organizar o seu fluxo de trabalho do dia-a-dia.

## O que significa desenvolvimento ágil?

Desenvolvimento ágil é um conjunto de estratégias para gerenciamento de projetos incremental e com ciclos de desenvolvimentos rápido. As vantagens disto são: melhoria continua de um projeto, frequente resolução de problemas e aumento da produtividade. O conceito surgiu em em oposição ao método cascata, no qual o desenvolvimento é linear.

## O que é Scrum?

O Scrum é um framework para a resolução de problemas. Ou seja, um conjunto de diretrizes e ferramentas que podem auxilia-lo a gerir um projeto. A vantagem do Scrum em relação a outros métodos agéis é que ele é relativamente simples de implementar e extremamente útil em situações onde é difícil prever os problemas futuros. O método também é mais democrático já que as opiniões de todos são igualmente ouvidas e desta maneira fica muito mais fácil estimar prazos, definir funções e criar soluções.

A base do Scrum é o empirismo. Ou seja, a teoria de que só conhecemos algo de fato através da experiência. E isto é muito visível no nosso mundo de desenvolvimento web, por exemplo. Os clientes fatalmente vão pedir alterações no escopo inicial, bugs vão acontecer, imprevistos vão surgir e negar mudanças pode não ser o melhor caminho para entregar um produto final de qualidade para a sua equipe, os clientes e usuários. Mas é necessário um conjunto de regras para acomodar estas mudanças ou você pode cair em um ciclo de perda de tempo sistematico. O Scrum basicamente é um conjunto de estratégias que vão te ajudar a vencer este tipo de cenário, comum a todas as profissões. O conceito foi criado inicialmente para ser utillizado em empresas de fabricação de automóveis, mas por sua natureza interdisciplinar acabou sendo adaptado para diversas outras áreas. Existem pessoas utilizando metodologias inspiradas no Scrum para organizar empresas, planejar festas, e até para [lidar com problemas familiares][1].

O termo Scrum surgiu do rugby. No jogo a palavra scrum descreve a formação ordenada dos jogadores em determinados momentos da partida. A inspiração aqui vem da união que equipes esportivas necessitam para vencer o jogo.

<img class="alignnone size-full wp-image-37513" alt="scrum-rugby" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/05/scrum-rugby.jpg" width="660" height="400" srcset="uploads/2013/05/scrum-rugby.jpg 660w, uploads/2013/05/scrum-rugby-277x168.jpg 277w, uploads/2013/05/scrum-rugby-511x310.jpg 511w" sizes="(max-width: 660px) 100vw, 660px" />

## O que você precisa para colocar na prática

Se você pesquisar por &#8220;Scrum&#8221; vai encontrar diversas cursos, livros e ferramentas online gratuitas e pagas. Mas é importante ressaltar que você não precisa necessariamente pagar por qualquer serviço. Você pode utilizar planilhas de dados, documentos de texto, quadros de notas ou até &#8211; pasmem! &#8211; folhas de papel. Obviamente não sou contra e não estou desvalorizando qualquer curso / certificado / ferramenta / etc. É claro que qualquer iniciativa de buscar mais conhecimento é válida e estes recursos podem agilizar ainda mais o seu trabalho. Mas você não precisa ser um Mestre Certificado XYZ ou qualquer título pomposo para utilizar esta metodologia. Você só precisa sentar com a sua equipe e organizar as tarefas. E é isto que vai gerar resultados positivos no seu empreendimento.

Com isto em mente vamos conhecer um pouco sobre como o Scrum funciona!

## O Time Scrum

O Time Scrum é um conjunto multi-disciplinar de profissionais. Estes times devem ser autogeridos, ou seja, não existe hierarquia ou a figura de um líder. O time deve decidir, em conjunto a melhor forma de completar o seu trabalho ao invés de receber ordens externas de alguem que não faz parte da equipe e por isto não tem o conhecimento empirico para determinar prazos, por exemplo. A opinião de todos deve ser igualmente ouvida e respeitada. Mas existem alguns papéis fixos para auxiliar o bom andamento do trabalho.

### Product Owner

A responsabilidade do Product Owner, ou Dono do Produto, é garantir a qualidade do trabalho. Este cara representa a voz do cliente, do dono da empresa, dos investidores, enfim, de todas as pessoas externas a equipe&#8230; Ele é responsável por traduzir as histórias dos usuários em uma lista de tarefas concretas, expressar claramente quais são as funcionalidades a serem desenvolvidas e definir a prioridade de cada uma de uma forma objetiva.

### Scrum Master

O Scrum Master, ao contrário do que o título pode sugerir, não manda na equipe. Muito pelo contrário, o Scrum Master serve a equipe. A função dele é facilitar o bom andamentos dos jobs e garantir que todos tenham as ferramentas necessárias para cumprir suas tarefas. Tipicamente o Scrum Master é o cara que conhece melhor as regras do Scrum e portanto consegue organizar o jogo de maneira mais efetiva. Ele é uma mistura de professor, gerente e ombro amigo.

### Equipe de desenvolvimento

Um pequeno grupo de pessoas (os tradicionalistas sugerem de 4 a 9) com cargos diferentes que vai trabalhar junto para cumprir as metas estabelecidas. É a galera que vai por a mão na massa e entregar um produto &#8220;pronto&#8221; ao final do ciclo de desenvolvimento. No caso de desenvolvimento web teríamos designers, programadores, front-enders, profissionais de UX, etc. Não importa o seu cargo todos tem o mesmo título: desenvolvedor.

## Eventos

Quem nunca perdeu tempo em uma reunião longa e sem propósito? As vezes conversar demais (e fazer de menos) pode ser prejudicial para qualquer empresa. Pensando nisso todos os eventos Scrum são time-boxed, ou seja, tem uma duração fixa de tempo. Desta forma a comunicação é sempre mais clara, objetiva e ágil.

### Sprint

Se você puder lembrar apenas de um termo do Scrum lembre-se deste: Sprint. As pessoas comuns dividem o tempo em dias, meses, horas&#8230; Os adeptos do Scrum dividem o tempo em ciclos de desenvolvimento chamados Sprints. Basicamente uma Sprint é período de tempo que você determinou para cumprir uma determinada tarefa, uma corrida para atingir uma meta. A idéia é ter algo concreto e funcional no final da Sprint. Estes ciclos devem ser períodos de tempo curtos e fixos. Você estipula anteriormente a duração das Sprints (recomenda-se de uma semana a 1 mês). Uma sprint deve começar imediatamente após o termino de outra.

Durante a Sprint não é possível alterar os objetivos estabelecidos para aquele ciclo ou os profissionais integrantes da equipe. Isto é super importante para garantir a produtividade. Mas se os objetivos tornarem-se obsoletos o Product Owner pode simplesmente cancelar a Sprint.

Sprints são divididas em etapas menores: reunião de planejamento, reuniões diárias, o trabalho de desenvolvimento em si, revisão e retrospectiva.

### Reunião de Planejamento

Nesta reunião serão definidos todos os objetivos da Sprint. Nas regras oficiais, considerando um sprint de 1 mês, esta reunião tem a duração de 8 horas. Você pode adaptar isto proporcionalmente de acordo com o seu ciclo de Sprint. Se o seu Sprint é de 1 semana, por exemplo, esta reunião terá a duração máxima de 2 horas. Em cada metade da reunião duas perguntas devem ser respondidas:

&#8211; O que será entregue como resultado?
  
&#8211; Como o trabalho necessário para entregar o produto será realizado?

### Reunião Diária

A idéia da reunião diária, ou stand-up meeting, é juntar a equipe para um bate-papo de 15 minutos no máximo para revisar o andamento do projeto. Cada membro da equipe deve responder as seguintes perguntas:

&#8211; O que eu consegui completar ontem?
  
&#8211; O que farei hoje?
  
&#8211; Quais obstáculos estão impedindo o meu progresso?

A função do Scrum Master é moderar a dinâmica e tentar ao máximo solucionar os obstáculos apresentados para que a Sprint seja bem sucedida.

Ah, e se você está se perguntando o por que do nome é que a recomendação é que estas reuniões sejam realizadas com todos de pé (do inglês stand-up). Desta maneira a reunião não se prolonga por muito tempo e todos ficam mais focados. Na minha opinião pessoal isto é um pouco formal e austero demais. Se você está sentado, de pé ou de ponta-cabeça em marte não é tão relevante quanto responder as perguntas e o respeito ao limite de tempo&#8230; Muitas vezes pausar para tomar um café (sentado) pode tornar estas reuniões muito muito mais confortáveis, agradáveis e divertidas para todos.

### Revisão da Sprint

A idéia aqui, obviamente, é revisar todos os itens desenvolvidos e demonstrar o produto final. A duração desta reunião considerando um sprint de um mês é 4 horas.

### Retrospectiva da Sprint

A sprint acabou! Agora é hora de olhar para trás e repensar o que deu certo, o que deu errado e planejar o que pode ser melhorado no futuro.

## Artefatos

Vamos ser sinceros: artefato é só um nome mais estiloso para documento ou ferramenta. Mas eles ajudam a facilitar a sua vida&#8230;

### Product Backlog

O product backlog é uma compilação de tudo o que o seu cliente gostaria de realizar no projeto. Pense com uma grande wishlist com todos os recursos e funcionalidades que os usuários gostariam de ver presentes no trabalho final. Esta lista deve ser organizada pelo Product Owner de acordo com valor, risco, prioridade e necessidade. Por natureza o backlog é algo dinâmico e muda constantemente para incluir as novas solicitações dos clientes, usuários e do mercado em si. Desta forma os produtos são sempre aperfeiçoados em cada Sprint.

### Sprint Backlog

Certo, agora que já sabemos tudo o que precisa ser realizado, a equipe define as tarefas a serem desenvolvidas na próxima Sprint. Esta listinha é conhecida como &#8211; surpresa! &#8211; Sprint Backlog. O Sprint Backlog é necessariamente um afunilamento mais detalhado do Product Backlog.

### Incremento

É o produto que deve estar &#8220;pronto&#8221; após a Sprint. Pronto aqui é uma palavra relativa já que o incremento pode (e deve) ser aperfeiçoado em próximos Sprints. Cada equipe vai definir anteriormente o que pronto significa de acordo com o contexto. É importante, no entanto, que o incremento seja algo concreto e utilizável. Uma demo de software ou uma página que possa ser navegada pelo usuário, por exemplo.

### Burndown Chart

É um gráfico que tem a função de monitorar o desenvolvimento da equipe. Funciona da seguinte maneira: todos os dias você anota quantas tarefas do seu Sprint Backlog foram efetivamente cumpridas. Desta maneira você pode saber com antecedência a velocidade que sua equipe trabalha. Este gráfico facilita a previsão de prazos futuros e até mesmo deduzir se a deadline vai estourar. O Burndown Chart é criado tendo como base dois eixos: um vertical representando a quantidade de trabalho que existe a ser feito e um horizontal para o tempo. A linha diagonal mostrará a velocidade da equipe ao completar as tarefas. Você pode utilizar alguma ferramenta para gerar automaticamente este gráfico ou até mesmo montar um utilizando lápis e papel. De qualquer forma a Burndown Chart é uma ótima maneira de medir o nível de produtividade do seu projeto. Lembrando sempre que não dá pra adivinhar o futuro com precisão. A base do Scrum ainda é a experiência empírica.

<img class="alignnone size-full wp-image-37512" alt="burndown-chart" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/05/burndown-chart.jpg" width="660" height="400" srcset="uploads/2013/05/burndown-chart.jpg 660w, uploads/2013/05/burndown-chart-277x168.jpg 277w, uploads/2013/05/burndown-chart-511x310.jpg 511w" sizes="(max-width: 660px) 100vw, 660px" />

### Kanban Boards

Não é tradicionalmente parte do Scrum, mas é uma boa ferramenta de planejamento e funciona bem em conjunto com o framework. Basicamente é um quadro &#8211; ou um app, folha de papel, parede em branco, etc &#8211; com quatro lista de tarefas: &#8220;para fazer&#8221;, &#8220;em progresso&#8221;, &#8220;esperando verificação&#8221; e &#8220;feito&#8221;. Esta é uma ótima maneira de visualizar rapidamente o status de um projeto, independentemente do uso do Scrum.

## Um exemplo concreto

Artefatos, mestres, papéis. A primeira vista tudo isto pode parecer mais um jogo de RPG do que um framework de gerenciamento de projetos&#8230; Mas na verdade tudo é mais simples do que parece. Vou exemplificar com uma situação real.

<img class="alignnone size-full wp-image-37511" alt="scrum" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/05/scrum.jpg" width="660" height="400" srcset="uploads/2013/05/scrum.jpg 660w, uploads/2013/05/scrum-277x168.jpg 277w, uploads/2013/05/scrum-511x310.jpg 511w" sizes="(max-width: 660px) 100vw, 660px" />

A sua empresa tem um cliente X que quer lançar um novo site. Um gerente de projetos (Product Owner) faz um briefing e levanta todas as necessidades do site (Users Stories). Ele se reúne com os profissionais de design, front-end e back-end (Equipe de Desenvolvimento) para definir todas as tarefas necessárias para produzir o projeto (Reunião de planejamento) e formaliza isto em uma lista de tarefas (Product Backlog). Você (Scrum Master) fica encarregado de organizar as reuniões e garantir que todos entendam as tarefas. A equipe decide democraticamente que vai entregar a página inicial pronta (Objetivo) até o final da semana (Sprint). A equipe então divide o objetivo em tarefas menores (Sprint Backlog) como criar o layout, desenvolver o HTML e CSS, implantar um sistema de administração de conteúdo e testar tudo em diversos browsers. Cada um escolhe que tarefas gostaria de realizar, define um prazo de duração em horas para cada tarefa e diariamente vocês se reúnem por 15 minutos para acompanhar o andamento do projeto (Reunião Diária). Ao final da semana vocês apresentam o resultado (Revisão da Sprint) e refletem sobre dificuldades e quais melhorias podem ser feitas na próxima semana (Retrospectiva da Sprint). Mas mais importante de tudo vocês entregaram um produto parcial, porém funcional (Incremento) para o cliente. A partir do feedback de todos vocês decidem qual vai ser a tarefa a ser realizada na próxima semana. E assim o ciclo recomeça!

## Scrum But&#8230;

Algumas pessoas mais tradicionalistas consideram praticamente uma heresia modificar alguns conceitos do Scrum, prática esta que foi apelidada pejorativamente de &#8220;Scrum But&#8221; (no sentido de &#8220;Eu uso o Scrum, mas XYZ&#8230;&#8221;). Eu sou da filosofia que você deve adaptar o que for útil para você, sua equipe e seu ambiente de trabalho. Sem dogmas.

## Scrum solo?

O Scrum é uma ótima metodologia para equipes, mas se você é um desenvolvedor solitário ainda pode aproveitar boa parte dos conceitos de gerenciamento de projetos. Neste caso obviamente você cumpre todos os papéis ao mesmo tempo, mas, bem&#8230; se você é um freelancer já está acostumado com isto, certo? Reuniões Diárias também não acontecem da mesma maneira (a não ser que você curta falar sozinho), mas é interessante tirar 15 minutos do seu tempo para repensar o projeto, revisar as tarefas e verificar se você está de fato conseguindo concluir as metas no prazo estipulado e determinar os próximos caminhos. Os artefatos e processos continuam os mesmos. É necessário ter mais disciplina para organizar e documentar o projeto, afinal você é praticamente um exercito de um homem só. Mas trabalhar sozinho pode ter suas vantagens. No final do dia o lucro é só seu&#8230;

## É para você?

A proposta destas ferramentas é agilizar os processos de desenvolvimento de projetos, mas devemos tomar cuidado para que estas regras não engessem o fluxo de trabalho. Frameworks como o Scrum podem facilitar o desenvolvimento ou burocratizar processos. Tudo depende da forma que você coloca estas regrinhas na prática. É necessário possuir flexibilidade e visão critica para decidir o que funciona melhor para a sua equipe. Estes fundamentos foram criados tendo como base desenvolvimento de softwares, algo que costuma demandar bem mais tempo do que webdesign, por exemplo. Considerando uma empresa que possua múltiplos projetos simultaneos a coisa pode ficar ainda mais complicada.

Pode ser constrangedor explicar para um cliente por que ele não pode ter uma mudança simples como a correção de um erro de ortografia imediatamente só por que este requisito não estava no Backlog da Sprint (como bem demonstrado [nesta sátira][2]). Eu pessoalmente gosto de separar um tempinho para resolver pepinos que não estavam previstos no Sprint. Outras pessoas preferem o suporte psicológico de métodos fixos com etapas de tempo mais bem delineadas. De qualquer forma é fundamental determinar metas a longo e médio prazo com estimativas de tempo realísticas. E acompanhar de perto se estas metas estão sendo cumpridas e, caso a resposta seja não, verificar o que deve ser corrigido. Ainda assim é interessante conhecer frameworks agéis. Pequenas mudanças no fluxo de trabalho, como as propostas pelo Scrum, podem ter um impacto super positivo no seu dia-a-dia.

#### Saiba mais

[Scrum Guide][3]

 [1]: https://online.wsj.com/article/SB10001424127887323452204578288192043905634.html "Family Inc"
 [2]: https://youtu.be/Sygm9x9sBEo "Another perspective on SCRUM"
 [3]: https://www.scrum.org/Scrum-Guides "Scrum Guide"