---
title: Como criar e manter uma cultura de desenvolvimento no seu time
authors: Danilo Vitoriano
type: post
date: 2015-07-15
excerpt: 'Inspirado no FEMUG SP #23, atitudes para manter o desenvolvimento pessoal dentro da cultura de um time.'
url: /cultura-organizacional/
categories:
  - Artigos
  - Eventos e Workshops
  - Mercado
tags:
  - cultura organizacional
  - femug
  - femug-sp

---
Quando falamos em desenvolvimento na área de tecnologia, logo pensamos na tarefa de programar, desenvolver código, softwares ou produtos relacionados ao digital e informática. Mas o desenvolvimento que abordaremos neste artigo refere-se ao desenvolvimento do profissional em si, seja na carreira ou nas suas funções dentro da empresa em que trabalha.

A intenção aqui não é falar sobre ferramentas ou metodologias para desenvolvimento das tarefas da equipe, gerenciamento de projetos, ou como ser mais produtivo e evitar perda de tempo e trabalhos desnecessários, até porque, são inúmeras as opções existentes no mercado de tecnologia, aplicadas desde que a informática existe. Apenas para citar algumas destas metodologias, temos as _**tech-talks**_ (reuniões informais entre profissionais de tecnologia, com o objetivo de estimular a expansão do conhecimento através da discussão entre pessoas especializadas <sup><a href="https://ibaldo.com.br/blog/2012/02/28/techtalk/" target="_blank">1</a></sup>), reuniões diárias, semanais, quinzenais ou mensais, também conhecidas como _dailys_, _weeklys_, etc., parte de metodologias ágeis de desenvolvimento e programação extrema como **_[Scrum][1]_**, _**<a href="https://pt.wikipedia.org/wiki/Kanban" target="_blank">Kanban</a>**, ou ainda, **<a href="https://www.administradores.com.br/noticias/carreira/entenda-a-diferenca-entre-coaching-e-mentoring/53772/" target="_blank">coaching</a>**_<a href="https://www.administradores.com.br/noticias/carreira/entenda-a-diferenca-entre-coaching-e-mentoring/53772/" target="_blank"> e </a>_**<a href="https://www.administradores.com.br/noticias/carreira/entenda-a-diferenca-entre-coaching-e-mentoring/53772/" target="_blank">mentoring</a>**, **<a href="https://www.devmedia.com.br/implementando-pair-programming-em-sua-equipe/1694" target="_blank">pair programming</a>**, ou **<a href="https://dojoto.info/mas-afinal-de-contas-o-que-e-o-coding-dojo.html" target="_blank">Dojo</a>**._

Este artigo, inspirado nas discussões do **<a href="https://sp.femug.com/t/femug-23-ied-sao-paulo-pauta/468" target="_blank">FEMUG SP #23</a>**, realizado no Instituto Europeu de Design em Julho de 2015 em São Paulo, busca falar de desenvolvimento pessoal, ou melhor, o desenvolvimento dos profissionais dentro de uma empresa: eu, você, todos nós.

## Quais as estratégias para melhorar o desenvolvimento profissional e criar ambientes mais agradáveis?

Nenhuma empresa sobrevive sem clientes, ao mesmo tempo que nenhuma empresa sobrevive sem bons profissionais motivados e em busca de gerar novos negócios, de crescimento, carreira e satisfação. A mentalidade das empresas de sucesso é focar no ativo mais valioso que elas possuem: o próprio funcionário.

Durante o encontro do FEMUG que discutiu o tema deste artigo, <a href="https://dnl.pw/" target="_blank">Daniel Filho</a> trouxe uma dúvida:

> Embora seja mais comum discutirmos técnicas e ferramentas para entregarmos projetos em menos tempo e com mais qualidade, o que sua empresa faz para manter o desenvolvimento pessoal dos profissionais?

A verdade é que poucas pessoas conseguiram encontrar motivações reais quando o assunto é desenvolvimento pessoal dentro de um time. A grande maioria encontrava apenas motivos para produzir mais e gerenciar melhor as entregas, prazos e demandas. Mas algumas soluções simples foram apresentadas para nos ajudar a manter uma real cultura de desenvolvimento. Para as empresas ou líderes que investem no desenvolvimento de um time, e depois perdem o funcionário para outras empresas, não se preocupem: um bom profissional saberá reconhecer aqueles que o ajudaram nesta jornada, e você só tem a ganhar fazendo parte desta história. Eis algumas sugestões:

## &#8211; Conversas pessoais (_one to one_)

Líderes e gestores que mantêm conversas particulares frequentes com cada integrante do time, conseguem obter informações valiosas sobre o clima organizacional, resolvendo problemas pequenos antes que se tornem grandes, contaminando toda a equipe.

Acho interessante citar uma máxima que gosto muito: _uma maçã podre apodrece todo o cesto_. Uma conversa simples de _feedback_ pode sanar problemas como brincadeiras de mal gosto entre alguns integrantes do time, resolver desavenças pessoais, encontrar soluções mais eficazes para horários de entrada e saída, prazo de entrega das tarefas, novas ferramentas e tecnologias de desenvolvimento, enfim, a proposta é não perder o controle e acompanhar de perto tudo o que acontece na equipe. Porém, não adianta fazer isto apenas uma vez: a frequência é o segredo do sucesso desta prática. Resolver conflitos internos é uma grande arma para alcançar satisfação no trabalho.

Esta prática também pode ser realizada com conversas entre membros da mesma empresa ou equipe, isto é, horizontalmente, compartilhando o conhecimento e trocando informações importantes. Talvez o seu colega considere algo muito importante, mas você não saiba porque nunca tiveram a oportunidade de falar sobre isto.

## &#8211; Patrocínio de cursos

Esta prática demanda certo investimento financeiro, mas pode ser resolvida com boas parcerias entre escolas e instituições de ensino, cursos online, entre outras.

Permitir que os integrantes de um time escolham cursos interessantes a serem feitos para aprimoramento profissional e pessoal pode resultar em ganhos de performance e vantagem competitiva para a própria empresa, além de lapidar a prata da casa: o funcionário. Vale reforçar novamente que, não é preciso ter medo caso o profissional mude de emprego mesmo depois de ter recebido algum investimento em sua qualificação. O mundo dá voltas, e um dia vocês poderão trabalhar juntos novamente, serem parceiros, cliente um do outro, mas enquanto ele estiver dentro do seu time, o benefício é colhido ali mesmo, com um funcionário motivado e satisfeito.

## &#8211; Incentivo para participação em eventos

Participar de eventos e encontros reforça o _networking_, reduz a timidez, e nos mantém atualizado com profissionais que realizam trabalhos similares aos nossos.

Trocar experiências com realidades diferentes é um grande aprendizado para qualquer time e para o desenvolvimento pessoal de cada um. Incentivar funcionários para participar de eventos gera resultados para o time e para empresa, além de divulgar o nome da sua organização em meio a outros profissionais da área.

Isto também demanda investimento financeiro, mas saber escolher entre cursos de curta duração e até mesmo fora do horário de trabalho pode economizar no caixa da empresa e trazer retorno na qualidade do time.

## &#8211; Benefícios extras

Parcerias com academias de ginástica, patrocinar a quadra para jogar futebol quinzenalmente, liberar funcionários para trabalhar _home-office_ a fim de fugir do trânsito podem ser recompensadores em termos de desenvolvimento pessoal na cultura da equipe. Desconto para comprar livros, espaço agradável para quem traz comida de casa, oferecer lanches saudáveis, salas de descompressão, entre outros, são recursos simples de serem implantados, e apesar de parecerem atitudes pequenas, refletem em ambientes mais agradáveis e profissionais mais felizes.

O bem-estar do time nem sempre está relacionado a recompensas materiais ou altos salários. Mesmo que sua empresa não tenha departamento de recursos humanos, responsável por pensar nestas estratégias, parte de cada um de nós sugerir e melhorar o ambiente e o meio em que convivemos.

Se mesmo com estas sugestões seu time não conseguir manter uma cultura de desenvolvimento proativa, não desista: atitudes enraizadas não mudam do dia para a noite. É preciso paciência para manter uma cultura de desenvolvimento que produza efeitos notáveis, mas cada pequeno passo é importante. Comece, por exemplo, participando dos encontros do FEMUG no seu estado. Se não existe nenhum, chame a galera e organize o primeiro. E se você tem outras práticas e sugestões aplicadas no local onde trabalhe, deixe um comentário. A cultura de desenvolvimento de um time começa individualmente.

_A pauta do FEMUG SP #23, inspiração para este artigo, foi sugerida por <a href="https://rinaldi.io/" target="_blank">Rafael Rinaldi</a>, organizador do evento._

 [1]: https://tableless.com.br/desenvolvimento-agil-utilizando-scrum/