---
title: Como implementamos uma cultura DevOps unindo os times de infra e produto
authors: Jonas Salengue
type: post
image: https://i.imgur.com/cryp5ye.jpg
date: 2018-05-17
excerpt: Como unimos os times de infraestrutura e desenvolvimento para criar uma cultura DevOps na empresa. 				
categories:
- Agile e Gestão
- Mercado
- Opinião
---

Olá, sou o Jonas, um dos líderes responsáveis pelo time de produto da RedeHost, juntamente com o Murilo. Há cerca de um ano, aceitei o desafio de assumir a área de infraestrutura da empresa e, como primeiro grande desafio, estruturar e formar um novo time.

Iniciamos o time de infra com três pessoas, cada com foco em uma das três grandes áreas de produto: hospedagem de sites, e-mail e Cloud Server. Concluímos, na época, que seria interessante mantermos redundância entre as pessoas, visando maior agilidade, gestão do conhecimento e bem-estar de todos, afinal ninguém deve estar sobrecarregado e sem tempo para atender aos compromissos pessoais. Foram realocados e contratados novos colegas para compor esta estrutura atual.

O time de desenvolvimento, liderado pelo Murilo, conta atualmente com quatro desenvolvedores que são responsáveis por manter nosso painel e serviços funcionando, além de projetos de melhoria e desenvolvimento de novas features.

Ambos times são os principais responsáveis pela garantia do serviço e melhor experiência de usabilidade para nossos clientes, da manutenção do nosso datacenter até a interface que o cliente acessa é o resultado do trabalho dedicado e maduro destes profissionais.

Por que decidimos integrar os times?
------------------------------------

Se estes são os times responsáveis por manter toda esta estrutura em funcionamento, porque não os dissolver e formar um único time? Este é um pensamento que há tempos compartilhamos e que agora tivemos a oportunidade de colocar em prática.

Utilizamos no último ano uma ferramenta de gestão conhecida como OKRs (Objective and Key Results) disseminada por empresas como o Google e o Facebook, no qual os objetivos estratégicos da RedeHost são divididos em trimestres, garantindo a execução e correção mais eficientes e, consequentemente, o atingimento das nossas metas. Foi através dos resultados da última rodada de OKRs que evidenciamos a necessidade de integrar os times de desenvolvimento e infraestrutura.

Analisando os pontos de intersecção das entregas entre os times, percebemos que não obtivemos os melhores resultados, e em alguns casos até mesmo a não entrega de alguns itens. Este fato pode ser explicado pela “divisão” do trabalho entre as equipes de infraestrutura e desenvolvimento que, no final das contas, implicavam no foco restrito a cada área dificultando a integração entre as tarefas. Considerando principalmente essas inconsistências, decidimos apostar em uma nova estrutura.

A estrutura atual
-----------------

A unificação das áreas resultou no nosso novo time de produto que contempla skills de DEV e infra fomentadas por uma cultura DEVOPS.

O time de produto da RedeHost possui a seguinte estrutura:
- Liderança: Murilo (focado no desenvolvimento do negócio) e Jonas (focado no desenvolvimento das pessoas);
- Hospedagem: dois analistas de infra, sendo um Sênior;
- Email: dois analistas de infra, sendo um Sênior;
- Virtualização / Cloud: três analistas de infra, sendo um Sênior;
- Desenvolvimento: três pares com um Analista de Sistemas Sênior em cada par. 

O trabalho realizado em pares agrega valor no nível de negócio e na integração do time. As responsabilidades são melhor divididas, o processo de gestão do conhecimento se torna parte da rotina e movimentações internas são facilitadas pois sempre existirá uma pessoa que domina determinada área. Cada par possui autonomia para tomar suas próprias decisões, alinhadas com nossa cultura e valores.

A nova rodada de OKRs, já contempla o novo formato do time, em que dividimos os Key Results em pequenos projetos com um líder responsável por cada um. Com esta proposta, pretendemos empoderar as pessoas e segmentar em fatias menores as entregas objetivando obter maior agilidade.

O Murilo e eu também somos um par enquanto líderes. Nós utilizamos algumas ferramentas para garantir a comunicação, engajamento e crescimento dos integrantes do time, através de rituais semanais, mensais e trimestrais. Semanalmente nos reunimos com os responsáveis pelos projetos para fazer um sync da evolução das entregas. Mensalmente, realizamos conversas individuais (1:1) com cada membro do time para discutir questões relacionadas ao desenvolvimento pessoal e profissional. Finalmente, de três em três meses executamos uma adaptação do processo de Feedback 360° em que utilizamos uma dinâmica criada pelo fundador do conceito Management 3.0 (Jurgen Appelo) . 

Nesta dinâmica, cada pessoa do time tem a oportunidade de passar um feedback presencial sobre o trabalho de cada um dos seus colegas seguindo um roteiro de perguntas que contemplam soft e hard skills. Após esta dinâmica, os resultados são coletados e armazenados. Como encerramento do processo, cada pessoa recebe do CEO da RedeHost, o Guilherme Soll, um formulário para avaliação dos líderes do time de produto. Os resultados do processo de feedback somados aos objetivos individuais, possibilitam traçarmos estratégias para o desenvolvimento das pessoas.

O que esperamos daqui pra frente?
---------------------------------

Considerando o cenário e apoio do time para a realização das mudanças que fizemos, estamos super otimistas em relação ao ganho que a RedeHost terá enquanto empresa, tanto para os clientes quanto para as pessoas que compõem este time incrível.

A ideia é que cada vez mais se desenvolva e se dissemine a cultura DEVOPS, possibilitando agilidade, flexibilidade e engajamento entre as pessoas. Fica muito mais fácil resolver problemas do dia a dia e criar novos produtos quando colocamos colegas com diferentes skills e experiências para pensarem juntos. Queremos cada vez mais atingir a diversidade no time buscando aperfeiçoar o processo criativo e qualidade do nosso produto.

A aposta é grande e o resultado esperado é compartilhado por todos! Temos certeza que será um sucesso considerando a responsabilidade e sede por desafios que alimentam as pessoas aqui da RedeHost.
