---
title: CSS puro e simples (só que não).
authors: Thaiana Poplade
type: post
date: 2013-12-05
excerpt: |
  |
    Pré-processadores, frameworks, novas propriedades e valores, novidades e mais novidades todas acontecendo ao mesmo tempo e ainda vemos profissionais de front-end perdendo a noção do uso puro e simples de folhas de estilo e da aplicação dos padrões. Por que isso acontece?
url: /css-puro-e-simples-sqn/
dsq_thread_id: 2026959890
categories:
  - Artigos
  - CSS3
  - Geral
  - Mercado
  - Tecnologia e Tendências
tags:
  - CSS

---
### Você lembra quando falávamos muito em Web Standards?

Então, os padrões não acabaram e continuam existindo: usabilidade, acessibilidade, manutenção, modularidade, redundância mínima, independência de device, internacionalidade, extensão de projeto, leitura e transparência de syntax, eficiência, implementação, simplicidade, etc; são apenas algumas das “palavras-chave” que ainda definem os padrões discutidos pela W3C.

### E o que, efetivamente, desses padrões temos visto por aí?

Pouco? Mais ou menos? As vezes eu começo, mas aí não consigo continuar porque tenho que entregar para “amanhã” ou nunca pensei nisso porque eu nem sei como fazer&#8230;

É. Temos diversas respostas para isso e vamos admitir, aprender CSS e HTML em seu uso profissional não é fácil e não está ficando mais fácil, pelo contrário, a cada dia que passa, mais e mais novidades surgem para facilitar nosso trabalho e permitir criar coisas que antes fazíamos em linhas e linhas de códigos de programação e agora apenas com uma propriedade e um valor em CSS, a mágica já acontece.

### E por que ainda não posso ou não consigo usar o que é novo?

Se você já se perguntou isso e não encontrou a resposta, algo não está legal.
  
O valor das maravilhas que a cada dia são atribuídas como padrão, só será dado quando você conhecer e entender o que mudou e o que evoluiu.

Se você nunca soube como criar uma borda arredondada, com imagem ou com javascript, você nunca saberá valorizar o uso do _border-radius_. Se você nunca se incomodou com o quanto as tabelas são “duras” e complicadas para diagramação de um conteúdo, você nunca saberá o real valor do _tableless_. Se você nunca teve que produzir linhas e linhas de códigos CSS para projetos gigantescos que necessitavam de modularidade, mínima redundância e velocidade de produção, você não saberá dar valor ao uso de um pré-processador e de frameworks.

### Então, qual é problema? Onde está o erro?

O erro está na maneira como os profissionais desta área estão se delineando em meio à tantas informações. Se você não sabe o real uso das propriedades _display, float_ e _position_, por exemplo, como você quer usar o Sass? Se você ainda não sabe quais elementos são blocos por padrão ou o que significa a propriedade _inherit_, que tanto aparece lá na seu software editor de CSS, como você vai entender as novas propriedades CSS3?

### O que fazer então?

Leia, teste, releia e reteste, o velho e o novo. As documentações estão aí para isso.

Em quase todos os eventos que participei desta área, os profissionais que se apresentam, no geral, começam falando um pouco de história: como era e como está hoje. Por que? Porque é a melhor forma de você ilustrar as evoluções, valorizar e demonstrar como adquirir bom senso de quando embarcar no uso das novidades ou quando manter o CSS puro e simples, de verdade. Portanto, leia e conheça o que você esta desenvolvendo, porque você está desenvolvendo e como era desenvolvido antes. Tenho certeza que você terá muito mais conhecimento e segurança para aplicar o que há de novo e decifrar sem erro o que nos acompanha desde o início.

Vamos aos estudos.

Até a próxima. 😉

Materiais de referência:

<a href="https://www.w3.org/People/Bos/DesignGuide/toc.html" target="_blank">https://www.w3.org/People/Bos/DesignGuide/toc.html</a>

<a href="https://novatec.com.br/guias/css3/" target="_blank">https://novatec.com.br/guias/css3/</a>

<a href="https://www.w3schools.com/css/" target="_blank">https://www.w3schools.com/css/</a>

<a href="https://www.w3.org/Style/CSS/Overview.en.html" target="_blank">https://www.w3.org/Style/CSS/Overview.en.html</a>