---
title: Crie layouts simples. SEMPRE!
authors: cristianoweb
type: post
date: 2015-03-23
excerpt: Você pode querer fazer um layout simples, mas seu cliente pode não entender de comunicação. E aí, o que você faz?
url: /crie-layouts-simples-sempre/
categories:
  - Design
tags:
  - Análise SWOT
  - arquitetura de informacao
  - Conteúdo
  - interface
  - layout
  - Planejamento
  - Simples

---
> &#8220;Sempre que você tiver duas alternativas para explicar alguma coisa, a explicação mais simples é provavelmente a mais correta&#8221;.

Essa citação é a famosa teoria_ &#8216;Navalha de Occam_&#8216; de Guilherme Occam, um frade franciscano inglês, também teólogo, filósofo e lógico.

Podemos dizer que o conceito desse pensamento é irmão do título desse artigo. Quanto mais simples for a mensagem, maior a chance dela atingir as pessoas. A questão que eu trago aqui é que **o simples não é sinônimo de fácil** como muitos pensam.

### Quanto custa um site simples?

É muito comum chegar na minha caixa de e-mail pedidos de orçamentos genéricos com a recorrente pergunta: &#8220;_**Quanto custa um site simples?**_&#8221; Como se o fato de pedir algo &#8216;simples&#8217; estivesse diretamente ligado a &#8216;orçamento barato&#8217;! Já são quase 7 anos trabalhando como freelancer para perceber que isso é uma regra! Todos que usam essa frase querem desconto, não algo realmente simples porque querem passar uma mensagem simples para os usuários do seu site. Preço eu discuto num outro artigo, prometo. O que eu quero discutir aqui hoje **é o conceito do simples e como ele é poderoso na comunicação**.

### Antes do layout, o conteúdo

Como princípio básico, eu construo os meus layouts o mais simples possível para os usuários. Mas para chegar numa interface simples é preciso muito convencimento e poder de argumentação com os clientes. 100% dos que eu atendi nesses anos, jamais criou o seu próprio conteúdo de comunicação sem que eu brigasse pelo usuário!

<div id="attachment_47659" style="width: 791px" class="wp-caption aligncenter">
  <img class="wp-image-47659" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/03/crie-layouts-simples-sempre-001.jpg" alt="&quot;Don't be evil&quot; - Frase conceito do Google usada como norte em todos os projetos." width="781" height="368" srcset="uploads/2015/03/crie-layouts-simples-sempre-001.jpg 800w, uploads/2015/03/crie-layouts-simples-sempre-001-265x125.jpg 265w, uploads/2015/03/crie-layouts-simples-sempre-001-400x189.jpg 400w" sizes="(max-width: 781px) 100vw, 781px" />
  
  <p class="wp-caption-text">
    &#8220;Don&#8217;t be evil&#8221; &#8211; Frase conceito do Google usada como norte em todos os projetos.
  </p>
</div>

Claro, que eu sou um tipo de profissional que se posicionou no mercado para atender pequenas e médias empresas. Estruturas que não possuem departamento de comunicação. Normalmente eu falo diretamente com o dono da empresa e é aí que mora o problema, porque a maioria das vezes ele não tem capacidade para gerar essa comunicação e pior, ainda acha a contratação de um profissional de planejamento e criação de conteúdo, caro e desnecessário, uma vez que ninguém melhor do que ele entende do próprio negócio.

Por mais que eu concorde com esse último argumento, isso não significa que ele sabe como se comunicar com o seu consumidor para falar sobre a sua empresa, marca, serviço ou produto. E sem a comunicação adequada, não há arquitetura de informação bem feita e consequentemente o &#8216;site simples&#8217; contratado lá atrás no formulário, vira algo &#8216;simplista&#8217;, inadequado, capenga!

### Antes de rabiscar o layout, é preciso muita pesquisa e planejamento

A prova disso é que se você pedir para um empresário responder junto com ele uma simples matriz de <a title="Análise SWOT | Esse link abre numa nova janela" href="https://pt.wikipedia.org/wiki/An%C3%A1lise_SWOT" target="_blank">Análise SWOT</a> sobre a sua empresa, ele será incapaz de responder de forma equilibrada a maioria dos tópicos. Ora vai superestimar alguns pontos, como subestimar outros. O resultado dessa estratégia é criar uma interface que efetivamente não comunica, não atrai, e não interage com o consumidor/usuário.

<img class="aligncenter wp-image-47658" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/03/crie-layouts-simples-sempre-002.jpg" alt="crie-layouts-simples-sempre-002" width="350" height="328" srcset="uploads/2015/03/crie-layouts-simples-sempre-002.jpg 800w, uploads/2015/03/crie-layouts-simples-sempre-002-148x139.jpg 148w, uploads/2015/03/crie-layouts-simples-sempre-002-400x375.jpg 400w" sizes="(max-width: 350px) 100vw, 350px" />

Aliás, interagir é um verbo que dificilmente os pequenos e médios empresários gostam de conjugar. O foco mesmo é a concorrência em todas as análises e tomadas de decisões. Para quase todas as perguntas a resposta é sempre a mesma. &#8220;_**Deixa eu ver como o meu concorrente está fazendo no site dele.**_&#8221; E assim, adeus diferencial.

### Mas e o conceito do simples?

<div id="attachment_47660" style="width: 800px" class="wp-caption aligncenter">
  <img class="wp-image-47660" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/03/crie-layouts-simples-sempre-003.jpg" alt="&quot;Design é função, não forma&quot; (Steve Jobs)" width="790" height="411" srcset="uploads/2015/03/crie-layouts-simples-sempre-003.jpg 800w, uploads/2015/03/crie-layouts-simples-sempre-003-265x139.jpg 265w, uploads/2015/03/crie-layouts-simples-sempre-003-400x208.jpg 400w" sizes="(max-width: 790px) 100vw, 790px" />
  
  <p class="wp-caption-text">
    &#8220;Design é função, não forma&#8221; (Steve Jobs)
  </p>
</div>

Bom, segundo Steve Jobs, &#8220;_**Design é função, não forma**_&#8220;. Ou seja, se um site não possui uma utilidade, deixa de ser necessário, e óbvio que o layout será inútil para o usuário. Cabe ao empresário pensar antes de contratar um profissional, e fazer as seguintes perguntas para sim mesmo:

  * Porque a minha empresa precisa de um site?
  * Como eu posso melhorar a relação dos nossos consumidores com a minha empresa?
  * Quanto eu estou disposto a ouvir e interagir com os nossos consumidores?
  * Como eu posso agregar mais valor dos meus serviços/produtos?
  * Entre outras tantas!&#8230;

Baseado nas respostas desse empresário, certamente ele terá um perfil desse projeto bem mais adequado à realidade. E de posse do conceito desse projeto, de preferência documentado, ele terá condições de selecionar o tipo de profissional que tem condições técnicas de atendê-lo, e tenho certeza, **que só assim, o design simples será criado, pois será focado no usuário e não no preço.**

Caso contrário, será apenas mais um site inútil na web e teremos um empresário que vai continuar achando que a Internet não serve para o seu negócio.