---
title: Criando mockups usando o Smarts Object no Photoshop
authors: Flavio Santana
type: post
date: 2013-07-29
excerpt: Criando mockups simples no Photoshop.
url: /criando-mockups-usando-o-smarts-object-no-photoshop/
dsq_thread_id: 1544065192
categories:
  - Design
  - O Básico
tags:
  - 2013
  - mockup
  - photoshop

---
Quando estamos criando alguma interface de usuário, seja para um site ou um aplicativo, sentimos a necessidade de nos preocupar como vamos apresentá-los ao cliente. Vejo em muitos sites como o Pixeden.com diferentes tipos de recursos visuais para apresentar sua ideia o mais perto da realidade ou como se comportaria nos dispositivos que se destina esses projetos. 

Eu vou mostrar como podemos criar o seu próprio **mockup** para apresentações usando o **Smart Object** e a ferramenta de perspectiva no Photoshop.

**Escolhendo a imagem**

Eu escolhi uma imagem aleatória na web de um smartphone e manipulei para retirar imagem que tem na tela dele, você pode usar essa imagem se quiser [neste link][1] ou uma outra de sua escolha.

[<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/07/mobile-mockup.jpg" alt="mobile-mockup" width="728" height="504" class="alignnone size-full wp-image-38321" srcset="uploads/2013/07/mobile-mockup.jpg 728w, uploads/2013/07/mobile-mockup-242x168.jpg 242w, uploads/2013/07/mobile-mockup-447x310.jpg 447w" sizes="(max-width: 728px) 100vw, 728px" />][2]

**Criando o Smart Object**

Com a imagem selecionada, vamos criar o Smart Object que será o nosso arquivo que iremos aplicar as imagens. Eu vou criar um retângulo de 270x490px usando a ferramenta Shape ou (U) na tecla de atalho em um tamanho similar ao da tela do smartphone. 

Quando se cria formas com a ferramenta Shape, ele já vêm como vetor, então o tamanho do retângulo não precisa ser exatamente igual, pois depois iremos redimensionar com a ferramenta de perspectiva.

[<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/07/mockup1.png" alt="mockup1" width="800" height="600" class="alignnone size-full wp-image-38322" srcset="uploads/2013/07/mockup1.png 800w, uploads/2013/07/mockup1-224x168.png 224w, uploads/2013/07/mockup1-413x310.png 413w" sizes="(max-width: 800px) 100vw, 800px" />][3]

Com o retângulo selecionado Agora vai em **Layer > Smart Objects > Convert to Smart Object** e converta-o em um Smart Object:

[<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/07/mockup2.png" alt="mockup2" width="800" height="600" class="alignnone size-full wp-image-38323" srcset="uploads/2013/07/mockup2.png 800w, uploads/2013/07/mockup2-224x168.png 224w, uploads/2013/07/mockup2-413x310.png 413w" sizes="(max-width: 800px) 100vw, 800px" />][4]

A miniatura muda quando transformamos em um Smart Object:

[<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/07/mockup3.png" alt="mockup3" width="800" height="600" class="alignnone size-full wp-image-38324" srcset="uploads/2013/07/mockup3.png 800w, uploads/2013/07/mockup3-224x168.png 224w, uploads/2013/07/mockup3-413x310.png 413w" sizes="(max-width: 800px) 100vw, 800px" />][5]

**Aplicando a Perspectiva**

Feito isso podemos prosseguir. **Vá em Edit > Transform > Perspective** e o retângulo irá ficar com a seleção da perspectiva.

[<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/07/mockup4.png" alt="mockup4" width="800" height="600" class="alignnone size-full wp-image-38325" srcset="uploads/2013/07/mockup4.png 800w, uploads/2013/07/mockup4-224x168.png 224w, uploads/2013/07/mockup4-413x310.png 413w" sizes="(max-width: 800px) 100vw, 800px" />][6]

Vamos adaptar o retângulo sobre a tela segurando o ctrl e clicando nos pontos pretos nas extremidades do retângulo. Comecei pelo lado esquerdo adaptando o restante do retângulo.Temos esse resultado:

[<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/07/mockup5.png" alt="mockup5" width="800" height="600" class="alignnone size-full wp-image-38326" srcset="uploads/2013/07/mockup5.png 800w, uploads/2013/07/mockup5-224x168.png 224w, uploads/2013/07/mockup5-413x310.png 413w" sizes="(max-width: 800px) 100vw, 800px" />][7]

A cor azul ou seja qualquer cor que seja esteja em primeiro plano, não interfere no visual, pois será aplicado a interface em cima dela. 

**Utilizando o Smart Object**

Clique duas vezes na layer que está como Smart Object e ele irá abrir em formato editável com a extensão **.psb.** É neste arquivo que aplicaremos a nossa interface.

[<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/07/mockup6.png" alt="mockup6" width="800" height="600" class="alignnone size-full wp-image-38327" srcset="uploads/2013/07/mockup6.png 800w, uploads/2013/07/mockup6-224x168.png 224w, uploads/2013/07/mockup6-413x310.png 413w" sizes="(max-width: 800px) 100vw, 800px" />][8]

Eu utilizei um shot que fiz para o **Dribbble.com** de uma interface para o iPhone, mas eu vou utilizar a mesma ideia para este exemplo.

[<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/07/mockup7.png" alt="mockup7" width="800" height="600" class="alignnone size-full wp-image-38328" srcset="uploads/2013/07/mockup7.png 800w, uploads/2013/07/mockup7-224x168.png 224w, uploads/2013/07/mockup7-413x310.png 413w" sizes="(max-width: 800px) 100vw, 800px" />][9]

Salve este documento **ctrl+s** e automaticamente ele irá atualizar no arquivo de origem, onde trabalhamos com o Smart Object. Note que a miniatura assume a forma do arquivo que aplicamos.

[<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/07/mockup8.png" alt="mockup8" width="800" height="600" class="alignnone size-full wp-image-38329" srcset="uploads/2013/07/mockup8.png 800w, uploads/2013/07/mockup8-224x168.png 224w, uploads/2013/07/mockup8-413x310.png 413w" sizes="(max-width: 800px) 100vw, 800px" />][10]

**Resultado final**

Eu apliquei um efeito de glass para melhorar o visual, e ficou assim.

[<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/07/mockup9.png" alt="mockup9" width="728" height="734" class="alignnone size-full wp-image-38330" srcset="uploads/2013/07/mockup9.png 728w, uploads/2013/07/mockup9-166x168.png 166w, uploads/2013/07/mockup9-307x310.png 307w" sizes="(max-width: 728px) 100vw, 728px" />][11]

Esta é uma forma de como podemos aplicar e criar diversas formas de mockups para exibirmos nossos trabalhos e essa técnica pode ser utilizado para diversos tipos de aplicações em diferentes propostas. Existem diversos artigos na web que contém pacotes para download gratuitos ou você pode criar o seu pacote de acordo com a necessidade. Aqui tem o link para baixar esse mockup **https://bit.ly/1c1p0go**. Gostou? Comenta ai 🙂

 [1]: https://bit.ly/1c1p0go
 [2]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/07/mobile-mockup.jpg
 [3]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/07/mockup1.png
 [4]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/07/mockup2.png
 [5]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/07/mockup3.png
 [6]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/07/mockup4.png
 [7]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/07/mockup5.png
 [8]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/07/mockup6.png
 [9]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/07/mockup7.png
 [10]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/07/mockup8.png
 [11]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/07/mockup9.png