---
title: 'Construa um Serviço e não um Produto Digital'
authors: Diego Eis
type: post
date: 2019-04-22
publishDate: 2019-04-22
image: https://i.imgur.com/u0eXVGT.jpg
excerpt: 'Serviços em vez de produtos'
categories:
  - Opinião
  - Produtos Digitais
tags:
  - Produtos Digitais
  - Gestão
---

## Serviços digitais em vez de Produtos Digitais

Quando falamos sobre Produtos, diretamente pensamos em algo físico, palpável, que você consegue usar e manipular com as suas mãos. Num mundo digital, isso complica um pouco, porque um Produto não necessariamente existe no mundo físico, ele é digital. Você pode até usar algo físico (celular) para usar algo digital (software). A partir daí temos o termo Produtos Digitais para tentar tangibilizar algo que tecnicamente não existe no mundo físico. Então, o termo Produtos Digitais serve mais como uma analogia para algo do mundo real… como acontece com quase tudo no mundo da tecnologia. Copiar, colar, recortar, pastas, janelas, etc… tudo não passa de uma analogia do mundo real para conseguirmos tangibilizar algo do mundo digital.

Mas a grande sacada é que o termo Produtos Digitais fez o seu trabalho. Na verdade, ele fez pela metade. se você chegar para os clientes do Spotify, eles vão conhecer o Spotify como um app. Eles vão dizer que são usuários de um serviço de streaming de música e não “eu uso o produto digital do Spotify pelo celular pra ouvir música”. Muito por que os meios de comunicação usam mais termos como serviço e streaming do que Produtos Digitais. Outro ponto é que o termo Produtos Digitais remete a uma coisa que é o produto da empresa. A gente aprisiona o uso a um produto e isso não é verdade. Nos usamos um serviço que não está preso ao celular, mas que pode ser acessado e usado por vários canais. Logo, você faz uso do serviço por meio do produto.

Esse não é um conceito novo, pelo contrário, é algo bem antigo. Se você já leu sobre Service Dominant Logic já deve ter se deparado com isso.

![](https://cdn-images-1.medium.com/max/800/1*l-Q6wScq2gjvGJrZdHm_0A@2x.jpeg)

A Apple deixou isso mais evidente agora, se posicionando como uma empresa de Serviços e não mais como uma empresa de hardware que junta software. O produto (físico ou digital) é apenas um meio de execução e entrega do serviço.

> Não é mais um app, não mais uma interface web, mas sim a construção de um > ecossistema, que entrega valor para as pessoas, para a empresa e também para a rede/ecossistema que se formou.

Um Product Manager deveria se chamar Service Manager. Veja como a visão fica mais ampla e mais complexa desse especialista. Ele não fixa apenas num app ou em uma versão desktop do produto digital, mas na cadeia de valor que o serviço entrega para o usuário. As vezes, o serviço nem será entregue por meio de software. Não é mais um app, não mais uma interface web, mas sim a construção de um ecossistema, que entrega valor para as pessoas, para a empresa e também para a rede/ecossistema que se formou.

O mercado de Produtos Digitais está muito mal acostumado achando que um Produto Digital é um App. Parece que um produto digital só é um produto digital se houver um App nas lojas de apps. Quantas pessoas não chegaram para você e soltaram um: “Cara, tenho uma ideia de produto, que o usuário baixa um app e …”

O pedaço de hardware ou de software faz parte de um conceito maior que se chama serviço. Do mesmo jeito que o Marketing saiu da ideia antiga de que os valores se encontravam nos Bens de Consumo e depois entenderam que na verdade o valor está no Serviço prestado e também na rede que se forma para entregar esse Serviço, o mercado de software (ou de produtos digitais) precisa passar pelo menos processo de adaptação e amadurecimento de um modelo de negócio baseado em serviço e não mais de produto ou peça de software.

### Mais sobre o assunto:

* [Onde está o valor nos produtos digitais?](https://medium.com/gestao-produtos/onde-esta-o-valor-dos-produtos-digitais-service-dominant-logic-10abe0c08a17) 
* [Você conhece Service Dominant Logic?](https://medium.com/gestao-produtos/um-estudo-sobre-service-dominant-logic-ou-s-d-logic-4894c3da621f)

