+++
authors = "Udacity Brasil"
canonical = "https://br.udacity.com/blog/post/4-programadoras-que-fizeram-historia"
categories = ["mercado"]
date = "2018-08-21T09:00:00-03:00"
excerpt = "Para comemorar o Dia Internacional da Mulher, o Fórum Econômico Mundial destacou mulheres que fizeram história, na tecnologia e no mundo."
image = "https://i.imgur.com/2tQbKQq.png"
publishdate = "2018-08-21T09:00:00-03:00"
tags = ["diversidade"]
title = "Conheça 4 programadoras que fizeram história"
type = "post"

+++
Para comemorar o Dia Internacional da Mulher, o [Fórum Econômico Mundial](https://www.weforum.org/agenda/2016/07/5-female-coders-who-changed-the-world/) destacou mulheres que fizeram história, na tecnologia e no mundo.

Algumas delas já são ícones culturais, como Grace Hopper, enquanto outras ganharam popularidade recentetemente, com adaptações cinematográficas como "O Jogo da Imitação" ou livros como "Os Inovadores", de Walter Isaacson, que traça a história da [atual revolução tecnológica](https://br.udacity.com/blog/post/entenda-a-revolucao-tecnologica).

## Ada Lovelace

![](https://d20vrrgs8k4bvw.cloudfront.net/images/blog/pt-BR/4-mulheres-programacao-ada.jpg)

Filha do poeta britânico Lord Byron, Ada Lovelace cresceu famosa na Inglaterra vitoriana. Sua própria contribuição para o mundo foi em outra área: a matemática.

Lovelace trabalhou nas máquinas calculadoras de Charles Babbage, um dos pioneiros da computação programável digital, que a chamava de "encantadora dos números".

Ela é considerada a fundadora da ciência da computação, assim como a primeira programadora do mundo.

Lovelace foi visionária também ao entender conceitos de programação que seriam provados muito depois, como a capacidade que máquinas têm para manipular símbolos e "não apenas números", e por criar o primeiro algoritmo feito para ser processado por máquinas.

**Leia:** [**Por que todo profissional deve aprender programação?**](https://br.udacity.com/blog/post/profissional-deve-aprender-programacao)

## Margaret Hamilton

![](https://d20vrrgs8k4bvw.cloudfront.net/images/blog/pt-BR/4-mulheres-programacao-margaret.jpg)

"Quando eu comecei, ninguém sabia o que nós estávamos fazendo. Era como o Velho Oeste. Não havia cursos. Ninguém nos ensinou", lembra Margaret Hamilton, que em 2016 foi condecorada com a Medalha Presidencial da Liberdade, a mais alta honraria civil americana.

Não é para menos. Hamilton foi diretora de engenheria de software do projeto responsável pelo código do Apollo Guide Computer, que guiou o voo da missão Apollo 11 e levou os primeiros homens à lua.

O projeto em si foi desenvolvido dentro do MIT Instrumentation Laboratory e começou do zero. O resultado foi o código para o primeiro computador portátil de história.

O peso da responsabilidade era grande. "Eu sempre imaginava as manchetes dos jornais \[em caso de acidente\], que apontariam para o que aconteceu e isso apontaria para mim."

Ainda na ativa, Hamilton ajudou a criar o campo de engenharia de software, publicou mais de 130 papers e relatórios e tornou-se fundadora e CEO da própria empresa, a Hamilton Technologies.

**Leia:** [**Saiba como se tornar um programador em 8 passos**](https://br.udacity.com/blog/post/como-se-tornar-programador)

## Grace Hopper

![](https://d20vrrgs8k4bvw.cloudfront.net/images/blog/pt-BR/4-mulheres-programacao-grace.jpg)

Uma figura muito querida da indústria, a almirante Grace Murray Hopper desenvolveu linguagens de programação acessíveis, que usavam palavras e não números para funcionar.

"O que eu buscava ao começar \[a programar\] em inglês era trazer todo um novo grupo de pessoas para usar o computador facilmente", [explicou](https://news.yale.edu/2017/02/10/grace-murray-hopper-1906-1992-legacy-innovation-and-service).

Ela intuiu – corretamente – que, para ampliar o impacto dessa tecnologia, era preciso criar linguagens mais simples. Seus trabalhos levaram ao primeiro compilador para computadores à primeira linguagem que usava palavras e não números como comandos.

Uma das primeiras linguagens deste tipo, a COBOL (Common Business Orientated Language), foi popularizada por Hopper.

Hopper também foi a responsável por associar as palavras "bug" e "debug" a problemas de computadores depois de encontrar uma mariposa em uma máquina.

Nos anos 1980, em uma entrevista ao programa de televisão americano "60 Minutes", ela falou sobre a dificuldade de aceitação que computadores enfrentaram no começo de sua carreira.

É um comentário que faz sentido ainda nos dias de hoje, quando o mundo se prepara para uma série de [novas mudanças tecnológicas](https://br.udacity.com/blog/post/entenda-a-revolucao-tecnologica) que terão efeitos sociais, econômicos e políticos.

"As pessoas tinham medo de computadores, assim como eu me lembro que havia pessoas que morriam de medo de telefones e não chegavam nem perto deles", [disse](https://br.udacity.com/blog/post/entenda-a-revolucao-tecnologica). "Havia pessoas que achavam que luz de gás era segura, mas luz elétrica não. Sempre passamos por isso com todas as mudanças."

## Joan Clarke

![](https://d20vrrgs8k4bvw.cloudfront.net/images/blog/pt-BR/4-mulheres-programacao-joan.jpg)

Colega e amiga próxima de Alan Turing, um dos maiores gênios da história da computação, Joan Clarke trabalhou com ele no departamento britânico responsável por quebrar códigos na Segunda Guerra Mundial.

Formada em matemática, ela fez parte da equipe que construiu alguns dos primeiros computadores do mundo, que tinham como objetivo desvendar as mensagens criptografadas pela famosa máquina Enigma, pertencente aos alemães.

Em 1939, Turing e sua equipe criaram uma máquina capaz de classificar milhares de combinações de letras rapidamente, o que permitiu que diversos códigos fossem revelados – e há quem estime que a guerra durou dois anos a menos graças a essa conquista.

A ideia de uma mulher criptoanalista era tão impensável na época que Clarke precisou ser contratada como linguista, já que não havia um processo para contratá-la de outra maneira, mesmo sem nenhum conhecimento sobre a profissão. Em um formulário da época, ela se divertiu ao preencher: "Profissão: linguista. Idiomas: nenhum".

Em 1944, tornou-se vice-chefe da Hut 8, onde ficava a equipe de Turing durante a guerra. Três anos depois, ganhou honrarias do governo britânico e se tornou Membro da Ordem do Império Britânico.