---
title: A comoditização do desenvolvimento web
authors: Diego Eis
type: post
date: 2017-09-11
excerpt: Tem uma faixa de serviços e soluções no mercado de web que viraram comodites.
categories:
  - Mercado
  - Opinião
  - Artigos
  - HTML
tags:
  - Mercado
  - Artigos
  - Opinião
  - HTML
image: https://i.imgur.com/826KY6u.jpg
---

Comodites são produtos cujo a qualidade ou características são parecidas ou iguais, e por isso a escolha não se baseia pela pelas características do produto, mas pelo preço e necessidade da pessoa/empresa. A Wikipedia dá um [exemplo bem legal](https://pt.wikipedia.org/wiki/Commodity): ela compara o cobre com um sistema de som. Veja que o cobre é igual aqui e em qualquer lugar do mundo. Já um sistema de som tem milhares outros aspectos que levam você, consumidor, a comparar a qualidade entre dois produtos. Você compra uma caixa de som da Apple ou da JBL? Qual a potência máxima das duas caixas? Qual o tamanho, a conectividade, interface, material usado, etc... Sacou a diferença? Comparar dois pedaços de cobre dá na mesma... Comparar dois produtos "já prontos", não. É por isso que as comodites tem preços regulados pelo mercado. O preço do barril de petróleo é o mesmo no mundo inteiro, já o preço das caixas de som, não.

## Serviços comuns, Sobrinhos e os serviços DIY
Existem uma série de trabalhos feitos por designers, programadores e outros profissionais do mercado de internet que podem ser vistos como comodites e por isso o preço vai importar muito mais do que as qualidades e características.
  
Aos poucos, o grande público leigo deixou de precisar de designers e programadores para terem produtos que até então eram complexos. Se o seu Manoel quiser um e-commerce para sua mercearia, ele não precisa mais procurar um designer e um programador, ele [faz por conta própria](https://tableless.com.br/wix-dev-site/) e pronto.

Mas, bem antes dos serviços DIY, a comoditização do mercado de desenvolvimento web começou com os sobrinhos. Eles estavam em todo lugar colocando o site da firma do tio online. Você que trabalha há alguns anos com internet já deve ter topado com um [Sobrinho](https://twitter.com/sobrinhoweb). Muita gente já reclamou falando que os sobrinhos iriam acabar com o mercado por praticarem baixos preços entregando serviços ruins... Mas aos poucos a galera entendeu que os sobrinhos atacavam uma faixa de clientes que não viam a diferença entre sites feitos por profissionais e sites feitos pelos sobrinhos, exatamente por isso, esses clientes sempre preferiam contratar o sobrinho mais barato. Se o mercado não faz distinção das características e da qualidade de uma mercadoria, essa mercadoria vira comodite. Logo, um site feito por você ou feito por um sobrinho, são a mesma coisa, infelizmente.

Mas eu sei que você consegue, claramente, dizer quando um site é feito por um profissional. Contudo, essa diferença tem ficado cada vez mais difícil de perceber com serviços como o WIX, onde qualquer um consegue ter um site com uma qualidade MUITO superior quando comparado à um sobrinho e cada vez mais semelhante a sites profissionais, feitos por nós. Hoje, pessoalmente, se eu não ver o código fonte, eu não sei distinguir que o site foi feito no Wix ou por outro serviço DIY.

## Os profissionais de web e a personalização
Veja, essa faixa de necessidades que são bem resolvidas usando serviços DIY (Do It Youself) é uma faixa na qual você não precisa estar.

![](https://i.imgur.com/5qq8hbg.png)

Quanto mais um serviço está do quadrante inferior esquerdo, mais comum é esse serviço e mais soluções automatizadas iremos encontrar, dispensando a necessidade de um especialista.

![](https://i.imgur.com/rCfBbhW.png)

Perceba que para criar um site institucional, podemos usar soluções como o Wix, que é algo MUITO mais barato do que pagar um designer + front-end + back-end. Qualquer um consegue criar uma conta nesses serviços, escolher o design e publicar o site. Você mesmo pode optar por criar os websites nessas ferramentas para clientes desse tipo.   

Para soluções que tem um nível alto de customização e complexidade, ter especialistas é indispensável. **É aí que eu acho que você deveria estar.**

Quanto mais comum uma necessidade se tornar, maior a possibilidade dessa necessidade ser resolvida de forma automática ou por serviços que facilitarão a execução do trabalho.

![](https://i.imgur.com/n1T1Myb.png)

Outro ponto é que você tem mais chances de ganhar dinheiro, ter um cargo melhor, ter mais responsabilidade e ter mais sucesso profissional se estiver desenvolvendo soluções que estão mais pro lado direito superior do diagrama. 

A cada dia que passa, design, front-end e back-end (esse último menos) se tornam cada vez mais comodites. O código HTML que você escreve não é muito diferente do código HTML que uma máquina pode escrever ou que os freelancers do Brasil (e do mundo) escrevem. É bastante comum agências de design venderem websites, onde eles fazem apenas o design do layout do projeto e terceirizam a parte de front-end e back-end. Tanto faz quem vai fazer o código front-end. Se todo mundo escreve o mesmo HTML, CSS e JS, qual a diferença para a agência entre escolher você ou outro front-end?

## A comoditização é real e você não precisa se preocupar... ainda.
Essa comoditização já é real desde muito tempo atrás e você não precisa se preocupar tanto assim. Empresas que fazem produtos, que tem sistemas complexos e altamente customizados sempre precisarão de profissionais capacitados para continuarem crescendo. Mesmo assim, o que você pode fazer para que seu trabalho tenha uma qualidade indiscutível?