---
title: Como uma simples mudança de cores pode revolucionar seu site
authors: David Arty
type: post
date: 2015-11-27
excerpt: 'Testes A/B: design orientado à conversão de leads qualificados'
url: /como-uma-simples-mudanca-de-cores-pode-revolucionar-seu-site/
categories:
  - Design
  - UX
tags:
  - design
  - ux
  - interação
  - interface
---
Acredito que muitos de nós estamos na batalha diária desenvolvendo projetos para se realizar profissionalmente, sustentar nossas famílias, entre outras razões particulares. Entretanto existem também os objetivos relacionados às nossas funções que motivam, ou deveriam motivar, nossas ações para que os resultados de nossos projetos nos realizem e tragam reconhecimento.

E uma meta primordial que faz com que todo profissional web atinja parte destes objetivos é desenvolver projetos com foco no usuário, como já foi citado <a href="https://tableless.com.br/nada-de-capa-quando-a-firula-e-mais-do-que-a-funcao/" target="_blank">neste excelente artigo</a> aqui no Tableless.

É óbvio que o foco no usuário é a menina-dos-olhos de todo projeto web. Para isso, toda equipe (ou equipe de um homem só) se concentra em construir conteúdos maravilhosos, interfaces tão bem projetadas que “parecem imperceptíveis” para o usuário. Lembro que um erro de usabilidade pode ser algo perceptível.

Mas será que todo projeto executado com foco no usuário resulta em sucesso total?

## Deixando o bom para buscar o ótimo

Vamos imaginar um exemplo. Se você concluiu um site agradável para os usuários, que resultou em um aumento de seguidores para seu cliente, engajamento e repercussão, a percepção é que o projeto é um sucesso.

E é sim, se a questão é somente gerar um _buzz_.

Com esta audiência é possível até monetizar, e o grande interessado nisso é seu cliente, detentor do site. O sucesso dele pode te proporcionar novos projetos. E é isso que &#8220;$garante$&#8221; nossos outros objetivos. Lembra? Sustentar nossas famílias, outras razões particulares.

Entretanto, voltando à questão do _buzz_, um site que satisfaça os usuários e inicialmente um cliente pode, no decorrer do tempo, também ser um desastre financeiro. Vejamos:

Manter páginas com grande tráfego tem um custo, construir conteúdo de qualidade e todo o processo de manter e administrar um site também. Agora, imagine este sucesso de audiência e repercussão sem o retorno financeiro que justifique este projeto no ar. Temos um problema de gastos, mas também uma grande oportunidade de melhoria pela frente se ainda existem reservas.

Inúmeras variáveis podem determinar o sucesso de audiência de um projeto online como do exemplo citado acima.  Para entendermos melhor citarei algumas:

  * A demanda (desejada) pelo produto, serviço ou conteúdo que o projeto aborda.
  * Validação da demanda;
  * Possuir tráfego qualificado;
  * Oferecer soluções;
  * Relacionamento através de marketing de conteúdo;
  * Apresentar os conteúdos, produtos, serviços em um site funcional e focado no usuário.

Parece-me um cenário ideal para vendas. Mas antes, por que este site não dá retorno?

Você pode ter certeza: qualquer projeto online pode ter milhares de seguidores, alguns que até defendem a marca, divulgam, compartilham, desejam possuir seus produtos, mas muitos deles entrarão no site, consumirão conteúdo gratuito, sairão, voltarão milhares de vezes prometendo a si mesmo comprar aquele curso maravilhoso, mas postergarão nesta decisão infinitas vezes.

Agora voltamos para aquela pergunta que fiz no inicio do artigo: “Mas será que todo projeto executado com foco no usuário resulta em sucesso total?”.

Se o resultado for vendas, nem sempre. Uma coisa é certa: ele conduzirá o usuário final pelo caminho correto, sem barreiras até conclusão do pagamento. Porém o que ele nem sempre faz é potencializar a decisão do usuário de trilhar este caminho. E aí que entra o Design aplicado à conversão.

Veja bem. Não estou dizendo que a culpa do baixo retorno de um projeto é o design focado no usuário. Sem ele, aí mesmo que as coisas pioram. Só quero mostrar que focar em usabilidade não é a única decisão a se tomar quando pensamos em conversão. Um site que atenda as principais variáveis de sucesso de audiência pode estar pecando na otimização de conversão.

## Utilizando o Design aplicado a conversões

Aqui mesmo no Tableless já foi falado sobre <a href="https://tableless.com.br/7-dicas-de-otimizacao-de-conversao-em-landing-pages/" target="_blank">otimização de conversões<b> </b>através de landing pages</a>. Para quem não sabe, conversão é o resultado de um objetivo traçado, por exemplo, uma venda, um cadastro, entre outros. E _landing pages_ são páginas de aterrissagem construídas para direcionar tráfego com objetivo o dos usuários tomarem uma ação (cadastro em formulário, clique, etc.) e que traga um resultado esperado (captação de e-mails, vendas, etc).

<img class="alignnone wp-image-52134 size-full" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/11/iMac-Office.png" alt="Design não é apenas o que parece e o que se sente. Design é como funciona - Steve Jobs" width="620" height="413" />

Uma página de aterrissagem é inútil se o tráfego não estiver qualificado para o que é ofertado. Não adianta direcionar pessoas interessadas em carros para uma página que fala sobre bicicletas. _Landing pages_ não fazem mágicas e muito menos lavam a mente de ninguém. Elas estão lá para potencializar a decisão de compra do usuário interessado em um assunto e que vive postergando esta decisão para outro momento.

Já que, segundo o conceito de página de aterrissagem é direcionar tráfego para que exista uma ação, podemos considerar que existem diferentes formas de _landing pages_, como posts de blog com formulário de captação de mails dentro do artigo, _Home Page_ minimalista com função de inscrição em boletins e páginas com _Popup Exit_. Elas trazem resultados, porém, por natureza tendem a ter distrações visuais que podem diminuir a eficácia das conversões. A mais eficiente de todos os tipos são mesmo as **_Squezee Pages_**.

_Squeeze Page_ é um tipo de _landing page_ específica, objetiva, com poucas distrações e mais poderosa para conversão, principalmente para a captura de e-mails.  É bastante conhecida como página de captura onde se oferece uma recompensa em troca da inscrição no boletim informativo, ou outro dado.

As _squeeze pages_ &#8220;comprimem&#8221; visitantes de seu tráfego para dentro do funil de vendas. Posteriormente é possível transformá-los em &#8220;_leads_ qualificados&#8221; através de relacionamento, para deixá-los aptos a receber ofertas.

Mas nenhum tipo de _landing page_ é eficiente se não a otimizarmos para conversão. A otimização pode aumentar a conversão de um projeto em significantes porcentagens. Existem <a href="https://chiefofdesign.com.br/testes-ab-taxas-de-conversao/" target="_blank">relatos de incrementos de 52% até 134%</a>.

E como isto é feito? Através de testes de versões.

Você pode realizar testes determinando a página original como controle, e criando uma versão que modifique somente um aspecto visual ou de conteúdo e utilizando uma ferramenta de teste A/B a fim de distribuir tráfego, medir as conversões de cada uma delas e garantir um nível de confiança de no mínimo 95%.

A versão que tiver mais conversão, vence. Se for a versão original, deve-se mantê-la, caso contrário, a variação deve assumir o lugar.

## E por que testar?

Você pode ser ótimo no que faz, mas o fato de testar, mostra que você preocupa-se com resultados. Não considere este procedimento como avaliação do &#8220;seu&#8221; desempenho. Foque em trazer resultados efetivos para seus clientes. Será seu diferencial. Além do mais, testes A/B são:

  * Práticos;
  * Podem atingir taxa de conversão mais elevadas;
  * Requer menos tráfego;
  * O resultado é obtido rapidamente.

### Mas onde entra o _design_?

Como testes A/B são práticos, qualquer pessoa com conhecimentos básicos pode aplicá-los. E pode conseguir resultados positivos. Um procedimento considerado comum,  por exemplo, é testar cores em botões de formulários de cadastros.

Veja este estudo:

**Teste de cores com botão na página inicial do site da Performable**

Durante um <a href="https://Teste de cores com botão na página inicial do site da Performable Durante um <a>teste</a> com um total de 2.000 visitas a equipe da Perfomable [https://blog.hubspot.com/blog/tabid/6307/bid/20566/The-Button-Color-A-B-Test-Red-Beats-Green.aspx] queria avaliar qual botão obteria mais cliques entre duas versões de páginas. A página original possuía um botão verde que correspondia também a cor verde usada também no padrão visual usado no logo da empresa. Foi definido na versão concorrente um botão vermelho, o resto do layout era totalmente igual. Sabe qual foi o resultado? 21% a mais pessoas clicaram no botão vermelho em relação ao botão verde." target="_blank">teste com um total de 2.000 visitas</a> a equipe da Perfomable queria avaliar qual botão obteria mais cliques entre duas versões de páginas. A página original possuía um botão verde que correspondia também a cor verde usada no padrão visual do logotipo da empresa. Foi definido na versão concorrente um botão vermelho, sendo o resto do layout totalmente igual. Sabe qual foi o resultado?

21% a mais pessoas clicaram no botão vermelho em relação ao botão verde.<img class="alignnone wp-image-52133 size-full" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/11/teste-ab-pratica.png" alt="Exemplo de Teste A/B" width="620" height="817" />

Muitos escolhem cores aleatórias para competir com a página da versão original, mas esta escolha de cores sem critérios, pode acarretar em muitos testes e necessidade de enviar mais tráfego.

Com o _design_ aplicado à conversão, as decisões de otimização tem critérios mais elaborados, baseado nos conceitos de _design_, sem achismos. Com isso, você obtém resultados mais certeiros logo nos primeiros testes.

Acredito que a decisão acertada da equipe de Perfomable foi devido a critérios baseados em conceitos de _design_ e não uma escolha qualquer. Conceitos sobre contrastes encontrados na <a href="https://pt.wikipedia.org/wiki/Teoria_das_cores" target="_blank">Teoria de Cores</a> e <a href="https://www.designculture.com.br/leis-da-gestalt-unidade-e-segregacao/" target="_blank">Segregação de Gestalt</a> do objeto justificam escolher a cor vermelha. Veja mais nesta explicação de um minuto em vídeo que gravei:



Poderíamos ter um ótimo resultado usando uma cor com pouco destaque em relação ao verde? Talvez! Porém só da para saber testando. Então pergunto: você prefere economizar tempo e dinheiro com critério ou adotar achismos?

Bem-vindo ao mundo da otimização, dos testes A/B e do _design_ aplicado a conversão. Para saber mais, sugiro conferir este <a href="https://designfreela.com/" target="_blank">infográfico</a>**.**

**O Design tem esse poder, não desperdice.**

**Referências:**

<a href="https://chiefofdesign.com.br/design-para-conversao/" target="_blank">Design para conversão</a>

<a href="https://designfreela.com/" target="_blank">Infográfico Design para Conversão &#8211; Saiba como não FERRAR com a conversão dos seus layouts e com os projetos dos seus clientes</a>

<a href="https://blog.hubspot.com/blog/tabid/6307/bid/20566/The-Button-Color-A-B-Test-Red-Beats-Green.aspx" target="_blank">The Button Color A/B Test: Red Beats Green</a>