---
title: Como se tornar um profissional Top em WordPress
authors: Rodrigo Simoni
type: post
date: 2013-02-04
excerpt: Como se tornar um profissional top em Wordpress.
url: /como-se-tornar-um-profissional-top-em-wordpress/
dsq_thread_id: 1064520291
categories:
  - Traduções
  - Wordpress
tags:
  - blog
  - cms
  - profissional wordpress
  - temas em wordpress
  - Wordpress

---
Neste artigo, vou mostrar como você poderá se tornar um profissional Top em WordPress e isso pode valer não só para os desenvolvedores, mas também para blogueiros, designers e todos os outros.

Primeiro, vamos definir algumas coisas: Se tornar um profissional Top em WordPress é um trabalho duro &#8211; muito duro. Você precisará de tempo, energia e determinação. Se você está procurando um artigo rápido sobre esse tema, irá perder seu tempo. Ser um dos melhores é uma tarefa difícil e, estatisticamente falando, as probabilidades de acontecer isso estão contra você.

> Com o WordPress, você não está dormindo no sofá de outra pessoa. É uma ferramenta open source que você pode controlar.

Em primeiro lugar, por que se importar com o WordPress? Cory Miller é o co-fundador da IThemes, que oferece temas WordPress profissionais, plugins e treinamento dos projetos. Ele também é co-autor da última edição do livro WordPress For Dummies. Miller começou com um blog em WordPress em 2006, como um iniciante e sem nenhuma experiência, começando a aprender com os temas gratuitos. Perguntei pra ele por que as pessoas devem se envolver com o WordPress.

“Com o WordPress, você não está dormindo no sofá de outra pessoa. É uma ferramenta open source que você pode controlar. Você pode fazer o que quiser com ele e sempre que quiser. Você não precisa de outra pessoa estúpida para fazer alterações ou não tocar nos códigos porque ele está fechado nos servidores de outras pessoas. Você tem liberdade. Mas o principal motivo para se envolver com WordPress é publicar alguma coisa na Web de forma fácil. Praticamente qualquer um pode ter um blog ou um site com o WordPress e isso abre uma oportunidade incrível para todos nós.“

O WordPress torna fácil publicar um blog ou site e democratiza a publicação de conteúdo na internet. Sua facilidade de usar torna possível um profissional Top sem ser um gênio em PHP.

## Por que ser Top em WordPress?

<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/02/profissional-em-wordpress-414x310.jpg" alt="Profissional em WordPress" width="414" height="310" class="alignnone size-medium wp-image-8156" srcset="uploads/2013/02/profissional-em-wordpress-414x310.jpg 414w, uploads/2013/02/profissional-em-wordpress-224x168.jpg 224w, uploads/2013/02/profissional-em-wordpress.jpg 500w" sizes="(max-width: 414px) 100vw, 414px" />

Ser comum é normal e subestimado. Você pode não ser o melhor em tudo e se passar sua vida tentando ser, poderá passar sua vida em uma neurose horrível. Além disso, pode ser bom ser apenas ok em alguma coisa e você aceitar isso, pois isso seria bem menos estressante. Dito isso, pode ser muito bom se esforçar para ser melhor naquilo em que você é apaixonado e se isso é WordPress e o controle de fazer suas próprias coisas, você tem muitos benefícios, por exemplo:

#### Ganhar mais dinheiro

Se você quiser ganhar mais dinheiro, você precisa ser o melhor no que faz. Se você é bom, sua reputação irá crescer e você será capaz de cobrar por melhores preços. Confira neste e-book <a href="https://build.codepoet.com/2012/05/11/getting-pricing-right/" target="_blank">como obter o preço certo</a>.

#### Ter os melhores clientes

Uma vez que você chegou ao topo, você tem muito mais liberdade para escolher seus clientes. Como seus preços irão aumentar, você vai descobrir que os clientes mais fáceis de lhe dar são os clientes que pagam melhor.

#### Ter mais influência

Se você é apaixonado por WordPress, construir sua reputação significa mais oportunidade de ser influenciador.

#### Faça parte da comunidade

A comunidade do WordPress é enorme e cresce ainda mais. Ao participar na comunidade e construir uma reputação no que você faz, você cria contatos com outras pessoas que também são apaixonadas por WordPress e que seguem o que você faz.

#### Fazer os contatos certos

Se você construir uma boa reputação e contribuir com a comunidade WordPress, participando de WordCamps, encontros, eventos e se envolver, as pessoas vão tomar conhecimento de quem você é.

## Eu não sou desenvolvedor. O que posso fazer?

Você não precisa saber escrever código para usar WordPress. Se as únicas pessoas envolvidas com WordPress fossem desenvolvedores, o WordPress não seria o que é hoje. Aqui vai algumas coisas que você pode ser para usar WordPress:

  * Estilista
  * Gerente de projetos
  * Empresário
  * Consultor
  * Jornalista
  * Blogueiro
  * Professor

Se você ainda não está convencido que pode usar o WordPress para outras coisas, um grande exemplo disso é Mika Epstein (conhecida como Ipstenu). Para ela, o WordPress começou como um hobby, mas rapidamente se tornou mais gratificante do que seu trabalho em TI, em um banco, onde ela fazia tudo, desde instalações de softwares a monitoramento de servidores. Recentemente, ela começou a trabalhar no suporte para WordPress da DreamHost, ajuda na documentação do WordPress.org e da suporte nos fóruns e blogs da comunidade do WordPress.

## Começando a se tornar Top em WordPress

Para ser um profissional Top em WordPress, você não precisa ser capaz de escrever PHP e saber como consultar um banco de dados MySQL. O ecossistema do WordPress é grande e há espeço para diferente especialidades e se você quer se tornar um profissional Top, deve se tornar um especialista em algumas dessas áreas.

## Use o WordPress

Pode parecer óbvio, mas usando o WordPress para você mesmo é uma ótima maneira para começar. Poderia ser o seu blog pessoal ou um site para um amigo ou para alguém da sua família, enfim, encontre uma maneira de usar logo o WordPress. Seria estranho alguém querer se tornar Top sem nunca ter experimentado a ferramenta a partir da perspectiva do usuário.

## Instalando o WordPress localmente

<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/02/mamp-wordpress-381x310.jpg" alt="MAMP WordPress" width="381" height="310" class="alignnone size-medium wp-image-8157" srcset="uploads/2013/02/mamp-wordpress-381x310.jpg 381w, uploads/2013/02/mamp-wordpress-206x168.jpg 206w, uploads/2013/02/mamp-wordpress.jpg 423w" sizes="(max-width: 381px) 100vw, 381px" />

Você não precisa ser um desenvolvedor para criar um ambiente de desenvolvimento no seu computador. Pode parecer assustador, mas eu me lembro da primeira vez que estava configurando o Xampp com o WordPress e estava totalmente confuso e não tinha ideia do que estava fazendo. Agora eu tenho mais instalações locais do WordPress do que eu posso acompanhar. Instalar WordPress no seu computador significa que você pode fazer o que quiser com ele sem ter que se preocupar com nomes de domínios, hospedagens etc. Depois de instalar o WordPress algumas vezes em seu computador, vai perceber como é extremamente simples. Veja os tutoriais de como instalar o WordPress usando <a href="https://wpmu.org/install-wordpress-locally-on-windows-with-xampp/" target="_blank">Xampp</a> (Windows) ou <a href="https://wp.smashingmagazine.com/2011/09/28/developing-wordpress-locally-with-mamp/" target="_blank">MAMP</a> (Mac).

## Siga os blogs

Há uma infinidade de blogs sobre WordPress que você pode aprender. Adicione eles no seu leitor de RSS e mantenha-se atualizado. Com tantos blogs falando sobre WordPress, pode parecer que todos oferecem a mesma coisa, mas cada um oferece algo único. Aqui estão alguns dos meus favoritos:

<a href="https://wp.smashingmagazine.com/" target="_blank"><strong>Smashing Magazine (Categoria de WordPress)</strong></a>
  
Artigos mais longos e tutoriais.

<a href="https://wprealm.com/" target="_blank"><strong>Realm WP</strong></a>
  
Notícias sobre WordPress, opinião e artigos de especialistas em toda a comunidade.

<a href="https://www.wpcandy.com/" target="_blank"><strong>WPCandy</strong></a>
  
Notícias e Podcasts sobre WordPress.

<a href="https://www.wpbeginner.com/" target="_blank"><strong>WPBeginner</strong></a>
  
Tutoriais de WordPress e vídeos, junto com uma seção de cupons de desconto em produtos e serviços relacionados com WordPress.

<a href="https://wpmu.org/" target="_blank"><strong>WPMU.org</strong></a>
  
Dicas diárias, tutoriais e notícias de WordPress.

<a href="https://wplift.com/" target="_blank"><strong>WPLift</strong></a>
  
Temas, plug-ins e tutoriais.

<a href="https://build.codepoet.com/" target="_blank"><strong>Code Poet</strong></a>
  
Entrevistas com especialistas de destaque do WordPress e tutoriais.

## Seja entusiasta

Um pouco de entusiasmo leva tempo. James Mason, começou em um emprego como desenvolvedor de WordPress no WPMU DEV, mas fez um péssimo trabalho na modificaçãoo de um plugin que lhe deram. No entanto, eles sabiam de suas habilidades de comunicação e atitude.

“Independente do mercado, as pessoas querem trabalhar com alguém que gostem de estar perto. Ter uma atitude positiva e estar disposto a enfrentar os desafios são qualidades que qualquer empresa está procurando.“

Seu entusiasmo o levou para um longo caminho e agora Mason é CEO de sua própria agência de WordPress e gerenciamento de projetos, <a href="https://thewpvalet.com/" target="_blank">Valet WP</a>.

## Ouvir

Já se passaram 10 anos desde que o WordPresss nasceu. Isso significa que há muita gente experiente na comunidade. Encontre essas pessoas e as ouça. Dougal Campbell é curador de uma lista no Twitter, chamado <a href="https://twitter.com/#!/dougal/wpleaders" target="_blank">WPLeaders</a> e é um ótimo lugar para encontrar pessoas com experiência em WordPress. Aproveite o tempo para aprender como funciona a comunidade antes de mergulhar nela.

## Envolva-se

<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/02/envolvase-wordpress-465x310.jpeg" alt="Envolva-se" width="465" height="310" class="alignnone size-medium wp-image-8158" srcset="uploads/2013/02/envolvase-wordpress-465x310.jpeg 465w, uploads/2013/02/envolvase-wordpress-252x168.jpeg 252w, uploads/2013/02/envolvase-wordpress.jpeg 500w" sizes="(max-width: 465px) 100vw, 465px" />

Agora que você aprendeu o básico em WordPress, está na hora de começar a se envolver. Claro, você pode até caminhar sozinho e há muitas pessoas com empresas de sucesso de WordPress que não tem nada a ver com a comunidade. Mas há muitos motivos para se envolver com a comunidade. Aqui está o porquê:

  * A comunidade oferece um campus de treinamento livre, onde especialistas lhe daráo feedback e te ajudar a usar melhor o WordPress.
  * Se você é freelancer ou tem seu próprio negócio, a comunidade pode lhe fornecer suporte e relações humanas.
  * Ao se envolver com WordPress, você está ajudando a criar um produto melhor e todos podem se beneficiar.

## Make WordPress.org

<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/02/make-wordpress.jpg" alt="Make WordPress" width="527" height="238" class="alignnone size-full wp-image-8159" srcset="uploads/2013/02/make-wordpress.jpg 527w, uploads/2013/02/make-wordpress-329x148.jpg 329w" sizes="(max-width: 527px) 100vw, 527px" />

Make WordPress.org é o lugar onde você pode encontrar blogs para todos os grupos. Onde costumava haver listas de discussão, agora há blogs. Todos os grupos estão reunidos na <a href="https://make.wordpress.org/" target="_blank">Make WordPress.org</a>. Você pode acompanhar todas elas ou escolher as que são mais relevantes para você. Os blogs que fazem parte são:

  * Núcleo
  * Plugins
  * Acessibilidade
  * Suporte (incluindo fóruns e documentos)
  * UI
  * Temas
  * Polyglots
  * Eventos
  * Sistemas

Há assunto para todos e cada blog tem uma comunidade empolgante e que trabalha para fazer o WordPress melhor. Cada frupo tem sua própria liderançaa que é responsável por organizar as discussões levantadas.

## Outros suportes

Os fóruns de suporte do WordPress são um excelente recurso para os usuários do WordPress, mas também é um ótimo lugar para você aprimorar suas habilidades em WordPress. Aprendemos melhor ensinando as pessoas. Eu aprendi 95% do que eu sei em WordPress escrevendo artigos e respondendo perguntas nos fóruns. Isso te ajuda a esclarecer o seu próprio conhecimento do WordPress. Respondendo perguntas de outras pessoas é a melhor maneira de fazer isso.

“Se você quiser saber mais sobre WordPress, não há maneira mais rápida do que ajudando as outras pessoas.“

## Escreva sobre WordPress

Você poderia começar a escrever sobre WordPress para o WordPress Codex, encontrando alguma página que precisa ser editada. O Codex feito em MediaWiki e qualquer um com um nome de usuário WordPress.org pode editar. O Codex tem sempre a necessidade de atualização e edição e contribuir com seus próprios artigos ajudará a primorar suas habilidades de WordPress. Você também pode ajudar com o <a href="https://make.wordpress.org/support/handbook/" target="_blank">Manual de usuário do WordPress</a>, que está atualmente em processo de edição nos blogs de suporte do WordPress.

O WordPress.org não é o único lugar para escrever sobre WordPress. Caso você encontre uma solução para um problema de WordPress e escrever sobre isso em seu blog pessoal, as pessoas encontrarão através do Google e lhes ajudarão a resolver seu problema e você o problema delas. Com o processo de escrever sobre como resolver problemas de WordPress, as soluções chegarão cada vez mais de forma clara para você.

## Conheça a comunidade

Trabalhar online é ótimo, mas não há nada como o encontro cara a cara para criar relacionamentos mais fortes e profundos. A fundação WordPress aceita dois tipos de eventos: WordPress <a href="https://central.wordcamp.org/" target="_blank">WordCamps</a> e <a href="https://wordpress.org/news/2012/01/year-of-the-meetup/" target="_blank">Meetups</a>. Wordcamps são grandes conferências anuais no qual especialistas e entusiastas se reúnem para compartilhar suas experiências com WordPress. Meetups são mais regulares, muitas vezes, uma vez por mês e são curtos encontros informais que podem envolver hacking ou apresentações. Participe de eventos e, quando se sentir confiante o suficiente, palestre neles. Não sinta que você tem que ser um gênio de WordPress para fazer uma apresentaçãoo. Se você já fez alguma coisa útil, o que vale a pena é compartilhar. Wordcamps e Meetups são importantes meios de construção de novos relacionamentos e amizades dentro dos mesmos interesses.

## Siga em frente

<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/02/siga-wordpress-466x310.jpg" alt="Siga em frente" width="466" height="310" class="alignnone size-medium wp-image-8160" srcset="uploads/2013/02/siga-wordpress-466x310.jpg 466w, uploads/2013/02/siga-wordpress-253x168.jpg 253w, uploads/2013/02/siga-wordpress.jpg 500w" sizes="(max-width: 466px) 100vw, 466px" />

Ao formar relacionamentos com as pessoas certas, você está no primeiro passo para ficar à frente. Essas pessoas não precisam ser as mais proeminentes, mas pessoas com conhecimento e experiência que você possa confiar. As vezes é uma questão de conhecer as pessoas certas para responder suas perguntas. Isso não significa que você deve chamar as pessoas às 4 da manhã para pedir ajuda. Ao construir novos relacionamentos e interagindo com a comunidade, você terá uma coleção inteira de pessoas que podem ajuda-lo com vários tipos de questões como qual a melhor empresa de hospedagem ou como encontrar um bom programador. Ficando à frente nem sempre é ser o melhor em algo em si, mas conhecer as pessoas certas fazendo as perguntas certas.

## Saiba o que está acontecendo

Se você quiser chegar à frente, você precisa saber mais do que apenas é o WordPress em sua versão atual. Você deve se manter atualizado com o que vai acontecer no WordPress não apenas em seu Core, mas em toda sua comunidade. Se você está trabalhando com seus clientes, você precisa saber o que está reservado para eles nas próximas atualizações do WordPress. Há muitas maneiras de fazer isso:

#### Execute o nightly builds

Mantenha a <a href="https://wordpress.org/download/nightly/" target="_blank">nightly builds</a> instalado em uma instalação local. Isso irá manter o seu update.

#### Acompanhe o desenvolvimento do Core

Você pode acompanhar o que está acontecendo no núcleo do WordPress de várias maneiras: seguindo o <a href="https://make.wordpress.org/core/" target="_blank">Make WordPress Core</a>, mantendo-se com os <a href="https://irclogs.wordpress.org/chanlog.php?channel=wordpress-dev" target="_blank">Recent Development Chats</a> e seguindo o <a href="https://core.trac.wordpress.org/" target="_blank">WordPress Trac</a>. Você também pode seguir o <a href="https://twitter.com/wordpresstrac" target="_blank">@wordpresstrac</a> no Twitter para atualizações ao vivo.

#### Acompanhe as mudanças de interface

Grande mudanças na interface do usuário pode ser confuso para os usuários despreparados com WordPress. Mantenha seus clientes informados sobre as atualizações.

## Saiba quando fazer uma pausa

Não jogue fora sua TV e não se livre do seu vídeo-game e seus livros ou qualquer coisa que voê gosta de fazer. Nos primeiros anos em que trabalhei com WordPress, eu trabalhava dia e noite. Fazer seu próprio negócio e se envolver com a comunidade pode ser muito intensa. Há confrontos e argumentos que chegarão até você. Pode vir de uma pessoa rude, fórum, twitter e isso pode te deixar cansado. Você precisa dar uma pausa e fazer as coisas que você gosta.

## Continue ouvindo

Mesmo que você tenha chegado ao topo, você precisa ouvir. Outras pessoas continuarão tendo opiniões diferente das suas e não importa o quanto bom você pense que é, há casos em que você pode estar errado. Chegar ao topo não significa saber todas as coisas a respeito de tudo, mas só que você é realmente bom em algo. Continue ouvindo aqueles que também são bons e mesmo os que não são.

## Conclusão

O mercado de WordPress é uma área onde reúne muitos tipos de profissionais. Não apenas desenvolvedores, mas jornalistas, blogueiros, gerentes de projetos, designers, consultores, médicos, professores e inúmeros profissões que utilizam o WordPress e são muito bem remunerado com ele. Há outras recompensas além do dinheiro. O nosso mundo está cada vez mais fragmentado, especialmente para nós que passamos a maior parte do tempo online. Ser parte de uma comunidade significa ter pessoas para se comunicar, compartilhar ideias e colaborar para formar novas parcerias e amizades. Se você quer tomar o caminho para o topo e se divertir enquanto faz isso, então é só escutar, aprender, compartilhar, colaborar e contribuir.

_Tradução e adaptação do texto de <a href="https://wp.smashingmagazine.com/author/siobhan-mckeown/?rel=author" target="_blank">Siobhan McKeown</a>, originalmente publicado na <a href="https://wp.smashingmagazine.com/2012/12/05/become-top-wordpress-professional/" target="_blank">Smashing Magazine</a>._