---
title: Como organizar e nomear o conteúdo do projeto?
authors: thonyconde
type: post
date: 2016-12-06
url: /como-organizar-e-nomear-o-conteudo-do-projeto/
categories:
  - Agile e Gestão
  - Artigos
  - Design
  - UX
tags:
  - arquitetura
  - card
  - informacao
  - sorting
  - ux

---
Pode até parecer uma questão simples ou de pouco valor no projeto, mas a verdade é que a forma que você solucione essa ponto será determinante para o sucesso e o card sorting é o melhor caminho!

<p style="text-align: center">
  <strong>O card-sorting é uma técnica usada para descobrir como o usuário classifica determinada informação em sua mente.</strong>
</p>

Muitas pessoas acreditam que podem classificar a informação pelos outros pois acham que sabem como será a melhor forma. Algo muito praticado é alguém do projeto definir uma estrutura, apresentar ao cliente, aprovar e tocar o barco! Porém isso é um grande erro e a classificação deve ser semelhante ao que as pessoas, usuário final, acredita ser a ideal e não você, ou seu contratante.

Um método simples, e extremamente útil, é o **card sorting!** Pode ser feito sem grandes dificuldades com um pequeno grupo pessoas.

Executei uma dinâmica recentemente como voluntário do PMI-CE, o qual faço parte, para determinar qual a melhor forma de organizar e nomear as informações que devem conter no novo site do capítulo.

Cada participante foi convidado de acordo com seu perfil de uso e representam as personas prioritárias do projeto.

<img class="alignnone size-full wp-image-56525" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2016/11/1WhatsApp-Image-2016-11-21-at-22.00.11.jpeg" alt="1whatsapp-image-2016-11-21-at-22-00-11" width="1280" height="720" />

**Funcionou assim:**

Cada participante recebeu uma série de pedaços de papeis descrevendo o conteúdo que precisa ser disponibilizado no novo site e pedi que cada pessoa relacionasse os pedaços em conjuntos, criando categorias.

_Foi estabelecido um time-box de 15 minutos para que todos pudessem formar seus conjuntos._

Após isso abrimos uma discussão sobre a classificação que cada pessoa determinou para cada item. As escolhas de cada pessoa foram cruzadas e amplamente discutidas até adquirirem a concordância do grupo sobre como cada item deveria ser agrupado.

Enquanto ocorriam as conversas tive a oportunidade de ouvir e aprender sobre o que cada pessoa entende a respeito de cada item e categoria. Além da opinião pessoal de cada um sobre a melhor forma de classificar tudo. É aqui que está o principal valor deste teste.

Ao fim do teste um relatório foi elaborado e um organograma com a taxonomia sugerida pelo grupo.

**Em resumo, estas seriam as etapas:**

  1. Defina as personas do projeto e convide um representante de cada perfil para participar.
  2. Cada pessoa recebe uma serie de papeis embaralhados que descrevem os conteúdos.
  3. Então deve agrupar os papeis os quais acredita que os conteúdos tem alguma semelhança.
  4. Cada grupo deve ser nomeado, de acordo com a visão de cada pessoa.
  5. As escolhas são registradas e discutidas.
  6. Encontramos uma classificação final baseado no cruzamento dos resultados.

Em pouco mais de uma hora encontramos uma taxonomia que foi consenso entre todos os participantes. Logo após discutimos também sobre a nomenclatura e classificação de cada item e grupo.

> <p style="text-align: center">
>   <strong>Taxonomia (do grego antigo τάξις táxis, arranjo e nomia νομία, método) é a disciplina acadêmica que define os grupos de organismos biológicos, com base em características comuns e dá nomes a esses grupos.</strong>
> </p>

É importante falar que nada é infalível e mesmo aplicando a técnica as coisas podem mudar. O projeto deve ser analisado constantemente e ajustes baseados no comportamento de uso das pessoas sempre serão necessários e bem vindos.

Como entregável temos a arquitetura do projeto já nomeada, agrupada e classificada, conforme o resultado da atividade. Uma ferramenta muito útil para ajudar nisso, e free, é o xMind.

Card sorting é uma atividade extremamente simples mas de grande valor ao projeto que ajuda a evitar diversos problemas de usabilidade, experiência de usuário, desperdício de tempo e dinheiro.