---
title: Como escrever e-mails de apresentação
authors: Dani Guerrato
paid: true
type: post
date: 2013-09-02
excerpt: Saiba como evitar os principais erros na hora de redigir um e-mail, conheça dicas simples para ganhar a simpatia de quem está do outro lado do monitor e nunca mais esqueça seu portfólio.
url: /como-escrever-e-mails-de-apresentacao/
dsq_thread_id: 1657065749
categories:
  - Artigos
  - Geral
tags:
  - boas praticas
  - clientes
  - emails

---
Seja na hora de entrar em contato com um cliente, conseguir uma parceria ou até mesmo uma vaga de emprego em uma agência a maior parte da comunicação entre profissionais ligados a web acaba sendo, pela própria natureza do meio, em formato de e-mails. Causar uma boa impressão neste momento é fundamental para conseguir a simpatia de quem está do outro lado da rede. Mas saber como se comportar ao redigir e-mails de apresentação infelizmente é algo que cursos e palestras não fazem questão de explicar. Neste artigo vou dar algumas dicas para você não fazer feio nesta hora.

A maior parte deste conteúdo surgiu da minha experiência dos dois lados da caixa de entrada. Quando eu estava iniciando a minha carreira quebrei a cara muitas vezes por não saber como agir nestas situações. E não entendia como, mesmo tendo o conhecimento necessário, perdia oportunidades bacanas. Hoje como sócia de um pequeno estúdio de design recebo muitos contatos em busca de colocações profissionais e, por ironia do destino, vejo o pessoal cometendo os mesmos erros que eu fazia no começo. A idéia deste artigo não é ser um manual de comportamento, mas oferecer algumas dicas que funcionaram bem para mim. E, é claro, o que costuma causar uma boa impressão na hora de recrutar profissionais aqui na empresa!

## Não esqueça do portfólio!

Se você for guardar apenas uma informação deste texto guarde esta: não esqueça do seu portfólio. Sério. É muito mais importante do que um currículo. Sinceramente, muitas empresas nem ao menos lêem e-mails que não tem portfólio. Esta história de &#8220;casa de ferreiro, espeto de pau&#8221; não cola. Se você não consegue separar tempo suficiente do seu dia-a-dia para investir em você como profissional por que outras pessoas deveriam fazer o mesmo? Mostre o que sabe fazer! Mesmo que sejam projetos para fins de estudo. Se você não tem nenhum cliente crie um blog, uma marca fantasia ou até mesmo faça um redesign de um site conhecido. Diversos designers conseguiram visibilidade ao reimaginar conceitos de layouts conhecidos como [Facebook][1] ou [IMDB][2], por exemplo. Se você não sabe escrever uma linha sequer de HTML/CSS isto também não é desculpa. Procure um serviço gratuito de hospedagem de portfólios como [Behance][3], [Dunked][4] ou [Carbonmade][5]. Até mesmo um álbum de fotos no Facebook é válido! Na pior das hipóteses envie anexos por e-mail ou links para os jobs que você sente mais orgulho de ter participado. Já se você é um desenvolvedor que não saca nada de design envie um link para seu repositório no [Github][6] ou hospede trechos de códigos em serviços como como [CodePen][7] ou [JSFiddle][8]. Desenvolva alguma interação só para demonstrar o que você sabe projetar. Faça o que fizer não deixe de mostrar o seu trabalho. Isto é muito mais importante do que onde você estudou ou se trabalhou em alguma agência famosinha ou não.

Mas lembre-se de ser consistente com sua proposta. Se quer uma vaga como designer e desenvolvedor híbrido utilizar um template pronto como portfólio pode pegar mal. Por que alguém deveria contratar os seus serviços de designer se até você mesmo prefere utilizar o de outra pessoa? Oferecer serviços de SEO sem ter uma boa colocação em mecanismos de busca também gera desconfiança.

## Escreva corretamente

Ninguém está exigindo que você seja exatamente um poeta da era digital, mas é fundamental saber se comunicar. Para isto não custa nada utilizar um corretor ortográfico ou até mesmo pedir para outra pessoa dar aquela revisada básica nos seus textos. Evite abreviações em excesso, utilize pontuação correta e letras maiúsculas para iniciar frases. É natural (e perfeitamente desculpável) cometer alguns errinhos de ortografia, principalmente se são teclas próximas do teclado. Mas em tempos de dicionários digitais e corretores automáticos é impossível não saber que &#8220;você&#8221; é com &#8220;c&#8221; e não com &#8220;ç&#8221;.

## Fique atento a variação linguística

Você provavelmente utilizaria um conjunto de expressões diferentes para explicar um problema em uma bancada de mestrado, no chat do Facebook ou para um grupo de crianças em uma festinha. Esta habilidade mágica do ser humano é chamada de variação linguística. É basicamente a sua capacidade de modificar o tom do discurso de acordo com a situação social.

Esta regrinha vale para qualquer tipo de comunicação, seja ela por e-mail, telefone ou até mesmo ao vivo. Mas quando você não conhece o seu público-alvo é importante manter o tom neutro. Dizer para um empresário de 60 anos vestido de terno e gravata que você &#8220;manja dos paranaues&#8221; pode não ser a melhor maneira de explicar sua habilidade em escrever códigos semânticos. Você não está escrevendo um e-mail prazamiga então fique longe de gírias, memes e linguagem informal demais.

O inverso também é um erro. Exagerar na formalidade pode fazer você parecer pedante. Se você utilizou as palavras &#8220;deveras&#8221;, &#8220;efemeridade&#8221; ou &#8220;vossa senhoria&#8221; está na hora de olhar para um calendário e perceber que estamos no século XXI.

O ideal é tentar, na medida do possível, criar rapport (empatia) com seu interlocutor. Utilize uma linguagem neutra e espere a resposta. Se receber um texto lotado de smiles, sorria de volta. 🙂 Se o seu cliente falar &#8220;vai curintcha&#8221;, entre na brincadeira. E se o tratamento for frio, utilize uma linguagem séria e polida. É claro que isto não vai funcionar sempre. Por e-mail não existe o olho no olho e as vezes pode ser difícil distinguir uma brincadeira de um insulto. É preciso muito cuidado para garantir que seu texto seja interpretado da maneira correta.

Prestar atenção na formatação do e-mail também é fundamental. Não preciso avisar para passar longe da Comics Sans e efeitinhos do tipo IncrediMail, certo? A maior parte dos exemplos bizarros do tumblr ironico [Meu CV em Anexo][9] é de gente sem noção.

## Guarde os jargões para seus colegas de profissão

Longas discussões sobre Gestalt são bem interessantes em um grupo de designers, mas podem fazer uma pessoa &#8220;normal&#8221; se sentir perdida. Evite o uso de linguagem técnica, principalmente ao lidar com o cliente final. A maior parte das pessoas que não trabalham com internet não fazem idéia do que Design Responsivo ou SEO significa, por exemplo. Seja claro e objetivo. Dizer &#8220;uma técnica para o site funcionar em smartphones, tablets e computadores&#8221; ou &#8220;estratégia que pode melhorar a colocação do seu site no Google&#8221; funciona melhor. Pense no que sua mãe entenderia e parta daí.

## Seja educado

Para a internet ainda valem as dicas da sua mãe: &#8220;por favor&#8221; e &#8220;obrigado&#8221; são mesmo palavras mágicas. Não escreva em capslock a não ser que você esteja gritando (o que não é bacana em nenhum tipo de diálogo). Evite enviar diversos e-mails sobre o mesmo tópico e dê a pessoa tempo suficiente para responder. Saiba ouvir uma crítica construtiva e desconsidere as destrutivas.

E tentar corrigir alguém que utilizou a palavra &#8220;logomarca&#8221; é a maneira mais fácil de parecer um babaca.

## Procure conhecer a empresa

Antes de oferecer os seus serviços verifique se aquela empresa / pessoa de fato precisa deles. Trabalho com desenvolvimento web, mas já recebi currículos de diversos profissionais que não possuem nada a ver com a área como engenheiros químicos. Enviar o mesmo e-mail copiado e colado para diversas empresas diferentes também pega mal. Se você quer a atenção do profissional do outro lado, ofereça a mesma cortesia: dedique-se a personalizar a mensagem e demonstrar interesse real na empresa. Navegue pelo site, procure os canais das redes sociais, enfim, verifique se aquele parece ser um ambiente que combina com a sua personalidade, visão e valores.

## Cuidado com o Off-topic

Recebeu uma corrente para arranjar o amor da sua vida em 7 dias ou aquele ppt com um texto enorme que a Clarice Lispector obviamente não escreveu com fotos em preto e branco de crianças vestidas de anjinho? Pense duas vezes antes de clicar no botão &#8220;enviar&#8221;. Alias, antes de escrever qualquer coisa faça para si mesmo a seguinte pergunta: &#8220;a pessoa do outro lado REALMENTE precisa saber desta informação?&#8221;. Já recebi (e gostaria que fosse piada) currículos contendo até hábitos sexuais do profissional em questão.

O mesmo vale para experiências anteriores. Se o emprego que você está procurando é em desenvolvimento web é improvável que os quinze dias que você passou fritando hamburguers na lanchonete da esquina sejam relevantes.

Lembre-se de não exagerar e pecar pela falta de informação. Um dos e-mails mais nonsense que já recebemos por aqui continha, sem nenhuma outra informação de contato ou apresentação, apenas uma linha de texto: &#8220;vc tem trabalho para mim?&#8221;. A resposta, obviamente, foi negativa.

## Tenha um objetivo razoável

Não adianta ter apenas três meses de profissão e querer ganhar R$3 mil por mês no primeiro estágio. É importante estudar o mercado para ter um objetivo de salário condizente com seu conhecimento e experiência. Troque idéias com outros profissionais da área para ter em mente qual é o valor médio de acordo com sua região, nível, volume de trabalho, etc.

A palavra &#8220;parceiro&#8221; indica uma relação bilateral entre profissionais. Não é automaticamente um sinonimo para &#8220;envie todos os seus clientes para mim&#8221;.

## Tenha bom senso ao escolher um título profissional

Se você precisa dizer que é o rei, você não é o rei. Opte por títulos profissionais que descrevam a sua função claramente ou você corre o risco de parecer mala. Para isto é necessário uma boa dose de bom senso e autocritica. A não ser que você tenha de fato dirigido uma equipe de profissionais criativos você não trabalhou como &#8220;diretor de arte&#8221;, você não é o CEO a não ser que tenha um escritório executivo e, sinceramente, &#8220;webmaster&#8221; parece um algo saído diretamente dos anos 90 em rodapés de sites hospedados no Geocities.

O ideal é escolher cargos objetivos que descrevem seu campo de atuação como &#8220;designer&#8221;, &#8220;desenvolvedor front-end&#8221;, &#8220;programador&#8221;, etc.

## Seja sincero

É importante auto-crítica aqui. Não assuma uma responsabilidade que você não pode cumprir. Seja sincero quanto ao tempo que você demora para fazer um job. Não adianta prometer para ontem e depois atrasar meses a entrega do trabalho. O mesmo vale para suas habilidades. Saber utilizar o Google Tradutor não qualifica seu inglês como avançado. E não diga que você é um super hiper mago ninja do CSS, se mal sabe a diferença entre position relative e absolute. Faça a coisa certa e seja sempre honesto.

É muito mais nobre dizer que não sabe fazer algo mas está disposto a pesquisar e aprender do que prometer algo que você não vai cumprir. Destaque o que você tem de melhor. Descreva o que você pode oferecer de positivo para a empresa. E assim você sempre terá espaço para crescer e aprender.

## Evite exposição negativa em redes sociais

Se você é um freelancer, seu nome é sua marca. Cuide sempre para que, mesmo em situações informais, você esteja passando uma mensagem condizente com os valores que você afirmou representar. De nada adianta dizer no seu portfólio o quanto você ama a sua profissão se você solta comentários do tipo &#8220;odeio segundas-feiras&#8221;, &#8220;que preguiça de acordar cedo&#8221; ou &#8220;odeio o meu trabalho&#8221;, &#8220;que $%@#* de job&#8221;, etc.

Sim, as empresas vão fuçar no seu Facebook e Twitter para saber se você é um cara legal. Portanto, tente manter a postura profissional. Não xingue clientes antigos, não reclame do seu trabalho e evite expor demais a sua vida pessoal. E não preciso dizer que seu futuro chefe / cliente / parceiro não precisa ver sua foto bêbado na balada, certo? Marcar colegas em propagandas recorrentes também causa antipatia. Se possível crie listas e separe suas postagens de acordo com o conteúdo que interessará cada tipo de pessoa. Desta forma você ainda pode compartilhar suas notificações do Candy Crush e centenas de fotos de gatinhos fofos sem ser ocultado do feed.

## Conclusão

Com um pouquinho de bom senso, simpatia e atenção ao detalhe qualquer um pode causar uma boa impressão. É só ter calma, revisar o texto e mostrar o que você sabe fazer de melhor. Seguindo estas dicas você garante ao menos um clique no seu portfólio. O resto vai do seu esforço em fazer um bom trabalho e manter um bom relacionamento entre clientes e parceiros.

 [1]: https://www.behance.net/gallery/Facebook-New-Look-Concept/6504647 "Facebook New Look Concept"
 [2]: https://www.behance.net/gallery/IMDB-Filmpage-Concept/1678386 "IMDB Filmpage Concept"
 [3]: https://www.behance.net/ "Behance"
 [4]: https://dunked.com/ "Dunked"
 [5]: https://carbonmade.com/ "Carbonmade"
 [6]: https://github.com/ "Github"
 [7]: https://codepen.io/ "CodePen"
 [8]: https://jsfiddle.net/ "JSFiddle"
 [9]: https://meucvemanexo.tumblr.com "Meu CV Anexo"