---
title: Como escrever bem para o SEO – Texto e Contexto, da palavra-chave à semântica.
authors: Douglas Faria
type: post
date: 2014-01-03
excerpt: Entenda como melhorar o texto para os sistemas de busca.
url: /como-escrever-bem-para-o-seo-texto-e-contexto-da-palavra-chave-semantica/
enclosure:
  - |
    |
        https://www.example.com/video123.flv
        1270
        video/x-flv
        
categories:
  - SEO
tags:
  - Semântica
  - SEO
  - webwriting

---
Como escrever bem para o SEO não é um assunto bem explorado, mas muito mal conduzido. Vamos falar sobre a forma de escrever para se atingir bons resultados com SEO no Google.

## Texto e Contexto: a contextualização dos buscadores

Pois é, está aí uma coisa que deve ser entendida. O significado desse título é mais do que pensar em um texto coeso, com boa estruturação e voltado para um público alvo específico, até porque isso soa meio obvio. Mas vai além. Você já reparou como a web ainda é poluída por sites onde as palavras-chave são mal colocadas em seus textos e títulos?

Volta e meia a gente se depara com aquele site que fala a mesma palavra-chave umas 10 vezes, do mesmo jeito (igualzinha mesmo!) em tudo que é **<H>**. Não estou nem falando do puro Keyword Stuffing, mas de sites normais, onde o dono do site acha que quanto mais palavras-chave colocar, melhor ficará no ranking.

Nessas horas é que o seu conhecimento vai fazer a diferença. Hoje os buscadores são muito mais inteligentes e já não basta saber direcionar e contextualizar o leitor. Mais do que isso, temos que saber contextualizar os buscadores. A ideia é saber explorar de formas diferentes as palavras-chave e assim desenvolver o conteúdo relevante.

Antigamente as estratégias eram mais engessadas, muitas vezes focadas em um termo de busca. Mas nos dias de hoje, com o SEO crescendo muito, a ideia é mostrar ao buscador que você é especialista em determinado assunto.

## Webwriting

Webwriting, basicamente, é um conjunto de estratégias para desenvolver um texto com um conteúdo estrategicamente escolhido, que chame a atenção do usuário.

O que acontece é que não é só ir lá e escrever. Você deve focar na estratégia e em uma forma de contextualizar a palavra chave no seu texto.

[<img class="alignnone size-full wp-image-40003" alt="como escrever bem para o SEO - 4 passos" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/12/produção-de-conteúdo.png" width="817" height="315" srcset="uploads/2013/12/produção-de-conteúdo.png 817w, uploads/2013/12/produção-de-conteúdo-329x126.png 329w, uploads/2013/12/produção-de-conteúdo-588x226.png 588w, uploads/2013/12/produção-de-conteúdo-660x254.png 660w" sizes="(max-width: 817px) 100vw, 817px" />][1]

**1. Faça um Brainstorm**

Isso é essencial, se você procura uma forma de otimizar seu site para um termo definido de forma contextualizada, essa é uma grande sacada. Ao se definir um tema (que também pode ser feito pelo brainstorm) você pode levantar tópicos interessantes dessa forma.

**2. Estude, pesquise e tenha embasamento.**

Saber o que falar nem sempre é o desafio, mas saber sobre o que você vai falar é, de fato, muito importante. Seja o cara naquilo que você quer passar, domine o assunto. Não é legal escrever um artigo ou produzir um conteúdo para o seu site sem qualidade.  Portanto, estude muito, pesquise muito e tenha embasamento.

**3. Planejamento**

Uma fase legal! Aqui é onde você vai ditar as regras, escolher como distribuir o conteúdo. Pense em imagens relacionadas (sempre com boa qualidade, por favor). Você também pode pensar em vídeos e enriquecer seus tópicos e/ou parágrafos estrategicamente, deixando o conteúdo mais atrativo e interessante.

## Dicas para imagens

  * Procure imagens de alta qualidade.
  * Utilize imagens que realmente tenham a ver com o assunto. Seja responsável nessa escolha ;-).
  * Renomeie arquivo utilizando a palavra chave. Faça isso sem inventar, use a keyword mas em um contexto que represente bem a imagem.
  * Insira as imagens relacionadas no seu texto perto dos parágrafos que tratam do assunto.
  * Utilize legendas.
  * Cite os direitos autorais.

## Dicas para o texto 

  * Utilize listas em seu texto. É intuitivo e chama a atenção do usuário.
  * Parágrafos curtos  bem espaçados e com um fundo leve. Não cansem o usuário antes mesmo de ele começar a ler.
  * Seja objetivo.
  * Fuja de especificações.
  * Utilize a técnica da pirâmide invertida!

## Dicas para vídeos

  * Utilize vídeos não muito longos.
  * Utilize texto junto ao vídeo, não deixe sozinho na página.
  * Tente utilizar vídeos com boa qualidade.
  * Faça as marcações de Rich Snippet para conteúdo de vídeo:

<pre class="lang-html">&lt;div itemprop="video" itemscope itemtype="https://schema.org/VideoObject"&gt;

&lt;h2&gt;Video: &lt;span itemprop="name"&gt;Title&lt;/span&gt;&lt;/h2&gt;

&lt;meta itemprop="duration" content="T1M33S" /&gt;

&lt;meta itemprop="thumbnailUrl" content="thumbnail.jpg" /&gt;

&lt;meta itemprop="contentURL" content="https://www.example.com/video123.flv" /&gt;

&lt;meta itemprop="embedURL" content="https://www.example.com/videoplayer.swf?video=123" /&gt;

&lt;meta itemprop="uploadDate" content="2011-07-05" /&gt;

&lt;meta itemprop="expires" content="2012-01-30" /&gt;

&lt;object ...&gt;

&lt;param ...&gt;

&lt;embed type="application/x-shockwave-flash" ...&gt;

&lt;/object&gt;

&lt;span itemprop="description"&gt;Video description&lt;/span&gt;

&lt;/div&gt;

</pre>

[Para saber mais, visite o help da Google para Rich Snippets e Marcação dedados estruturados][2]

Agora é hora de escrever e ser feliz. Vamos às estratégias:

### Contextualização da palavra chave

Como eu falei lá no início do artigo, é complicado ficar manipulando o texto em função de uma keyword. Por isso a ideia da contextualização. Não utilize diversas vezes a mesma palavra chave em um texto ou parágrafo. Claro que você fará o básico de coloca-la em no seu **H1**, nos atributos alt das imagens (sem exageros), no título da sua página, entre outras. Mas no texto é diferente. Supondo que você quer otimizar **Locação de Brinquedos.**

Neste caso, você poderia variar a palavra chave e criar o contexto de forma bem legal, por exemplo:

  * Locar brinquedos.
  * Brinquedos que geralmente são locados.
  * Locação.
  * Brinquedos.
  * Aluguel de brinquedos.
  * Brinquedos alugados.
  * Pula pula para crianças.

Assim você consegue criar um texto legal, evidenciando e contextualizando a palavra chave. Veja:

[<img class="alignnone size-full wp-image-40004" alt="como escrever conteúdo para seo - contextualizando a palavra chave" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/12/palavra-chave-contextualizada.png" width="722" height="409" srcset="uploads/2013/12/palavra-chave-contextualizada.png 722w, uploads/2013/12/palavra-chave-contextualizada-296x168.png 296w, uploads/2013/12/palavra-chave-contextualizada-547x310.png 547w" sizes="(max-width: 722px) 100vw, 722px" />][3]

## Semântica

Esses dias [a Dani publicou um artigo aqui falando de semântica][4], muito legal e ela colocou muito bem o quanto as pessoas não escrevem o HTML da forma correta. No SEO o impacto disso pode ser devastador, pois o google presta muita atenção no seu código. E ajuda-lo (fazer a sua obrigação, na verdade!) pode ser um caminho mais curto e correto.

Utilize Strong para dar importância aos trechos mais importantes. Crie um padrão para botões e links. Estruture a navegação interna do site. Faça isso, mas faça de forma inteligente e bem feita. Faça o uso da Tag **<nav>** para mostrar ao buscador a sua navegação. Assim ele poderá ver que você se esforçou na montagem da arquitetura do site!

Utilize listas e utilize **<h2>** para escrever subtítulos (lembrando que o título principal é o **<h1>**).

Muitas vezes você tem um bom texto, um conteúdo de qualidade, mas não escreve direito o HTML da página. Com isso você deixa de usufruir da inteligência dos buscadores, que vão ler os dados estruturados, os alt texts das imagens, entre outros.

A sacada aqui não é ter um código validado pelo W3C, e sim algo correto, que melhore a usabilidade da página e escancare para o buscador um conteúdo bem feito.

## Conclusão

Conheçam bem o HTML, ou passem isso para alguém que sabe e oriente a sua equipe ou você mesmo a focar na qualidade, não na quantidade. Seja o mestre no assunto, entenda daquilo que você escreve. Seja objetivo e convincente para passar conteúdo relevante. Muita gente sabe muito, mas não transmite da forma correta. Seja criativo e lembre-se: Não especifique, conte uma história!

 [1]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/12/produção-de-conteúdo.png
 [2]: https://support.google.com/webmasters/answer/2413309?hl=pt-BR
 [3]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/12/palavra-chave-contextualizada.png
 [4]: https://tableless.com.br/semantica-padroes-e-o-que-voce-tem-a-ver-com-isto/