---
title: Como boas práticas de escrita de código podem influenciar em uma melhor rotina de trabalho
authors: Helder Burato Berto
type: post
date: 2016-09-17
url: /como-boas-praticas-de-escrita-de-codigo-podem-influenciar-em-uma-melhor-rotina-de-trabalho/
categories:
  - Código
  - Técnicas e Práticas
tags:
  - boas praticas
  - codigo
  - equipe
  - front-end

---
Observei que alguns itens estão me ajudando na rotina de trabalho, como obter um melhor tempo de produção e um melhor controle sobre o que estou fazendo.

São alguns hábitos simples que podem lhe ajudar muito. É apenas questão de implementar no seu dia a dia e demonstrar para a sua equipe (caso trabalhe em equipe) o quanto é mais organizado e produtivo trabalhar desta forma.

A seguir listei algumas técnicas que podem ajudar bastante no seu dia a dia como desenvolvedor front-end.

#### Style Guide

É um documento que contém estilos e padrões de um projeto, que podem ser utilizados para manter a pregnância do design e desenvolvimento.

Existem algumas metodologias que podem ajudar você no desenvolvimento desse <strong class="markup--strong markup--p-strong">Style Guide, </strong>como: <a href="https://getbem.com/introduction/" target="_blank">BEM</a>, <a href="https://github.com/necolas/idiomatic-css/tree/master/translations/pt-BR" target="_blank">IDIOMATIC</a>, <a href="https://primercss.io/scaffolding/" target="_blank">PRIMER CSS</a>, <a href="https://getbootstrap.com/css/" target="_blank">Twitter Bootstrap</a>.

#### Skeleton ou Estruturas Boilerplate

<a href="https://www.initializr.com/" target="_blank">Initializr</a>, <a href="https://github.com/helderburato/generator-hyapp" target="_blank">Gerador HyApp</a> + <a href="https://yeoman.io/" target="_blank">Yeoman</a> e <a href="https://html5boilerplate.com/" target="_blank">HTML5 Boilerplate</a>. Que são geradores de pequenas estruturas de diretórios para iniciar projetos em HTML/CSS/JS;

#### Font Ícones

<a href="https://fontawesome.io/" target="_blank">Font Awesome</a>, <a href="https://fontello.com/" target="_blank">Fontello</a>, <a href="https://icomoon.io/app/#/select" target="_blank">IcoMoon</a> são ótimas opções. No meu dia a dia costumo utilizar na maioria dos projetos o &#8220;Font Awesome&#8221; pela facilidade e padronização nos layouts da empresa em que trabalho;

#### Web Fonts

<a href="https://fonts.google.com/" target="_blank">Google Fonts</a> sem dúvidas é uma ótima opção e agiliza bastante quando utilizada nos layouts;

#### Task Runner

Tratando-se de automatizadores de tarefas os mais conhecidos são o <a href="https://gulpjs.com/" target="_blank">GulpJS</a> e o <a href="https://gruntjs.com/" target="_blank">GruntJS</a>. Costumo utilizar o Gulp pois foi o que mais me identifiquei, mas você pode escolher o que mais adequar ao seu projeto ou ao modo de trabalho de sua equipe.

### Será que isso influencia mesmo na rotina ou nos custos do produto final?

Segundo uma experiência direta da <strong class="markup--strong markup--p-strong">IBM </strong>e também de dados reunidos por pesquisadores que trabalham com centenas de empresas, percebe-se que a maioria das empresas acabam investindo <strong class="markup--strong markup--p-strong">25% </strong>a mais do orçamento no ciclo de vida do desenvolvimento para garantir a qualidade do software.

Além disso, <strong class="markup--strong markup--p-strong">30%</strong> dos custos de projeto para desenvolvimento de software estão associados a retrabalho e <strong class="markup--strong markup--p-strong">70%</strong> desse valor estão relacionados a erros de requisitos.

A qualidade de escrita de código influencia diretamente nos custos do projeto e da qualidade de vida do software.

<img class="alignnone size-full wp-image-56001" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2016/09/Group.png" alt="Group" width="1138" height="600" />

### Mente aberta para novas ideias

Sou totalmente aberto a novas ideias e sugestões naquilo que eu posso melhorar no meu dia a dia de trabalho, mas parece que nem todo desenvolvedor enxerga as observações no seu próprio código como algo bom, algo produtivo. E sim como uma crítica pessoal.

Lógico, todos nós temos dias difíceis, prazos curtos. E todo desenvolvedor que tem um pouco mais de experiência compreende muito bem como é correr contra o tempo para lançar um novo produto ou <em class="markup--em markup--p-em">feature</em>. Mas creio que isso não seja motivo para excluir a possibilidade de mudança, de tentar o novo. <strong class="markup--strong markup--p-strong">O que seria do mundo se ninguém tivesse tentado algo diferente?</strong>

Me deparo fazendo esse tipo de pergunta quase que diariamente, costumo estar sempre dando uma olhada em novas tecnologias, mesmo que seja por brincadeira. Mas me sinto frustrado quando não é possível aplicar nas equipes ou em projetos. Entendo que nem sempre é possível sair utilizando tudo que é novo, ainda mais quando nos deparamos com coisas novas todos os dias no nosso ramo, mas não podemos ficar presos ao velho para sempre.

Tire 1 ou 2 dias agora para escrever bem seu código e no futuro você verá como o trabalho ficará mais fácil ao entrar novos membros na equipe e for necessário explicar como as coisas funcionam.

**Padrões são bons!**

Essa frase parece que assusta muitas pessoas, mas diferente de medo, ela deveria emitir a sensação de algo bom, pois é o que ela traz com o tempo.

Agradeço a todos que tiraram um tempo e leram o texto, e qualquer sugestão de melhoria estou a disposição, obrigado!
