---
title: Como aumentar a autoridade de um site ou blog através de links quebrados
authors: Adriano Luz
type: post
date: 2016-08-28
url: /como-aumentar-autoridade-de-um-site-ou-blog-atraves-de-links-quebrados/
categories:
  - Wordpress
tags:
  - Autoridade
  - da
  - PA

---
## Aumentar Autoridade do um site

<div align="center">
  <img class="size-full wp-image-55928 aligncenter" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2016/08/autoridade2.jpg" alt="autoridade2" width="700" height="329" />
</div>

&nbsp;

Aumentar Autoridade de um site ou blog é algo que pode fazer com que seus resultados cresçam bastante nas buscas do Google.

Existem diversas empresas no mercado especializadas em SEO, que oferecem ferramentas e métricas que visam mensurar a autoridade de sites e páginas.

A mais conhecida de todas é o <a href="https://moz.com" target="_Blank">Moz</a>, que possui as métricas DA (Domain Autorithy) e PA (Page Autorithy).

Essa autoridade é um calculo matemático baseado em estudos realizados sobre o algoritmo do Google.

Embora ela não seja 100% fiel ao que o Google utiliza para posicionamento, ela é a base utilizada por profissionais de SEO.

E para calculo desta autoridade, são avaliados basicamente os backlinks e sua qualidade, resultando em uma nota que vai de 0 a 100.

Pois bem, toda essa introdução é basicamente para lhe mostrar a importância que tem aumentar sua autoridade.

Isso influencia diretamente no posicionamento das suas páginas no Google.

Nesse artigo eu vou te ensinar como aumentar a autoridade de seu site ou blog usando os links quebrados, para você que usa a plataforma WordPress.

&nbsp;

## Mas afinal, como funciona a estratégia de aumentar autoridade com Links quebrados?

Com o passar dos tempos, especialmente blogs e sites que já possuem alguns anos online, a tendência é que a quantidade de links que apontam para páginas suas que não existam sejam muito grandes.

Isso porque muitos donos de sites e blogs que linkaram para seus conteúdos não adicionaram a URL correta.

Isso muitas vezes chega a totalizar 10% ou mais dos links que apontam para seus conteúdos.

Além disso, com o tempo muitas vezes optamos por retirar do ar algumas páginas, por qualquer motivo que seja. Ou por que o conteúdo ficou desatualizado ou por qualquer outra decisão estratégica que tenha tomado ao longo dos anos do site no ar.

Quando fazemos isso, todos os links que apontavam para esta página ficam quebrados e você perde esta autoridade.

A estratégia de utilizar estes links quebrados consiste basicamente em fazer um redirecionamento 301 de todos os links quebrados para a página principal de nosso site ou para qualquer outra página.

Para quem ainda não conhece, o redirecionamento 301 (permanente) é uma forma de dizermos ao Google que aquela página mudou de endereço de forma definitiva.

Com isso, o Google transfere toda a autoridade da página antiga para a nova página que você apontar em seu redirecionamento.

&nbsp;

## Mas qual a relação com o Wordpress?

O WordPress é a plataforma CMS mais utilizada para Criar Sites e <a href="https://afiliados-na-web.com/como-criar-um-blog" target="_blank">Criar Blogs</a>.

E ela possibilita a instalação de plugins que adicionam funcionalidades a blogs e sites.

Através destes plugins conseguiremos resolver a maioria dos problemas de nossas páginas.

Pensando nesta questão de links quebrados, existem várias ferramentas na qual uma delas pode resolver nosso problema.

&nbsp;

## Mas como fazer isso no WordPress? Não é impossível prever todos os links quebrados que apontam para nosso site?

Sim e não. De certa forma é praticamente impossível prever todos os links quebrados que apontam para nossas páginas.

Até porque estamos considerando todas as urls erradas que outros donos de sites e blogs criaram para nossas páginas.

E para criarmos os redirecionamentos manualmente através do .htaccess seria totalmente desumano.

Porém existe um plugin que pode ser adicionado em seu wordpress, em Plugins ==> Adicionar Novo, chamado 404 Redirection.

Este plugin cria automaticamente um redirecionamento 301 para todas as páginas que tentarem acessar em nosso site e não forem encontradas.

Dessa forma sempre que criarem qualquer link que não exista uma página em nosso site automaticamente aproveitaremos a Autoridade (Juice) que esta sendo transferido para aquela página, transferindo esta autoridade para a página principal do site.

Dependendo do site e da quantidade de backlinks isso pode fazer uma diferença muito grande nos resultados.