---
title: Começando a programar
authors: Lenadro TK
type: post
date: 2018-10-22
excerpt: Conheça referências e caminhos curtos para entrar nesse mundão de possibilidades.
image: https://cdn-images-1.medium.com/max/800/1*XthWUtD_NU-VJ7ESA2qX3A.jpeg
categories:
  - Mercado
  - Técnicas e Práticas
tags:
  - Carreira
  - CSS
  - Javascript
---

Quando comecei a compartilhar [minha jornada de aprendizado no mundo da
programação](https://medium.com/the-renaissance-developer) e como eu [hackeio minha educação](https://medium.com/the-renaissance-developer/how-i-hack-my-education-354fb5b8a025),
as pessoas da comunidade começaram a se interessar e me perguntar 'como começar a programar'.

Eu realmente quero ajudar futuros desenvolvedores em suas jornadas. A quantidade de perguntas inspirou a escrever esse artigo.

Então peguei um tempo para pensar na minha jornada e troquei ideia com
desenvolvedores experientes sobre programação, como começar, sobre carreira e
todas essas coisas interessantes que todo mundo quer saber.

Esse artigo tem histórias e muitos conselhos práticos para você ficar inspirado,
motivado e dar o primeiro passo no mundo da programação.

Espero que te ajude muito!

# A Mentalidade

Minha **dica número #1** é **aprenda porque você curte, porque você acha interessante, ou ache que é simplesmente útil** (e realmente é!!).

Por que eu falo isso? Eu sou muito fã da frase `"do what you are passionate
about"`. Parece cliché total, mas sempre funcionou pra mim. Quando você começa a
aprender a programar, percebe que é erro atrás de erro, frustração atrás de
frustração. Errar e encontrar uma solução é parte do processo de aprendizado da
programação.

> Make it wrong. Make it works. Make it right. Make it fast. Just make it.

Fazer funcionar é difícil quando estamos começando. A paixão e o interesse
ajudam demais você ser consistente e disciplinado no processo de aprendizado.

Não é apenas com paixão que você vai conseguir aprender a programar, muito longe
de falar isso. Mas o ponto é que facilita demais quando você curte o processo,
quando você curte o aprendizado. Porque ele é duro e vai exigir de você ser
disciplinado, paciente, consistente.

> It is not a sprint. It is a long long marathon.

Lembre-se: não é uma corrida de tiro. É uma loooonga maratona. Não espere
aprender tudo da noite pro dia.

![](https://cdn-images-1.medium.com/max/800/1*TWEjK-8fXse8_4lyz-2YRA.png)
<span class="figcaption_hack">Teach Yourself C++ in 21 Days ([source](http://abstrusegoose.com/249))</span>

# Dica número #2: continue aprendendo

Como desenvolvedor de software, um dos meus grandes desafios é conseguir
acompanhar o que está surgindo no mundo de tecnologia: novas bibliotecas como
[ReactJS em 2013](https://en.wikipedia.org/wiki/React_(JavaScript_library)),
aplicações web como
[SPA](https://en.wikipedia.org/wiki/Single-page_application),
[PWA](https://en.wikipedia.org/wiki/Progressive_web_app), e as novas `hypes`:
Machine Learning, Inteligência Artificial, criptomoeda (Blockchain blockchain
blockchain!), e por ai vai.

Não estou falando que temos que estudar T-U-D-O e nos sobrecarregar. Meu ponto é
que muitas coisas são criadas muito rápido no mundo de tecnologia, então temos
que abraçar a ideia e a mentalidade de `lifelong learning`.

E falando sobre **se sobrecarregar**, aqui vai à **dica #3**: **tente não se
sobrecarregar**. Você não precisa começar com os conceitos mais avançados ou
pegar o livro mais denso sobre algoritmos. Comece com o famoso `Hello World`.
Comece aprendendo os conceitos básicos.

Uma analogia: quando você quer perder peso, você não começa com uma corrida de
maratona. Ao invés disso, você começa aos poucos, com uma caminhada de 1km
talvez. E vai aumentando o seu ritmo gradativamente.

E é a mesma coisa com programação. Você não precisa programar e estudar em todo
o seu tempo livre, mudando completamente sua rotina.

Vá de pequenas mudanças, mas faça regularmente. Consistência é uma prática
importante no aprendizado. Um código por vez.

Não se compare com `desenvolvedores experientes` ou os `famosos unicórnios`, ou
até aqueles chamados de `10x engineers`. Esse é a **dica #4**. Primeiramente que
não é nada justo se comparar dessa forma. Segundo que você está apenas
começando. Mantenha-se focado na sua jornada, no seu aprendizado.

> Don’t compare! You’ll never be happy with your life. The grass is always
> greener.

Se você achar outro profissional foda, ao invés de se comparar a ela, tenha essa
pessoa como inspiração, como motivação (e talvez como mentora).

É muito fácil se comparar com seus colegas, mas isso apenas aumentar aquela
sensação de [síndrome do
impostor](https://en.m.wikipedia.org/wiki/Impostor_syndrome) dentro de você. Não
deixe isso abalar a sua jornada.

Prática é a chave de tudo. Encontre maneiras de aprender conceitos e
praticá-los. Essa é **dica #5**. Construir a sua base de conhecimento com
conceitos e teorias é importante, mas seja prático. Tente algo prático.
Experimente. Nós vamos voltar nesse tópico mais para frente, mas lembre-se:
prática é a chave!

# Teoria & Conceitos

Já digo que é muito importante entender conceitos básicos de programação e
construir uma base sólida. Se você está na faculdade agora, está ótimo!
Faculdades são “boas” em ensinar conceitos básicos e teorias. Se você está
cursando Ciência da Computação, provavelmente que você teve/terá aulas de
`Algoritmos & Estrutura de Dados`. Se você não está na faculdade, relaxa. A
internet tá aqui pra ajudar!

Quando eu comecei, aprendi por 2 cursos online:
[Codecademy](https://www.codecademy.com/) & [CS50 at
Harvard](https://cs50.harvard.edu/)**.**

Nesses cursos, aprendi o básico com `Python` no Codecademy e `C`. Mas a minha
opinião é que você precisa apenas começar. Escolha uma linguagem de programação,
seja ela Python, C, Java, JavaScript, Ruby, etc. E comece a entender as coisas
básicas: o que são `variáveis`, `if-else`, `loops`, `estrutura de dados`?

> [Be language
> agnostic](http://www.gayle.com/blog/2014/07/09/15-pieces-of-career-advice-software-developers-should-follow). Language is just a tool. It’s valuable to know a language deeply, but it’s also valuable to be learning new things. The best developers tend not to identify as a ____ developer. — Gayle Laakmann McDowell

Provavelmente, quando você escolher um curso, ele vai te ensinar em uma
linguagem de programação específica. Mas nada de stress! Foque nos conceitos
básicos (e talvez você se apaixone pela linguagem, assim como aconteceu comigo e
[Python](https://medium.freecodecamp.org/learning-python-from-zero-to-hero-120ea540b567) & [Ruby](https://medium.freecodecamp.org/learning-ruby-from-zero-to-hero-90ad4eecc82d))

# Por que eu escolhi esses cursos?

Quando eu tava pesquisando sobre como começar a programar, eu queria MUITO
entender conceitos, mas também ser bastante prático. `CS50` me pareceu uma ótima
escolha para construir a minha base de entendimento sobre os conceitos básicos
de programação. David J. Malan é um dos melhores professores que tive na minha
vida. By far.

E `Codecademy` me ajudou muito a ser prático. Em toda lição aprendida eu
precisava exercitar esses conceitos. Então tinha muito treino. Codar, codar e
codar. Lembra da **dica #5**? Encontre maneiras de aprender conceitos e ser
prático.

# Aqui vão outros recursos que são de ótima qualidade:

[Introduction to Computer
Science](https://br.udacity.com/course/intro-to-computer-science--cs101/) do
Udacity. Esse curso cobre praticamente tudo o que você precisa para começar a
entender programação. O `Bonus point` desse curso é que toda etapa de
aprendizado, você sempre tem o `practice time`, quando você pode exercitar a
teoria e os conceitos que você aprendeu.

[Introduction to
Algorithms](http://courses.csail.mit.edu/6.006/fall11/notes.shtml) do MIT vai te
ensinar muito sobre pensamento algorítmico. Entender algoritmos e como eles
funcionam é uma das coisas mais importantes quando você está começando essa
jornada. Existem 2 bíblias de algoritmos que é o [Introduction to
Algorithm](https://www.amazon.com/Introduction-Algorithms-3rd-MIT-Press/dp/0262033844)
do CLRS e
[Algorithms](https://www.amazon.com/Algorithms-4th-Robert-Sedgewick/dp/032157351X/ref=pd_sim_14_3?_encoding=UTF8&pd_rd_i=032157351X&pd_rd_r=Y548PDB04MJN6BH8MYFB&pd_rd_w=UgKc5&pd_rd_wg=CvgEt&psc=1&refRID=Y548PDB04MJN6BH8MYFB)
do Robert Sedwick.

A partir daqui você provavelmente vai começar a se sobrecarregar com os
infinitos recursos que a internet te possibilita. Todo dia um curso novo nasce,
artigos são criado, e os vários podcasts que você ainda precisa ouvir. Mas
calma. Apenas calma. Você não precisa se atropelar nos estudos, não precisar ler
todos os novos artigos ou ver todos os novos cursos (To olhando falando de você
Udemy!).

Apenas respire, escolha um curso, aprenda, pratique, construa a sua confiança.
Lembre-se, tudo isso é uma jornada e as coisas não acontecem da noite pro dia.
Uma linha de código de cada vez :)

# Treinando, Praticando, Programando, Construindo

Pratique, pratique e pratique. Não tem como não dizer o quanto praticar é
importante quando você está começando a programar.

> Code. A lot… The best way to be a great coder is to just practice — a lot. —
> [Gayle Laakmann
McDowell](http://www.gayle.com/blog/2014/07/09/15-pieces-of-career-advice-software-developers-should-follow)

Praticar não apenas faz você um desenvolvedor melhor, mas também faz você ganhar
muita confiança nesse processo. A síndrome do impostor é real.

Como disse no começo desde artigo, vou tentar escrever sobre coisas que você
consegue pôr em prática facilmente.

Assim como fiz, você também pode começar com o
[Codecademy](https://www.codecademy.com/). É um ótimo conteúdo e tem uma
experiência bem legal, já que para todos os conceitos aprendidos, você põe em
prática.

Outro site muito legal é o [Hacker Rank](https://www.hackerrank.com/). Esse site
tem muitas opções de linguagem de programação para você poder escolher com qual
você quer começar. Além disso, tem exercícios divididos por domínios.

Eu gosto bastante do Hacker Rank porque você consegue exercitar bastante o
pensamento de como resolver problemas computacionais. Basicamente você receber
vários dados de entrada e seu algoritmo precisar passar todos os testes.

<span class="figcaption_hack">All Hacker Rank Track</span>

Outra coisa que sou apaixonado são as competições de programação. Participei por
3 anos na faculdade em competições do tipo [ACM ICPC](https://icpc.baylor.edu/).

Basicamente existe uma porção de problemas, e você precisa implementar um
algoritmo que resolva cada um. Participar dessas competições me fez ganhar muita
confiança em programação, e hoje me sinto um desenvolvedor mais preparado. Tenho
um [repositório Algorithms no GitHub](https://github.com/LeandroTk/algorithms),
que fica todo meu treinamento e problemas que resolvi.

Sou heavy user do Quora, e um dia li uma ótima resposta da Veni Johanna sobre
“*Does competitive programming really help in improving your knowledge and skill
set as a developer?*”.

Vou listar aqui as skills que a gente ganha e aprende no processo de se preparar
para competições de programação:

1.  Você desenvolve o hábito de converter e modelar um problema específico para um
mais abstrato.
1.  Você fica acostumado à memorização de padrões e a procurar padrões no seu banco
de padrões.
1.  Você sabe como se concentrar e performar em um ambiente com pressão.
1.  Você tem consciência e confiança na sua própria habilidade.
1.  Você aprende a gerenciar seu tempo, especialmente em termos de raciocínio e
hábitos de programação.
1.  Você fica habituado a problemas bem definidos.
1.  Você fica habituado a ter um objetivo em mente.

Eu curti muito os comentários dela. Se tiver interesse dá uma olhada na [versão
completa da resposta
dela](https://www.quora.com/Does-competitive-programming-really-help-in-improving-your-knowledge-and-skill-set-as-a-developer-Are-there-better-things-that-would-help-one-amass-greater-knowledge-in-less-time/answer/Veni-Johanna).
Você deveria. É um conteúdo muito relevante!

Para sermos bem práticos, vou listar alguns sites ótimos para começar seu
aprendizado e treino desde do `dia 0`.

* [Codeforces](http://codeforces.com/): é um dos sites mais conhecidos em termos
de competição de programação. Tem vários problemas, desde os básicos,
considerados fáceis e para iniciantes, até os mais avançados e que exige
conhecimento de algoritmos e estrutura de dados avançados. Bonus point: para a
maioria dos problemas existe o Editorial. O autor do problema escreve como você
deve abordar e resolver o problema — qual algoritmo e estrutura de dados
aplicar.
* [Topcoder](https://www.topcoder.com/): esse site é bem similar ao Codeforces em
termos de qualidade de problemas e o editorial. Ele também é muito conhecido
pelos seus
[tutoriais](https://www.topcoder.com/community/data-science/data-science-tutorials/).
Cada tutorial ensina uma técnica, algoritmo ou estrutura de dados diferente.
* [Hacker Rank](http://hackerrank.com/): como disse ali em cima, Hacker Rank tem
vários problemas diferentes organizados por domínios como `Algorithms`, `Data
Structures`, `Mathematics`, `Programming Languages`, etc. A UI e UX do site é um
plus. Ele é bonito e bem fácil de usar. Eu usei bastante esse site pra melhorar
minhas skills de Python, por exemplo.
* [CodeNation](http://codenation.com.br/): desafios de programação voltados à
desafios da vida real, para preparar a galera pra detonar no mercado.
* [Hacker Earth](https://www.hackerearth.com/) e [Code
Chef](https://www.codechef.com/) são outros dois sites interessantes.

Agora você pode escolher um desses site e já começar a se divertir! :)

# Desenvolvendo projetos

Depois de ter estudados os conceitos básicos e praticado muito, comecei a me
sentir bem travado. Então comecei a pesquisar como eu poderia ir para o próximo
nível. Desenvolver projetos foi a resposta pra mim. Logo, aprendi os fundamentos
da web: `HTML`, `CSS`, `JavaScript` e um framework web. Naquele tempo, acabei
aprendendo `Ruby on rails` (Framework Ruby) e `Django` (Framework Python).

* Meu primeiro projetinho foi o [meu próprio
site](http://leandrotk.github.io/tk/).
* Depois desenvolvi site pro restaurante da minha mãe.
* E por final, 2 joguinhos: jogo da velha & jogo da cobrinha.

Todos os sites eram estáticos, ou seja, eu não lidei com a parte do servidor,
apenas brincando com a parte do front: `HTML`, `CSS` e `JavaScript`.

Com o tempo, fui ganhando mais confiança e me senti preparado para desenvolver
um site full stack, com servidor, usando um framework web e tudo mais. Então
comecei a construir uma livraria online (tipo a Amazon quando tava começando).

Esse projetinho consistia em ter um dashboard no admin: basicamente o user com
`role` de `admin`, poderia adicionar novos produtos, editá-lo, deletá-lo, etc…
enfim, todo o `CRUD` que conhecemos.

A parte pública teria o Sign Up, Login, Listagem de livros e a compra. Consegui
terminar esse projetinho e fiquei muito feliz com o resultado. Mas mais
empolgado durante todo o processo de desenvolvimento. Foi duro e desafiador pra
mim naquele tempo, mas aprendi demais.

Primeiro produto de software que desenvolvi na vida real foi toda a landing page
da [aLavadeira](https://www.alavadeira.com/), para a versão mobile responsiva.

E hoje desenvolvo a parte WEB da [Worldpackers](http://worldpackers.com/) e a
API que os apps iOS e Android consomem. E que hoje tem mais de 1 milhão de
viajantes e anfitriões em todo o mundo.

*****

Meu grande amigo Douglas tem uma história bem legal de como ele começou a
programar e desenvolver apps. Ele aprendeu os conceitos básicos na faculdade,
mas desenvolver aplicativos era uma coisa que ele sempre teve curiosidade.
Tentou algumas vezes criar aplicativos Android, mas logo acabava desistindo.

> “I simplesmente não sabia como começar, porque eu tinha muitas coisas a
> aprender, e não me sentia preparado para desenvolver um app. Tinha tantas coisas
diferentes pra aprender, que eu me senti travado tentando entender o que era o
mais certo ou a melhor maneira. As 2 coisas mais importantes nesse estágio eram:
1. Defina o um objetivo simples e aprenda o básico para alcançar esse objetivo.
2. Evite o perfeccionismo. Apenas faça.” — Doug

Ouvindo a história do Doug, eu senti que todas as pessoas que estão começando,
de certa forma, se sentem travadas em alguma parte do processo de aprendizagem.
E é super normal se sentir frustrado ou não entender como começar.

> “I pedi ajuda a um amigo meu, que já tinha desenvolvido um app. Perguntei se ele
> sabia a melhor maneira de fazer coisa específica e a verdade é: ele não sabia,
mas me senti mais seguro sabendo que a gente tava desenvolvendo do mesmo jeito.”
— Doug

Se você tem colegas ou amigos que tenham mais experiência que você, peça ajuda,
provavelmente eles irão de ajudar de alguma forma. E de certa forma é legal como
esses *“mentores”* nos inspiram e motivam a começar e tentar novamente.

Outro aprendizado que a gente pode pegar da história do Doug: ele definiu um
objetivo de fazer um app o mais simples na primeira vez.

> “Eu desenvolvi a [primeira versão do
> app](https://play.google.com/store/apps/details?id=com.iacovelli.usp) e
publiquei na Play Store. Depois eu aprendi mais coisas sobre Java, Kotlin e
Android e pude implementar mais features no app. Mas foi um processo que me
consumiu bastante. Eu precisei de bastante persistência.” — Doug

É tão legal quando a gente ta na curva de aprendizado em que a gente se sente
confiante e apenas `no flow` para continuar aprendendo e desenvolvendo. Mas
concordo totalmente com o Doug, quando você começa a aprender uma coisa nova,
precisa de muita persistência para que o seu aprendizado seja consistente.

Hoje o Doug é um dev Android. Já publicou 2 projetos pessoais (apps Android) na
Play Store, liderou o app Android da Worldpackers e hoje trabalha na Youse.

> “I learned how to program by working on lots of different website projects
> starting from a pretty young age. The best way to learn a new skill is to
practice, practice, practice. It doesn’t matter what you build, as long as you
pick something and start.” — Feross Aboukhadijeh

Na [resposta do Feross no
Quora](https://www.quora.com/How-did-Feross-Aboukhadijeh-learn-to-program-And-if-he-could-do-it-over-again-what-would-he-do-different-What-language-would-he-start-with/answer/Feross-Aboukhadijeh),
ele conta como aprendeu a programar construindo muitos projetos pessoais. A
história dele é inspiradora. Você acaba percebendo como ele mantem um progresso
no seu aprendizado, projeto por projeto. A dica dele pra aprender a programar:

* Faça projetos pessoais.
* Compre e leia livros de programação.
* Faça projetos pessoais.
* Veja disciplina de ciência da computação.
* Faça projetos pessoais.
* Leia blogs de tecnologia.
* Faça projetos pessoais.

[Veja a história completa
dele!](https://www.quora.com/How-did-Feross-Aboukhadijeh-learn-to-program-And-if-he-could-do-it-over-again-what-would-he-do-different-What-language-would-he-start-with/answer/Feross-Aboukhadijeh)

# Aqui uma lista de projetos pessoais que você pode fazer.

Hora de ajudar você a desenvolver coisas!

* Se você é um gamer, talvez você curta começar com `jogo da velha`, `sudoku`, ou
o `jogo da cobrinha`.
* Se você curte dados, talvez seja legal aprender a fazer [web
scraping](https://en.wikipedia.org/wiki/Web_scraping), ou brincar com a API de
dados de ações para analisar gráficos.
* Se você quer aprender mais sobre frontend, desenvolva seu próprio website.
* Se você quer desenvolver um produto completo, comece com uma livraria online, um
blog, or um wikipedia.

A lista vai longe. Tem [essa outra lista](https://github.com/karan/Projects) que
vai te dar mais opções pra escolher qual projeto você quer começar. Mas eu
concordo com o Ferros, não importa o que você vai desenvolver, contanto que você
escolha uma e comece. Então comece a desenvolver! Você vai ter problemas, vai
ficar travado, mas vai aprender DEMAIS!

# Eu sei que é bem desafiador manter seu projeto andando.

Para você se manter responsável, achei um projeto bem interessante que você faz
todo dia. Chama `100 days of code`. Aqui um
[template](https://github.com/Kallaway/100-days-of-code) pra começar. É bem
simples, você escreve um jounal sobre o seu progresso e seus pensamentos sobre o
projeto.

E realmente ajuda. Você se mantem responsável pelo projeto, mantem o projeto
andando e faz um track do seu progresso. Tudo em um repositório no GitHub
público, porque assim você pode compartilhar com seus amigos e a comunidade.
Colabore com a comunidade do GitHub, compartilhe e inspire outras pessoas.

Procurando sobre histórias desse projeto de `100 days of code`, achei o “[How I
Coded Everyday for 365
Days](https://hackernoon.com/how-i-coded-everyday-for-365-days-67ebb5fc7ae)” da
Emily. É uma história inspiradora de muita disciplina e vontade de aprender a
programar.

É bem legal como ela escreve sobre o seus projeto e como ela aprender durante o
ano inteiro. Esses projetos foram desde apps iOS usando Swift, até
desenvolvimento web usando uma stack completa (HTML, CSS, JS, Flask — framework
web para Python). Leia o [artigo
completo](https://hackernoon.com/how-i-coded-everyday-for-365-days-67ebb5fc7ae).

Continue motivado. Continue construindo. Continue codando! :)

# Compartilhando alguns outros recursos

Ótimos websites, artigos e vídeos:

# Websites

* [freeCodeCamp](https://www.freecodecamp.org/) é totalmente focado em
desenvolvimento web e JavaScript (apesar de já ter vista algumas coisas de
Python). É totalmente de grátis! (YAY!)
* [Udemy](https://www.udemy.com/), [CodeSchool](https://www.codeschool.com/) e
[Khan Academy](https://www.khanacademy.org/) sites bem similares. Cada um tem
uma boa variedade de cursos. Khan Academy é free, o CodeSchool é um mix (alguns
cursos free e outros pagos), e Udemy é pago.
* E não esqueça os MOOCs: [Udacity](https://www.udacity.com/),
[Coursera](https://www.coursera.org/), e [edX](https://www.edx.org/). Todos eles
são sites com ótimos cursos. Só vai! :)

# Siga pessoas no Twitter

* Se você tem interesse em Data Science e Machine Learning, Andrew Ng é a pessoa
certa! E os brazucas `@jesstemporal`, `@leleportella`, e Fernando Masanori.
* Para coisas de programação, eu curto ler tweets do DHH (Ruby on Rails), Dan
Abramov (Redux), Tracy Chou (ex-Quora, Pinterest), Quincy Larson (freeCodeCamp),
Preethi Kasireddy (Blockchain), Dan Bader (Real Python), The Practical Developer
(dev.to). E claro, os brazucas Eduardo Cuducos, Elton Minetto, @w_oliveiras,
Henrique Bastos, e a lista vai loooonge!

# Pessoas que estão documentando a sua jornada de aprendizado no Medium

* [How To Successfully Teach Yourself How To
Code](https://medium.freecodecamp.org/successfully-teaching-yourself-how-to-code-f6aac23db44a)
da Lydia Hallie
* [How I went from fashion model to software engineer in 1
year](https://medium.freecodecamp.org/how-i-went-from-fashion-model-to-software-engineer-in-1-year-a7399a40d9e7)
da Madison Kanna
* [BaseCS](https://medium.com/basecs) da Vaidehi Joshi
* [Here’s Why Learning How To Code Is So
Hard](https://medium.com/the-mission/heres-why-learning-how-to-code-is-so-hard-and-what-to-do-about-it-3d6fda152409)
do Kevin Kononenko
* [I Want to Learn Programming but I Don’t Know where to
Start](https://codeburst.io/i-want-to-learn-programming-but-i-dont-know-where-to-start-80dd2d55e1fd)
da Robyn Silber

# Vlogs & Canais no YouTube

Eu gosto bastante de assistir vlogs e ver o lifestyle das pessoas no YouTube.

* [Fun Fun Function](https://www.youtube.com/channel/UCO1cgjhGzsSYb1rsB4bFe4Q) é o
canal Mattias Petter Johansson, ex-dev do Spotify. Ele começou o canal dele
falando sobre JavaScript e hoje ele fala sobre desenvolvimento de software no
geral. Eu gosto bastante como ele aborda cada tópico e como explica de uma forma
divertida.
* [Mayuko](https://www.youtube.com/user/hellomayuko) é uma dev iOS que trabalha no
Patreon. Ela fala sobre desenvolvimento, carreira e lifestyle.
* [CS Dojo](https://www.youtube.com/channel/UCxX9wt5FWQUAAz4UrysqK9A) é bem focado
em programação e dicas para entrevistas, algoritmos e estrutura de dados. É o
canal do YK Sugishita, um ex-Googler do Canada.
* [Joma Tech](https://www.youtube.com/channel/UCV0qA-eDDICsRR9rPcnG7tw), pra mim,
é o canal mais engraçado nessa lista. Jonathan Ma é um data scientist no
Facebook. Ele faz vlogs sobre a vida de como é ser data scientist e conta suas
experiências nas Tech Giants.

# Como aprender programação sem se perder no mar de conteúdo disponível?

<iframe width="560" height="315" src="https://www.youtube.com/embed/Tv2x_8RIhXY" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen></iframe>


# That’s all!

Eu espero muito que esse artigo possa te ajudar na sua jornada e seu
aprendizado! Se divirta e programe muito!

Qualquer coisa, to lá no [Twitter](https://twitter.com/LeandroTk_) &
[Github](https://github.com/LeandroTk). ☺
