---
title: Carrinho de orçamento para WordPress
authors: Orivelton Cesar
type: post
date: 2016-05-09
url: /carrinho-de-orcamento-para-wordpress/
categories:
  - CMS
  - Wordpress
tags:
  - carrinho de orçamento
  - WooCommerce
  - Wordpress
  - YITH WooCommerce Request A Quote

---
O WordPress agiliza muito o trabalho de qualquer um que queira publicar online um site simples ou complexo e que tenha um painel administrativo decente. A comunidade é bem ampla e a plataforma dá passos firmes a caminho do e-commerce, cada vez mais ganhando espaço até mesmo entre as plataformas fechadas. E se você tem um negócio experimental ou não quer ter custos e nem dor de cabeça com transações bancárias, aqui vai uma dica de como ter um e-commerce com produtos em que o cliente faz o fluxo de orçamento e no final ele envia uma lista dos produtos de seu interesse com os dados para contato, vamos lá então.

## Exemplo de produto

Com o ambiente do wordpress instalado, seu tema precisa ter compatibilidade com o plugin **<a href="https://br.wordpress.org/plugins/woocommerce/screenshots/" target="_blank">WooCommerce</a>**. Ele transforma seu tema em uma loja virtual e se integra sem problemas, tendo extensões gratuitas e  premium, caso não tenha um tema pago o <a href="https://wordpress.org/themes/author/woothemes/" target="_blank">diretório de temas do WooCommerce</a> te da algumas opções gratuitas, o resultado será um produto próximo a esse com o botão comprar.

<img class="alignnone  wp-image-53980" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2016/05/botao-comprar.png" alt="botao-comprar" width="643" height="368" />

Se você nunca viu o WooCommerce, nós já falamos muito sobre WooCommerce aqui no Tableless:

  1. [Lojas virtuais com WooCommerce][1]
  2. [Criando temas personalizados no WooCommerce][2]

## Configurações

O Plugin que faz a mágica chama-se <a href="https://wordpress.org/plugins/yith-woocommerce-request-a-quote/" target="_blank">YITH WooCommerce Request A Quote</a>, quando esse plugin é ativado o botão comprar é substituído por um texto que pode ser &#8220;**Solicitar um orçamento**&#8220;, as configurações são simples e intuitivas, veja só;

No painel administrativo do wordpress iremos acessa as configurações do plugin.

<img class="alignnone size-full wp-image-53982" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2016/05/acesso-painel.png" alt="acesso-painel" width="160" height="127" />

O próximo passo será fazer a customização em que a versão gratuita disponibiliza em configurações gerais.

<img class="alignnone  wp-image-53984" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2016/05/passo-a-passo.png" alt="passo-a-passo" width="745" height="260" />

**1 &#8211; Request Quote Page**

<p style="padding-left: 30px">
  É a página que será adicionado o formulário para pedir o orçamento.
</p>

**2- Tipo do botão**

<p style="padding-left: 30px">
  Você pode escolher botão ou um link.
</p>

**3- Botão/Link texto**

<p style="padding-left: 30px">
  Esse campo você pode adicionar o texto a ser exibido no botão ou link que escolheu.
</p>

**4 &#8211; Ocultar botão &#8220;Adicionar ao carrinho&#8221;.**

<p style="padding-left: 30px">
  Esse é um dos passos mais importante para o plugin funcionar, marque a opção <strong>Ocultar botão &#8220;Adicionar ao carrinho&#8221;.</strong>
</p>

Veja o resultado, o botão é substituído pelo texto que você customizou nas configurações gerais.

<img class="alignnone  wp-image-53985" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2016/05/pedido-de-orcamento.png" alt="pedido-de-orcamento" width="653" height="397" />

O cliente clicou no botão solicitar orçamento aparecerá uma mensagem avisado que o produto foi adicionado a lista de orçamento.

<img class="alignnone size-full wp-image-53986" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2016/05/click-botao.png" alt="click-botao" width="644" height="412" />

Em **visualiza na lista** o cliente será levado para uma página para ele vai preencher um formulário com os dados de contato.

<img class="alignnone  wp-image-53987" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2016/05/finalização.png" alt="finalização" width="748" height="417" />

## Recebendo o formulário no e-mail

Após o envio do pedido você receberá no seu e-mail cadastrado nas configurações do WooCommerce  o orçamento dos produtos e os dados do cliente, com esses dados você pode fazer o primeiro contato com seu cliente e quem sabe fechar o negócio.

## Última dica

Essa é uma forma bem econômica de avaliar seu negócio se vai mesmo pegar na internet e ir fazendo os ajustes para cada vez converter mais vendas para seu negócio. Alguns ajustes como informações claras sobre o produto, formas de pagamento, prazo de entrega, recomendações de clientes que já compraram e reduzir a quantidade de cliks até a finalização da compra é um ponto decisivo para o cliente efetuar ou não a compra do seu produto, essas são algumas dicas básicas para ter sucesso com seu e-commerce.

 [1]: https://tableless.com.br/lojas-virtuais-com-woocommerce/
 [2]: https://tableless.com.br/lojas-virtuais-com-woocommerce-ii-criando-temas-personalizados/