---
title: Bootstrap 4 Alpha
authors: Isaque Melo
type: post
date: 2015-08-27
excerpt: O framework Bootstrap chega na versão 4 (alpha) com pré-processador Sass e outras mudanças.
url: /bootstrap-4-alpha/
categories:
  - Artigos
  - Geral
  - SASS
  - Traduções
tags:
  - bootstrap
  - SASS

---
Já faz um tempo que o Bootstrap vem dominando a web. Dificilmente vemos um desenvolvedor que não o conheça, e boa parte da comunidade web já ouviu falar ou já usou o framework.

Agora a equipe do Bootstrap <a href="https://blog.getbootstrap.com/2015/08/19/bootstrap-4-alpha/" target="_blank">anunciou</a> sua nova versão, o **Bootstrap 4 Alpha**.

[<img class="alignnone wp-image-50861 size-full" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/08/bs4-alpha.png" alt="Homepage do Bootstrap 4 Alpha" width="2360" height="1588" />][1]

O framework está repleto de novidades. Algumas delas são:

## Mudança de Less para Sass

O Bootstrap compila mais rápido do que nunca &#8211; graças a Libsass &#8211; e agora se juntaram a esta grande e crescente comunidade de desenvolvedores Sass.

## Melhoria no sistema de Grids

Foi adicionado uma nova grid, que causará grande melhora nos dispositivos móveis. Também ocorreu uma remodelagem completa nos _mixins_ semânticos.

## Novas opções para personalização

<span id="ouHighlight__33_42TO37_45" class="highlight">Ao invés de </span><span id="ouHighlight__44_53TO47_53" class="">separar </span><span id="ouHighlight__81_89TO79_88" class="">gradientes</span><span id="noHighlight_0.481113150017336">,</span> <span id="noHighlight_0.6814724979922175"></span><span id="ouHighlight__92_102TO91_100">transições</span><span id="noHighlight_0.811446403618902">,</span> <span id="noHighlight_0.30436457856558263"></span><span id="ouHighlight__105_111TO103_109" class="">sombras</span> <span id="noHighlight_0.6863153295125812"></span><span id="ouHighlight__114_116TO111_111" class="">e</span><span id="noHighlight_0.2496850637253374"> outras personalizações </span><span id="ouHighlight__123_124TO124_127">para</span> <span id="noHighlight_0.19514952460303903"></span><span id="ouHighlight__126_126TO129_131" class="">uma</span> <span id="noHighlight_0.7088381128851324">folha de </span><span id="ouHighlight__137_146TO142_148" class="">estilos</span> <span id="noHighlight_0.2908061526250094"></span><span id="ouHighlight__128_135TO150_157" class="">à parte (</span><span id="ouHighlight__148_151TO159_162">como</span><span id="noHighlight_0.5787958002183586"> era na </span><span id="ouHighlight__153_154TO164_165">versão 3)</span><span id="noHighlight_0.5214279058855027">,</span> <span id="noHighlight_0.4220451375003904"></span><span id="ouHighlight__169_171TO176_180" class="">todas</span> <span id="noHighlight_0.918515301309526"></span><span id="ouHighlight__173_177TO182_186" class="">essas</span> <span id="noHighlight_0.7640828147996217"></span><span id="ouHighlight__179_185TO188_193" class="">opções</span><span id="noHighlight_0.4096155730076134"> foram colocadas </span><span id="ouHighlight__187_190TO195_196" class="">em</span> <span id="noHighlight_0.4232193084899336"></span><span id="ouHighlight__197_205TO198_206">variáveis</span> <span id="noHighlight_0.7291480258572847"></span><span id="ouHighlight__192_195TO208_211">Sass</span><span id="noHighlight_0.5328994235023856">.</span> <span id="noHighlight_0.3506186828017235"></span><span id="ouHighlight__208_211TO214_218">Quer</span><span id="noHighlight_0.761297364719212"> </span><span id="ouHighlight__221_231TO220_229">transições</span> <span id="noHighlight_0.18227634043432772"></span><span id="ouHighlight__213_219TO231_236">padrões </span><span id="ouHighlight__233_234TO238_239">em</span> <span id="noHighlight_0.11960533494129777"></span><span id="ouHighlight__236_245TO241_244">tudo</span> <span id="noHighlight_0.48817266849800944"></span><span id="ouHighlight__247_248TO246_247">ou</span> <span id="noHighlight_0.5429222423117608"></span><span id="ouHighlight__253_259TO249_257" class="">desativar</span><span id="noHighlight_0.7604012105148286"> os </span><span id="ouHighlight__269_275TO259_264" class="">cantos</span> <span id="noHighlight_0.0033320076763629913"></span><span id="ouHighlight__261_267TO266_277" class="">arredondados</span><span id="noHighlight_0.18449167720973492">?</span> <span id="noHighlight_0.15296318451873958"></span><span id="ouHighlight__278_283TO280_284" class="">Basta</span> <span id="noHighlight_0.8132120880763978"></span><span id="ouHighlight__285_290TO286_293" class="">atualizar</span><span id="noHighlight_0.07241212041117251"> </span><span id="ouHighlight__292_292TO295_297" class="">a </span><span id="ouHighlight__294_301TO299_306" class="">variável</span> <span id="noHighlight_0.25222062366083264"></span><span id="ouHighlight__303_305TO308_308" class="">e</span> <span id="noHighlight_0.570360544603318"></span><span id="ouHighlight__307_315TO310_318" class="">recompilar.</span>

## Todos os plugins foram reescritos

Cada plugin foi reescrito com ES6 para aproveitar as mais recentes melhoras do JavaScript. A versão 4 ve<span id="ouHighlight__132_135TO153_155" class="">m</span> <span id="noHighlight_0.36849321285262704"></span><span id="ouHighlight__151_154TO157_159" class="">com </span><span id="noHighlight_0.8874966793227941"></span><span id="ouHighlight__160_166TO161_167" class="">suporte</span><span id="noHighlight_0.3962369414512068"> para <em>Universal Module Definition</em> (</span><span id="ouHighlight__156_158TO169_171" class=""><a href="https://github.com/umdjs/umd" target="_blank">UMD</a>)</span><span id="noHighlight_0.18047267338261008">,</span> <span id="noHighlight_0.9055605356115848"></span><span id="ouHighlight__186_192TO174_180" class="">métodos</span> <span id="noHighlight_0.08181263506412506"></span><span id="ouHighlight__169_175TO182_190" class="">genéricos</span> <span id="noHighlight_0.145829914836213">de </span><span id="ouHighlight__177_184TO195_204" class="">subdivisão</span><span id="noHighlight_0.30580205423757434"> e</span><span id="noHighlight_0.6392135077621788"> </span><span id="ouHighlight__207_214TO207_217" class="">verificação</span> <span id="noHighlight_0.9670881452038884">de </span><span id="ouHighlight__202_205TO222_225" class="">tipo</span> <span id="noHighlight_0.7507147502619773">de </span><span id="ouHighlight__195_200TO230_234" class="">opção, entre outros</span><span id="noHighlight_0.8302771004382521">.</span>

## Melhor documentação

Toda a documentação foi reescrita em Markdown; foram adicionados alguns plugins úteis para simplificar os exemplos. Também foram colocados trechos de códigos para agilizar o trabalho.

## Fim do suporte ao IE8

<span id="ouHighlight__0_6TO0_8" class="">O</span><span id="noHighlight_0.7597462392877787"> </span><span id="ouHighlight__12_18TO12_18" class="">suporte</span><span id="noHighlight_0.15465820394456387"> ao </span><span id="ouHighlight__8_10TO23_25" class="">IE8</span><span id="noHighlight_0.509343218524009"> foi abandonado </span><span id="ouHighlight__20_22TO27_27" class="">e</span><span id="noHighlight_0.4135255643632263"> as unidades de medida mudaram para </span><span id="ouHighlight__33_35TO43_45" class="">REM </span><span id="ouHighlight__37_39TO47_47" class="">e</span> <span id="noHighlight_0.45592652703635395"></span><span id="ouHighlight__41_42TO49_50">EM</span><span id="noHighlight_0.115584553219378">.</span> <span id="noHighlight_0.8139501307159662">O</span><span id="ouHighlight__51_58TO62_69" class=""> fim d</span><span id="noHighlight_0.5428129727952182">o </span><span id="ouHighlight__60_66TO73_79" class="">suporte</span><span id="noHighlight_0.9242240693420172">,</span><span id="noHighlight_0.3814675039611757"> </span><span id="ouHighlight__76_80TO92_100" class="">significa</span> <span id="noHighlight_0.8024199057836086"></span><span id="ouHighlight__82_83TO102_104" class="">que</span> <span id="noHighlight_0.6282858841586858"></span><span id="ouHighlight__85_87TO106_109" class="">pode-se</span> <span id="noHighlight_0.12069125333800912"></span><span id="ouHighlight__89_105TO111_120" class="">aproveitar</span> <span id="noHighlight_0.06503489147871733"></span><span id="ouHighlight__107_109TO122_123" class="">as</span> <span id="noHighlight_0.5774596999399364"></span><span id="ouHighlight__111_114TO125_132" class="">melhores</span> <span id="noHighlight_0.5065434332937002"></span><span id="ouHighlight__116_120TO134_139">partes</span> <span id="noHighlight_0.9085071054287255"></span><span id="ouHighlight__122_123TO141_142">do</span><span id="noHighlight_0.2688959944061935"> </span><span id="ouHighlight__125_127TO144_146">CSS</span> <span id="noHighlight_0.34350621490739286"></span><span id="ouHighlight__129_135TO148_150">sem </span><span id="ouHighlight__137_141TO152_156" class="">o uso de </span><span id="ouHighlight__158_160TO170_172" class="">CSS</span> <span id="noHighlight_0.566822367021814"></span><span id="ouHighlight__162_166TO174_178" class="">hacks</span> <span id="noHighlight_0.8859184393659234"></span><span id="ouHighlight__168_169TO180_181" class="">ou</span> <span id="noHighlight_0.11384950415231287"></span>_<span id="ouHighlight__171_179TO183_194" class="">fallbacks</span>_<span id="noHighlight_0.8839674249757081">.</span> <span id="noHighlight_0.7743959142826498"></span>

_<span id="ouHighlight__182_187TO197_202" class="">Pixels</span> <span id="noHighlight_0.37850770237855613"></span>_<span id="ouHighlight__194_197TO204_208" class="">foram</span> <span id="noHighlight_0.46460154722444713"></span><span id="ouHighlight__199_205TO210_217" class="highlight">trocados</span> <span id="noHighlight_0.8350909308064729"></span><span id="ouHighlight__207_209TO219_221" class="">por</span> <span id="noHighlight_0.6744522778317332"></span><span id="ouHighlight__211_214TO223_226" class="">REMS </span><span id="ouHighlight__216_218TO228_228" class="">e</span> <span id="noHighlight_0.28712224145419896">EMS, </span><span id="ouHighlight__224_240TO234_246" class="">eventualmente</span><span id="noHighlight_0.32065628934651613"> para</span><span id="noHighlight_0.47396003059111536"> </span><span id="ouHighlight__245_248TO250_255" class="">tornar</span> <span id="noHighlight_0.46526208659633994"></span><span id="ouHighlight__293_296TO257_261" class="">ainda</span> <span id="noHighlight_0.6913347935769707"></span><span id="ouHighlight__298_303TO263_272" class="">mais fácil</span> <span id="noHighlight_0.8071073237806559">a </span><span id="ouHighlight__261_270TO276_285" class="">tipografia</span> <span id="noHighlight_0.17413580045104027"></span><span id="ouHighlight__250_259TO287_296" class="">responsiva</span> <span id="noHighlight_0.8454670906066895"></span><span id="ouHighlight__272_274TO298_298">e</span> <span id="noHighlight_0.6733989510685205"></span><span id="ouHighlight__286_291TO300_314" class="">dimensionamento </span><span id="noHighlight_0.3753285778220743">do </span><span id="ouHighlight__276_284TO319_328" class="">componente</span><span id="noHighlight_0.21270700567401946">.</span> <span id="noHighlight_0.9447224051691592"></span>

<span id="ouHighlight__306_307TO331_332" class="">Se</span> <span id="noHighlight_0.3133630729280412"></span><span id="ouHighlight__309_311TO334_337" class="">você </span><span id="ouHighlight__313_316TO339_346" class="">precisar</span> <span id="noHighlight_0.47584015876054764">de </span><span id="ouHighlight__322_328TO351_357" class="">suporte</span><span id="noHighlight_0.22770247887820005"> ao </span><span id="ouHighlight__318_320TO362_364" class="">IE8</span><span id="noHighlight_0.4113714068662375">,</span><span id="noHighlight_0.914000281598419"> vai ter que </span><span id="ouHighlight__331_334TO367_374" class="">continuar</span><span id="noHighlight_0.2844633760396391"> </span><span id="ouHighlight__336_340TO376_381" class="">usando</span><span id="noHighlight_0.9633060169871897"> o</span><span id="noHighlight_0.42434997437521815"> </span><span id="ouHighlight__342_350TO388_396" class="">Bootstrap v3</span><span id="noHighlight_0.24006641446612775">.</span>

<span id="ouHighlight__27_34TO18_26" class="">Também foram adicionados controles</span> <span id="noHighlight_0.05131633346900344">de </span><span id="ouHighlight__22_25TO31_40" class="">formulários</span> <span id="noHighlight_0.37164003239013255"></span><span id="ouHighlight__15_20TO42_54" class="">personalizados</span><span id="noHighlight_0.46348911290988326">,</span> <span id="noHighlight_0.749728238210082">classes de </span>_<span id="ouHighlight__37_42TO57_62" class="">margin </span>_<span id="ouHighlight__44_46TO64_64">e</span> <span id="noHighlight_0.9394099384080619"></span>_<span id="ouHighlight__48_54TO66_72">padding</span>_<span id="noHighlight_0.7057353919371963">, e </span><span id="ouHighlight__77_83TO83_89">novos utilitários de classes em geral</span><span id="noHighlight_0.3223601672798395">.</span>

O lançamento da versão final será dividido em quatro etapas: lançamento de algumas versões Alpha, depois mais duas versões betas, fase de testes em ambiente de produção, e então a esperada versão final. Vale lembrar que o suporte a versão 3 continuará, recebendo apenas atualizações críticas e melhorias na documentação.

> Quando nós lançamos Bootstrap 3, imediatamente paramos todo o apoio para v2.x, causando muita dor para todos os nossos usuários. Isso foi um erro que não vai acontecer novamente. Em um futuro próximo, manteremos o Bootstrap 3 com correções de bugs críticos e melhorias de documentação. Os docs da v3 também continuarão hospedados após a liberação final da v4.

[<img class="alignnone wp-image-50866 size-full" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/08/Capturar.png" alt="Temas para os criadores que utilizam o Bootstrap 4" width="1349" height="671" />][2]

Além de lançar o Bootstrap 4, também foi anunciado outro projeto: o **Bootstrap Official Themes**, que são alguns temas criados pelos próprios criadores do _framework_. Existem três temas disponíveis para _dashboards_, marketing de um produto e outro para aplicações.

Infelizmente, todos os três são pagos (cada tema custa $99). Ainda não foi divulgado se os temas poderão ser gratuitos no futuro.

&nbsp;

 [1]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/08/bs4-alpha.png
 [2]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/08/Capturar.png