---
title: As tabelas HTML são amigáveis para SEO?
authors: Morais Junior
type: post
date: 2019-11-25
excerpt: Com o passar do tempo acabamos esquecendo o real motivo de utilizar a tag **table** do HTML e sua importancia no SEO quando bem utilizada nas chamadas **tabelas de dados**.
categories:
  - HTML
  - SEO
tags:
  - SEO
  - Frontend
  - Table
  - Html
---

# As tabelas HTML são amigáveis para SEO?

Isso mesmo, tabelas. Se vamos melhorar nossas tabelas para que elas apareçam na listagem de resultados é importante primeiro sempre lembrar a diferença entre o que vamos chamar de **tabela de conteúdo** e **tabela de dados**. 

No inicio da web os desenvolvedores perceberam que poderiam utilizar tabelas para distribuir e organizar o conteúdo na página, chamamos isso de **tabela de conteúdo**, Isso hoje em dia é considerado arcaico e não deve ser utilizado, porem com o passar do tempo acabamos esquecendo o real motivo de utilizar a tag **[TABLE](https://www.w3schools.com/tags/tag_table.asp "table")** do HTML e sua importancia no SEO quando bem utilizada nas chamadas **tabelas de dados**.

[![Print da tela de uma tabela SEO](https://manbit.com.br/posts/posts/img/tableSEO1.png "Print da tela de uma tabela SEO")](https://manbit.com.br/posts/posts/img/tableSEO1.png "Print da tela de uma tabela SEO")

Por tanto, se você deseja uma melhor aparência de resultado na listagem de busca da Google, e você deve desejar isso, pois torna o seu resultado mais atraente para o clique de um visitante, então você deve optar por uso de tabelas de dados.

## O que é uma tabela de dados?
Pode parecer óbvio, mas tabelas de dados são aquelas que contém dados, mas organizados de maneira lógica para permitir ações como consultas e às vezes cálculos. Simplesmente jogar uma informação abaixo da outra, e outras ao lado destas, não garante a formação de uma boa tabela de dados.
Mostramos abaixo algumas regras simples para organização dos dados que irão melhorar a sua table, seja ela vertical ou horizontal. Importante lembrar que o fluxo de dado vai depender da quantidades de entradas de dados:
Dados com sequência, progressão ou comparação, entre outros, que se agrupam em muitas entradas, pedem quase sempre uma tabela vertical.
Dados informativos, que normalmente formam um par Tema-Valor, pedem quase sempre uma tabela horizontal.

A primeira regra é que uma boa **tabela de dados** preferencialmente tem uma linha ou coluna que atua como títulos (headers) de identificação da informação seguinte para uma coluna (ou linha) contendo valores (subject column/ value line). 
### Tabelas Vertical
Boas tabelas verticais irão apresentar pelo menos algumas das características abaixo. Elas não são necessariamente regras fixas, porém são grandes indicativos de uma boa tabela:
- **Colunas de Dados** - tabelas verticais terão uma coluna de dados identificável que representa consistentemente uma classe ou categoria de informação. Isso torna a tabela mais adequada para análise.
- **Títulos** - a tag **TH** é usada declarar títulos para as colunas.
- **Legenda da tabela** - A tag caption contém texto que aparece acima de uma tabela, atuando como uma espécie de título. Deve ser usado palavras chaves de maneira não poluente.
- **Contexto e sua proeminência** - Títulos, legendas e uma coluna de dados formam uma boa tabela, mas o contexto é importante. O Google analisa o conteúdo próximo da tabela, que provavelmente terá uma forte influência em seu significado. Isso inclui a tag de cabeçalho ( h1 a h6 ) mas próxima acima da tabela, bem como textos doacima ou abaixo da tabela e o título da página.
- **Tamanho da tabela** - Uma tabela que é amplamente vertical (tem muito mais linhas que colunas) ou muito horizontal (com muito mais colunas que linhas)  dificilmente será uma tabela de conteúdo.
- **Informações padronizadas** - Os dados de uma coluna normalmente obedecem um padrão de informação que facilita a análise vertical.
- **Colunas de dados relacionados** - As tabelas com duas colunas de dados relacionados são comuns. Infelizmente, no momento, os algoritmos de Pesquisa de tabela do Google concentram-se em identificar apenas uma coluna de assunto.
- **Análise Horizontal** - depois que uma coluna de dados é fixada, o Google procura analisar o relacionamento com as outras. A indexação semântica de dados circundante e a identificação de cabeçalhos acontecem aqui. Às vezes, todos os dados se encaixam perfeitamente em um vocabulário semântico.
- **Unidades** - Boas tabelas mostram dados numéricos. Únidades de medida ajudam na clareza da mesma.

### Tabelas Horizontais
Tabelas horizontais são muito utilizadas para listagem de dados na relação Tema-Valor (Assunto - Informação). Um excelente exemplo disso são as tabelas que aparecem à direita da maioria das páginas da wikipedia.

![](https://manbit.com.br/posts/posts/img/tableSEO2.png)

Nesses casos, muitas das indicações feitas anteriormente para tabelas verticais não podem ser seguidas de modo exato, mas algumas podem ser adaptadas.
O principal é organizar de modo que a relação tema-valor seja sempre mantida na mesma ordem, caso contrário o fluxo de informação fica prejudicado.
Títulos (cabechaços) usados pela tab **TH** nesse caso normalmente definem sessões da tabela, organizando grupo de informações semelhantes.

## Devo usar tabelas na minha página?
Claro que sim. Uma boa tabela enriquece sua página e organiza melhor informações que, caso fossem apresentadas em forma de texto ou em listagem descritiva, tornaria a leitura cansativa e prejudicaria o interesse do visitante em permanecer na página.
Os princípios que expliquei nesse artigo irão ajudar que suas tabelas tenham maior chance de aparecer na listagem de resultados da Google, melhorando o ranking de sua página e o potencial interesse dos visitantes
