+++
authors = "Christopher Watkins"
categories = ["front-end"]
date = "2018-08-16T09:00:00-03:00"
excerpt = "Desenvolvedores web não se dão bem com planilhas, mas também não precisam mais: existem outras maneiras de representar dados"
image = "https://i.imgur.com/jSr7mmP.png"
publishdate = "2018-08-16T09:00:00-03:00"
tags = ["ferramentas"]
title = "As 12 melhores bibliotecas de gráficos para desenvolvedores web"
type = "post"
canonical = "https://br.udacity.com/blog/post/bibliotecas-de-grafico-para-desenvolvedores-web"
+++
Muitos de vocês estão profundamente envolvidos em projetos de desenvolvimento web. Pensando nisso, Rohit Boggarapu, engenheiro de software na Adobe, escreve abaixo para compartilhar suas ferramentas gráficas de visualização de dados voltadas aos desenvolvedores web favoritas.

É um ponto de atenção. A diferença entre os dados e nossa interpretação deles pode ser gigantesca, sobretudo quando expostos em formatos ininteligíveis dentro de planilhas - talvez o pior modelo de todos.

Desenvolvedores web não se dão bem com planilhas, mas também não precisam mais: existem outras maneiras de representar dados, e Boggarapu oferece dicas, atalhos e conselhos para escolher a melhor para você.

## 12 bibliotecas de gráficos para desenvolvedores web

### Google Charts

A imensa biblioteca de informações disponíveis no [Google Charts](https://developers.google.com/chart/) é um extraordinárioponto de partida para os que pretendem iniciar uma representação gráfica usando o JavaScript. Ali, você encontrará um grande número de códigos comentados, além de instruções passo a passo, que serão úteis na inclusão de gráficos HTML5/SVG em suas páginas da web.

Se você procura avançado nível de personalização e mais gráficos do que o native 18 do Google, abaixo veremos opções melhores e com maior variedade de recursos.

**Ideal para:** Desenvolvedores que buscam soluções flexíveis e bem documentadas.

![](https://d20vrrgs8k4bvw.cloudfront.net/images/blog/pt-BR/bibliotecas-desenvolvedores-web-01.png)

### MetricsGraphics

A [MetricsGraphics](https://github.com/mozilla/metrics-graphics) é uma biblioteca gráfica desenvolvida em D3.js, mas otimizada para visualização e apresentação de dados de uma série temporal. Embora limitada a gráficos de linha, de dispersão, de colunas, histogramas e tabela, a ferramenta é excelente para as funções descritas.

Similar ao Google Charts, o Metrics Graphics - que é um produto Mozilla - apresenta uma vasta gama de documentos e exemplos de códigos no site. O que torna fácil a compreensão dos iniciantes.

Embora seja uma solução simplificada, o aprendizado ganha fluidez graças aos divertidosexemplos interativos (observação de ovinis??).

**Ideal para:** Desenvolvedores que buscam uma solução rápida e eficiente sem a necessidade de percorrer um emaranhado de códigos para tal.

![](https://d20vrrgs8k4bvw.cloudfront.net/images/blog/pt-BR/bibliotecas-desenvolvedores-web-02.png)

### FusionCharts

A [FusionCharts](https://www.fusioncharts.com/) suporta vanilla JavaScript, jQuery, Angular e outras bibliotecas conhecidas. Os mais de 90 gráficos e 1000 mapas o transformam em uma solução muito mais completa que o Google Charts ou o MetricsGraphics. Veja asespecificações técnicas e conheça a lista completa das representações gráficas disponíveis.

Levando em conta a escalabilidade de seu aplicativo ou site, é importante lembrar que a escolha de uma biblioteca gráfica incompleta pode representar um erro grave. O FusionCharts é utilizado por empresas como a Microsoft, Google e IBM. O que o torna uma ferramenta escalável mesmo para os requisitos corporativos.

**Ideal para:** Desenvolvedores que precisam de grande variedade de gráficos customizados.

![](https://d20vrrgs8k4bvw.cloudfront.net/images/blog/pt-BR/bibliotecas-desenvolvedores-web-03.png)

**Leia:** [**Como montar um portfólio de desenvolvedor e apresentar meu trabalho?**](https://br.udacity.com/blog/post/montar-portfolio-desenvolvedor)

### Epoch

O [Epoch](https://epochjs.github.io/epoch/) é uma ferramenta desenvolvida em d3.js especificamente. Por isso, desenvolvedores podem usar gráficos em tempo real em seus projetos de aplicativos e sites. Além de amplamente documentado, o Epoch é de código aberto e 100% gratuito. Isso o torna uma boa opção aos que não estão dispostos a investir recursos na aquisição de uma solução.

Com cinco diferentes tipos de gráficos - seja básico ou de tempo real - o Epoch é compatível com ferramentas como o FusionCharts ou o Highcharts. No entanto, é o que apresenta melhor desempenho na representação de dados em tempo real.

**Ideal para:** Gráficos simples e flexíveis.

![](https://d20vrrgs8k4bvw.cloudfront.net/images/blog/pt-BR/bibliotecas-desenvolvedores-web-04.png)

### ECharts

O [ECharts](https://echarts.baidu.com/), da Baidu, é uma excelente ferramenta de gestão de dados já expostos a representações gráficas, pois apresenta uma característica única: O Drag-Recalculate permite que os usuários transfiram seções de dados de um gráfico para outro e que esses mesmos gráficos sejam recalculados em tempo real. Além disso, o EChart é desenvolvido para big data e pode traçar instantaneamente até 200.000 pontos em um gráfico cartesiano usando oZRender, uma biblioteca canvas feita especificamente para ECharts.

Brinque com o código do gráfico exposto acima e descubra do que o ECharts é capaz.

**Ideal para:** Código aberto, gestão de dados em tempo real através da ferramenta de recálculo.

![](https://d20vrrgs8k4bvw.cloudfront.net/images/blog/pt-BR/bibliotecas-desenvolvedores-web-05.png)

### D3.js

Embora não seja a ferramenta mais fácil de ser usada, não há como negar o poder do [d3.js](https://github.com/mbostock/d3/wiki/Gallery) no desenvolvimento de gráficos em JavaScript. Muitas outras bibliotecas se desenvolvem porque apresentam todas as funcionalidades esperadas desse tipo de ferramenta: suporte HTML, SVG e CSS e, contanto que os gráficos não estejam desatualizados, incluem ainda uma enorme quantidade de contribuições criadas pelo usuário.

É válido pesquisar a respeito deste curso de visualização de dados e d3.js, pois, dada a complexidade de compreensão do D3.js, é preciso contar com uma sólida base de conceitos como essa.

**Ideal para:** Especialistas em gráficosque não se intimidem com as dificuldades de codificar.

![](https://d20vrrgs8k4bvw.cloudfront.net/images/blog/pt-BR/bibliotecas-desenvolvedores-web-06.png)

### Sigma

O [Sigma](https://sigmajs.org/), comparado a outras ferramentas já expostas, é um recurso mais segmentado, pois se dedica exclusivamente ao desenho de gráficos. É desenvolvido em Canvas, WebGL e apresenta API pública. Por isso, dispõe de uma grande variedade de plugins disponibilizados pela comunidade no GitHub. Este é um exemplo do que se pode fazer com o Sigma js:

O Sigma é altamente responsivo, permite interatividade por meio de toque e possibilita que os desenvolvedores adicionem suas próprias funções aos scripts, renderizando contornos às especificações.

**Ideal para:** Desenvolvedores que demandam uma ferramenta poderosa de desenho gráfico.

![](https://d20vrrgs8k4bvw.cloudfront.net/images/blog/pt-BR/bibliotecas-desenvolvedores-web-07.png)

**Leia:** [**O que é data storytelling e como utilizá-la nos negócios**](https://br.udacity.com/blog/post/big-data-storytelling)

### Highcharts

O popular [Highcharts](https://www.highcharts.com/) cria gráficos interativos sem que haja dependência de plugins. A API de gráficos flexíveis da Highcharts é utilizada por empresas como a Nokia, Twitter, Visa e Facebook.

O Highcharts é gratuito quando o uso não é comercial. No entanto, se houver pretensão de ganhar dinheiro com a ferramenta (e obter suporte enquanto o faz), é necessário pagar US$ 590 pela licença de desenvolvedor.

Veja um exemplo de gráfico desenvolvido no Highcharts:

Se tiver interesse em aprender mais a respeito do Highcharts, acesse este interessante tutorial.

**Ideal para:** Desenvolvedores que tenham a intenção de criar gráficos contando com o auxílio de um suporte técnico que, tal qual o produto, apresenta alto padrão de qualidade. Independentemente do nível de complexidade.

![](https://d20vrrgs8k4bvw.cloudfront.net/images/blog/pt-BR/bibliotecas-desenvolvedores-web-08.png)

### dc.js

[dc.js](https://dc-js.github.io/dc.js/) é uma biblioteca Javascript de código aberto, ideal para a criação de representações gráficas interativas. Nesse tipo de gráfico interativo, qualquer alteração permite que todo o resto da ferramenta reaja de acordo com a manipulação feita em um dado específico. Segue exemplo:

Com exceção de alguns cursos online, a biblioteca é ensinada aos alunos exclusivamente por esse modelo. Assim, usando esse documento como base, é possível criar sua própria versão.

O dc.js não cria gráficos tão variados como algumas das ferramentas dessa lista (ECharts ou Google Charts), mas cumpre muito bem a função de explorar conjuntos de dados multidimensionais.

**Ideal para:** Desenvolvedores em busca de um painel de gráficos relacionais para um determinado projeto.

![](https://d20vrrgs8k4bvw.cloudfront.net/images/blog/pt-BR/bibliotecas-desenvolvedores-web-09.png)

### dygraphs

O [dygraphs](https://github.com/danvk/dygraphs), originalmente desenvolvido pelo Google e hoje disponível no Google Correlate é uma verdadeira joia das ferramentas de criação de representações gráficas. Pode ser usado em projetos intensos, pois tem a capacidade única de traçar milhões de pontos de dados sem perder a velocidade - o que acaba tornando seu design (digamos, despojado) uma falha absolutamente tolerável.

O Dygraphs é ativamente apoiado e desenvolvido pela comunidade. Foi isso que transformou uma ferramenta interna do Google em um recurso público e amplamente utilizado. A fonte está aberta para exibição no GitHub.

**Ideal para:** Desenvolvedores que procuram uma ferramenta dedicada a traçar grandes conjuntos de dados.

![](https://d20vrrgs8k4bvw.cloudfront.net/images/blog/pt-BR/bibliotecas-desenvolvedores-web-10.png)

### Vega

A [Vega](https://vega.github.io/vega/) é uma biblioteca baseada em d3.js para criar, compartilhar e salvar projetos de visualização. É composta de ferramentas e sistemas que, dentre outras coisas, rivalizam com o d3 sem a necessidade de escrever códigos. A Vega traduz JSON em gráficos SVG ou HTML5 que - embora nada extravagante - cumpre bem sua função.

Já que essabiblioteca não demanda programação (apenas a capacidade de editar valores em um arquivo JSON), trata-se de uma excelente alternativa ao d3, pois apresenta menor complexidade e os mesmo recursos.

**Ideal para:** Desenvolvedores que demandam a capacidade do d3 sem a complexidade de aprender tudo do zero.

![](https://d20vrrgs8k4bvw.cloudfront.net/images/blog/pt-BR/bibliotecas-desenvolvedores-web-11.png)

**Leia:** [**Tutorial para iniciantes em Git e GitHub: faça seu primeiro commit**](https://br.udacity.com/blog/post/tutorial-iniciantes-git-github)

### NVD3

A última ferramenta nesta lista é desenvolvida em d3, que é o precursor da maioria das bibliotecas gráficas de código aberto. O [NVD3](https://nvd3.org/examples/) é um conjunto de componentes que permite aos desenvolvedores a criação de gráficos reutilizáveis. Uma grande variedade de modelos e códigos pode ser explorada nosite do NVD3. Essa é, sem dúvida, a melhor maneira de desenvolver conhecimento a respeito da ferramenta.

Como você pode ver, o estilo do NVD3 é um pouco mais refinado do que o de outras ferramentas:

Além de suportar 11 tipos de gráficos (incluindo área, linha, barra, pizza, dispersão), é compatível com todos os navegadores modernos, do IE10 em diante.

**Ideal para:** Desenvolvedores com conhecimento em d3 que procurem gráficos reutilizáveis.

![](https://d20vrrgs8k4bvw.cloudfront.net/images/blog/pt-BR/bibliotecas-desenvolvedores-web-12.png)

Se você está procurando por mais informações sobre as ferramentas de representação gráfica são as mais adequadas para o seu projeto, confira este [esclarecedor quadro técnico comparativo](https://www.fusioncharts.com/javascript-charting-comparison/) (em inglês).

Embora essa lista seja voltada para [desenvolvedores web](https://br.udacity.com/course/front-end-web-developer-nanodegree--nd001/), algumas das ferramentas aqui são tão fáceis de usar que você nem precisa ser um desenvolvedor para começar a trabalhar com elas.

Com a gama de exemplos interativos disponíveis online personalizar códigos, ficou fácil até para quem está apenas começando no desenvolvimento web.

_Artigo originalmente publicado no_ [_blog americano_](https://blog.udacity.com/2016/03/12-best-charting-libraries-for-web-developers.html) _da Udacity_