---
title: Arquitetura da Informação em Landing Page
authors: Rodrigo Simoni
type: post
date: 2013-07-10
excerpt: 'Construir uma boa arquitetura de informação e aprofundar o assunto da página faz toda a diferença para se obter bons resultados de conversão. '
url: /arquitetura-da-informacao-em-landing-page/
dsq_thread_id: 1464687905
categories:
  - Design
  - SEO
  - UX
tags:
  - 2013
  - ai
  - arquitetura de informacao
  - ux

---
Arquitetura da informação (AI) é a arte de construir uma estrutura clara e direta em um site, com objetivo de facilitar ao máximo a navegação do usuário e fazer com que ele encontre rapidamente o que está procurando. Vou citar abaixo algumas dicas importantes sobre arquitetura da informação e profundidade, afim de ajudar na conversão em landing pages. Mãos à obra!

<img class="aligncenter" alt="Arquitetura da informação" src="https://www.conversion.com.br/uploads/2013/07/usuarios-contexto-conteudo.jpg?9d7bd4" width="210" height="197" />

## Técnica da pirâmide invertida

A técnica da pirâmide invertida é um método de escrita jornalística onde o objetivo é expor logo nos primeiros parágrafos as informações mais relevantes sobre o assunto, deixando o artigo mais dinâmico e prendendo mais a atenção do leitor. Quando falamos em profundidade da informação, a técnica da pirâmide invertida é usada para o mesmo efeito. Abordamos na primeira page view os parágrafos que queremos destacar e que possuem a maior relevância. Mais abaixo vem o conteúdo menos importante e em sequência mais abaixo, conteúdos com detalhes informativos mais técnicos e muito mais secundários, interessantes somente a usuários que realmente querem se aprofundar mais. O mais importante é seguir uma ordem de relevância na estrutura do seu conteúdo.

<img class="aligncenter" alt="Pirâmide invertida" src="https://www.conversion.com.br/uploads/2013/07/conteudo-piramide.jpg?9d7bd4" width="500" height="365" />

## Pense, planeje e faça

Antes de qualquer coisa, você precisa ter uma estratégia clara de como será organizado o conteúdo na sua página e como irá abordar o assunto. Saiba qual será a principal palavra-chave da página e suas variações. Se possível, crie um wireframe para ficar mais clara a estrutura da informação. Foque no conteúdo e tenha o máximo de profundidade no assunto, isto é, saiba do que está falando e seja autoridade nisso. Depois que você tiver uma estratégia definida, tenha respostas rápidas e simples para essas perguntas:

  * Que página é essa?
  * Para quê essa página serve?
  * Quais as partes mais importantes dessa página?
  * Como eu posso converter nessa página?
  * Profundidade e autoridade no assunto

O conteúdo ainda é rei em SEO e talvez sempre será. É baseado no conteúdo que se constrói a relevância. Mais do que se preocupar em como o Google te dará relevância, se preocupe com o usuário. Isso é dar a ele o máximo de informação sobre o assunto em que está buscando. Tenha o melhor conteúdo e certifique se o seu é melhor do que todos que você vê na internet sobre esse mesmo assunto. Tenha o máximo de informações possíveis. Se for uma página de um produto por exemplo, escreva tudo sobre ele como as principais vantagens e features, detalhes, faça uso de listas para explicar de forma mais clara, use fotos, vídeos, slides, tabelas de especificações técnicas, comparações etc. Resumindo, seja autoridade no assunto, um expert, o melhor. Veja um exemplo de profundidade de conteúdo na landing page da Kindle Fire, tablet da Amazon e como eles trabalharam a profundidade da arquitetura da informação:

<img class="alignnone" alt="Profundidade de conteúdo" src="https://www.conversion.com.br/uploads/2013/07/amazon.jpg?9d7bd4" width="500" height="1086" />

<a href="https://www.amazon.com/Kindle-Fire-Amazon-tablet/dp/B0083Q04IQ" target="_blank">Veja o exemplo completo</a>

## Informações mais importantes no topo

A divisão do conteúdo na página e sua estrutura deve ser clara e objetiva e as informações mais importantes precisam ser posicionadas no topo da página. Lembre que muitos usuários podem acessar sua landing page através de notebooks ou tablets e por isso visualizarão uma parte pequena da página. Por isso, foque o conteúdo mais importante destacando na primeira page view, ou seja, antes da “dobra” ou rolagem da página. Caso tenha um Call to Action, use também no topo e de forma destacada, se possível com uma cor que se destaque das outras cores do site. As informações mais secundárias podem vir na sequência e não terá tanto problema se o usuário precisar usar a barra de rolagem. Conteúdo de caráter mais técnico e detalhado poderão aparecer mais abaixo da página e serão úteis para usuários mais avançados naquele assunto, pois estarão interessados em mais detalhes.

## Títulos otimizados

Um comportamento muito comum em usabilidade é que antes de se aprofundar em um texto, damos uma “passada de olho” para sabermos o que pode nos interessar. Lemos alguns títulos, olhamos algumas imagens e caso nos interesse, podemos ler o texto. Do contrário, adeus, página. Por isso, temos que valorizar e destacar os principais títulos da página. Tenha apenas um H1 na página, pois ele será seu título principal e precisa ser o mais visível e destacado. A palavra-chave mais importante precisa estar nesse título. Os títulos mais secundários, como H2 e H3 podem conter variações (long tails) da sua palavra-chave principal e também precisam ter certa visibilidade, mas não maior que a do título principal.

<img class="alignnone" alt="Títulos otimizados" src="https://www.conversion.com.br/uploads/2013/07/amazon2.jpg?9d7bd4" width="600" height="425" />

## Mantenha o óbvio

Não precisa reinventar a roda. Faça com que a estrutura da informação seja óbvia, mantendo as convenções que já estamos acostumados. Deixe os elementos do seu conteúdo claros e tome cuidado com tecnologia demais. Ter um conteúdo rico não quer dizer que você precise organizar ele com Jquery ou Ajax para organizar melhor a página. Isso pode na verdade atrapalhar tanto a otimização de SEO quanto usuários mais conservadores. Procure deixar a estrutura do seu conteúdo de forma corrida e simples. O design da sua página também precisa ser simples, pois estamos falando de uma landing page que precisa de conversão. Ela precisa ser clean e ter cores leves com objetivo de dar foco total ao conteúdo. Não dê muitas escolhas ao usuário, isso pode o deixar confuso e fazer com que perca esse foco. Deixar sua página na última moda é bonito, mas nada funcional.

## Reotimize

Depois da tempestade vem a bonança. Até aqui você teve muito trabalho para deixar seu conteúdo extremamente rico e com boa profundidade da informação. Você já poderá ter bons resultados em SEO por isso. Mas, como SEO é um ciclo sem fim, você precisará sempre reotimizar esse conteúdo. É provável que seja preciso atualizar informações do texto como detalhes técnicos, dados e estatísticas, acontecimentos importantes etc. Dependendo do conteúdo, ele pode ficar desatualizado, perdendo sua relevância. Além disso, faça testes, muitos testes. Mude a posição de certos elementos do conteúdo, insira mais conteúdo, melhore sua Call to Action, vasculhe o que pode ser melhorado e depois disso mensure. Testes A/B são fáceis de fazer e são muito bem-vindos para otimizar os resultados.

## CRO

CRO (Conversion Rate Optimization) consiste na otimização de conversão de uma determinada página, e como o título desse artigo já diz, profundidade de informação é a chave para conversão. Existem muitas técnicas de otimização de conversão, mas com toda a certeza a otimização do conteúdo e sua profundidade é a melhor forma de otimizar sua landing page, pois esta questão é ligada diretamente com a relevância que o Google te dá juntamente com a encontrabilidade de usuários com a página.

## Conclusão

Como tudo em SEO, não existe uma receita pronta. É preciso ter uma visão ampla e saber como o Google pensa. SEO é muito mais expertise do que usar ferramentas. Atender seus usuários é o caminho e dar a eles informações úteis através de um conteúdo aprofundado e rico é o que vai permitir o aumento de conversões em sua landing page.