---
title: Anotações sobre Material Design do Google
authors: Diego Eis
type: post
date: 2014-12-03
excerpt: Anotações sobre o Material Design, o novo conceito de design que o Google tem adotado em seus produtos.
url: /anotacoes-sobre-material-design-google/
categories:
  - Design
  - Mobile
  - UX

---
O Material Design nasceu com a necessidade de melhorar o design do Google. Não é segredo que o design do Google era quase inexistente, pra não dizer um lixo. O Google é uma empresa de programadores e muito por causa disso não havia uma essência clara de que o design é algo importante. Mas isso tem mudado desde 2011, que foi quando Larry Page teve controle total da empresa e decidiu mudar esse quadro. Até então a empresa tinha a mania ruim de se forcar apenas nos testes A/B para decidir a interface. Como o [The Verge][1] comentou, eles testavam tipo umas 41 versões de azul nos links em vez de confiar nos próprios designers. Uma pena, porque eu vejo muito disso em diversas empresas que eu conheço, inclusive na que eu trabalho.

O Material Design então veio para tentar mudar a bagunça que é a interface dos produtos do Google. O Matias Duarte, Vice-Presidente de design do Android, encabeçou essa mudança toda.

Aqui na Locaweb estamos fazendo algo parecido, um pouco menos grandioso, mas bastante desafiador: estamos mudando a interface dos produtos para algo totalmente diferente. Nós temos o nosso framework ([opensource][2]) chamado [Locaweb Style][3], totalmente mobile first, com cada módulo sendo pensado em conjunto entre equipe de UX e Front. Uma coisa é certa: adequar um padrão entre vários produtos diferentes é bastante interessante. Um dos problemas que temos é manter a documentação do framework inteiro. Dá trabalho, bastante trabalho. A [documentação do Material Design][4] é bem impressionante e bastante simples. 

## Anotações do Podcast

Eu ouvi o podcast que o pessoal do Tecnoblog fez sobre Material Design e tomei a liberdade de anotar algumas coisas. Abaixo seguem essas anotações e vamos ver como essa coisa se desenrola.

  * O Google não tinha um design uniforme. Haviam telas de logins diferentes e principalmente produtos com o visual e experiências totalmente diferentes.
  * O Material Design foi uma cria dos produtos Google Now e do Google Plus.
  * O Google criou uma equipe para definir um padrão de design em NY. Eles desenhavam padrões e design e depois evangelizavam o pessoal na California.
  * Material Design é um framework para produzir a experiência Google.
  * O Guideline é muito detalhada, desde font até animação.
  * Ter uma Guideline detalhada é decisiva para que os programadores e outros designs consigam implementar o Material Design nos produtos do Google.
  * Tendo um framework visual, você consegue agilizar e manter um padrão uniforme entre os produtos.
  * Não ter restrições não é design, é arte.
  * Nas novas APIs, os desenvolvedores não precisam ter trabalho com animações ou componentes. O Google já criou padrões de animações e elementos para que o sistema tenha uma identidade
  * A maior analogia do Material Design é uma mesa com papéis jogados na mesa. Quando você tem muitos papéis na mesa, estes papéis se comportam da mesma maneira.
  * Animação é algo bastante difícil, você precisa fazer algo orgânico, rápido, que seja “invisível” e não faça o usuário “enjoar” dessas animação.
  * As animações do Material Design não são gratuitas, elas sempre tem um sentido, elas sempre tem uma ação por trás, mostrando uma continuidade no comportamento.
  * Efeitos de profundidade trazem uma naturalidade entre os elementos e a interface global do sistema.
  * O esqueumorfismo da Apple era muito sobre textura. O Android adota um esqueumofirmos mais ligado a interação e não à interface.
  * Você consegue entender como um módulo funciona não pelo seu visual, mas pelo seu comportamento.
  * O uso de elementos sobre outros elementos é também uma estratégia importante.
  * O Material Design nasceu dos cards do Google Now e do Google Plus. Ele nasceu de uma pergunta: O que teria embaixo desses cards? O que aconteceria se eu mexesse nesse card?
  * nas convenções do Google, eles dão um bloquinho com todos os princípios do Material Design e todos os princípios são explicados com camadas de papel. Um jeito interessante de mostrar como a sobreposição dos elementos funciona.
  * Contextualização através de Camadas
  * Float Action Button: um botão circular no canto inferior direito em cada App
  * É um botão que executa uma ação principal. Dependendo do contexto ele muda a ação principal.

Ouça o podcast aqui:
  


### Links para ler mais:

  * [Material Design Principles &#8211; video][5]
  * [TODAS as documentações sobre interface do Google][6]
  * [Here’s How Google’s Making Android Way Better][7]
  * [Redesigning Google: how Larry Page engineered a beautiful&nbsp;revolution][1]
  * [Google’s Design Guru Said Creating Android’s Massive New Redesign Was Like ‘Going To The Moon’][8]

 [1]: https://www.theverge.com/2013/1/24/3904134/google-redesign-how-larry-page-engineered-beautiful-revolution
 [2]: https://github.com/locaweb/locawebstyle/
 [3]: https://locaweb.github.com/locawebstyle/
 [4]: https://www.google.com/design/spec/material-design/introduction.html
 [5]: https://www.google.com/events/io/io14videos/79edef8b-96d4-e311-b297-00155d5066d7
 [6]: https://www.google.com/design/
 [7]: https://time.com/2921566/google-android-l-lollipop/
 [8]: https://www.businessinsider.com/matias-duarte-material-design-android-lollipop-2014-11